/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.SupportVersion;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class ShowSupportLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String[] tableColumn = new String[]{ResourceUtil.getString((String)"oem.tool.main.table.header.model"), ResourceUtil.getString((String)"oem.tool.main.table.header.version")};
    private DefaultTableModel model = new DefaultTableModel(this.tableColumn, new int[0]);
    private IsmTable table = new IsmTable((TableModel)this.model);
    private JButton closeBtn = UiMethod.createButton(ResourceUtil.getString((String)"oem.support.close"), 'C');

    public ShowSupportLayout() {
        this.initUI();
        this.initData(null);
    }

    public ShowSupportLayout(OemInfo selectOem) {
        this.initUI();
        this.initData(selectOem);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        JLabel descLabel = new JLabel(ResourceUtil.getString((String)"oem.support.desc"));
        JComponent vBox = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)descLabel), new JScrollPane((Component)this.table), UCD.buildHorizontalBoxRight((Component)this.closeBtn)});
        this.add((Component)UiMethod.buildFrameSpace(vBox, 12), "Center");
    }

    private void initData(OemInfo selectOem) {
        String target = ResourceUtil.getString((String)"oem.tool.info.button.desc2.default");
        if (null == selectOem) {
            Map<String, List<String>> allSupport = OemDataContext.getInstance().getModelVersion();
            ArrayList<String> keySet = new ArrayList<String>(allSupport.keySet());
            Collections.sort(keySet);
            keySet.stream().forEach(key -> {
                String supportVers = ((List)allSupport.get(key)).stream().filter(element -> !element.equals(target)).collect(Collectors.joining(","));
                this.createRow((String)key, supportVers);
            });
        } else {
            Map<String, SupportVersion> allPackSupport = OemDataContext.getInstance().getSelectSupportVer(selectOem);
            ArrayList<String> keySet = new ArrayList<String>(allPackSupport.keySet());
            Collections.sort(keySet);
            this.createRow(allPackSupport, keySet);
        }
    }

    private void createRow(String key, String supportVers) {
        DefaultTableRow row = new DefaultTableRow(this.tableColumn.length, (Object)key);
        row.setValueAt(0, (Object)key);
        row.setValueAt(1, (Object)supportVers);
        this.model.addRow(new TableRow[]{row});
    }

    private void createRow(Map<String, SupportVersion> allPackSupport, List<String> keySet) {
        for (String key : keySet) {
            SupportVersion product = allPackSupport.get(key);
            String versions = product.getSupportShowVersion();
            this.createRow(key, versions);
        }
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }
}

