/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui.listener;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.ui.OemMainFrame;
import com.huawei.ism.tool.oem.ui.ShowParseErrorDialog;
import com.huawei.ism.tool.oem.ui.listener.InitCallable;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.Callable;
import javax.swing.JFrame;

public class OemMainWindowListener
extends WindowAdapter {
    private OemMainFrame mainFrame;

    public OemMainWindowListener(OemMainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeAction();
    }

    private void closeAction() {
        String tip = ResourceUtil.getString((String)"oem.tool.exit.warn.remind");
        if (OemDataContext.getInstance().isExecutingOem() && !this.confirmClose(tip)) {
            return;
        }
        Runtime.getRuntime().exit(0);
    }

    private boolean confirmClose(String tip) {
        return DialogUtils.showYesNoDialog((Window)((Object)this.mainFrame), (String)tip).getValue() == 0;
    }

    @Override
    public void windowOpened(WindowEvent e) {
        AsyncExcutor.execute((Window)((Object)this.mainFrame), (Callable[])new Callable[]{new InitCallable(this.mainFrame)});
        OemDataContext dataContext = OemDataContext.getInstance();
        if (!dataContext.getFailePackage().isEmpty()) {
            ShowParseErrorDialog dialog = new ShowParseErrorDialog((JFrame)((Object)this.mainFrame));
            dialog.setModal(true);
            dialog.setVisible(true);
        }
    }
}

