/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui.listener;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.ExecuteResult;
import com.huawei.ism.tool.oem.ui.ErrorDetailOemDialog;
import com.huawei.ism.tool.oem.ui.OemMainFrame;
import com.huawei.ism.tool.oem.ui.layout.OemMainLayout;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;

public class ShowDetailListener
extends MouseAdapter {
    private OemMainFrame mainFrame;
    private OemMainLayout layout;

    public ShowDetailListener(OemMainFrame mainFrame, OemMainLayout layout) {
        this.mainFrame = mainFrame;
        this.layout = layout;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event) || event.getClickCount() > 1) {
            return;
        }
        DevNode devNode = this.mainFrame.getCurrentChosenDevNode();
        int index = this.getListIndex(event.getPoint(), this.layout.getDetail());
        if (-1 == index) {
            return;
        }
        List<ExecuteResult> execResultList = OemDataContext.getInstance().getDevExeResults(devNode);
        if (null != execResultList) {
            ExecuteResult rec = execResultList.get(index);
            ErrorDetailOemDialog detailDialog = new ErrorDetailOemDialog(rec.getDetail(), this.mainFrame);
            detailDialog.setVisible(true);
        }
    }

    private int getListIndex(Point point, JList detailList) {
        int index = -1;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)obj;
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }
}

