/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui.support;

import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.ui.OemMainFrame;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Frame;
import java.text.MessageFormat;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class AddDevObservers
extends JDialog
implements INodeObserver {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AddDevObservers.class);
    private OemMainFrame mainFrame;

    public AddDevObservers(OemMainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void fireNodeAdd(DevNode dev) throws ToolException {
        TaskResult result = new TaskResult();
        String deviceTypeandVersion = "";
        String deviceIp = "";
        if (null == dev) {
            return;
        }
        if (!OemDataContext.getInstance().isSupport()) {
            deviceIp = dev.getIp();
            deviceTypeandVersion = dev.getDeviceType().toString() + " " + dev.getProductVersion();
            result.setErrorId("oem.tool.execute.device.add.deviceadddialog.nosupportdevtype");
            result.setErrorLocaleDescription(MessageFormat.format(ResourceUtil.getString((String)"oem.tool.execute.device.add.deviceadddialog.nosupportdevtype"), deviceIp, deviceTypeandVersion));
            DialogUtils.showInfoDialog((Frame)((Object)this.mainFrame), (String)result.getErrorLocaleDescription());
            LOGGER.error("The product version is : " + dev.getProductVersion() + ",and it's not support.Delete it!");
            DefaultNodeProviderImpl.getInstance().removeNode(dev);
            this.setVisible(true);
            return;
        }
        this.mainFrame.bindDeviceData();
    }

    public void fireNodeDelete(DevNode dev) throws ToolException {
    }

    public void fireNodeModify(DevNode dev) throws ToolException {
    }
}

