/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui.support;

import com.huawei.ism.tool.oem.ui.support.CompCellClickAdapter;
import com.huawei.ism.tool.oem.ui.support.CompLabel;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CompCell
extends IsmTableCell {
    private static final long serialVersionUID = 3437596994348375009L;
    private static CompCellRender render = new CompCellRender();
    private CompLabel[] subLabels;
    private int marginValue = 2;
    private CompLabel clickLabel;

    public CompCell(CompLabel ... label) {
        this(2, label);
    }

    public CompCell(int marginValue, CompLabel ... label) {
        this.marginValue = marginValue;
        this.subLabels = label;
    }

    public void setMargin(int margin) {
        this.marginValue = margin;
    }

    public TableCellRenderer getRender() {
        return render;
    }

    public ActionListener getAction() {
        return new CompCellClickAdapter(this);
    }

    public CompLabel getClickLabel() {
        return this.clickLabel;
    }

    public int compareTo(IsmTableCell op) {
        if (!(op instanceof CompCell)) {
            return -1;
        }
        CompCell other = (CompCell)op;
        int minLength = this.subLabels.length < other.subLabels.length ? this.subLabels.length : other.subLabels.length;
        int weight = 0;
        for (int count = 0; count < minLength; ++count) {
            String thisVal = this.subLabels[count].getText();
            String thatVal = other.subLabels[count].getText();
            weight = weight * 10 + thisVal.compareTo(thatVal);
        }
        return weight;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompCell)) {
            return false;
        }
        CompCell other = (CompCell)((Object)obj);
        if (this.subLabels.length != other.subLabels.length) {
            return false;
        }
        for (int count = 0; count < this.subLabels.length; ++count) {
            if (this.subLabels[count].equals(other.subLabels[count])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (CompLabel cell : this.subLabels) {
            hashCode += cell.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer descBuf = new StringBuffer("");
        for (CompLabel cell : this.subLabels) {
            descBuf = descBuf.append(":").append(cell.getText());
        }
        String desc = descBuf.toString();
        if (desc.endsWith(":")) {
            desc = desc.substring(0, desc.length() - 1);
        }
        return desc;
    }

    public boolean isMouseInBounds(MouseEvent event, Rectangle rect) {
        Point tableCellLocation = rect.getLocation();
        Point mousePosition = event.getPoint();
        Point mouseRelativeLocation = new Point();
        mouseRelativeLocation.setLocation(mousePosition.getX() - tableCellLocation.getX(), mousePosition.getY() - tableCellLocation.getY());
        for (CompLabel label : this.subLabels) {
            Rectangle bounds = label.getBounds();
            if (!bounds.contains(mouseRelativeLocation)) continue;
            this.clickLabel = label;
            return true;
        }
        return false;
    }

    private static class CompCellRender
    extends IsmTableCell.CustomTableCellRender {
        private static final long serialVersionUID = 7057533522462966382L;

        private CompCellRender() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof CompCell) {
                CompCell cell = (CompCell)((Object)value);
                CompLabel[] subLabels = cell.subLabels;
                JPanel comp = new JPanel();
                for (CompLabel label : subLabels) {
                    comp.add(Box.createHorizontalStrut(cell.marginValue));
                    comp.add(label);
                }
                this.setBackGround(table, isSelected, row, comp);
                return comp;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

