/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui.support;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.OemUIContext;
import com.huawei.ism.tool.oem.entity.ExecuteResult;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DetailListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 100000010L;
    private static final int NUMBER_100 = 100;
    private static final int NUMBER_180 = 180;
    private static final int NUMBER_280 = 280;
    private static final int NUMBER_39 = 39;
    private static final int NUMBER_520 = 520;
    private static final int NUMBER_18 = 18;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg = null;
        boolean isComponentSelected = isSelected;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isComponentSelected = true;
        }
        JPanel viewPan = new JPanel();
        this.checkDescLabel(value, viewPan);
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        if (isComponentSelected) {
            viewPan.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty((String)"setForeground", (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPan});
        } else {
            viewPan.setBackground(list.getBackground());
            viewPan.setForeground(list.getForeground());
        }
        return viewPan;
    }

    void checkDescLabel(Object value, JPanel viewPan) {
        if (value instanceof ExecuteResult) {
            ExecuteResult result = (ExecuteResult)value;
            JLabel devNodeLabel = new JLabel();
            devNodeLabel.setPreferredSize(new Dimension(100, devNodeLabel.getPreferredSize().height));
            int dLength = 0;
            if (result.getDevNode() != null) {
                String ip = result.getDevNode().getIp();
                int len = ip.length();
                dLength = Math.min(280 * len / 39 - 100, 180);
                if (StringUtils.isIpv6Address(ip) && dLength > 0) {
                    devNodeLabel.setPreferredSize(new Dimension(dLength + 100, devNodeLabel.getPreferredSize().height));
                }
                devNodeLabel.setText(result.getDevNode().getIp());
            }
            String date = result.getStartDateString();
            JLabel descLabel = new JLabel(result.getDescription());
            Dimension descLabelSize = new Dimension(520 - dLength, 18);
            UiMethod.setComponentSize((Dimension)descLabelSize, (Component[])new Component[]{descLabel});
            JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), new JLabel(date)});
            JLabel resultLabel = new JLabel("");
            if (!result.isProcessing()) {
                resultLabel.setIcon(this.getResultIcon(result));
                resultLabel.setText(this.getResultString(result));
            } else {
                resultLabel.setIcon(OemUIContext.PROCESSING_IMAGE);
                resultLabel.setText(ResourceUtil.getString((String)"oem.tool.execute.processing"));
            }
            JComponent view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, devNodeLabel, descLabel, Box.createGlue(), resultLabel, Box.createHorizontalStrut(8)});
            viewPan.setLayout(new BorderLayout());
            viewPan.add((Component)view, "North");
            viewPan.setToolTipText(result.getDescription());
        }
    }

    public String getResultString(ExecuteResult result) {
        if (result.isSuccess()) {
            return ResourceUtil.getString((String)"oem.tool.execute.sus");
        }
        return ResourceUtil.getString((String)"oem.tool.execute.failed");
    }

    private ImageIcon getResultIcon(ExecuteResult result) {
        if (result.isSuccess()) {
            return OemUIContext.SUCCESS_IMAGE;
        }
        return OemUIContext.FAILED_IMAGE;
    }
}

