/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.utils;

import com.huawei.ism.tool.oem.logic.task.ImportTask;
import com.huawei.ism.tool.oem.logic.task.OemTask;
import com.huawei.ism.tool.oem.logic.task.PowerOffTask;
import com.huawei.ism.tool.oem.logic.task.RollBackTask;
import java.util.Locale;
import org.slf4j.LoggerFactory;

public enum CmdType {
    IMPORTOEM{

        @Override
        public OemTask getTask() {
            return new ImportTask();
        }
    }
    ,
    ROLLBACK{

        @Override
        public OemTask getTask() {
            return new RollBackTask();
        }
    }
    ,
    POWEROFF{

        @Override
        public OemTask getTask() {
            return new PowerOffTask();
        }
    };


    public static CmdType getCmdType(String type) {
        String uperType = type.toUpperCase(Locale.ENGLISH);
        try {
            return CmdType.valueOf(uperType);
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(CmdType.class).info("get cmdType failed");
            return null;
        }
    }

    public abstract OemTask getTask();
}

