/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.utils;

import com.huawei.ism.tool.oem.logic.handler.HandleConFile;
import com.huawei.ism.tool.oem.logic.handler.HandleImageFIle;
import com.huawei.ism.tool.oem.logic.handler.HandleIniFile;
import com.huawei.ism.tool.oem.logic.handler.HandleJsFile;
import com.huawei.ism.tool.oem.logic.handler.HandleProFile;
import com.huawei.ism.tool.oem.service.impl.HandleAbstracter;
import java.util.Locale;

public enum HandleType {
    IMAGE{

        @Override
        public HandleAbstracter getHandler() {
            return new HandleImageFIle();
        }
    }
    ,
    JS{

        @Override
        public HandleAbstracter getHandler() {
            return new HandleJsFile();
        }
    }
    ,
    CONF{

        @Override
        public HandleAbstracter getHandler() {
            return new HandleConFile();
        }
    }
    ,
    PROPERTIES{

        @Override
        public HandleAbstracter getHandler() {
            return new HandleProFile();
        }
    }
    ,
    INI{

        @Override
        public HandleAbstracter getHandler() {
            return new HandleIniFile();
        }
    };


    public static HandleType getHandler(String type) {
        String uperType = type.toUpperCase(Locale.ENGLISH);
        try {
            return HandleType.valueOf(uperType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public abstract HandleAbstracter getHandler();
}

