/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.thread;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConsumer
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(StreamConsumer.class);
    private InputStream inputStream;

    public StreamConsumer(InputStream inputStream) {
        super.setName("stream-consume");
        this.inputStream = inputStream;
    }

    public StreamConsumer(InputStream inputStream, String threadName) {
        super.setName(threadName);
        this.inputStream = inputStream;
    }

    @Override
    public void run() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8));){
            String lineStr;
            while ((lineStr = bufferedReader.readLine()) != null) {
                if (StringUtils.containsAny((CharSequence)lineStr, (CharSequence[])new CharSequence[]{"password", "pwd", "token", "session", "ERR_NAME_NOT_RESOLVED", "securityKey"})) {
                    log.info("*******");
                    continue;
                }
                log.info(lineStr);
            }
            log.info("stream consumer end.");
        }
        catch (IOException e) {
            log.error("consume inputStream error.", (Throwable)e);
        }
    }
}

