/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.crypto;

import com.huawei.ism.tool.base.utils.crypto.AesCrypterManager;
import com.huawei.ism.tool.base.utils.crypto.EserviceKmcAesCrypterManager;
import java.util.Arrays;

public class CryptoManagerFactory {
    public static final String KMC = "kmc";
    public static final String WCC = "wcc";
    private static String cryptoType = "kmc";

    public static AesCrypterManager getInstance(String crypterName) {
        return CryptoEnums.findCryptoManager(cryptoType).getManagerInstance();
    }

    public static void setCryptoType(String cryptoType) {
        CryptoManagerFactory.cryptoType = cryptoType;
    }

    private static enum CryptoEnums {
        KMC("kmc"){

            @Override
            AesCrypterManager getManagerInstance() {
                return EserviceKmcAesCrypterManager.getInstance();
            }
        }
        ,
        INVALID("invalid");

        String crypterName;

        private CryptoEnums(String crypterName) {
            this.crypterName = crypterName;
        }

        AesCrypterManager getManagerInstance() {
            return null;
        }

        static CryptoEnums findCryptoManager(String crypterName) {
            return Arrays.stream(CryptoEnums.values()).filter(cryptoEnum -> cryptoEnum.crypterName.equalsIgnoreCase(crypterName.trim())).findAny().orElse(INVALID);
        }
    }
}

