/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.crypto;

import com.huawei.encryptbase.utils.AesEncryptUtils;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.base.utils.crypto.AesCrypterManager;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EserviceKmcAesCrypterManager
implements AesCrypterManager {
    private static final Logger log = LoggerFactory.getLogger(EserviceKmcAesCrypterManager.class);
    public static final String KMC_APPCONFIG_PATH = "eservice.tools.encrypt.param.config.path";
    public static final String INITIALIZED_KMC_CONFIG_PATH;
    private static final String KMC_APP_CONFIG_DIR_NAME = "mm";
    private static final String KMC_APP_CONFIG_FINE_NAME = "appConfig.properties";
    private static final String STANDBY_KEY_STORE_FILE_KEY_NAME = "standby_key_store_file";
    private static final String STANDBY_KEY_STORE_FILE_FILE_NAME = "s1.ks";
    private static final String PRIMARY_KEY_STORE_FILE_KEY_NAME = "primary_key_store_file";
    private static final String PRIMARY_KEY_STORE_FILE_FILE_NAME = "k1.ks";
    private static final String AUTO_UPDATE_MK_ENABLED = "auto_update_mk_enabled";
    private static final String AUTO_UPDATE_FLAG = "true";
    private static final String KMC_DEFAULT_CONFIG = "config";
    private static final String KMC_DEFAULT_CONFIG_DIR = "/config/appConfig.properties";
    private static final String CONFIG = "config";

    private static void syncKmcConfigPath(String kmcConfigPath) {
        log.info("kmc appConfig = {}", (Object)kmcConfigPath);
        log.info("before KMC appConfig is set, kmcAppConfig from the property = {}", (Object)StringUtils.getCleanMessage(System.getProperty(KMC_APPCONFIG_PATH)));
        if (StringUtils.isNULLStr(System.getProperty(KMC_APPCONFIG_PATH))) {
            if (!VerifyUtil.isEmpty(kmcConfigPath) && new File(kmcConfigPath).exists()) {
                System.setProperty(KMC_APPCONFIG_PATH, kmcConfigPath);
                log.info("after KMC appConfig is set, kmcAppConfig from the property = {}", (Object)StringUtils.getCleanMessage(System.getProperty(KMC_APPCONFIG_PATH)));
            } else {
                log.info("kmc appConfig not exist.");
            }
        } else {
            log.info("kmc appConfig from properties:{}", (Object)StringUtils.getCleanMessage(System.getProperty(KMC_APPCONFIG_PATH)));
        }
    }

    private static String initKmcConfigPath() {
        String kmcConfigPath = System.getenv("kmcConfigPath");
        log.info("kmcConfigPath = {}", (Object)StringUtils.getCleanMessage(kmcConfigPath));
        if (PlatformAppContext.getInstance().getRuntime() == null) {
            log.info("curr runtime is null");
            return "";
        }
        if (VerifyUtil.isEmpty(kmcConfigPath)) {
            if (EserviceKmcAesCrypterManager.isStartFromToolBox()) {
                log.info("is start from toolbox.");
                kmcConfigPath = EserviceKmcAesCrypterManager.getKmcAppConfigDefaultPath();
            } else {
                kmcConfigPath = SystemEnvUtil.getDefaultUserDir() + File.separator + "config" + File.separator + KMC_APP_CONFIG_DIR_NAME + File.separator + KMC_APP_CONFIG_FINE_NAME;
                EserviceKmcAesCrypterManager.initKmcConfigFile(kmcConfigPath);
            }
        }
        kmcConfigPath = FilePathUtils.checkFile(kmcConfigPath).replace("\\", "/");
        return kmcConfigPath;
    }

    private static boolean isStartFromToolBox() {
        String curWorkPath = SystemEnvUtil.getDefaultUserDir();
        log.info("curWorkPath = {}", (Object)curWorkPath);
        boolean curWorkPathHasIniFlag = new File(curWorkPath, "tool.ini").exists();
        log.info("curWorkPathHasIniFlag = {}", (Object)curWorkPathHasIniFlag);
        File toolBoxWorkPath = new File(curWorkPath).getParentFile().getParentFile();
        boolean toolsFlag = new File(toolBoxWorkPath, "tools").exists();
        log.info("toolsFlag = {},", (Object)toolsFlag);
        return curWorkPathHasIniFlag && toolsFlag;
    }

    public static String getKmcAppConfigDefaultPath() {
        StringBuilder kmcConfigFilePath = new StringBuilder(ApplicationContext.getInstance().getCurrWorkPath());
        kmcConfigFilePath.append("config").append(File.separator).append(KMC_APP_CONFIG_DIR_NAME).append(File.separator).append(KMC_APP_CONFIG_FINE_NAME);
        String path = FilePathUtils.getCanonicalPath(new File(kmcConfigFilePath.toString()));
        path = path.replace("\\", "/");
        return path;
    }

    private static void initKmcConfigFile(String kmcConfigPath) {
        String userCfgDir = SystemEnvUtil.getDefaultUserDir() + File.separator + "config";
        if (userCfgDir.equals(EserviceKmcAesCrypterManager.getToolBoxCfgDir())) {
            EserviceKmcAesCrypterManager.initKmcConfigFileFromTemplate(kmcConfigPath);
        }
    }

    private static String getToolBoxCfgDir() {
        String workPath = ApplicationContext.getInstance().getCurrWorkPath();
        StringBuilder sbBuilder = new StringBuilder(workPath);
        sbBuilder.append("config");
        return sbBuilder.toString();
    }

    private static void initKmcConfigFileFromTemplate(String kmcConfigPath) {
        Properties appConfigPerties = new Properties();
        try (InputStream in = AesEncryptUtils.class.getResourceAsStream(KMC_DEFAULT_CONFIG_DIR);
             BufferedReader br = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));){
            String line = "";
            while ((line = br.readLine()) != null) {
                if (!line.contains("=")) continue;
                String[] lines = line.split("=");
                String lineKey = lines[0].trim();
                if (lineKey.equals(STANDBY_KEY_STORE_FILE_KEY_NAME)) {
                    appConfigPerties.put(lineKey, EserviceKmcAesCrypterManager.getStandByKeyStoreFileValue());
                    continue;
                }
                if (lineKey.equals(PRIMARY_KEY_STORE_FILE_KEY_NAME)) {
                    appConfigPerties.put(lineKey, EserviceKmcAesCrypterManager.getPrimaryKeyStoreFileValue());
                    continue;
                }
                if (lineKey.equals(AUTO_UPDATE_MK_ENABLED)) {
                    appConfigPerties.put(lineKey, AUTO_UPDATE_FLAG);
                    continue;
                }
                appConfigPerties.put(lineKey, lines[1]);
            }
        }
        catch (IOException e) {
            log.error("read info from template error.");
        }
        File kmcConfigForPluginFile = new File(kmcConfigPath.replace("\\", "/"));
        if (!kmcConfigForPluginFile.getParentFile().exists() && !kmcConfigForPluginFile.getParentFile().mkdirs()) {
            log.error("create config mm appConfig.properties failed.");
        }
        try (FileOutputStream oFile = new FileOutputStream(kmcConfigForPluginFile);){
            appConfigPerties.store(oFile, "");
        }
        catch (IOException e) {
            log.error("save info to file error.");
        }
    }

    private static String getStandByKeyStoreFileValue() {
        String s1KeyStoreValue = ApplicationContext.getInstance().getWorkPath() + File.separator + "config" + File.separator + STANDBY_KEY_STORE_FILE_FILE_NAME;
        return s1KeyStoreValue;
    }

    private static String getPrimaryKeyStoreFileValue() {
        String k1KeyStoreValue = ApplicationContext.getInstance().getWorkPath() + File.separator + "config" + File.separator + PRIMARY_KEY_STORE_FILE_FILE_NAME;
        return k1KeyStoreValue;
    }

    @Override
    public boolean isInitSuccess() {
        return true;
    }

    @Override
    public String performEncrypt(String content) {
        String result = AesEncryptUtils.encryptByAes((String)content);
        EserviceKmcAesCrypterManager.logResult(result, "encrypt");
        return result;
    }

    @Override
    public String performDecrypt(String content) {
        String result = AesEncryptUtils.decryptByAes((String)content);
        EserviceKmcAesCrypterManager.logResult(result, "decrypt");
        return result;
    }

    public static void setKmcConfigPath(String[] args) {
        log.info("args = {}", (Object)Arrays.toString(args));
        String kmcAppConfigPath = "";
        for (int j = 0; j < args.length; ++j) {
            if (args[j].indexOf("-kmcConfigPath=") != 0) continue;
            kmcAppConfigPath = args[j].substring("-kmcConfigPath=".length());
            break;
        }
        log.info("kmc config path = {}", (Object)kmcAppConfigPath);
        if (VerifyUtil.isEmpty(kmcAppConfigPath)) {
            log.error("kmc app config path is empty");
        } else {
            System.setProperty(KMC_APPCONFIG_PATH, kmcAppConfigPath);
        }
    }

    private static void logResult(String result, String type) {
        String logHeader = StringUtils.isNULLStr(result) ? "Failed to " : "Success to ";
        log.info("{} {}", (Object)logHeader, (Object)type);
    }

    public static EserviceKmcAesCrypterManager getInstance() {
        return EServiceKmcAesCrypterManagerHolder.INSTANCE;
    }

    private EserviceKmcAesCrypterManager() {
    }

    static {
        String kmcConfigPath = EserviceKmcAesCrypterManager.initKmcConfigPath();
        EserviceKmcAesCrypterManager.syncKmcConfigPath(kmcConfigPath);
        INITIALIZED_KMC_CONFIG_PATH = kmcConfigPath;
    }

    private static class EServiceKmcAesCrypterManagerHolder {
        private static final EserviceKmcAesCrypterManager INSTANCE = new EserviceKmcAesCrypterManager();

        private EServiceKmcAesCrypterManagerHolder() {
        }
    }
}

