/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.runtime;

import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.framework.platform.common.data.DataType;
import com.huawei.ism.tool.framework.platform.listener.IListener;
import com.huawei.ism.tool.framework.platform.runtime.SystemProperties;
import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktakerFactory;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuntime {
    private static final Logger log = LoggerFactory.getLogger(AbstractRuntime.class);
    private static final Locale[] SUPPORTED_LAN = new Locale[]{Locale.CHINESE, Locale.ENGLISH};
    private static final String USER_CFG = DataType.cfg.getDirName() + File.separator + "system.ini";
    private String workPath;
    private String vender = "Huawei";
    private SystemProperties appConfigs;
    private final String jreVersion = System.getProperty("java.version");
    private boolean junitMode = false;
    private final Map<String, Object> propertyMap = new ConcurrentHashMap<String, Object>();
    private final List<IListener> listeners = new ArrayList<IListener>();

    public AbstractRuntime(String workPath) {
        this.workPath = workPath;
        this.appConfigs = new SystemProperties(workPath);
        String venderStr = this.appConfigs.getValue("app.oem.vender");
        if (null != venderStr && !"".equals(venderStr)) {
            this.vender = venderStr;
        }
    }

    public final Class<?> loadClass(String className) {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkAccess(Thread.currentThread());
            }
            return Class.forName(className);
        }
        catch (Exception e) {
            log.error("Load class failed: " + className, (Throwable)e);
            return null;
        }
    }

    public AbstractRuntime() {
        this(SystemEnvUtil.getDefaultUserDir());
    }

    public Locale[] getSupportedLans() {
        return null == SUPPORTED_LAN ? null : (Locale[])SUPPORTED_LAN.clone();
    }

    public String getVender() {
        return this.vender;
    }

    public void setProperty(String key, Object value, boolean persist) {
        this.propertyMap.put(key, value);
    }

    public Object getProperty(String key) {
        return this.propertyMap.get(key);
    }

    public String getAppConfig(String key) {
        return this.appConfigs.getValue(key);
    }

    public String getAppConfigNoExcept(String key) {
        try {
            return this.getAppConfig(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isJreSupported() {
        return this.jreVersion.matches(this.getAppConfig("app.supported.jre.version"));
    }

    public void setJUnitMode() {
        this.junitMode = true;
    }

    public boolean isJunit() {
        return this.junitMode;
    }

    public final String getWorkPath() {
        return this.workPath;
    }

    public String getPath(DataType type) {
        return this.getWorkPath() + File.separator + type.getDirName() + File.separator;
    }

    public String getVersion() {
        return this.appConfigs.getValue("app.version");
    }

    public String getReleaseDate() {
        return this.appConfigs.getValue("app.release.date");
    }

    public String getReleaseTimeMark() {
        return this.appConfigs.getValue("app.release.time.mark");
    }

    public String getSupportEncryptionAlgorithm() {
        return this.appConfigs.getValue("app.support.encryption.algorithm");
    }

    public String getUserDataPath() {
        String path = this.getPath(DataType.data);
        if (!this.checkAndCreateDir(path)) {
            log.error("Failed to create dir:" + path);
            return "";
        }
        return path;
    }

    public File getUserCfgFile() {
        return new File(this.getWorkPath() + File.separator + USER_CFG);
    }

    public boolean isEnglishEnv() {
        String lan = Locale.getDefault().getLanguage();
        return lan.equals(Locale.ENGLISH.getLanguage());
    }

    public boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        if (null == osName) {
            throw new EncapsulatedRuntimeException("cannot get the os.name from SystemProperty.");
        }
        String osSystem = osName.toLowerCase(Locale.ENGLISH);
        if (osSystem.contains("windows")) {
            return true;
        }
        if (osSystem.contains("linux")) {
            return false;
        }
        return false;
    }

    public String getSystemTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getObaseResPath(String pluginId) {
        return "config/resource/languages/" + pluginId;
    }

    public String getJreVersion() {
        return this.jreVersion;
    }

    public void addListener(IListener listener) {
        if (!this.listeners.contains(listener)) {
            if (log.isInfoEnabled()) {
                log.info("Add listener: " + listener.getListenerName());
            }
            this.listeners.add(listener);
        }
    }

    public void removeListener(IListener listener) {
        this.listeners.remove(listener);
    }

    public <T> List<T> getListenerList(Class<T> classType) {
        if (null == classType) {
            return new ArrayList(0);
        }
        ArrayList<IListener> list = new ArrayList<IListener>();
        for (IListener listener : this.listeners) {
            if (!classType.isInstance(listener)) continue;
            IListener temp = listener;
            list.add(temp);
        }
        return list;
    }

    public abstract AbstractWorktakerFactory createWorktakerFactory(String var1, ClassLoader var2);

    private boolean checkAndCreateDir(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            return true;
        }
        return dir.mkdirs();
    }

    public String getUserReturnPath() {
        String path = this.getWorkPath() + File.separator + DataType.upload.getDirName() + File.separator + "toolbox" + File.separator;
        if (!this.checkAndCreateDir(path)) {
            log.error("Failed to create dir:" + path);
            return "";
        }
        return path;
    }

    public String getUserTempReturnPath() {
        String path = this.getWorkPath() + File.separator + DataType.temp.getDirName() + File.separator + "toolbox" + File.separator;
        if (!this.checkAndCreateDir(path)) {
            log.error("Failed to create dir:" + path);
            return "";
        }
        return path;
    }
}

