/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.sceneimpl;

import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.service.ITooServceInvoker;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Map;
import org.slf4j.Logger;

public class ToolServiceInvoker
implements ITooServceInvoker {
    private static final String LOG_PATH_NAME = "log";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ToolServiceInvoker.class);

    private ToolServiceInvoker() {
    }

    public static ITooServceInvoker getInstance() {
        return Holder.INSITANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void invoke(String startUpJarFileName, String toolPathName, Map<String, Object> context) {
        block7: {
            String toolBoxPath = ContextUtil.getToolBoxPath();
            String startUpJarPath = this.buildJarPath(startUpJarFileName, toolPathName, toolBoxPath);
            URL url = null;
            context.put("result", Boolean.FALSE);
            try {
                url = new URL("jar:file:" + File.separator + startUpJarPath + "!/");
                ClassLoader urlLoader = this.addJarToSystem(startUpJarPath, url);
                this.setUserDir(toolPathName, toolBoxPath);
                Boolean isInvoke = this.invokeAndSetResult(context, urlLoader);
                LOGGER.info("invokeSubMethod over.result:{}", (Object)isInvoke);
                this.releaseJar(url);
            }
            catch (ClassNotFoundException e) {
                context.put("result", Boolean.FALSE);
                context.put("CLASS_NOT_FOUND", Boolean.TRUE);
                LOGGER.warn("expansion tool may mot be the latest one.", (Throwable)e);
                this.releaseJar(url);
            }
            catch (Exception e2) {
                context.put("result", Boolean.FALSE);
                LOGGER.error("error to execute", (Throwable)e2);
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.releaseJar(url);
            }
        }
    }

    public String buildJarPath(String startUpJarFileName, String toolPathName, String toolBoxPath) {
        String sourceFile = toolBoxPath + "tools" + File.separator + toolPathName + File.separator + "plugins" + File.separator + startUpJarFileName;
        String targetFile = toolBoxPath + "tmp" + File.separator + startUpJarFileName;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("sourceFile=" + sourceFile + ",targetFile=" + targetFile);
        }
        StreamUtils.copyFile(new File(sourceFile), new File(targetFile));
        if (new File(targetFile).exists()) {
            LOGGER.info("copy jar file success.");
            return targetFile;
        }
        return sourceFile;
    }

    public ClassLoader addJarToSystem(String startUpJarPath, URL url) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("startUpJarPath jarpath=" + startUpJarPath + "url=" + url);
        }
        ClassLoader urlLoader = ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        ReflectionUtils.setAccessable(method, true);
        method.invoke((Object)urlLoader, url);
        return urlLoader;
    }

    public Boolean invokeAndSetResult(Map<String, Object> context, ClassLoader urlLoader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> invokeClass = urlLoader.loadClass((String)context.get("INVOKE_CLASS"));
        String defaultMethod = (String)context.get("defaultMethod");
        Method execMethod = invokeClass.getMethod(defaultMethod == null ? "check" : defaultMethod, Window.class, Map.class);
        Boolean result = (Boolean)execMethod.invoke(invokeClass.newInstance(), context.get("parentWindow"), context);
        context.put("result", result);
        return result;
    }

    public void setUserDir(String toolPathName, String toolBoxPath) {
        StringBuilder workDir = new StringBuilder().append(toolBoxPath).append(LOG_PATH_NAME).append(File.separator).append(toolPathName).append(File.separator);
        System.setProperty("user.dir", workDir.toString());
    }

    private void releaseJar(URL url) {
        try {
            if (url == null) {
                return;
            }
            LOGGER.info("begin to uninstall jar.");
            URLConnection uc = url.openConnection();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("actual type=" + uc.getClass().getName());
            }
            if (uc instanceof JarURLConnection) {
                LOGGER.info("is jarurlconnection.");
                uc.setUseCaches(true);
                ((JarURLConnection)uc).getJarFile().close();
            }
        }
        catch (Exception e) {
            LOGGER.error("uninstall jar error.", (Throwable)e);
        }
    }

    private static class Holder {
        private static final ITooServceInvoker INSITANCE = new ToolServiceInvoker();

        private Holder() {
        }
    }
}

