/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.treetable;

import com.huawei.ism.tool.base.ui.component.treetable.ITreeTableRow;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TreeTableModel
extends AbstractTableModel {
    public static final int NAME_COLUMN = 0;
    private static final long serialVersionUID = 7995224461642240234L;
    private transient List<RowItem> allItemList;
    private transient List<RowItem> publishedItemList;
    private transient List<ITreeTableRow<?, ?>> tableRows = new ArrayList();
    private String[] tableColumns = null;

    public TreeTableModel(String[] tableColumns) {
        this.tableColumns = null == tableColumns ? null : (String[])tableColumns.clone();
        this.allItemList = new ArrayList<RowItem>();
        this.publishedItemList = new ArrayList<RowItem>();
    }

    @Override
    public String getColumnName(int column) {
        return this.tableColumns[column];
    }

    public List<RowItem> getAllItemList() {
        return this.allItemList;
    }

    public void setRows(ITreeTableRow<?, ?> ... newRows) {
        this.tableRows.clear();
        for (ITreeTableRow<?, ?> iTreeTableRow : newRows) {
            this.tableRows.add(iTreeTableRow);
        }
        this.buildModel();
    }

    public List<ITreeTableRow<?, ?>> getAllTableRows() {
        ArrayList allRowsList = new ArrayList();
        for (RowItem item : this.allItemList) {
            allRowsList.add(item.getTableRow());
        }
        return allRowsList;
    }

    public void deleteRow(ITreeTableRow<?, ?> row) {
        ITreeTableRow<?, ?> parentRow = row.getParentRow();
        if (null == parentRow) {
            this.tableRows.remove(row);
        } else {
            for (ITreeTableRow<?, ?> tableRow : this.tableRows) {
                if (!parentRow.equals(tableRow)) continue;
                tableRow.getSubRowList().remove(row);
            }
        }
        this.allItemList.clear();
        this.addRowListToModel(this.tableRows, null);
        this.updateVisiableRows(true);
    }

    public void updateRow(ITreeTableRow<?, ?> newTableRow) {
        ITreeTableRow<?, ?> parentRow = newTableRow.getParentRow();
        if (null != parentRow) {
            this.updateRow(parentRow, newTableRow);
        } else {
            for (ITreeTableRow<?, ?> parent : this.tableRows) {
                this.updateRow(parent, newTableRow);
            }
        }
        int currentRow = this.getIndexInItemList(this.allItemList, newTableRow);
        if (currentRow < 0) {
            return;
        }
        RowItem rowItem = this.allItemList.get(currentRow);
        rowItem.setTableRow(newTableRow);
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    private void updateRow(ITreeTableRow<?, ?> parentTableRow, ITreeTableRow<?, ?> childRow) {
        int index = parentTableRow.getSubRowList().indexOf(childRow);
        if (-1 != index) {
            parentTableRow.getSubRowList().set(index, childRow);
        }
    }

    private int getIndexInItemList(List<RowItem> itemList, ITreeTableRow<?, ?> iTreeTableRow) {
        for (RowItem item : itemList) {
            if (!item.getTableRow().equals(iTreeTableRow)) continue;
            return itemList.indexOf(item);
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.length;
    }

    public int getAllRowCount() {
        return this.allItemList.size();
    }

    @Override
    public int getRowCount() {
        return this.publishedItemList.size();
    }

    public RowItem getRowElement(int rowIdx) {
        if (-1 == rowIdx) {
            return null;
        }
        if (this.publishedItemList.size() <= rowIdx) {
            return null;
        }
        return this.publishedItemList.get(rowIdx);
    }

    public ITreeTableRow<?, ?> getRow(int rowIdx) {
        return this.publishedItemList.get(rowIdx).getTableRow();
    }

    public int getRowItemIndex(RowItem rowItem) {
        return this.publishedItemList.indexOf(rowItem);
    }

    public int getRowIndex(Object identifier) {
        for (RowItem rItem : this.allItemList) {
            if (!rItem.getTableRow().getIdentifier().equals(identifier)) continue;
            return this.allItemList.indexOf(rItem);
        }
        return -1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIdx) {
        RowItem item = this.getRowElement(rowIndex);
        if (null == item) {
            return null;
        }
        if (0 == columnIdx) {
            return item;
        }
        return item.getTableRow().getValue(columnIdx);
    }

    protected void updateVisiableRows(boolean isUpdate) {
        this.publishedItemList.clear();
        for (RowItem item : this.allItemList) {
            RowItem parent = item.getParent();
            if (parent != null && !parent.isVisible() && (parent.parent != null || !isUpdate)) continue;
            this.publishedItemList.add(item);
        }
        this.fireTableDataChanged();
    }

    private void buildModel() {
        this.allItemList.clear();
        this.addRowListToModel(this.tableRows, null);
        for (RowItem item : this.allItemList) {
            item.toggle();
        }
        this.fireTableDataChanged();
    }

    private void addRowListToModel(List<?> rowList, RowItem parentItem) {
        for (ITreeTableRow iTreeTableRow : rowList) {
            RowItem rowItem = new RowItem(iTreeTableRow, parentItem);
            this.allItemList.add(rowItem);
            List subRows = iTreeTableRow.getSubRowList();
            this.addRowListToModel(subRows, rowItem);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
    }

    public class RowItem {
        private ITreeTableRow<?, ?> tableRow;
        private RowItem parent;
        private boolean showExpandAndCollapseIcon = true;
        private boolean visible = true;
        private SelectType seletType = SelectType.UNSELECT;

        public RowItem(ITreeTableRow<?, ?> iTreeTableRow, RowItem parent) {
            this.tableRow = iTreeTableRow;
            this.parent = parent;
            boolean bl = this.visible = iTreeTableRow == null;
            if (null != iTreeTableRow) {
                List<ITreeTableRow<?, ?>> subRows = iTreeTableRow.getSubRowList();
                this.showExpandAndCollapseIcon = !subRows.isEmpty();
            }
        }

        public ITreeTableRow<?, ?> getTableRow() {
            return this.tableRow;
        }

        public void setTableRow(ITreeTableRow<?, ?> row) {
            this.tableRow = row;
        }

        public RowItem getParent() {
            return this.parent;
        }

        public int getDepth() {
            int depthInt = 0;
            if (this.parent != null) {
                depthInt = this.parent.getDepth();
                ++depthInt;
            }
            return depthInt;
        }

        public void reverse() {
            if (SelectType.SELECT == this.seletType) {
                this.seletType = SelectType.UNSELECT;
            } else if (SelectType.UNSELECT == this.seletType) {
                this.seletType = SelectType.SELECT;
            }
        }

        public void setSelectType(SelectType selectType) {
            this.seletType = selectType;
        }

        public SelectType getSelectType() {
            return this.seletType;
        }

        public boolean hasExpandAndCollapseIcon() {
            return this.showExpandAndCollapseIcon;
        }

        public void toggle() {
            if (this.hasExpandAndCollapseIcon()) {
                this.visible = !this.visible;
                TreeTableModel.this.updateVisiableRows(false);
            }
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return !(this.parent != null && !this.parent.isVisible() || this.showExpandAndCollapseIcon && !this.visible);
        }

        public String toString() {
            return this.tableRow.getValue(0).toString();
        }
    }

    public static enum SelectType {
        HALF,
        UNSELECT,
        SELECT;

    }
}

