/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.filechooser.toolbox;

import com.huawei.ism.tool.base.ui.UiResource;
import com.huawei.ism.tool.base.ui.file.FileTypeUtils;
import com.huawei.ism.tool.base.ui.filechooser.FileChooserWrapper;
import com.huawei.ism.tool.base.ui.filechooser.HibernateContainer;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolFileChooser {
    private static final int MAX_FILE_LENGTH = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolFileChooser.class);
    private static final String NETWORKPATH = "network shortcuts";
    private static final long REQUIRED_FREE_DISK = 0x6400000L;

    private ToolFileChooser() {
    }

    public static IsmFileChooser createIsmFileChooser(String title, String defaultPath, String description, String[] exts) {
        IsmFileChooser fileChooser = new IsmFileChooser(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (!StringUtils.isNULLStr(defaultPath)) {
            File defaultPackagePath = new File(defaultPath);
            fileChooser.setCurrentDirectory(defaultPackagePath.isDirectory() ? defaultPackagePath : defaultPackagePath.getParentFile());
        } else {
            fileChooser.setCurrentDirectory(null);
        }
        fileChooser.addFileFilter(exts, description);
        return fileChooser;
    }

    public static File selectFile(Window parent, String title, String[] exts, String defaultPathId, String description, int fileSelectionMode, boolean isWindowsOS, Locale locale) {
        return ToolFileChooser.selectFile(parent, title, exts, defaultPathId, description, fileSelectionMode, false, isWindowsOS, locale);
    }

    public static File selectFile(Window parent, String title, String[] exts, String defaultPathId, String description, int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, Locale locale) {
        File file;
        String defaultPath;
        Object defaultPathObj = HibernateContainer.getInstance().get(defaultPathId);
        String string = defaultPath = null != defaultPathObj ? defaultPathObj.toString() : null;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("read filechooser default path: " + defaultPathId + " -->" + defaultPath);
        }
        if (null != (file = ToolFileChooser.selectFileByPath(parent, title, exts, defaultPath, description, fileSelectionMode, isOpenDialog, isWindowsOS, locale))) {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("[Selected file >> " + file.getCanonicalPath() + "][Success]");
                }
                HibernateContainer.getInstance().put(defaultPathId, (Object)file.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("[Selected file exception>> " + e);
            }
        }
        return file;
    }

    public static File selectFileByPath(Window window, String title, String[] exts, String defaultPath, String desc, int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, Locale locale) {
        return ToolFileChooser.selectFileByPathDealDot(window, title, exts, defaultPath, desc, fileSelectionMode, isOpenDialog, isWindowsOS, locale, false);
    }

    public static File selectFileByPathDealDot(Window window, String title, String[] exts, String defaultPath, String desc, int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, Locale locale, boolean isDotsupport) {
        String failFileNames = "";
        IsmFileChooser fileChooser = ToolFileChooser.createIsmFileChooser(title, defaultPath, desc, exts);
        int showResult = ToolFileChooser.checkOpenDialog(window, fileSelectionMode, isOpenDialog, isWindowsOS, (JFileChooser)fileChooser);
        if (showResult == 0) {
            boolean ismatch;
            File aFile = fileChooser.getSelectedFile();
            if (null == aFile) {
                return null;
            }
            String path = null;
            path = ToolFileChooser.checkFileInfo(window, fileSelectionMode, locale, isDotsupport, aFile);
            if (path == null) {
                return null;
            }
            boolean isDirectory = aFile.isDirectory();
            if (!isDirectory && !(ismatch = FileTypeUtils.getInstance().matchFileType(path))) {
                failFileNames = failFileNames + aFile.getName() + System.lineSeparator();
                DialogUtils.showInfoDialog((Window)window, (String)ResourceUtil.getStringWithParams("filechooser.prompt.file.path.extension.inconsistent.error", failFileNames));
                return null;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Selected file is >> " + path + "][Success]");
            }
            return aFile;
        }
        return null;
    }

    static String checkFileInfo(Window window, int fileSelectionMode, Locale locale, boolean isDotsupport, File aFile) {
        String path;
        try {
            path = aFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get path exception:" + e);
            return null;
        }
        if (ToolFileChooser.isNwPath(window, path, locale)) {
            return null;
        }
        if (ToolFileChooser.isNlPath(window, path, locale)) {
            return null;
        }
        if (!ToolFileChooser.checkSpecialChar(path, fileSelectionMode, isDotsupport)) {
            LOGGER.info("The selected path is invailabe.");
            if (isDotsupport) {
                DialogUtils.showInfoDialog((Window)window, (String)ResourceUtil.getString("filechooser.prompt.file.path.specialcharacterdealdot"));
            } else {
                DialogUtils.showInfoDialog((Window)window, (String)ResourceUtil.getString("filechooser.prompt.file.path.specialcharacter"));
            }
            return null;
        }
        if (!ToolFileChooser.checkSelectFile(path, fileSelectionMode)) {
            DialogUtils.showInfoDialog((Window)window, (String)ResourceUtil.getString("filechooser.prompt.file.error.path"));
            return null;
        }
        if (!ToolFileChooser.checkDiskFreeSpace(path, fileSelectionMode)) {
            LOGGER.info("The selected disk space in not enough.");
            DialogUtils.showInfoDialog((Window)window, (String)ResourceUtil.getString("filechooser.prompt.file.remind.diskspacenotenough"));
            return null;
        }
        if (!ToolFileChooser.checkPathDeep(path, fileSelectionMode)) {
            LOGGER.info("The path is too long.");
            DialogUtils.showInfoDialog((Window)window, (String)ResourceUtil.getString("filechooser.prompt.file.max.length"));
            return null;
        }
        if (!ToolFileChooser.checkSpace(window, path)) {
            return null;
        }
        return path;
    }

    static int checkOpenDialog(final Window window, int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, final JFileChooser fileChooser) {
        fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                String type = ev.getPropertyName();
                String newValue = String.valueOf(ev.getNewValue());
                if ("directoryChanged".equals(type) && newValue.length() > 128) {
                    fileChooser.cancelSelection();
                    DialogUtils.showInfoDialog((Window)window, (String)ResourceUtil.getString("filechooser.prompt.file.max.length"));
                }
            }
        });
        FileChooserWrapper.wrapper(fileChooser);
        FileChooserWrapper.setDefaultFileName("", fileChooser, isWindowsOS);
        fileChooser.setFileSelectionMode(fileSelectionMode);
        int showResult = 0;
        showResult = isOpenDialog ? fileChooser.showOpenDialog(window) : fileChooser.showSaveDialog(window);
        return showResult;
    }

    private static boolean checkPathDeep(String filePath, int fileSelectionMode) {
        return filePath.length() <= 128;
    }

    private static boolean checkDiskFreeSpace(String filePath, int fileSelectionMode) {
        if (1 != fileSelectionMode) {
            return true;
        }
        File file = new File(filePath);
        long freeSpace = file.getFreeSpace();
        return freeSpace >= 0x6400000L;
    }

    private static boolean checkSpecialChar(String filePath, int fileSelectionMode, boolean isSupportDot) {
        if (1 != fileSelectionMode) {
            return true;
        }
        String normalizedFilePath = filePath.replaceAll("\\\\", "").replaceAll("/", "").replaceAll(":", "");
        if (isSupportDot) {
            normalizedFilePath = normalizedFilePath.replaceAll("\\.", "");
        }
        if (normalizedFilePath.contains("  ")) {
            return false;
        }
        return normalizedFilePath.matches("[\\w ]+");
    }

    public static String getSaveFilePath(String title, String suffix, Window pDialog, String defaultFileName, String defaultPathId, boolean isWindowsOS, Locale locale) {
        String endFix = "." + suffix;
        Object defaultPathObj = HibernateContainer.getInstance().get(defaultPathId);
        String defaultPath = null != defaultPathObj ? defaultPathObj.toString() : null;
        IsmFileChooser fileChooser = new IsmFileChooser(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addFileFilter(new String[]{suffix}, endFix);
        if (!StringUtils.isNULLStr(defaultPath)) {
            File defaultPackagePath = new File(defaultPath);
            fileChooser.setCurrentDirectory(defaultPackagePath.isDirectory() ? defaultPackagePath : defaultPackagePath.getParentFile());
        } else {
            fileChooser.setCurrentDirectory(null);
        }
        FileChooserWrapper.wrapper((JFileChooser)fileChooser);
        FileChooserWrapper.setDefaultFileName(defaultFileName, (JFileChooser)fileChooser, isWindowsOS);
        int resultCode = fileChooser.showSaveDialog((Component)pDialog);
        if (0 != resultCode) {
            return null;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (null == selectedFile) {
            return null;
        }
        String path = ToolFileChooser.checkInfoDialog(pDialog, defaultPathId, locale, endFix, selectedFile);
        if (path == null) {
            return null;
        }
        return path;
    }

    static String checkInfoDialog(Window pDialog, String defaultPathId, Locale locale, String endFix, File selectedFile) {
        String path = null;
        try {
            path = selectedFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get canonical path exception: " + e);
            return null;
        }
        if (ToolFileChooser.isNwPath(pDialog, path, locale)) {
            return null;
        }
        if (ToolFileChooser.isNlPath(pDialog, path, locale)) {
            return null;
        }
        if (path.endsWith(".")) {
            int index = path.lastIndexOf(".");
            path = path.substring(0, index);
        }
        if (!path.endsWith(endFix)) {
            path = path + endFix;
        }
        if (path.length() > 128) {
            DialogUtils.showInfoDialog((Window)pDialog, (String)UiResource.getInstance().getString(locale, "filechooser.prompt.file.max.length"));
            return null;
        }
        if (!ToolFileChooser.checkSpace(pDialog, path)) {
            return null;
        }
        HibernateContainer.getInstance().put(defaultPathId, (Object)path);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[Save file path >> " + FileUtils.filterLogIfComputerName(path) + "][Success]");
        }
        return path;
    }

    private static boolean isNwPath(Window window, String path, Locale locale) {
        if (path.startsWith("\\")) {
            DialogUtils.showInfoDialog((Window)window, (String)UiResource.getInstance().getString(locale, "filechooser.prompt.file.network.path"));
            return true;
        }
        return false;
    }

    private static boolean isNlPath(Window window, String filePath, Locale locale) {
        if (filePath.toLowerCase(Locale.getDefault()).contains(NETWORKPATH)) {
            DialogUtils.showInfoDialog((Window)window, (String)UiResource.getInstance().getString(locale, "filechooser.prompt.file.network.path"));
            return true;
        }
        return false;
    }

    private static boolean checkSpace(Window window, String filePath) {
        if (filePath.contains("  ")) {
            DialogUtils.showInfoDialog((Window)window, (String)ResourceUtil.getString("filechooser.prompt.file.path.black"));
            return false;
        }
        return true;
    }

    private static boolean checkSelectFile(String filePath, int fileSelectionMode) {
        if (1 != fileSelectionMode) {
            return true;
        }
        File checkFile = new File(filePath + File.separator + "CheckFile");
        boolean checkSucc = checkFile.mkdirs();
        if (!checkSucc) {
            return false;
        }
        if (!checkFile.delete()) {
            LOGGER.info("Delete checkFile failed.");
        }
        return true;
    }
}

