/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.io.Serializable;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.python.google.common.annotations.GwtCompatible;
import org.python.google.common.collect.ImmutableMap;
import org.python.google.common.collect.Maps;
import org.python.google.common.collect.Ordering;

@GwtCompatible(serializable=true)
final class ExplicitOrdering<T>
extends Ordering<T>
implements Serializable {
    final ImmutableMap<T, Integer> rankMap;
    private static final long serialVersionUID = 0L;

    ExplicitOrdering(List<T> valuesInOrder) {
        this(Maps.indexMap(valuesInOrder));
    }

    ExplicitOrdering(ImmutableMap<T, Integer> rankMap) {
        this.rankMap = rankMap;
    }

    @Override
    public int compare(T left, T right) {
        return this.rank(left) - this.rank(right);
    }

    private int rank(T value) {
        Integer rank = this.rankMap.get(value);
        if (rank == null) {
            throw new Ordering.IncomparableValueException(value);
        }
        return rank;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof ExplicitOrdering) {
            ExplicitOrdering that = (ExplicitOrdering)object;
            return this.rankMap.equals(that.rankMap);
        }
        return false;
    }

    public int hashCode() {
        return this.rankMap.hashCode();
    }

    public String toString() {
        String string2 = String.valueOf(this.rankMap.keySet());
        return new StringBuilder(19 + String.valueOf(string2).length()).append("Ordering.explicit(").append(string2).append(")").toString();
    }
}

