/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.common.tool.IDuplicationHandler;
import com.huawei.ism.tool.framework.platform.common.tool.ITool;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractToolBox;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.singletoolbox.changelanguage.ui.ChangeLanguageDialog;
import com.huawei.ism.tool.singletoolbox.changelanguage.ui.DiskReviveChangeLanguageDialog;
import com.huawei.ism.tool.singletoolbox.utils.DefaultDuplicationHandler;
import com.huawei.ism.tool.singletoolbox.utils.SingletoolBoxContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Locale;
import org.slf4j.Logger;

public class SingletoolBox
extends AbstractToolBox {
    private static FileLock fl = null;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SingletoolBox.class);
    private static final String TOOL_RUNNING_FLAG = "runningFlag";
    private static final Object LOCK_OBJECT = new Object();
    private ITool curTool = null;

    public String getName() {
        return "Single-Tool Box";
    }

    public boolean init() {
        return true;
    }

    public boolean containsTool(String name) {
        return false;
    }

    public boolean addTool(final ITool tool) {
        if (null == tool) {
            LOGGER.error("Tool is null , cannot add into the single-tool box due to lack of StartItem");
            return false;
        }
        if (null == tool.getStartItem()) {
            LOGGER.error("Tool " + tool.getId() + " cannot add into the single-tool box due to lack of StartItem");
            return false;
        }
        if (!this.setCurTool(tool)) {
            LOGGER.error("Tool " + tool.getId() + " cannot add into the single-tool box which already contained tool.");
            return false;
        }
        this.isStartedTool(tool);
        String lan = System.getenv("language");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("system env is:" + lan);
        }
        if (null == lan) {
            if ("diskrevive".equals(tool.getId()) || "rgrevive".equals(tool.getId())) {
                DiskReviveChangeLanguageDialog dialog = new DiskReviveChangeLanguageDialog(null);
                dialog.setVisible(true);
                if (!dialog.isConfirmed()) {
                    LOGGER.info("login failed.");
                    Runtime.getRuntime().exit(0);
                    return false;
                }
            } else {
                ChangeLanguageDialog dlg = new ChangeLanguageDialog(null);
                if (!dlg.isConfirm()) {
                    LOGGER.info("login failed.");
                    return false;
                }
            }
        } else {
            Locale loc = lan.equals("zh") ? Locale.CHINA : Locale.ENGLISH;
            LanguageManager.getInstance().setCurrentLanguage(loc);
        }
        new Thread("SingletoolBox-Thread-1"){

            @Override
            public void run() {
                tool.getStartItem().getAction().actionPerformed(null, null);
            }
        }.start();
        return true;
    }

    private void isStartedTool(ITool tool) {
        if (!this.requestFileLock(TOOL_RUNNING_FLAG)) {
            String msg;
            IDuplicationHandler duHandler;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Tool " + tool.getId() + " is already running.");
            }
            if (null == (duHandler = tool.getDuplicationHandler())) {
                duHandler = new DefaultDuplicationHandler();
            }
            if (!duHandler.handleDuplicatedStarting(msg = ResourceUtil.getStringWithParams((String)"tool.already.running", (Object[])new Object[]{tool.getStartItem().getName()}))) {
                Runtime.getRuntime().exit(0);
            }
        }
    }

    public synchronized void removeTool(String name) {
        this.curTool = null;
    }

    public void fireToolStarted(String toolId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Tool " + toolId + " started");
        }
    }

    public void fireToolStopped(String toolId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Tool " + toolId + " stopped, program exit now.");
        }
        Runtime.getRuntime().exit(0);
    }

    private synchronized boolean setCurTool(ITool tool) {
        if (null != this.curTool) {
            return false;
        }
        this.curTool = tool;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requestFileLock(String id) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            String lockFile = id;
            try (FileOutputStream fos = new FileOutputStream(lockFile);){
                FileLock lock = fos.getChannel().tryLock();
                if (null != lock) {
                    fl = lock;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Obtained file lock " + lockFile + " success: " + fl);
                    }
                    boolean bl = true;
                    return bl;
                }
                LOGGER.error("Cannot obtain file lock " + lockFile + ".");
            }
            catch (IOException e) {
                LOGGER.error("Obtain file lock " + lockFile + " failed.", (Throwable)e);
            }
            return false;
        }
    }

    protected AbstractContext getContext() {
        return SingletoolBoxContext.getInstance();
    }

    public void registerFailed(String id) {
    }

    public void registerSuccess(String id) {
    }

    public boolean containsIndependentTool(String toolId) {
        return false;
    }

    public void removeOneTool(String name) {
    }
}

