/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox.changelanguage.ui;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.singletoolbox.changelanguage.ui.ChangeLanguageLayout;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class ChangeLanguageDialog
extends JDialog {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ChangeLanguageDialog.class);
    private static final long serialVersionUID = -686835313956785604L;
    private static final Dimension CFG_DLG_SIZE = new Dimension(491, 320);
    private ChangeLanguageLayout layout = null;
    private boolean confirm = false;
    private transient ActionListener listener;

    public ChangeLanguageDialog(Window owner) {
        super(owner);
        this.initUI();
        this.addListener();
        this.setVisible(true);
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    private void initUI() {
        this.layout = new ChangeLanguageLayout();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"confirm.dialog.title"));
        this.setModal(true);
        this.setResizable(false);
        this.setSize(CFG_DLG_SIZE);
        this.setPreferredSize(CFG_DLG_SIZE);
        this.setDefaultCloseOperation(2);
        this.setIconImage(ResourceUtil.getImage((String)"oem.png").getImage());
        this.getRootPane().setUI(null);
        this.validate();
        UiMethod.putScreenCenter(this);
    }

    private void addListener() {
        JComboBox lanBox = this.layout.getLanComboBox();
        lanBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeLanguageDialog.this.setLocalLan();
            }
        });
        this.listener = new VersionActionListener();
        this.layout.getVerComboBox().addActionListener(this.listener);
        JButton confirmBtn = this.layout.getBtnConfirm();
        confirmBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeLanguageDialog.this.languageConfirm();
            }
        });
        JButton cancelBtn = this.layout.getBtnCancel();
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runtime.getRuntime().exit(0);
            }
        });
    }

    private void setLocalLan() {
        Object selectItem = this.layout.getLanComboBox().getSelectedItem();
        if (ResourceUtil.getString((String)"confirm.dialog.english.lan").equals(selectItem)) {
            LanguageManager.getInstance().setCurrentLanguage(Locale.ENGLISH);
        } else {
            LanguageManager.getInstance().setCurrentLanguage(Locale.SIMPLIFIED_CHINESE);
        }
        this.layout.getVerComboBox().removeActionListener(this.listener);
        this.layout.refreshUIByLan();
        this.layout.getVerComboBox().addActionListener(this.listener);
    }

    private void languageConfirm() {
        Locale curLocale = LanguageManager.getInstance().getCurrentLanguage();
        ApplicationContext.getInstance().setCurrentLanguage(curLocale);
        ResourceManager.setLocale((Locale)curLocale);
        IsmPlafUtils.setLocale((Locale)curLocale);
        String version = this.layout.getVerComboBox().getSelectedItem().toString();
        if (curLocale.equals(Locale.SIMPLIFIED_CHINESE) && ResourceUtil.getString((String)"confirm.dialog.version.unified").equals(version)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("OEM tools welcome page >> Confirm chinese language and " + ResourceUtil.getString((String)"confirm.dialog.version.unified", (Locale)Locale.ENGLISH) + " product][Success");
            }
        } else if (curLocale.equals(Locale.SIMPLIFIED_CHINESE) && ResourceUtil.getString((String)"confirm.dialog.version.mass").equals(version)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("OEM tools welcome page >> Confirm chinese language and " + ResourceUtil.getString((String)"confirm.dialog.version.mass", (Locale)Locale.ENGLISH) + " product][Success");
            }
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("OEM tools welcome page >> Confirm english language and " + version + " product][Success");
        }
        this.confirm = true;
        this.dispose();
    }

    private void setVersion() {
        String selectVer = this.layout.getVerComboBox().getSelectedItem().toString();
        if (ResourceUtil.getString((String)"confirm.dialog.version.unified").equals(selectVer)) {
            System.setProperty("oemVer", "unified");
        } else if (ResourceUtil.getString((String)"confirm.dialog.version.mass").equals(selectVer)) {
            System.setProperty("oemVer", "mass");
        }
    }

    class VersionActionListener
    implements ActionListener {
        VersionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChangeLanguageDialog.this.setVersion();
        }
    }
}

