/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox.changelanguage.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ChangeLanguageLayout
extends JPanel {
    private static final long serialVersionUID = -3780477578558628667L;
    private static final char LOGIN_BTN_MEMONIC = 'O';
    private static final char CANCEL_BTN_MEMONIC = 'C';
    private static final Dimension BUTTON_PADDING_SIZE = new Dimension(90, 21);
    private static final Dimension LABEL_COL_SIZE = new Dimension(110, 21);
    private static final Dimension INPUT_COL_SIZE = new Dimension(160, 21);
    private static final Dimension BUTTON_SIZE = new Dimension(80, 21);
    private static final int SPACE_WIDTH = 60;
    private static final int INT2 = 2;
    private static final int INT3 = 3;
    private static final int INT4 = 4;
    private static final int INT8 = 8;
    private static final int INT10 = 10;
    private static final int INT12 = 12;
    private static final int INT15 = 15;
    private static final int INT20 = 20;
    private JLabel titleImgIcon;
    private JLabel lanLabel;
    private JComboBox lanComboBox;
    private JLabel verLabel;
    private JComboBox verComboBox;
    private JButton btnConfirm;
    private JButton btnCancel;

    public ChangeLanguageLayout() {
        this.initComponent();
        this.initLayout();
    }

    public JComboBox getLanComboBox() {
        return this.lanComboBox;
    }

    public JButton getBtnConfirm() {
        return this.btnConfirm;
    }

    public JButton getBtnCancel() {
        return this.btnCancel;
    }

    public void refreshUIByLan() {
        if (Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage())) {
            this.titleImgIcon.setIcon(ResourceUtil.getImage((String)"aboutheader.png"));
        } else {
            this.titleImgIcon.setIcon(ResourceUtil.getImage((String)"aboutheader_cn.png"));
        }
        this.lanLabel.setText(ResourceUtil.getString((String)"confirm.dialog.label.lan") + ":");
        this.verLabel.setText(ResourceUtil.getString((String)"confirm.dialog.label.ver") + ":");
        this.verComboBox.removeAllItems();
        this.verComboBox.addItem(ResourceUtil.getString((String)"confirm.dialog.version.unified"));
        this.verComboBox.addItem(ResourceUtil.getString((String)"confirm.dialog.version.mass"));
        this.btnConfirm.setText(ResourceUtil.getString((String)"confirm.dialog.btn.confirm"));
        UCD.formatMnemonicDisplay((AbstractButton)this.btnConfirm);
        this.btnCancel.setText(ResourceUtil.getString((String)"confirm.dialog.btn.cancel"));
        UCD.formatMnemonicDisplay((AbstractButton)this.btnCancel);
        this.updateUI();
    }

    private void initComponent() {
        Font labelFont = new Font(null, 1, 15);
        this.lanLabel = new JLabel(ResourceUtil.getString((String)"confirm.dialog.label.lan") + ":");
        this.verLabel = new JLabel(ResourceUtil.getString((String)"confirm.dialog.label.ver") + ":");
        this.lanLabel.setFont(labelFont);
        this.verLabel.setFont(labelFont);
        this.lanComboBox = new JComboBox();
        this.verComboBox = new JComboBox();
        if (Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage())) {
            this.titleImgIcon = new JLabel(ResourceUtil.getImage((String)"aboutheader.png"));
            this.lanComboBox.addItem(ResourceUtil.getString((String)"confirm.dialog.english.lan"));
            this.lanComboBox.addItem(ResourceUtil.getString((String)"confirm.dialog.china.lan"));
        } else {
            this.titleImgIcon = new JLabel(ResourceUtil.getImage((String)"aboutheader_cn.png"));
            this.lanComboBox.addItem(ResourceUtil.getString((String)"confirm.dialog.china.lan"));
            this.lanComboBox.addItem(ResourceUtil.getString((String)"confirm.dialog.english.lan"));
        }
        this.verComboBox.addItem(ResourceUtil.getString((String)"confirm.dialog.version.unified"));
        this.verComboBox.addItem(ResourceUtil.getString((String)"confirm.dialog.version.mass"));
        this.btnConfirm = UCD.createButton((String)ResourceUtil.getString((String)"confirm.dialog.btn.confirm"), (Dimension)BUTTON_SIZE, (char)'O');
        this.btnCancel = UCD.createButton((String)ResourceUtil.getString((String)"confirm.dialog.btn.cancel"), (Dimension)BUTTON_SIZE, (char)'C');
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.titleImgIcon, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.buildInputInfoPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.buildBtnPanel(), gridBagConstraints);
    }

    private JPanel buildInputInfoPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        panel.add((Component)this.buildLanguage(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        panel.add((Component)this.verComboBox, gridBagConstraints);
        panel.add((Component)this.buildVersion(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        panel.add((Component)Box.createHorizontalBox(), gridBagConstraints);
        return panel;
    }

    private Box buildLanguage() {
        Box box = Box.createHorizontalBox();
        box.add(this.lanLabel);
        this.lanLabel.setHorizontalAlignment(4);
        UiMethod.setComponentSize(LABEL_COL_SIZE, this.lanLabel);
        box.add(Box.createHorizontalStrut(8));
        box.add(this.lanComboBox);
        UiMethod.setComponentSize(INPUT_COL_SIZE, this.lanComboBox);
        box.add(Box.createHorizontalStrut(60));
        return box;
    }

    private Box buildVersion() {
        Box box = Box.createHorizontalBox();
        box.add(this.verLabel);
        this.verLabel.setHorizontalAlignment(4);
        UiMethod.setComponentSize(LABEL_COL_SIZE, this.verLabel);
        box.add(Box.createHorizontalStrut(8));
        box.add(this.verComboBox);
        UiMethod.setComponentSize(INPUT_COL_SIZE, this.verComboBox);
        box.add(Box.createHorizontalStrut(60));
        return box;
    }

    private JPanel buildBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        panel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel leftPad = new JLabel();
        UiMethod.setComponentSize(BUTTON_PADDING_SIZE, leftPad);
        panel.add((Component)leftPad, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        panel.add((Component)this.btnConfirm, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        panel.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        JLabel rightPad = new JLabel();
        UiMethod.setComponentSize(BUTTON_PADDING_SIZE, rightPad);
        panel.add((Component)rightPad, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)new JSeparator(), gridBagConstraints);
        return panel;
    }

    public void setVerComboBox(JComboBox verComboBox) {
        this.verComboBox = verComboBox;
    }

    public JComboBox getVerComboBox() {
        return this.verComboBox;
    }
}

