/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserDataType;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.framework.pubservice.listener.INodeObserver;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;

public class UserDataRefresher
implements INodeObserver,
ILogSupportService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UserDataRefresher.class);
    private static final int INTERVAL = 300;
    private static final String DEVDATAFILE = UserDataType.device.getFileName();
    private static final String LOGDATAFILE = UserDataType.operatingLogs.getFileName();
    private File refreshDataDir = null;

    public UserDataRefresher() {
    }

    public UserDataRefresher(String refreshPath) {
        if (StringUtils.isNULLStr(refreshPath)) {
            return;
        }
        this.refreshDataDir = new File(FilePathUtils.filterPath((String)refreshPath));
        Thread hook = new Thread(){

            @Override
            public void run() {
                UserDataRefresher.this.clearFile(new File(UserDataRefresher.this.refreshDataDir, DEVDATAFILE));
                UserDataRefresher.this.clearFile(new File(UserDataRefresher.this.refreshDataDir, LOGDATAFILE));
            }
        };
        hook.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Uncaught sub thread error:", e);
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
    }

    public void fireNodeAdd(DevNode dev) {
    }

    public void fireNodeDelete(DevNode dev) {
    }

    public void fireNodeModify(DevNode dev) {
        File devFile = new File(this.refreshDataDir, DEVDATAFILE);
        Properties devIni = new Properties();
        devIni.put("type", dev.getDeviceType().toString());
        devIni.put("sn", dev.getDeviceSerialNumber());
        devIni.put("version", dev.getProductVersion());
        this.saveData(devFile, devIni);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData(File devFile, Properties devIni) {
        FileWriter fw;
        block7: {
            if (null != this.refreshDataDir && !this.refreshDataDir.exists() && !this.refreshDataDir.mkdirs()) {
                LOGGER.error("Make dir failed: " + this.refreshDataDir);
                return;
            }
            if (!this.clearFile(devFile)) {
                this.waitSomeTime();
                if (!this.clearFile(devFile)) {
                    return;
                }
            }
            fw = null;
            try {
                if (!devFile.createNewFile()) break block7;
                fw = new FileWriter(devFile);
                devIni.store(fw, "");
            }
            catch (Exception e) {
                try {
                    LOGGER.error("create new file error: " + devFile, (Throwable)e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeResource(fw, fw);
                    throw throwable;
                }
                StreamUtils.closeResource((Flushable)fw, (Closeable)fw);
            }
        }
        StreamUtils.closeResource(fw, fw);
    }

    private boolean clearFile(File file) {
        if (file.exists() && !file.delete()) {
            try {
                LOGGER.error("Delete file error:" + file.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("Delete file error:", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private void waitSomeTime() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Sleep error when refresh device.", (Throwable)e);
        }
    }

    public void addOperaLog(OperaLog log) {
        File devFile = new File(this.refreshDataDir, LOGDATAFILE);
        Properties logIni = new Properties();
        this.putKeyValue(logIni, "operateType", log.getOperateType());
        this.putKeyValue(logIni, "result", String.valueOf(log.isResult()));
        this.putKeyValue(logIni, "operaName", log.getOperaName());
        this.putKeyValue(logIni, "deviceName", log.getDeviceName());
        this.putKeyValue(logIni, "level", log.getLevel().toString());
        this.putKeyValue(logIni, "detailInfo", log.getDetailInfo());
        this.saveData(devFile, logIni);
    }

    public void addOperaLog(String key, boolean result) {
    }

    private void putKeyValue(Properties properties, Object key, Object value) {
        properties.put(key, value == null ? "" : value);
    }

    public void clearEnv() {
    }
}

