# -*- coding: UTF-8 -*-

import os
from string import rfind
import constant
from resource import MESSAGES_DICT
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil


def check_patch_ver(cli, lang):
    """
    查询是否存在补丁及补丁版本
    :return: True/False(命令执行成功/失败), True/False（存在OEM补丁/不存在）, err_msg（错误提示）
    """
    cmd = "os_upgrade_coldpatch.sh -v"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInMinisystemModel(
        cli, cmd, lang)
    if not flag:
        return False, "", err_msg
    if constant.QUERY_PATCH_FLAG not in cli_ret.lower() and \
            constant.NO_PATCH_FLAG not in cli_ret.lower() or \
            constant.QUERY_PATCH_FAILED in cli_ret.lower():
        err_msg = baseUtil.getPyResource(
            lang, "exe.cmd.error", args="", resource=MESSAGES_DICT)
        return False, "", err_msg
    cli_lines = cli_ret.encode("utf8").splitlines()
    for line in cli_lines:
        if constant.QUERY_PATCH_FLAG in line.lower():
            patch_ver = parse_patch_ver(line)
            return True, patch_ver, ""
    return True, "", ""


def parse_patch_ver(cli_line):
    """
    解析补丁版本
    :param cli_line: cli回显
    :return: 补丁版本号
    """
    words = cli_line.strip().split(" ")
    ver_word = words[-1]
    return ver_word[:-1]


def get_patch_pkg_path():
    """
    获取补丁包路径
    :return: 补丁包路径
    """
    cur_path = __file__
    patch_pkg_path = os.path.join(
        cur_path[0:rfind(cur_path, "unified")], constant.PATCH_FILE_NAME)
    if os.path.isfile(patch_pkg_path):
        return True, patch_pkg_path
    else:
        return False, patch_pkg_path


def special_char_trans(trans_str):
    """
    转换字符串中的特殊字符
    :param trans_str: 待转换字符串
    :return: 转换后字符串
    """
    trans_str = trans_str.replace("\\", "\\\\").replace(
        " ", "\\s").replace("?", "\\q").replace("|", "\\|")
    return trans_str


def get_import_oem_cmd(dev_type, log):
    """
    根据型号获取导入oem包的命令
    :param log: 日志打印
    :param dev_type: 设备型号
    :return: 如果是有备份特性二级存储设备型号，返回带dataprotect_swith参数的导入命令；其余设备返回通用命令
    """
    if dev_type in constant.DATA_BACKUP_PRODUCTS:
        log.info("The version is {}".format(dev_type))
        return constant.OCEAN_PROTECT_OEM_CMD
    return constant.IMPORT_OEM_CMD
