# -*- coding: UTF-8 -*-

import traceback

from resource import MESSAGES_DICT
import preprocess
import constant
import util

from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil


class SetOemVendor:
    def __init__(self, context, oem_type=constant.OemType.OEM):
        self.context = context
        self.logger = context.get('logger')
        self.lang = context.get("lan")
        self.cli = context.get("devSSH")
        self.ip = context.get("devIp")
        self.dev_path = context.get("devPath")
        self.oem_type = oem_type

    def execute(self):
        self.logger.info("start set oem vendor.")
        try:
            flag, err_msg = preprocess.execute(self.context)
            if not flag:
                return False, err_msg
            oem_succ, msg = self.import_oem()

            self.logger.info("Set oem vendor end.The result is:oem({0})"
                             .format(str(oem_succ)))
            return oem_succ, msg
        except Exception:
            self.logger.error("set oem vendor exception:" +
                              str(traceback.format_exc()))
            err_msg = baseUtil.getPyResource(
                self.lang, "install.oem.patch.error", args="",
                resource=MESSAGES_DICT)
            return False, err_msg

    def import_oem(self):
        user = util.special_char_trans(self.context.get("devUser"))
        passwd = util.special_char_trans(
            self.context.get("dev").getLoginUser().getPassword())
        dev_type = self.context.get("dev").getDeviceType().toString()
        if self.oem_type == constant.OemType.OEM:
            cmd = util.get_import_oem_cmd(dev_type, self.logger).format(self.ip, user, passwd, self.dev_path)
        else:
            cmd = "restore oem_package"
        flag, err_msg = self.exec_set_oem(cmd, passwd)
        self.logger.info("exe import oem cmd result:{0}".format(str(flag)))
        return flag, err_msg

    def exec_set_oem(self, cmd, passwd):
        """执行导入OEM包的命令
        :param cmd: 待执行命令
        :param passwd: 密*码
        :return: (falg, ret, err_msg)
            flag:
                True: 执行命令正常
                False: 执行命令不正常
            err_msg: 错误消息
        """
        is_opened = False
        try:
            is_opened, check_ret = cliUtil.needOpenDeveloperSwitch(
                self.cli, self.lang)

            if is_opened:
                check_ret = cliUtil.openDeveloperSwitch(self.cli, self.lang)
                if not check_ret[0]:
                    return check_ret[0], check_ret[2]

            enter_developer_ret = cliUtil.enterDeveloperMode(
                self.cli, self.lang)
            if not enter_developer_ret[0]:
                cliUtil.developerMode2CliMode(self.cli)
                return enter_developer_ret[0], enter_developer_ret[1]

            check_ret = cliUtil.excuteCmdInCliMode(
                self.cli, cmd, False, self.lang)
            cli_ret = check_ret[1]

            if "password" in cli_ret.lower():
                check_ret = cliUtil.excuteCmdInCliMode(
                    self.cli, passwd, False, self.lang)
                cli_ret = check_ret[1]

            cnt = 0
            while "y/n" in cli_ret and cnt < 5:
                ret = cliUtil.excuteCmdInCliMode(
                    self.cli, "y", True, self.lang)
                cli_ret = ret[1]
                cnt += 1

            ret_flag = True
            err_msg = check_ret[2]
            # 判断是否执行成功
            if "command executed successfully" not in cli_ret.lower():
                ret_flag = False
                if not err_msg:
                    err_msg = baseUtil.getPyResource(
                        self.lang, "exe.cmd.error", args=cli_ret,
                        resource=MESSAGES_DICT)

            if "oem package size exceed limiation" in cli_ret.lower():
                err_msg = baseUtil.getPyResource(
                    self.lang, "oem.package.size.exceed.limiation", args=cli_ret,
                    resource=MESSAGES_DICT)

            if cliUtil.isInDeveloperMode(cli_ret):
                cliUtil.developerMode2CliMode(self.cli)

            return ret_flag, err_msg
        finally:
            # 关闭开关
            if is_opened:
                cliUtil.closeDeveloperSwitch(self.cli, self.lang)
