# -*- coding: UTF-8 -*-

from cbb.frame.base import baseUtil
from cbb.frame.cli import cliUtil
from cbb.frame.base import constants

from com.huawei.ism.tool.obase.utils import ManualConfigItemMgr


class UpgradeHotPatchSet:
    SET_INTERVAL_SUCC = "successful"
    INTERVAL_RANGE = [0.5, 300]

    def __init__(self, data_dict):
        self.data_dict = data_dict
        self.dev = self.data_dict.get("dev")
        self.dev_ip = self.dev.getIp()
        self.lang = self.data_dict.get("lang")
        self.log = self.data_dict.get("logger")

    def execute(self):
        if not self.__need_set_interval():
            self.log.info("Don't need set hotpatch interval.")
            return True, ""

        # 获取需要设置的间隔时间
        get_interval_ret = self.__get_interval_value()
        if not get_interval_ret[0]:
            return False, get_interval_ret[2]

        # 执行设置命令
        exe_ret = self.__exe_set_cmd(get_interval_ret[1])
        if not exe_ret[0]:
            return False, exe_ret[1]
        return True, ""

    def __need_set_interval(self):
        if ManualConfigItemMgr.getInstance().getItem(
                self.dev_ip, constants.SET_HOTPATCH_INTERVAL) \
                and not ManualConfigItemMgr.getInstance().expected(
                self.dev_ip, constants.SET_HOTPATCH_INTERVAL, "0"):
            return True
        return False

    def __get_interval_value(self):
        hotpatch_interval = ManualConfigItemMgr.getInstance().getItem(
            self.dev_ip, constants.SET_HOTPATCH_INTERVAL).getValue()
        self.log.info("the interval value is:{}".format(hotpatch_interval))
        try:
            hotpatch_interval = float(hotpatch_interval)
        except ValueError as ve:
            self.log.error("the interval value is type error.{}".format(ve))
            return False, "", baseUtil.getPyResource(
                self.lang, "set.hotpatch.interval.error.value")
        if hotpatch_interval < UpgradeHotPatchSet.INTERVAL_RANGE[0] \
                or hotpatch_interval > UpgradeHotPatchSet.INTERVAL_RANGE[1]:
            return False, "", baseUtil.getPyResource(self.lang, "set.hotpatch.interval.error.value")
        return True, hotpatch_interval, ""

    def __exe_set_cmd(self, hotpatch_interval):
        cli = self.data_dict.get("ssh")
        cmd = "os_upgrade_hotpatch.sh -t set {}".format(hotpatch_interval)
        cli_ret = cliUtil.excuteCmdInMinisystemModel(cli, cmd, True)

        if not cli_ret[0]:
            self.log.error("execute set hotpatch interval error:{}".format(cli_ret[2]))
            return False, baseUtil.getPyResource(self.lang, "set.hotpatch.interval.failed")

        if UpgradeHotPatchSet.SET_INTERVAL_SUCC not in cli_ret[1].lower():
            self.log.error("execute set hotpatch interval not succss.")
            return False, baseUtil.getPyResource(self.lang, "set.hotpatch.interval.failed")
        self.data_dict["hotpatch_interval"] = hotpatch_interval
        return True, ""
