# coding=utf-8

from defusedxml import ElementTree


class Command:
    """
    命令对象定义
    """

    def __init__(self):
        self.base_cmd = ''
        self.hyper_cmd = False
        self.output_conf_list = []
        self.input_conf_list = []


def get_cmd_list(xml_file):
    """
    通过解析xml配置文件，获取格式化的命令信息列表
    :param xml_file: 命令配置文件
    :return: collect_cmd_list：收集命令的配置解析结果列表
    """

    # 所有收集命令
    collect_cmd_list = []
    # 获取所有的element
    root = ElementTree.parse(xml_file)
    cmd_model_config_list = root.iter("Model")
    # 获取第一层信息：命令模式配置
    for cmd_model_config in cmd_model_config_list:
        # 初始化字典结构
        cmd_model_conf_dict = {"model": cmd_model_config.attrib["name"],
                               "commands": []}
        # 保存基础命令（无参数）
        cmd_config_list = cmd_model_config.iter("command")
        for cmd_config in cmd_config_list:
            command_ins = Command()
            command_ins.base_cmd = cmd_config.attrib["name"]
            command_ins.hyper_cmd = bool(cmd_config.get("hyper_cmd"))
            cmd_output_param_conf_list = cmd_config.iter("output")
            for cmd_output_conf in cmd_output_param_conf_list:
                param_name = cmd_output_conf.attrib["name"]
                param_key_value = cmd_output_conf.attrib["key_value"]
                parse_func = cmd_output_conf.attrib["parse_func"]
                limit_count = cmd_output_conf.get("limit_count")
                output_conf_dict = {"name": param_name,
                                    "key_value": param_key_value,
                                    "parse_func": parse_func,
                                    "limit_count": limit_count
                                    }
                command_ins.output_conf_list.append(output_conf_dict)
            cmd_input_param_conf_list = cmd_config.iter("input")
            for cmd_input_conf in cmd_input_param_conf_list:
                param_name = cmd_input_conf.attrib["name"]
                input_param = deal_input_param(cmd_input_conf)
                limit_count = deal_limit_count(cmd_input_conf)
                input_conf_dict = {"name": param_name, "params": input_param,
                                   "limit_count": limit_count}
                command_ins.input_conf_list.append(input_conf_dict)
            # 保存命令配置
            cmd_model_conf_dict["commands"].append(command_ins)
        collect_cmd_list.append(cmd_model_conf_dict)
    return collect_cmd_list


def deal_input_param(cmd_input_conf):
    input_param = cmd_input_conf.attrib["params"]
    if not input_param:
        return input_param

    # 如果配置了参数列表，则使用
    if "~" in input_param:
        tmp_list = input_param.split("~")
        start, end = int(tmp_list[0]), int(tmp_list[1])
        input_param = [str(i) for i in
                       range(start, end + 1)]
    else:
        input_param = input_param.split(",")
    return input_param


def deal_limit_count(cmd_input_conf):
    limit_count = cmd_input_conf.get("limit_count")
    if limit_count and "," in limit_count:
        tmp_list = limit_count.split(",")
        limit_count = (int(tmp_list[0]), int(tmp_list[1]))
    return limit_count
