# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.base import baseUtil
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil


def execute(context):
    """
    关闭SMB全局failover功能
    :param context:
    :return:
    """
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    cli = contextUtil.getCli(context)

    cifs_status = contextUtil.getItem(context, "cifs_status")
    if cifs_status == "No":
        cmd = "change service cifs smb_global_ca_enable=no"
        ret = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang,
                                               preExec=False)
        logger.logInfo("ret: %s." % ret[1])
        if not ret[0]:
            err_msg, suggestion = common.getMsg(lang, "off.SMB.fail")
            return False, err_msg, suggestion
    contextUtil.setItem(context, "cifs_status", None)
    return True, "", ""
