# -*- coding: UTF-8 -*-
import os
NODE_MAX = 16
SPEED = 10000
BASE_IP_RANGE_BEGIN = 0
BASE_IP_RANGE_END = 255 - NODE_MAX - 1
BASE_IP_RANGE = "%s-%s" % (BASE_IP_RANGE_BEGIN, BASE_IP_RANGE_END)

CFG_DATA_PERSIST_DIR = os.path.join('temp', 'expanEval')
CFG_DATA_PERSIST_FILENAME = "expansionEvalConfig.dat"

INNTER_IP_RANGE_BEGIN = 2

EXCLUDE_IP_RANGE_BEGIN = 132
EXCLUDE_IP_RANGE_END = 133
INNTER_IP_RANGE_END = 255 - NODE_MAX
INNTER_IP_RANGE = "%s-%s" % (INNTER_IP_RANGE_BEGIN, EXCLUDE_IP_RANGE_BEGIN - NODE_MAX) + "," + "%s-%s" % \
                  (EXCLUDE_IP_RANGE_END + 1, INNTER_IP_RANGE_END)

SUPPORT_SWITCH_VER = ["CE6850", "CE6810", "CE6855", "CE6865", "CE6866",
                      "CE8850", "CE8851"]
SUPPORT_PDT_MODEL_18000 = ["18800 V3", "18500 V3", "18800F V3", "18500F V3",
                           "18800 V5", "18800F V5", "18500 V5",
                           "18500F V5"]

PDT_MODEL_2800V3 = ["2800 V3", "2800 V5"]
PDT_MODEL_ARM = ["2200 V3", "2600 V3", "2800 V3", "2600 V3 FOR VIDEO",
                 "5110 V5", "5110F V5", "5100K V5", "5200K V5", "5210 V5",
                 "5210F V5", "5300 V5", "5500 V5 ELITE"]

PDT_MODEL_6800V5 = ["6800 V5", "6800F V5"]

# 控制器管理口默认IP
DEFAULT_MGMT_IP = ["192.168.128.101", "192.168.128.102"]

# 10TNL_SAS盘不支持的版本
NLSAS_UNMATCH_PRODUCT_VERSION = ["V300R006C00", ]

# 不支持删除交换机默认IP的版本和多domain的版本
NO_SUPPORT_DELETE_SWTICH_IP = ["V300R001C00", "V300R001C01"]

# 支持内部双网段IP配置
SUPPORT_DOUBLE_INNER_IP = "V300R001C20"

# 需要执行扩控后继承元阵列管理IP命令的版本
NEED_INHERIT_CLUSTER_MGTIP_BASE_VERSION = "V300R001C20"

# 需要执行扩控后继承元阵列管理IP命令的版本
NEED_PRE_CHECK_MGMT_CABLE = "V300R001C21SPC100"

# 适用于EXPANSION_SPEC_DICT_DORADO扩容规格的版本
VERSION_FOR_EXPANSION_SPEC_DICT_DORADO = ["V300R001C01", "V300R001C20"]

# 需要检查内部型号是否一致的起始版本
NEED_CHECK_INTERNAL_PRODUCT_MODEL_VERSION = "V300R001C21"

# 需要检查内部型号
EXP_INTERNAL_PRODUCT_MODEL_VERSION = "V300R002C10"

# 智能框扩框型号版本
SMART_ENCLOSURE_RISK_VERSION = ["6.0.0", "6.0.1"]

# Dorado内部IP
PREFIX_INNTERNET0 = "172.16.192.2"
PREFIX_INNTERNET1 = "172.16.193.2"
SUBNET_MASK = "255.255.255.0"

# Dorado V300R001C20 可选择的内部IP
CHOOSE_INNER_IP = ["172.16.192.2", "10.253.192.2"]
NONEED_BASEIP_NEWWORK = [(2, 4), (6, 8)]

# Dorado V300R001C20 默认内部IP
DEFAULT_INNER_IP = "172.16.192.2"

# Dorado V300R001C20 选择基址IP提示
REMIND_INNER_IP = {"172.16.192.2": ("172.16.192.*", "172.16.193.*", "172.16.*.*"),
                   "10.253.192.2": ("10.253.192.*", "10.253.193.*", "10.253.*.*")}

# Dorado V300R001C20 内部各频面IP
INNER_IP_GROUP1 = ["172.16.192.2", "172.16.193.2"]
INNER_IP_GROUP2 = ["10.253.192.2", "10.253.193.2"]

# V5Kunpeng高端交换机组网支持的扩控数量
SWITCH_SUP_CTRLS_MAX_H = 12
# V5Kunpeng高端直连组网支持的扩控数量
DIRECT_SUP_CTRLS_MAX_H = 8
# V5Kunpeng中低端交换机组网支持的扩控数量
SWITCH_SUP_CTRLS_MAX_L = 4
# V5Kunpeng中低端直连组网支持的扩控数量
DIRECT_SUP_CTRLS_MAX_L = 4


# 2800 V3支持的扩控数量
SUPPORT_CONTROLLERS_MAX_2800 = 2

# 针对V3R3C20以后版本的资料归一问题
SPECIAL_MSG_KEY = "MSG_KEY"

# 针对V3R3C20以后版本的资料归一问题
SPECIAL_MSG_VALUE = "BeforeV3R3C20"

# 针对Dorado V3R1C20之前的版本为安装部署
SPECIAL_Dorado_MSG_VALUE = "BeforeV3R1C20"

# 针对Dorado V3R1C20之前的版本白名单
SPECIAL_Dorado_VER = ["V300R001C00", "V300R001C01"]

# 6U小卡设备型号
SMALL_SAS_6U_PRODUCTS = [
    "Dorado18000 V3",
    "6900 V3",
    "6800 V3",
    "6800F V3"]

# 进度条刷新开始标识和结束标识
PROCESS_STATE_CHECKING = "checking"
PROCESS_UPGRADE_FINISHED = "finished"

# 检查单个框固件版本超时时间
PER_CHECK_FW_TIME = 3 * 60
DORADO_V6_DISK_FW_SYNC_TIME_OUT = 15 * 60
CHECK_TIME_INTERVAl = 30

FULL_PRODUCT_VERSION = ["V300R006C00SPC100"]

PATCH_VERSION = "V300R006C00SPH105"
# Purley版本的重启超时时间
PURLEY_TIME = 180 * 60
# 查询内部设备信息CPU型号无效
CPU_MODEL_INVALID = "--"
# 查询内部设备信息CPU核数无效
CPU_NUMBER_INVALID = -1
# 当前业务包V3R6及DoradoV3共用，使用黑名单限制支持Purley的版本
PURLEY_VERS_BLACKLIST = ["V300R006C00", "V300R006C01", "V300R001C01", "V300R001C00"]

SCENE_EXPAND_CTRL = "expandController"
SCENE_EXPAND_ENCLOSURE = "expandEnclosure"
SCENE_EXPAND_BAY = "expandBay"
SCENE_EXPAND_KEY = "toolScene"
SCENE_EXPAND_DD = "expandDD"
SCENE_EXPAND_SCM = "expandScm"

BDM_CLEAR_DISK_DLT_ERROR = "1073744478"

SWITCH_CONFIG = """
#
lldp enable
#
dcb pfc
 priority 1 to 2 5
#
dcb ets-profile default
#
dcb ets-profile iwarpets
 priority-group 0 queue 0 to 2 4 to 6
 priority-group 15 queue 7
#
vlan batch 2000 to 2020
#
interface 10GE1/0/1
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/2
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/3
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/4
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/5
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/6
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/7
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/8
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/9
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/10
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/11
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/12
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/13
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/14
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/15
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/16
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/17
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/18
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/19
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/20
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/21
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/22
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/23
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/24
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/25
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/26
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/27
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/28
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/29
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/30
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/31
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/32
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/33
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/34
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/35
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/36
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/37
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/38
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/39
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/40
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/41
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/42
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/43
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/44
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/45
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/46
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/47
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 10GE1/0/48
 shutdown
 port link-type trunk
 port trunk allow-pass vlan 2000 to 2020
 lldp tlv-enable dcbx
 dcb pfc enable mode manual
 dcb ets enable iwarpets
 dcb compliance intel-oui
#
interface 40GE1/0/1
 shutdown
#
interface 40GE1/0/2
 shutdown
#
interface 40GE1/0/3
 shutdown
#
interface 40GE1/0/4
 shutdown
#
"""

# 中低端通用组网配置，只含直连
COMMON_LOW_END_DIRECT = {
    "2C": {
        "direct": {
            "supports_expansion_ctrls": [4],
            "scale_out_card_num": 1
        },
    },
}

# arm低端组网配置，支持交换机
ARM_LOW_END_SWITCH = {
    "2C": {
        "direct": {
            "supports_expansion_ctrls": [4],
            "scale_out_card_num": 1
        },
        "switch": {
            "supports_expansion_ctrls": [4, 8],
            "scale_out_card_num": 1
        },
    },
    "4C": {
        "switch": {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 1
        },
    }
}

# Dorado中端组网配置，支持交换机
DORADO_MID_END_SWITCH = {
    "2C": {
        "direct": {
            "supports_expansion_ctrls": [4],
            "scale_out_card_num": 1
        },
        "switch": {
            "supports_expansion_ctrls": [4, 6, 8],
            "scale_out_card_num": 1
        },
    },
    "4C": {
        "switch": {
            "supports_expansion_ctrls": [6, 8],
            "scale_out_card_num": 1
        },
    },
    "6C": {
        "switch": {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 1
        },
    },
}

# 高端Dorado组网配置，只含直连
DORADO_HIGH_END_DIRECT = {
    "2C": {
        "none": {
            "supports_expansion_ctrls": [4],
            "scale_out_card_num": 0
        },
        "direct": {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 1
        },
    },
    "4C": {
        "direct": {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 1
        },
    },
}

# 高端ARM组网配置，只含直连
ARM_HIGH_END_DIRECT = {
    "2C": {
        "none": {
            "supports_expansion_ctrls": [4],
            "scale_out_card_num": 0
        },
        "direct": {
            "supports_expansion_ctrls": [6, 8],
            "scale_out_card_num": 1
        },
    },
    "4C": {
        "direct": {
            "supports_expansion_ctrls": [6, 8],
            "scale_out_card_num": 1
        },
    },
    "6C": {
        "none": {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 0
        },
    },
}


# 高端通用组网配置，含交换机
ARM_HIGH_END_SWITCH = {
    "2C": {
        "none": {
            "supports_expansion_ctrls": [4],
            "scale_out_card_num": 0
        },
        "direct": {
            "supports_expansion_ctrls": [6, 8],
            "scale_out_card_num": 1
        },
        "switch": {
            "supports_expansion_ctrls": [6, 8, 10, 12, 14, 16],
            "scale_out_card_num": 1
        },
    },
    "4C": {
        "direct": {
            "supports_expansion_ctrls": [6, 8],
            "scale_out_card_num": 1
        },
        "switch": {
            "supports_expansion_ctrls": [6, 8, 10, 12, 14, 16],
            "scale_out_card_num": 1
        },
    },
    "6C": {
        "direct": {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 0
        },
        "switch": {
            "supports_expansion_ctrls": [8, 10, 12, 14, 16],
            "scale_out_card_num": 1
        },

    },
    "8C": {
        "switch": {
            "supports_expansion_ctrls": [10, 12, 14, 16],
            "scale_out_card_num": 1
        },
    },
    "10C": {
        "switch": {
            "supports_expansion_ctrls": [12, 14, 16],
            "scale_out_card_num": 1
        },
    },
    "12C": {
        "switch": {
            "supports_expansion_ctrls": [14, 16],
            "scale_out_card_num": 1
        },
    },
    "14C": {
        "switch": {
            "supports_expansion_ctrls": [16],
            "scale_out_card_num": 1
        },
    },
}

# 6810 V5，6810F V5 组网配置，含交换机
ARM_6810_END_SWITCH = {
    "2C": {
        "none": {
            "supports_expansion_ctrls": [4],
            "scale_out_card_num": 0
        },
        "direct": {
            "supports_expansion_ctrls": [6, 8],
            "scale_out_card_num": 1
        },
        "switch": {
            "supports_expansion_ctrls": [6, 8],
            "scale_out_card_num": 1
        },
    },
    "4C": {
        "direct": {
            "supports_expansion_ctrls": [6, 8],
            "scale_out_card_num": 1
        },
        "switch": {
            "supports_expansion_ctrls": [6, 8],
            "scale_out_card_num": 1
        },
    },
    "6C": {
        "direct": {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 0
        },
        "switch": {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 1
        },

    },
}

# 扩容规格字典（Dorado V6，只含直连组网）
EXPANSION_DICT_DORADO_DIRECT_ONLY = {
    "OCEANSTOR DORADO 18000 V6": DORADO_HIGH_END_DIRECT,
    "OCEANSTOR DORADO 8000 V6": DORADO_HIGH_END_DIRECT,
    "OCEANSTOR DORADO 6000 V6": COMMON_LOW_END_DIRECT,
    "OCEANSTOR DORADO 5000 V6": COMMON_LOW_END_DIRECT,
    "OCEANSTOR DORADO 3000 V6": COMMON_LOW_END_DIRECT,
    "OCEANSTOR DORADO 2000": COMMON_LOW_END_DIRECT,
    "OCEANSTOR DORADO 2020": COMMON_LOW_END_DIRECT,
    "OCEANSTOR DORADO 2100": COMMON_LOW_END_DIRECT,
    "OCEANSTOR DORADO 18800 V6": DORADO_HIGH_END_DIRECT,
    "OCEANSTOR DORADO 18800K V6": DORADO_HIGH_END_DIRECT,
    "OCEANSTOR DORADO 18500 V6": DORADO_HIGH_END_DIRECT,
    "OCEANSTOR DORADO 6800 V6": DORADO_HIGH_END_DIRECT,
    "OCEANSTOR DORADO 5800 V6": COMMON_LOW_END_DIRECT,
    "OCEANSTOR DORADO 5600 V6": COMMON_LOW_END_DIRECT,
    "OCEANSTOR DORADO 5500 V6": COMMON_LOW_END_DIRECT,
    "OCEANSTOR DORADO 5300 V6": COMMON_LOW_END_DIRECT,
}

# 扩容规格字典（Dorado V6，支持交换机组网）
EXPANSION_DICT_DORADO_SWITCH_SUP = {
    "OCEANSTOR DORADO 5000 V6": DORADO_MID_END_SWITCH,
    "OCEANSTOR DORADO 5500 V6": DORADO_MID_END_SWITCH,
}

# 扩容规格字典（ARM）只含直连组网
EXPANSION_DICT_ARM_DIRECT_ONLY = {
    "2810 V5": COMMON_LOW_END_DIRECT,
    "2600 V5": COMMON_LOW_END_DIRECT,
    "5110 V5": COMMON_LOW_END_DIRECT,
    "5110F V5": COMMON_LOW_END_DIRECT,
    "5210 V5": COMMON_LOW_END_DIRECT,
    "5210F V5": COMMON_LOW_END_DIRECT,
    "5310 V5": COMMON_LOW_END_DIRECT,
    "5310F V5": COMMON_LOW_END_DIRECT,
    "5300 V5": COMMON_LOW_END_DIRECT,
    "5300K V5": COMMON_LOW_END_DIRECT,
    "5510 V5": COMMON_LOW_END_DIRECT,
    "5510F V5": COMMON_LOW_END_DIRECT,
    "5500 V5": COMMON_LOW_END_DIRECT,
    "5500K V5": COMMON_LOW_END_DIRECT,
    "5610 V5": COMMON_LOW_END_DIRECT,
    "5610F V5": COMMON_LOW_END_DIRECT,
    "5600 V5": COMMON_LOW_END_DIRECT,
    "5810 V5": COMMON_LOW_END_DIRECT,
    "5810F V5": COMMON_LOW_END_DIRECT,
    "5800 V5": COMMON_LOW_END_DIRECT,
    "6810 V5": ARM_HIGH_END_DIRECT,
    "6810F V5": ARM_HIGH_END_DIRECT,
    "18510 V5": ARM_HIGH_END_DIRECT,
    "18510F V5": ARM_HIGH_END_DIRECT,
    "18810 V5": ARM_HIGH_END_DIRECT,
    "18810F V5": ARM_HIGH_END_DIRECT,
    "5210 V5 ENHANCED": COMMON_LOW_END_DIRECT,
    "5220 V5": COMMON_LOW_END_DIRECT,
    "5210F V5 ENHANCED": COMMON_LOW_END_DIRECT,
    "5110 V5 ENHANCED": COMMON_LOW_END_DIRECT,
    "5120 V5": COMMON_LOW_END_DIRECT,
    "5110F V5 ENHANCED": COMMON_LOW_END_DIRECT,
}

# 扩容规格字典（ARM）含交换机组网
EXPANSION_DICT_ARM_SWITCH_SUP = {
    "5310 V5": DORADO_MID_END_SWITCH,
    "5310F V5": DORADO_MID_END_SWITCH,
    "5300 V5": DORADO_MID_END_SWITCH,
    "5300K V5": DORADO_MID_END_SWITCH,
    "5510 V5": DORADO_MID_END_SWITCH,
    "5510F V5": DORADO_MID_END_SWITCH,
    "5500 V5": DORADO_MID_END_SWITCH,
    "5500K V5": DORADO_MID_END_SWITCH,
    "5610 V5": DORADO_MID_END_SWITCH,
    "5610F V5": DORADO_MID_END_SWITCH,
    "5600 V5": DORADO_MID_END_SWITCH,
    "5810 V5": DORADO_MID_END_SWITCH,
    "5810F V5": DORADO_MID_END_SWITCH,
    "5800 V5": DORADO_MID_END_SWITCH,
    "6810 V5": ARM_6810_END_SWITCH,
    "6810F V5": ARM_6810_END_SWITCH,
    "18510 V5": ARM_HIGH_END_SWITCH,
    "18510F V5": ARM_HIGH_END_SWITCH,
    "18810 V5": ARM_HIGH_END_SWITCH,
    "18810F V5": ARM_HIGH_END_SWITCH,
    "6800 V5": ARM_HIGH_END_SWITCH,
    "18500 V5": ARM_HIGH_END_SWITCH,
    "18800 V5": ARM_HIGH_END_SWITCH,
}

# 组网图规格配置
NETWORK_SPEC_DICT = {
    "direct":
        {
            "4C":
                {
                    "planeA":
                        [
                            ("P0<->P0", 4),
                            ("P1<->P1", 4),
                        ],
                    "planeB":
                        [
                            ("P2<->P2", 4),
                            ("P3<->P3", 4),
                        ],

                },
        },
    "switch":
        {
            "4C":
                {
                    "planeA":
                        [
                            ("P0<->P0", 12),
                        ],
                    "planeB":
                        [
                            ("P1<->P1", 12),
                        ],

                },
            "6C":
                {
                    "planeA":
                        [
                            ("P0<->P0", 30),
                        ],
                    "planeB":
                        [
                            ("P1<->P1", 30),
                        ],

                },
            "8C":
                {
                    "planeA":
                        [
                            ("P0<->P0", 56),
                        ],
                    "planeB":
                        [
                            ("P1<->P1", 56),
                        ],
                },
        },
}

DORADO_NETWORK_SPEC_DICT = {
    "switch":
        {
            "4C":
                {
                    "planeA":
                        [
                            ("MGMT<->MGMT", 12),
                        ],
                    "planeB":
                        [
                            ("MAINTENANCE<->MAINTENANCE", 12),
                        ],

                },
            "6C":
                {
                    "planeA":
                        [
                            ("MGMT<->MGMT", 30),
                        ],
                    "planeB":
                        [
                            ("MAINTENANCE<->MAINTENANCE", 30),
                        ],

                },
            "8C":
                {
                    "planeA":
                        [
                            ("MGMT<->MGMT", 56),
                        ],
                    "planeB":
                        [
                            ("MAINTENANCE<->MAINTENANCE", 56),
                        ],
                },
        },
}

# Dorado检查PCIe交换机组网规格字典
DORADO_PCIE_SWITCH_PORT_SPEC_DICT = {
    "2U2C":
        {
            "4C": {'switchporttuplelist': [('2', '2', '3', '3')]},
            "6C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5')]},
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7')]},
        },
    "2U4C":
        {
            "6C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5')]},
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7')]},
        },
    "2U6C":
        {
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7')]},
        },
    "3U2C":
        {
            "4C": {'switchporttuplelist': [('2', '2', '3', '3')]},
            "6C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5')]},
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7')]},
        },
    "3U4C":
        {
            "6C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5')]},
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7')]},
        },
    "3U6C":
        {
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7')]},
        },
    "6U2C":
        {
            "4C": {'switchporttuplelist': None},
            "6C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5')]},
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7')]},
        },
    "6U4C":
        {
            "6C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5')]},
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7')]},
        },
    "6U6C":
        {
            "8C": {'switchporttuplelist': None},
        },
}

MIDDLE_END_3U_TO_N_MAP = {
    # 引擎0的PCIe端口连线规则
    (0, 0, 'CTE0.A3.P0'): (0, 0),
    (0, 0, 'CTE0.A3.P1'): (1, 0),

    (0, 1, 'CTE0.B3.P0'): (0, 1),
    (0, 1, 'CTE0.B3.P1'): (1, 1),

    # 引擎1的PCIe端口连线规则
    (1, 0, 'CTE0.A3.P0'): (0, 2),
    (1, 0, 'CTE0.A3.P1'): (1, 2),

    (1, 1, 'CTE0.B3.P0'): (0, 3),
    (1, 1, 'CTE0.B3.P1'): (1, 3),

    # 引擎2的PCIe端口连线规则
    (2, 0, 'CTE0.A3.P0'): (0, 4),
    (2, 0, 'CTE0.A3.P1'): (1, 4),

    (2, 1, 'CTE0.B3.P0'): (0, 5),
    (2, 1, 'CTE0.B3.P1'): (1, 5),

    # 引擎3的PCIe端口连线规则
    (3, 0, 'CTE0.A3.P0'): (0, 6),
    (3, 0, 'CTE0.A3.P1'): (1, 6),

    (3, 1, 'CTE0.B3.P0'): (0, 7),
    (3, 1, 'CTE0.B3.P1'): (1, 7),
}

# ('suggestEngineId', 'ctrlId', 'location') ->(dswNo, dswPortNum)
DORADO_MIDDLE_END_2U_TO_N_MAP = {
    # 引擎0的PCIe端口连线规则
    (0, 0, 'CTE0.A.IOM1.P0'): (0, 0),
    (0, 0, 'CTE0.A.IOM1.P1'): (1, 0),

    (0, 1, 'CTE0.B.IOM1.P0'): (0, 1),
    (0, 1, 'CTE0.B.IOM1.P1'): (1, 1),

    # 引擎1的PCIe端口连线规则
    (1, 0, 'CTE0.A.IOM1.P0'): (0, 2),
    (1, 0, 'CTE0.A.IOM1.P1'): (1, 2),

    (1, 1, 'CTE0.B.IOM1.P0'): (0, 3),
    (1, 1, 'CTE0.B.IOM1.P1'): (1, 3),

    # 引擎2的PCIe端口连线规则
    (2, 0, 'CTE0.A.IOM1.P0'): (0, 4),
    (2, 0, 'CTE0.A.IOM1.P1'): (1, 4),

    (2, 1, 'CTE0.B.IOM1.P0'): (0, 5),
    (2, 1, 'CTE0.B.IOM1.P1'): (1, 5),
}

MIDDLE_END_4_TO_N = {
    # 引擎0的PCIe端口连线规则
    (0, 0, 'CTE0.A3.P0'): (0, 0),
    (0, 0, 'CTE0.A3.P1'): (1, 0),

    (0, 1, 'CTE0.B3.P0'): (0, 1),
    (0, 1, 'CTE0.B3.P1'): (1, 1),

    # 引擎1的PCIe端口连线规则（已有控制器）
    (1, 2, 'CTE0.A3.P0'): (0, 2),
    (1, 2, 'CTE0.A3.P1'): (1, 2),

    (1, 3, 'CTE0.B3.P0'): (0, 3),
    (1, 3, 'CTE0.B3.P1'): (1, 3),

    # 引擎2的PCIe端口连线规则（新扩容控制器）
    (2, 0, 'CTE0.A3.P0'): (0, 4),
    (2, 0, 'CTE0.A3.P1'): (1, 4),

    (2, 1, 'CTE0.B3.P0'): (0, 5),
    (2, 1, 'CTE0.B3.P1'): (1, 5),

    # 引擎3的PCIe端口连线规则
    (3, 0, 'CTE0.A3.P0'): (0, 6),
    (3, 0, 'CTE0.A3.P1'): (1, 6),

    (3, 1, 'CTE0.B3.P0'): (0, 7),
    (3, 1, 'CTE0.B3.P1'): (1, 7),
}

MIDDLE_END_6_TO_N = {
    # 引擎0的PCIe端口连线规则
    (0, 0, 'CTE0.A3.P0'): (0, 0),
    (0, 0, 'CTE0.A3.P1'): (1, 0),

    (0, 1, 'CTE0.B3.P0'): (0, 1),
    (0, 1, 'CTE0.B3.P1'): (1, 1),

    # 引擎1的PCIe端口连线规则
    (1, 2, 'CTE0.A3.P0'): (0, 2),
    (1, 2, 'CTE0.A3.P1'): (1, 2),

    (1, 3, 'CTE0.B3.P0'): (0, 3),
    (1, 3, 'CTE0.B3.P1'): (1, 3),

    # 引擎2的PCIe端口连线规则（已有控制器）
    (2, 4, 'CTE0.A3.P0'): (0, 4),
    (2, 4, 'CTE0.A3.P1'): (1, 4),

    # 引擎2的PCIe端口连线规则（新增引擎， 控制器编号从0开始）
    (2, 5, 'CTE0.B3.P0'): (0, 5),
    (2, 5, 'CTE0.B3.P1'): (1, 5),

    # 引擎3的PCIe端口连线规则
    (3, 0, 'CTE0.A3.P0'): (0, 6),
    (3, 0, 'CTE0.A3.P1'): (1, 6),

    (3, 1, 'CTE0.B3.P0'): (0, 7),
    (3, 1, 'CTE0.B3.P1'): (1, 7),
}

HIGH_END_2_TO_N_MAP = {
    (0, 0, 'CTE0.R3.IOM0.P0'): (0, 0),
    (0, 0, 'CTE0.R3.IOM0.P1'): (1, 0),

    (0, 1, 'CTE0.L3.IOM0.P0'): (0, 1),
    (0, 1, 'CTE0.L3.IOM0.P1'): (1, 1),

    (0, 2, 'CTE0.R3.IOM1.P0'): (0, 2),
    (0, 2, 'CTE0.R3.IOM1.P1'): (1, 2),

    (0, 3, 'CTE0.L3.IOM1.P0'): (0, 3),
    (0, 3, 'CTE0.L3.IOM1.P1'): (1, 3),

    (1, 0, 'CTE0.R3.IOM0.P0'): (0, 4),
    (1, 0, 'CTE0.R3.IOM0.P1'): (1, 4),

    (1, 1, 'CTE0.L3.IOM0.P0'): (0, 5),
    (1, 1, 'CTE0.L3.IOM0.P1'): (1, 5),

    (1, 2, 'CTE0.R3.IOM1.P0'): (0, 6),
    (1, 2, 'CTE0.R3.IOM1.P1'): (1, 6),

    (1, 3, 'CTE0.L3.IOM1.P0'): (0, 7),
    (1, 3, 'CTE0.L3.IOM1.P1'): (1, 7),
}

HIGH_END_6_TO_N_MAP = {
    (0, 0, 'CTE0.R3.IOM0.P0'): (0, 0),
    (0, 0, 'CTE0.R3.IOM0.P1'): (1, 0),

    (0, 1, 'CTE0.L3.IOM0.P0'): (0, 1),
    (0, 1, 'CTE0.L3.IOM0.P1'): (1, 1),

    (0, 2, 'CTE0.R3.IOM1.P0'): (0, 2),
    (0, 2, 'CTE0.R3.IOM1.P1'): (1, 2),

    (0, 3, 'CTE0.L3.IOM1.P0'): (0, 3),
    (0, 3, 'CTE0.L3.IOM1.P1'): (1, 3),

    # 引擎1的PCIe端口连线规则
    (1, 4, 'CTE0.R3.IOM0.P0'): (0, 4),
    (1, 4, 'CTE0.R3.IOM0.P1'): (1, 4),

    (1, 5, 'CTE0.L3.IOM0.P0'): (0, 5),
    (1, 5, 'CTE0.L3.IOM0.P1'): (1, 5),

    (1, 6, 'CTE0.R3.IOM1.P0'): (0, 6),
    (1, 6, 'CTE0.R3.IOM1.P1'): (1, 6),

    (1, 7, 'CTE0.L3.IOM1.P0'): (0, 7),
    (1, 7, 'CTE0.L3.IOM1.P1'): (1, 7),
}

# Dorado交换机组网PCIe端口连接规则映射表（接口卡上的PCIe端口号--->(交换机变化，端口号)
DORADO_PCIE_PORT_TO_DSW_PORT_MAP = {
    "middleLowEnd": {
        (2, 4): MIDDLE_END_3U_TO_N_MAP,
        (2, 6): MIDDLE_END_3U_TO_N_MAP,
        (2, 8): MIDDLE_END_3U_TO_N_MAP,

        (4, 6): MIDDLE_END_4_TO_N,
        (4, 8): MIDDLE_END_4_TO_N,

        (6, 8): MIDDLE_END_6_TO_N,
    },
    "highEnd": {
        (2, 4): HIGH_END_2_TO_N_MAP,
        (2, 6): HIGH_END_2_TO_N_MAP,
        (2, 8): HIGH_END_2_TO_N_MAP,
        (4, 6): HIGH_END_2_TO_N_MAP,
        (4, 8): HIGH_END_2_TO_N_MAP,

        (6, 8): MIDDLE_END_6_TO_N,
    }
}

# Dorado18000检查PCIe交换机组网规格字典
DORADO18000_PCIE_SWITCH_PORT_SPEC_DICT = {
    "6U2C":
        {
            "4C": {'switchporttuplelist': None},
            "6C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5')]},
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7'),
                                           ('4', '4', '5', '5', '6', '6', '7', '7')]},
        },
    "6U4C":
        {
            "6C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5')]},
            "8C": {'switchporttuplelist': [('2', '2', '3', '3'), ('4', '4', '5', '5'), ('6', '6', '7', '7'),
                                           ('4', '4', '5', '5', '6', '6', '7', '7')]},
        },
    "6U6C":
        {
            "8C": {'switchporttuplelist': None},
        },
}
# Dorado 待扩引擎bayID配置字典
DORADO_NEW_BAYID_SPEC_DICT = {
    "2U2C":
        {
            "4C": {"newBayIDsTuple": ('1', '1')},
            "6C": {"newBayIDsTuple": ('1', '1', '2', '2')},
            "8C": {"newBayIDsTuple": ('1', '1', '2', '2', '3', '3')},
        },
    "2U4C":
        {
            "6C": {"newBayIDsTuple": ('2', '2')},
            "8C": {"newBayIDsTuple": ('2', '2', '3', '3')},
        },
    "2U6C":
        {
            "8C": {"newBayIDsTuple": ('3', '3')},
        },
    "3U2C":
        {
            "4C": {"newBayIDsTuple": ('1', '1')},
            "6C": {"newBayIDsTuple": ('1', '1', '2', '2')},
            "8C": {"newBayIDsTuple": ('1', '1', '2', '2', '3', '3')},
        },
    "3U4C":
        {
            "6C": {"newBayIDsTuple": ('2', '2')},
            "8C": {"newBayIDsTuple": ('2', '2', '3', '3')},
        },
    "3U6C":
        {
            "8C": {"newBayIDsTuple": ('3', '3')},
        },
    "6U2C":
        {
            "4C": {"newBayIDsTuple": None},
            "6C": {"newBayIDsTuple": ('1', '1')},
            "8C": {"newBayIDsTuple": ('1', '1')},
        },
    "6U4C":
        {
            "6C": {"newBayIDsTuple": ('1', '1')},
            "8C": {"newBayIDsTuple": ('1', '1')},
        },
    "6U6C":
        {
            "8C": {"newBayIDsTuple": None},
        },
}

# Dorado 待扩引擎bayID配置字典
DORADO18000_NEW_BAYID_SPEC_DICT = {
    "6U2C":
        {
            "4C": {"newBayIDsTuple": None},
            "6C": {"newBayIDsTuple": ('1', '1')},
            "8C": {"newBayIDsTuple": ('1', '1')},
        },
    "6U4C":
        {
            "6C": {"newBayIDsTuple": ('1', '1')},
            "8C": {"newBayIDsTuple": ('1', '1', '1', '1')},
        },
    "6U6C":
        {
            "8C": {"newBayIDsTuple": None},
        },
}


# 用户行为数据字段
class UserOpDataFields():
    # 扩容类型：扩控制器/硬盘柜/硬盘框
    EXPANSION_TYPE_CTRL = "CTRL"
    EXPANSION_TYPE_BAY = "BAY"
    EXPANSION_TYPE_ENCLOSURE = "ENCLOSURE"

    TYPE = "expansionType"
    ORIGIN_CTRL_NUM = "originCtrlNum"
    ORIGIN_CLUST_TYPE = "originCfgClustType"
    NEW_CTRL_NUM = "newCtrlNum"
    NEW_CLUST_TYPE = "newCfgClustType"
    ORIGIN_DISK_ENCLOSURE_NUM = "originDiskEnclosureNum"
    NEW_DISK_ENCLOSURE_NUM = "newDiskEnclosureNum"


DORADO_18000_MAX_ENC_HEIGHT_DICT = {
    2: 16,
    4: 32,
    6: 48,
    8: 64
}

DORADO_18000V3_SMB0_SAS_PORT_DICT = {
    'DAE000.A.P0': 'CTE0.R0.IOM0.P0',
    'DAE000.A.P1': 'CTE0.R0.IOM0.P1',
    'DAE000.B.P0': 'CTE0.L0.IOM0.P0',
    'DAE000.B.P1': 'CTE0.L0.IOM0.P1',

    'DAE020.A.P0': 'CTE0.R0.IOM0.P2',
    'DAE020.A.P1': 'CTE0.R0.IOM0.P3',
    'DAE020.B.P0': 'CTE0.L0.IOM0.P2',
    'DAE020.B.P1': 'CTE0.L0.IOM0.P3',

    'DAE040.A.P0': 'CTE0.R1.IOM0.P0',
    'DAE040.A.P1': 'CTE0.R1.IOM0.P1',
    'DAE040.B.P0': 'CTE0.L1.IOM0.P0',
    'DAE040.B.P1': 'CTE0.L1.IOM0.P1',

    'DAE060.A.P0': 'CTE0.R1.IOM0.P2',
    'DAE060.A.P1': 'CTE0.R1.IOM0.P3',
    'DAE060.B.P0': 'CTE0.L1.IOM0.P2',
    'DAE060.B.P1': 'CTE0.L1.IOM0.P3',

    'DAE008.A.P0': 'CTE0.R2.IOM0.P0',
    'DAE008.A.P1': 'CTE0.R2.IOM0.P1',
    'DAE008.B.P0': 'CTE0.L2.IOM0.P0',
    'DAE008.B.P1': 'CTE0.L2.IOM0.P1',

    'DAE028.A.P0': 'CTE0.R2.IOM0.P2',
    'DAE028.A.P1': 'CTE0.R2.IOM0.P3',
    'DAE028.B.P0': 'CTE0.L2.IOM0.P2',
    'DAE028.B.P1': 'CTE0.L2.IOM0.P3',

    'DAE048.A.P0': 'CTE0.R4.IOM0.P0',
    'DAE048.A.P1': 'CTE0.R4.IOM0.P1',
    'DAE048.B.P0': 'CTE0.L4.IOM0.P0',
    'DAE048.B.P1': 'CTE0.L4.IOM0.P1',

    'DAE068.A.P0': 'CTE0.R4.IOM0.P2',
    'DAE068.A.P1': 'CTE0.R4.IOM0.P3',
    'DAE068.B.P0': 'CTE0.L4.IOM0.P2',
    'DAE068.B.P1': 'CTE0.L4.IOM0.P3',

    'DAE080.A.P0': 'CTE0.R0.IOM1.P0',
    'DAE080.A.P1': 'CTE0.R0.IOM1.P1',
    'DAE080.B.P0': 'CTE0.L0.IOM1.P0',
    'DAE080.B.P1': 'CTE0.L0.IOM1.P1',

    'DAE0A0.A.P0': 'CTE0.R0.IOM1.P2',
    'DAE0A0.A.P1': 'CTE0.R0.IOM1.P3',
    'DAE0A0.B.P0': 'CTE0.L0.IOM1.P2',
    'DAE0A0.B.P1': 'CTE0.L0.IOM1.P3',

    'DAE0C0.A.P0': 'CTE0.R1.IOM1.P0',
    'DAE0C0.A.P1': 'CTE0.R1.IOM1.P1',
    'DAE0C0.B.P0': 'CTE0.L1.IOM1.P0',
    'DAE0C0.B.P1': 'CTE0.L1.IOM1.P1',

    'DAE0E0.A.P0': 'CTE0.R1.IOM1.P2',
    'DAE0E0.A.P1': 'CTE0.R1.IOM1.P3',
    'DAE0E0.B.P0': 'CTE0.L1.IOM1.P2',
    'DAE0E0.B.P1': 'CTE0.L1.IOM1.P3',

    'DAE088.A.P0': 'CTE0.R2.IOM1.P0',
    'DAE088.A.P1': 'CTE0.R2.IOM1.P1',
    'DAE088.B.P0': 'CTE0.L2.IOM1.P0',
    'DAE088.B.P1': 'CTE0.L2.IOM1.P1',

    'DAE0A8.A.P0': 'CTE0.R2.IOM1.P2',
    'DAE0A8.A.P1': 'CTE0.R2.IOM1.P3',
    'DAE0A8.B.P0': 'CTE0.L2.IOM1.P2',
    'DAE0A8.B.P1': 'CTE0.L2.IOM1.P3',

    'DAE0C8.A.P0': 'CTE0.R4.IOM1.P0',
    'DAE0C8.A.P1': 'CTE0.R4.IOM1.P1',
    'DAE0C8.B.P0': 'CTE0.L4.IOM1.P0',
    'DAE0C8.B.P1': 'CTE0.L4.IOM1.P1',

    'DAE0E8.A.P0': 'CTE0.R4.IOM1.P2',
    'DAE0E8.A.P1': 'CTE0.R4.IOM1.P3',
    'DAE0E8.B.P0': 'CTE0.L4.IOM1.P2',
    'DAE0E8.B.P1': 'CTE0.L4.IOM1.P3',
}

# Dorado V6单引擎最大支持的硬盘框数量，key=内部型号，value=单引擎最大支持的硬盘框数
DORADO_V6_SINGLE_ENG_MAX_DAE_NUM = {
    'D3000V6_N_C': 4,
    'D3000V6': 5,
    'D3000V6_C': 5,
    'D3000V6_N_C_F': 4,
    'D3000V6_F': 5,
    'D3000V6_C_F': 5,
    'D2000V6_C': 3,
    'D2020V6_C': 3,
    'D2100V6_C': 3,
    'D5000V6': 7,
    'D5000V6_C': 7,
    'D5000V6_I': 7,
    'D5000V6_I_C': 7,
    'D5000V6_N': 5,
    'D5000V6_N_C': 5,
    'D6000V6': 11,
    'D6000V6_I': 11,
    'D6000V6_N': 8,
    'D8000V6': 32,
    'D8000V6_C': 32,
    'D8000V6_I': 32,
    'D8000V6_I_C': 32,
    'D8000V6_N': 23,
    'D8000V6_N_C': 23,
    'D8000V6_2P': 32,
    'D8000V6_C_2P': 32,
    'D8000V6_I_2P': 32,
    'D8000V6_I_C_2P': 32,
    'D8000V6_N_2P': 23,
    'D8000V6_N_C_2P': 23,
    'D18000V6': 32,
    'D18000V6_C': 32,
    'D18000V6_I': 32,
    'D18000V6_I_C': 32,
    'D18000V6_N': 23,
    'D18000V6_N_C': 23,

    'D5300V6': 5,
    'D5300V6_C': 5,
    'D5300V6_N_C': 4,
    'D5300V6_F': 5,
    'D5300V6_C_F': 5,
    'D5300V6_N_C_F': 4,
    '2910V6': 4,
    '2910V6_XPU': 4,
    'D5500V6': 7,
    'D5500V6_C': 7,
    'D5500V6_I': 7,
    'D5500V6_I_C': 7,
    'D5500V6_N': 5,
    'D5500V6_N_C': 5,
    'D5500V6_N_C_X': 5,
    'D5500V6_N_C_X_1P': 5,
    'D5500V6_C_X': 5,
    'D5500V6_C_X_H': 7,
    "D2000V6_C_X_H": 4,
    "D2000V6_C_X": 4,
    'D5600V6': 11,
    'D5600V6_I': 11,
    'D5600V6_N': 8,
    'D5600V6_N_C_X': 9,
    'D5600V6_N_C_X_1P': 9,
    'D5600V6_S': 10,
    'D5600V6_S_H': 13,
    'D5600V6_X': 11,
    'E8000': 11,
    'D5600V6_X_1P': 11,
    'D5600V6_X_H': 14,
    'D5600V6_X_H_1P': 14,
    'D5600KV6_X': 11,
    'D5600KV6_X_1P': 11,
    'D5600KV6_X_H': 14,
    'D5600KV6_X_H_1P': 14,
    'D6800V6': 32,
    'D6800V6_C': 32,
    'D6800V6_I': 32,
    'D6800V6_I_C': 32,
    'D6800V6_N': 23,
    'D6800V6_N_C': 23,
    'D6800V6_C_X': 32,
    'D6800V6_C_X_H': 37,
    'D6800V6_N_C_X': 23,
    'D6800KV6_C_X': 32,
    'D6800KV6_C_X_H': 37,
    'D6800V6_2P': 32,
    'D6800V6_C_2P': 32,
    'D6800V6_I_2P': 32,
    'D6800V6_I_C_2P': 32,
    'D6800V6_N_2P': 23,
    'D6800V6_N_C_2P': 23,
    'D6800V6_C_X_2P': 32,
    'D18500V6': 32,
    'D18500V6_C': 32,
    'D18500V6_I': 32,
    'D18500V6_I_C': 32,
    'D18500V6_N': 23,
    'D18500V6_N_C': 23,
    'D18500V6_2P': 32,
    'D18500V6_C_2P': 32,
    'D18500V6_I_2P': 32,
    'D18500V6_I_C_2P': 32,
    'D18500V6_N_2P': 23,
    'D18500V6_N_C_2P': 23,
    'D18800V6': 32,
    'D18800V6_C': 32,
    'D18800V6_I': 32,
    'D18800V6_I_C': 32,
    'D18800V6_N': 23,
    'D18800V6_N_C': 23,
    'D18800KV6_N': 23,
    'D18800KV6_N_C': 23,

    'D5600KV6_N': 8,
    '5310_Q': 33,
    '5310_Q_RV': 33,
    '5510_Q_L1': 33,
    '5510_Q_L1_RV': 33,
    '5510_Q_L2': 33,
    '5510_Q_L2_RV': 33,
    '5510_Q_L3': 34,
    '5510_Q_L3_RV': 34,
    '5310_M_C': 17,
    '5310_M_C_S': 17,
    '5310_M_C_D': 17,
    '5320_M_C': 15,
    '5510_M_C': 28,
    '5510_M_C_S': 28,
    'A300V6_N_C': 28,
    '5610_M_C': 34,
    '5610_M_C_S': 34,
    '5810H': 39,
    '6810_M_C': 50,
    '6810_M_C_2P': 50,
    '6810_N_C': 23,
    '6810_N_C_2P': 23,
    '18510_C': 32,
    '18510_C_2P': 32,
    '18510_M_C': 67,
    '18510_M_C_2P': 67,
    '18510_N_C': 23,
    '18510_N_C_2P': 23,
    '18500K_C': 32,
    '18500K_C_2P': 32,
    '18500K_M_C': 67,
    '18500K_M_C_2P': 67,
    '18500K_N_C': 23,
    '18500K_N_C_2P': 23,
    '18810_C': 32,
    '18810_M_C': 67,
    '18810_N_C': 34,
    '5300K_M_C': 33,
    '5500K_M_C': 33,
    'M1500': 7,
    'M1500T': 7,
    'M1500_F': 7,
    'M5610_H': 34,
    'M1500_H': 34,
    'M1500T_H': 34,
    'M1600': 11,
    'M1600T': 11,
    'M1600_H': 11,
    'M1600T_H': 11,
    'M1610': 11,
    'M1610T': 11,
    'M1610_H': 11,
    'M1610T_H': 11,
    '2200_16G': 12,
    '2200_24G': 12,
    '2220_16G': 12,
    '2220_24G': 12,
    '5120_32G': 17,
    '5120_16G': 17,
    '2600_32G': 21,
    '2600_64G': 21,
    '2620_32G': 17,
    '2620_64G': 17,
    '5210_16G': 17,
    '5210_32G': 21,
    '5210_48G': 42,
    '5210_64G': 42,
    '5220_48G': 33,
    '5220_64G': 33,
    '5220_32G': 33,
    'M1500_CAP1': 2,
    'M1500_CAP2': 2
}

# 新融合扩大规格后的单引擎最大支持的硬盘框数量
NEW_DORADO_SINGLE_ENG_MAX_DAE_NUM = {
    '5310_M_C': 33,
    '5310_M_C_S': 33,
    '5310_M_C_D': 33,
    '5510_M_C': 33,
    '5510_M_C_S': 33,
    'A300V6_N_C': 33,
}

# 二级存储X系列扩大规格后的单引擎最大支持的硬盘框数量
OCEAN_PROTECT_SINGLE_ENG_MAX_DAE_NUM = {
    'D5500V6_C_X': 6,
    'D5500V6_C_X_H': 16,
}

# OceanStor Dorado 18000 V6扩大规格后单引擎最大支持的硬盘框数量 Expanded specifications
NEW_DORADO_SINGLE_ENG_MAX_DAE_NUM_AFTER_EXPANSION_SPEC = {
    'D18000V6_N': 45,
    'D18000V6_N_C': 45,
}

# V5R8COO 最大硬盘框数量
V5R8C00_MAX_DAE_NUM = {
    "2210": 21,
    "2220": 21,
    "2200 V5": 21,
    "2810 V5": 64,
    "5310 V5": 64,
    "5310F V5": 58,
    "5510 V5": 130,
    "5510F V5": 78,
    "5610 V5": 164,
    "5610F V5": 94,
    "5810 V5": 192,
    "5810F V5": 118,
    "6810 V5": 96,
    "6810F V5": 160,

    "5300 V5": 64,
    "5300F V5": 58,
    "5500 V5": 130,
    "5500F V5": 78,
    "5600 V5": 164,
    "5600F V5": 94,
    "5800 V5": 192,
    "5800F V5": 118,
    "6800 V5": 96,
    "6800F V5": 160,
    # TODO:临时配置，待删除
    "18510 V5": 256,
    "18510F V5": 96,
    "18810 V5": 384,
    "18810F V5": 128,
}


# V5R8 X10 级联深度
V5R8C00_MAX_CASCADING_DEPTH = {
    "2810 V5": {
        "SAS": 8,
    },
    "5310 V5": {
        "SAS": 8,
        "IP": 4,
    },
    "5310F V5": {
        "SAS": 4,
        "IP": 4,
    },
    "5510 V5": {
        "SAS": 8,
        "IP": 4,
    },
    "5510F V5": {
        "SAS": 4,
        "IP": 4,
    },
    "5610 V5": {
        "SAS": 8,
        "IP": 4,
    },
    "5610F V5": {
        "SAS": 4,
        "IP": 4,
    },
    "5810 V5": {
        "SAS": 8,
        "IP": 4,
    },
    "5810F V5": {
        "SAS": 4,
        "IP": 4,
    },
    "6810 V5": {
        "SAS": 4,
        "IP": 4,
    },
    "6810F V5": {
        "SAS": 4,
        "IP": 4,
    },
}

# 微存储、新融合 级联深度
NEW_OCEANSTOR_AND_MICRO_MAX_CASCADING_DEPTH = {
    "OceanStor Micro 1500": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanDisk 1500": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanDisk 1600": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanDisk 1500T": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanDisk 1600T": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanDisk 1610": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanDisk 1610T": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 2200": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 2220": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5120": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 2600": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 2620": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5210": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5220": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5310 Capacity Flash": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5510 Capacity Flash": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor A300": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5310": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5320": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5300K": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5500K": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5510": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5510S": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5610": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 5810-HS": {
        "SAS": 8,
        "IP": 2,
    },
    "OceanStor 6810": {
        "SAS": 4,
        "IP": 2,
    },
    "OceanStor 18510": {
        "SAS": 4,
        "IP": 2,
    },
    "OceanStor 18500K": {
        "SAS": 4,
        "IP": 2,
    },
    "OceanStor 18810": {
        "SAS": 4,
        "IP": 2,
    },
}

# 二级存储 级联深度
OCEAN_PROTECT_MAX_CASCADING_DEPTH = {
    "OceanProtect A8000": {
        "SAS": 2,
    },
    "OceanProtect X6000": {
        "SAS": 8,
    },
    "OceanProtect X8000": {
        "SAS": 8,
    },
    "OceanProtect E8000": {
        "SAS": 8,
    },
    "OceanProtect X8000K": {
        "SAS": 8,
    },
    "OceanProtect X9000": {
        "SAS": 4,
    },
    "OceanProtect X9000K": {
        "SAS": 4,
    },
    "OceanProtect X3000": {
        "SAS": 2,
    }
}

SSD_DISK_TYPE = {
    "SSD": "3",
    "SSD SED": "10",
    "NVMe SSD": "14",
    "NVMe SSD SED": "16",
    "SCM": "17",
    "SCM SED": "18",
    "Capacity-Optimized SSD": "19",
    "Capacity-Optimized SSD SED": "20"
}

# 包装的QLC盘
PACKED_QLC_DISK_TYPE = {
    "Capacity-Optimized SSD": "19",
    "Capacity-Optimized SSD SED": "20"
}

# 正版的QLC盘
REALLY_QLC_DISK_TYPE = {
    "Capacity-Optimized SSD": "21",
    "Capacity-Optimized SSD SED": "22"
}

HDD_DISK_TYPE = {
    "SAS": "1",
    "SAS SED": "8",
    "SATA": "2",
    "SATA SED": "9",
    "NearLine SAS": "4",
    "NearLine SAS SED": "11"
}

DISK_TYPE_TOOL_PRODUCT = {
    "NAS": "NAS",
    "SAS": "SAS",
    "SSD": "SSD",
    "SATA": "SATA",
    "SSD SED": "SSD SED",
    "HWCM SSD": "HWCM SSD",
    "NVMe SSD": "NVMe SSD",
    "NVMe SSD SED": "NVMe SSD SED",
    "NL SAS": "NearLine SAS",
    "SAS SED": "SAS SED",
    "NL SAS SED": "NearLine SAS SED",
    "SATA SED": "SATA SED",
    "Capacity Optimized SSD": "Capacity-Optimized SSD",
    "Capacity Optimized SSD SED": "Capacity-Optimized SSD SED"
}

# 新融合支持混闪的内部型号，该内部型号的RDMA级联深度为1
INTER_PRODUCT_MODEL_SUPPORT_FLASHING = ["18510_M_C", "18510_M_C_2P",
                                        "18810_M_C"]

# 微存储支持混闪的内部型号，该内部型号的RDMA级联深度为1
INTER_PRODUCT_MODEL_SUPPORT_FLASHING_MICRO = [
    "M1600_H", "M5610_H", "M1500_H", "M1500T_H", "M1600T_H", "M1610_H", "M1610T_H"
]

# 新融合支持全闪只支持NVMe框
INTER_PRODUCT_MODEL_SUPPORT_NVME = ["18510_N_C", "18510_N_C_2P", "18500K_N_C",
                                    "18500K_N_C_2P", "18810_N_C", "D6800V6_N_C_X"]

# 新融合整柜支持SAS框
HYBRID_V6_FULL_BAY_SUP_SAS_ENC = ["18510_C", "18510_C_2P", "18510_M_C",
                                  "18510_M_C_2P", "18500K_C", "18500K_C_2P",
                                  "18500K_M_C", "18500K_M_C_2P", "18810_C",
                                  "18810_M_C"]

# 工具扩容步骤
class ExpStep():
    EXP_CTRL_EXECUTE_EXP_1 = "executeExpansion1"  # 完成扩容第一阶段，如：6U 混合场景扩容，先2扩4，再4扩6
    EXP_CTRL_EXECUTE_EXP = "executeExpansion"


class Overtime:
    SAS_CABLE_ALARM_TIMEOUT = 210


class IntervalTime:
    DEFAULT_INTERVAL = 2


EXP_NVME_VER = "V300R002C10"
