# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import enclosureCommon
from cbb.frame.context import contextUtil

COLUMN_ITEM_SCRIPT = {
    "expandDaeOrDiskBay": {
        "0": "expandDiskBay/selectDaeNum.py",
    },
    "expandDiskBay": {
        "0": "expandDiskBay/selectCabinet.py",
        "1": "expandDiskBay/select2UEnclosure.py",
        "2": "expandDiskBay/select4UEnclosure.py",
        "3": "expandDiskBay/deleteCabinetData.py",
    },
    "expandDiskEnclosure": {
        "0": "expandDiskEnclosure/selectCabinet.py",
        "1": "expandDiskEnclosure/select2UEnclosure.py",
        "2": "expandDiskEnclosure/select4UEnclosure.py",
        "3": "expandDiskEnclosure/deleteCabinetData.py",
    },
    "expandOnly2UDiskEnclosure": {
        "0": "expandDiskEnclosure/select2UEnclosureForDorado18000.py",
    },
    "expandDiskBayAll": {
        "0": "expandDiskBay/selectCabinet.py",
        "1": "expandDiskBayAll/select2UEnclosure.py",
        "2": "expandDiskBayAll/select4UEnclosure.py",
        "3": "expandDiskBay/deleteCabinetData.py",
    },
    "expandDiskEnclosureAll": {
        "0": "expandDiskEnclosure/selectCabinet.py",
        "1": "expandDiskEnclosureAll/select2UEnclosure.py",
        "2": "expandDiskEnclosureAll/select4UEnclosure.py",
        "3": "expandDiskEnclosure/deleteCabinetData.py",
    },
}

COLUMN_ITEM_TYPE = {
    "0": "dropDown",
    "1": "dropDown",
    "2": "dropDown",
    "3": "button",
}

COLUMN_ITEM_TYPE_FOR_DORADO_V6_HIGH_END = {
    "0": "dropDown",
    "1": "button",
}
COLUMN_ITEM_PARAM_FOR_DORADO_V6_HIGH_END = {
    "0": "daeNum",
    "1": "delete",
}

COLUMN_ITEM_PARAM = {
    "0": "cabinet",
    "1": "2UEnclosure",
    "2": "4UEnclosure",
    "3": "delete",
}

COLUMN_ITEM_PARAM_FOR_DORADO_V3 = {
    "0": "2UEnclosure",
    "1": "delete",
}
COLUMN_ITEM_TYPE_FOR_DORADO = {
    "0": "dropDown",
    "1": "button",
}
ITEM_LENGTH = "108"

# Dorado界面适配
ITEM_LENGTH_FOR_DORADO = "230"


def createTableColumnItem(columnIdx, label, columnType, scriptFile, param, rule=[], **kwargs):
    """Create a column of the flex config step's config table.

    :param columnIdx:
    :param label:
    :param columnType:
    :param scriptFile:
    :param param:
    :param rule:
    :param kwargs:
    :return:
    """
    # 最大下拉框列数
    maxDropDownColumn = 2
    isDorado18000 = kwargs.get('isDorado18000')
    isV6Highend = kwargs.get('isV6HighEnd')

    columnWidth = ITEM_LENGTH_FOR_DORADO if (columnIdx == "0") else ITEM_LENGTH
    columnWidth = "145" if (not isDorado18000 and columnIdx in ['1', '2']) \
        else columnWidth
    columnWidth = "90" if isV6Highend else columnWidth

    columnItem = {}
    if columnType == "label" or columnType == "button":
        columnItem = {
            "id": columnIdx,
            "type": columnType,
            "combo": "",
            "content": {
                "length": columnWidth,
                "label": label,
                "lableLayout": "center",
                "script": scriptFile,
                "param": "",
                "default": label,
                "refreshItems": ""
            }
        }
    if columnType == "dropDown":
        # 最后一个下拉框配置refreshItems为控
        curItemId = int(columnIdx)
        refreshItems = [str(refreshId) for refreshId in range(curItemId + 1, maxDropDownColumn)]
        refreshItems = ','.join(refreshItems)

        columnItem = {
            "id": columnIdx,
            "type": columnType,
            "combo": "true",
            "content": {
                "length": columnWidth,
                "label": label,
                "script": scriptFile,
                "param": param,
                "rule": rule,
                "default": "",
                "refreshItems": refreshItems
            }
        }
    return columnItem


def createInputItemPairsForDoradoV6(labelColumnIdx, label, scriptFile, rule='', **kwargs):
    """For Dorado V6 high end product, the expansion disk enclosure or dis bay config's format is as follows:
    For single type disk enclosures:
        Expansion disk number: [DropDownItem].
    For multi-type disk enclosures:
        SAS disk enclosure number [DropDownItem]   Smart disk enclosure number [DropDownItem]


    :param labelColumnIdx:
    :param label:
    :param scriptFile:
    :param rule:
    :param kwargs:
    :return:
    """
    # 最大下拉框列数
    maxDropDownColumn = 2
    columnWidth = "90"
    labelColumn = {
        "id": str(labelColumnIdx),
        "type": 'label',
        "combo": "",
        "content": {
            "length": columnWidth,
            "label": label,
            "lableLayout": "center",
            "param": "",
            "default": label,
            "refreshItems": ""
        }
    }

    # 最后一个下拉框配置refreshItems为控
    curItemId = int(labelColumnIdx+1)
    refreshItems = [str(refreshId) for refreshId in range(curItemId + 1, maxDropDownColumn)]
    refreshItems = ','.join(refreshItems)

    dropdownColumn = {
        "id": str(labelColumnIdx+1),
        "type": 'dropDown',
        "combo": "true",
        "content": {
            "length": columnWidth,
            "label": '',
            "script": scriptFile,
            "param": '',
            "rule": rule,
            "default": "",
            "refreshItems": refreshItems
        }
    }
    return [{'columns': [labelColumn, dropdownColumn]}]


def getCabinetRule(context):
    '''
    @summary: 获取柜名的下拉框显示内容
    '''
    availableCabinets = contextUtil.getItem(context, "availableCabinets")
    rule = ",".join(availableCabinets)
    return rule


def getEnclosureRule(context, cabinetName, curEncHeight):
    '''
    @summary: 获取对应柜下硬盘框的rule（包括2U、4U硬盘框）
    '''
    logger = common.getLogger(context.get("logger"), __file__)

    otherEncHeight = 4  # 默认4U框，即获取2U框的rule
    otherEnclosureNum = 0
    (selectedEnc2UNum, selectedEnc4UNum) = contextUtil.getSelectedEncNumByCabinet(context, cabinetName)
    logger.logInfo("selected enclosure 2U [%d], 4U [%d]" % (selectedEnc2UNum, selectedEnc4UNum))
    cabinetInfoDict = contextUtil.getItem(context, "oldCabinetInfoDict")

    if str(curEncHeight) == "4":  # 默认2U硬盘框
        otherEncHeight = 2  # 2U框
        otherEnclosureNum = selectedEnc2UNum

    cabinet = cabinetInfoDict.get(cabinetName)
    if enclosureCommon.isNewExpansion(context):
        availableEncNum = enclosureCommon.getUpperLimitOfNewEncs(context, cabinet, curEncHeight, otherEncHeight,
                                                                 otherEnclosureNum)
    else:
        availableEncNum = common.getUpperLimitOfNewEncs(context, cabinet, curEncHeight, otherEncHeight,
                                                        otherEnclosureNum)
    logger.logInfo("enclosure type [%sU], number [%s]" % (str(curEncHeight), str(availableEncNum)))

    if str(curEncHeight) == "4" and not contextUtil.getItem(context, "support4UDiskEnclosure"):
        availableEncNum = 0

    availableEncs = [str(e) for e in range(availableEncNum + 1)]  # 加1是为了界面显示到最大数量
    rule = ",".join(availableEncs)

    return rule


def getRules(context):
    '''
    @summary: 初始化每行中各控件的rule
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    rules = []
    availableCabinets = contextUtil.getItem(context, "availableCabinets")
    logger.logInfo("availableCabinets:%s" % str(availableCabinets))
    cabinetName = availableCabinets[0]  # 取第一个柜为初始化默认柜

    # 柜的rule
    cabinetRule = getCabinetRule(context)
    rules.append(cabinetRule)

    # 2U框的rule
    enc2UHeight = 2
    enc2URule = getEnclosureRule(context, cabinetName, enc2UHeight)

    rules.append(enc2URule)

    # 4U框的rule
    enc4UHeight = 4
    logger.logInfo("support4UDiskEnclosure:%s" % str(contextUtil.getItem(context, "support4UDiskEnclosure")))
    if not contextUtil.getItem(context, "support4UDiskEnclosure"):
        enc4URule = '0'
    else:
        enc4URule = getEnclosureRule(context, cabinetName, enc4UHeight)
    rules.append(enc4URule)

    rules.append("")  # 最后一项为操作按钮，无rule

    # 初始化数据
    curRowConfigInfo = {
        "cabinetName": cabinetName,
        "newEnc2UList": [],
        "newEnc4UList": []
    }
    # 更新扩容配置信息
    rowId = contextUtil.getItem(context, "curRow")
    selectedConfig = contextUtil.getItem(context, "selectedConfig")
    selectedConfig.setdefault(str(rowId), curRowConfigInfo)
    contextUtil.setItem(context, "selectedConfig", selectedConfig)
    logger.logInfo("update rowId:%s" % str(rowId))
    # 更新已选柜的列表
    contextUtil.updateSelectedCabinets(context)
    return rules


def getEnclosureRuleForDorado18000(context, owingCtrl):
    """获取Dorado18000设备的2U硬盘框rule
    :param context:
    :param owingCtrl:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    confDictList = contextUtil.getItem(context, 'allPosibleConfDictList', [])
    tgtConfDictList = filter(lambda confDict: confDict.get('owningCtrl') == owingCtrl, confDictList)
    logger.logInfo('selected owning ctrl conf list:%s' % (str(tgtConfDictList)))
    if tgtConfDictList:
        tgtConfDict = tgtConfDictList[0]
        return tgtConfDict.get('ruleDict', {}).get('rule', '')
    else:
        return ''


def getRulesForDorado(context):
    """初始化每行中各控件【所属控制框（控制器），2U硬盘框数量】的rule.
    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    rules = []
    confDictList = contextUtil.getItem(context, 'allPosibleConfDictList', [])
    availableOwningCtrlList = contextUtil.getItem(context, 'availableOwningCtrls', [])

    logger.logInfo('Available owning controller list: %s' % str(availableOwningCtrlList))
    logger.logInfo('All possible conf dict list: %s' % str(confDictList))
    owningCtrlRule = ','.join(availableOwningCtrlList)

    if not availableOwningCtrlList:
        return []

    tgtConfDictList = list(filter(lambda conf: conf.get('owningCtrl') == availableOwningCtrlList[0], confDictList))
    if not tgtConfDictList:
        return []

    firstConfDict = tgtConfDictList[0]
    enc2URule = firstConfDict.get('ruleDict', {}).get('rule')

    rules.append(owningCtrlRule)
    rules.append(enc2URule)
    rules.append("")  # 最后一项为操作按钮，无rule

    saveDefaultConfigInContext(context, enc2URule, firstConfDict, logger)
    return rules


def getRulesForDoradoV6HighEnd(context):
    """Initialize rule for Dorado V6 high end
    :param context:
    :return:
    """
    rules = []

    maxSupportNewDiskEncNum = contextUtil.getItem(context, "maxSupportNewDiskEncNum", 0)

    daeNumRule = ','.join(map(str, range(maxSupportNewDiskEncNum + 1)))
    rules.append(daeNumRule)

    return rules


def get_rules_for_low_and_mid(context):
    """初始化中低端扩框规则
    :param context:
    :return:
    """
    rules = []
    max_support_new_disk_enc_num = contextUtil.getItem(context, "maxDaeNumToExp", 0)
    dae_num_rule = ','.join(map(str, range(max_support_new_disk_enc_num + 1)))
    rules.append(dae_num_rule)
    return rules


def saveDefaultConfigInContext(context, enc2URule, firstConfDict, logger):
    """ 每添加一个数据行后，将默认数据保存至上下文中，防止用户未选择数据时，默认数据不更新到上下文，

    影响数据校验及上下文中数据的准确性。

    :param context:
    :param enc2URule:
    :param firstConfDict:
    :param logger:
    :return:
    """
    defaultOwingCtrl = firstConfDict.get('owningCtrl', '')
    defaultNewEnc2UList = []
    try:
        defaultNewEnc2UNum = int(enc2URule.split(',')[0])
    except Exception as e:
        logger.logInfo("saveDefaultConfigInContext exception:%s" % str(e))
        defaultNewEnc2UNum = 0

    curRowConfigInfo = {
        "owningCtrl": defaultOwingCtrl,
        "newEnc2UList": defaultNewEnc2UList,
        'newEnc2UNum': defaultNewEnc2UNum,
    }

    rowId = contextUtil.getItem(context, "curRow")
    selectedConfig = contextUtil.getItem(context, "selectedConfig")
    selectedConfig.setdefault(str(rowId), curRowConfigInfo)
    contextUtil.setItem(context, "selectedConfig", selectedConfig)
    contextUtil.updateOwningCtrlInfoInContext(context)
    contextUtil.updateEnclosuresNum(context)

    logger.logInfo("Selected config in context:%s" % str(selectedConfig))

    return


def getItemInfoDict(context, tableHeadFlag=False):
    '''
    @summary: 动态生成每行属性的字典，只支持四列，多列需手动添加
    '''
    lang = contextUtil.getLang(context)
    if tableHeadFlag:
        labels = [
            common.getRes(lang, "dorado_v6_newly_add_dae_number"),
        ]

        itemInfoDict = {
            "labels": labels
        }
        return itemInfoDict
    else:
        # 目前适用下拉框
        labels = [
            "",
        ]
        rules = get_rules_for_low_and_mid(context)

    itemInfoDict = {
        "labels": labels,
        "rules": rules
    }
    return itemInfoDict



def getItemInfoDictForV6HighEnd(context, tableHeadFlag=False):
    '''
    @summary: 动态生成每行属性的字典，只支持四列，多列需手动添加
    '''
    lang = contextUtil.getLang(context)
    if tableHeadFlag:
        labels = [
            common.getRes(lang, "dorado_v6_newly_add_dae_number"),
        ]

        itemInfoDict = {
            "labels": labels
        }
        return itemInfoDict
    else:
        # 目前适用下拉框
        labels = [
            "",
        ]
        rules = getRulesForDoradoV6HighEnd(context)

    itemInfoDict = {
        "labels": labels,
        "rules": rules
    }
    return itemInfoDict


def getTableColumnItems(context, columnNum, itemInfoDict):
    '''
    @summary: 获取行的界面配置属性col_list
    '''
    columnItems = []
    expandType = contextUtil.getItem(context, "expandType")
    itemScript = COLUMN_ITEM_SCRIPT[expandType]
    labels = itemInfoDict.get("labels", [])
    rules = itemInfoDict.get("rules", [])
    if not rules:
        return []

    isDorado18000 = contextUtil.getItem(context, 'isDorado18000')
    for i in range(columnNum):
        itemId = str(i)
        label = labels[i]
        if not isDorado18000:
            columnType = COLUMN_ITEM_TYPE_FOR_DORADO.get(itemId, "")
            param = COLUMN_ITEM_PARAM_FOR_DORADO_V3.get(itemId, "")
        else:
            columnType = COLUMN_ITEM_TYPE.get(itemId, "")
            param = COLUMN_ITEM_PARAM.get(itemId, "")
        scriptFile = itemScript.get(itemId, "")
        rule = rules[i]
        rowItem = createTableColumnItem(itemId, label, columnType, scriptFile, param, rule, isDorado18000=isDorado18000)
        columnItems.append(rowItem)
    return columnItems


def getTableColumnItemsForV6HighEnd(context, columnNum, itemInfoDict):
    '''
    @summary: 获取行的界面配置属性col_list
    '''
    columnItems = []
    expandType = contextUtil.getItem(context, "expandType")
    itemScript = COLUMN_ITEM_SCRIPT[expandType]
    labels = itemInfoDict.get("labels", [])
    rules = itemInfoDict.get("rules", [])
    if not rules:
        return []

    for i in range(columnNum):
        columnIdx = str(i)
        label = labels[i]
        columnType = COLUMN_ITEM_TYPE_FOR_DORADO_V6_HIGH_END.get(columnIdx, "")
        param = COLUMN_ITEM_PARAM_FOR_DORADO_V6_HIGH_END.get(columnIdx, "")
        scriptFile = itemScript.get(columnIdx, "")
        rule = rules[i]
        rowItem = createTableColumnItem(columnIdx, label, columnType, scriptFile, param, rule, isV6HighEnd=True)
        columnItems.append(rowItem)

    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo('columnItems:%s' % columnItems)
    return columnItems


def getTableColumnHeadItems(columnNum, itemInfoDict):
    '''
    @summary: 获取表头界面配置属性col_list
    '''
    rowItems = []
    labels = itemInfoDict.get("labels", [])
    isDorado18000 = itemInfoDict.get('isDorado18000', False)
    for i in range(columnNum):
        rowId = str(i)
        label = labels[i]
        rowItem = createTableColumnItem(rowId, label, "label", "", "", rule=[], isDorado18000=isDorado18000)
        rowItems.append(rowItem)

    return rowItems


def getTableRowItem(context, columnNum, rowId=0, scriptFile=""):
    '''
    @summary: 获取一行的界面配置信息
    '''
    logger = common.getLogger(context.get("logger"), __file__)

    tableHeadFlag = (rowId == 0)
    itemInfoDict = getItemInfoDict(context, tableHeadFlag)

    if rowId == 0:
        columnList = getTableColumnHeadItems(columnNum, itemInfoDict)
    else:
        columnList = getTableColumnItems(context, columnNum, itemInfoDict)

    rowItem = {
        "id": str(rowId),
        "script": scriptFile,
        "columns": columnList
    }
    return rowItem

