﻿# -*- coding: UTF-8 -*-
import java.lang.Exception as jException
from com.huawei.ism.tool.framework.platform.exception import (
    ToolException,
)  # @UnresolvedImport

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil

"""
公共方法：判断工具登录用户的权限
"""


def execute(context):
    try:
        # 检查工具与设备的连接
        isPass, errMsg = checkConnection(context)
        if not isPass:
            BaseFactory.result.setResultFailByDesc(context, errMsg, "")
            return
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        hasPrivilegeRet = cliUtil.hasSuperAdminPrivilege(
            cli, lang, cliUtil.PrivilegeType.ROLE_ID
        )
        if len(hasPrivilegeRet) < 2 \
                or not hasPrivilegeRet[0] or not hasPrivilegeRet[1]:
            errMsg = BaseFactory.lang.getDesc(
                context, FuncFactory.LangKey.ERROR_USER_SUPER_PERMISSION_DENIED
            )
            BaseFactory.result.setResultFailByDesc(context, errMsg, "")
            return
        BaseFactory.result.setResultPass(context)
    except Exception as ex:
        BaseFactory.exception.handler(context, ex)

    return


def checkConnection(context):
    """
    @summary:密码过期或即将过期时提示用户修改
    @return：
    """
    try:
        contextUtil.getCli(context)
        sshConnector = contextUtil.getItem(context, contextUtil.SSH_CONNECTOR)
        sshConnector.getConnectionForPwdWillExpireBreak()
        return True, ""

    # 密码已经过期或即将过期
    except jException as pwdExp:
        errMsg = pwdExp.getErrorMsg()
        return False, errMsg

    # 框架抛出的其它连接异常
    except (ToolException, Exception):
        errMsg = getConnFailMsg(context)
        return False, errMsg


def getConnFailMsg(context):
    """
    @summary：设置与设备连接失败的通用错误消息
    """
    lan = context.get("lan")

    if lan == "zh":
        return u"与设备通信异常，请检查网络连接或设备状态是否正常。"
    else:
        return (
            "The communication with the device is abnormal. "
            "Check whether the network connection "
            "and device status are normal."
        )
