# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.common.query.software.alarm import getCurrentSystemAlarms
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

def execute(context, alarmIds=None, encId=None):
    """检查框超温告警

    :param context:
    :return:
    """
    BaseFactory.log.info(context, "encId is : %s" % encId)
    if not alarmIds:
        BaseFactory.result.setResultPass(context)
        return
    BaseFactory.log.info(context, "alarmIds is : %s" % alarmIds)

    enclosure = FuncFactory.getFruInfo(context, restData.Enum.ObjEnum.ENCLOSURE, encId)
    if not enclosure:
        BaseFactory.result.setResultPass(context)
        return
    sn = restUtil.Tlv2Rest.getRecordValue(enclosure, restData.Hardware.Enclosure.SERIAL_NUM)
    alarms = getCurrentSystemAlarms(context, alarmIds=alarmIds, alarmsParms=sn)
    BaseFactory.log.info(context, "alarms is : %s" % str(alarms))
    if alarms:
        BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.SYS_EXIST_TMPRETURE_ALMS)
        return

    BaseFactory.result.setResultPass(context)
    return
