# -*- coding: UTF-8 -*-
import math


def calculate_expansion_dict_4_ctrl(ctrl_num, max_ctrl_num):
    ret = {}
    ctrl_num = int(ctrl_num)
    if ctrl_num == 2:
        ret["none"] = {
            "supports_expansion_ctrls": [4],
            "scale_out_card_num": 1
        }
        ret["direct"] = {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 1
        }
    if ctrl_num == 4:
        ret["direct"] = {
            "supports_expansion_ctrls": [8],
            "scale_out_card_num": 1
        }
    ret["switch"] = {
        "supports_expansion_ctrls": [
            i for i in range(
                int(math.ceil((ctrl_num + 4) / 4.0) * 4),
                max_ctrl_num + 4,
                4)],
        "scale_out_card_num": 1}
    return ret


def calculate_expansion_dict_2_ctrl(ctrl_num, max_ctrl_num):
    ret = {}
    ctrl_num = int(ctrl_num)
    if ctrl_num == 2:
        ret["direct"] = {
            "supports_expansion_ctrls": [4],
            "scale_out_card_num": 1
        }
    ret["switch"] = {
        "supports_expansion_ctrls": [
            i for i in range(
                int(math.ceil((ctrl_num + 2) / 2.0) * 2),
                max_ctrl_num + 2,
                2)],
        "scale_out_card_num": 1}
    return ret


def trans_expansion_dict_for_eval(expansion_spec):
    """
    扩容评估不支持
    :param expansion_spec:
    :return:
    """
    eval_spec = []
    for net_type, spec in expansion_spec.items():
        eval_spec.extend(spec.get("supports_expansion_ctrls"))
    eval_spec = [str(item) for item in sorted(set(eval_spec))]
    return True, ",".join(eval_spec), ""
