# coding:utf-8
import platform
import subprocess
import traceback


def clean_permission_on(file_path, log):
    if platform.system() != "Windows":
        log.info("not windows, don't need clean permission")
    else:
        clean_permission_on_windows(file_path, log)


def clean_permission_on_windows(file_path, log):
    # 去掉权限
    try:
        subprocess.check_call('icacls "' + file_path + '" /inheritance:d')
        subprocess.check_call('icacls "' + file_path + '" /remove:g Users')
    except subprocess.CalledProcessError as e:
        log.error("clean permission on windows error: {}".format(str(traceback.format_exc())))
    except Exception as e:
        log.error("check call fail:{}".format(str(traceback.format_exc())))
