# -*- coding: UTF-8 -*-

""" 查询结果处理器"""

from cbb.frame.tlv import tlvUtil


class ResourceAdapter():
    def __init__(self):
        pass

    def tlv2Rest(self, datas, dataBean):
        """
        tlv命令查询结果转化为rest接口返回值格式
        :param datas: 执行TLV命令的返回值
        :param dataBean: TLV命令的格式
        :return: 转换为rest命令的返回值结果
        """
        restDatas = []
        for data in datas:
            restData = dict()
            for sector, value in dataBean.items():
                restData[sector] = tlvUtil.getRecordValue(data, value)
            restDatas.append(restData)
        return restDatas
