# -*- coding: UTF-8 -*-
from expparser import (
    Literal,
    CharsNotIn,
    Suppress,
    Combine,
    OneOrMore
)
from cbb.frame.dsl import adapter
from cbb.frame.dsl import offline_adapter
from cbb.frame.dsl.base_operator import BaseOperator


class ExecRestDsl(BaseOperator):
    """
    self.dsl("exec_rest '/host'", param_obj={"method": "get"})
    """

    def __init__(self, dsl_context):
        BaseOperator.__init__(self, dsl_context)
        self.context = dsl_context.context
        self.dsl_context = dsl_context

    def get(self):
        key = Literal("exec_rest").setResultsName("type")
        a = CharsNotIn("'")
        b = Suppress("'")
        uri_section = Combine(b + OneOrMore(a) + b).setResultsName("uri")

        pattern = key + uri_section
        pattern.setParseAction(self.base_action)
        return pattern

    def action(self, s, loc, toks):
        self.logger.info("enter {} action ".format(toks.type))
        param_obj = {"method": "get"}
        if "param_obj" in self.dsl_context.kwargs:
            param_obj.update(self.dsl_context.kwargs.get("param_obj"))
            self.logger.info(param_obj)
        if self.context.get("diagnoseType") == "offline":
            return offline_adapter.exec_rest(self.context, toks.uri,
                                             param_obj.get("method"))
        return adapter.exec_rest(self.context, toks.uri,
                                 param_obj.get("method"))
