# coding:utf-8
import restDataType

PUB_ATTR = {
    "type": {"index": 0, "type": restDataType.DATA_TYPE_ENUM},
    "id": {"index": 1, "type": restDataType.DATA_TYPE_STRING},
    "name": {"index": 2, "type": restDataType.DATA_TYPE_STRING},
    "parentType": {"index": 3, "type": restDataType.DATA_TYPE_ENUM},
    "parentID": {"index": 4, "type": restDataType.DATA_TYPE_STRING},
    "parentName": {"index": 5, "type": restDataType.DATA_TYPE_STRING},
    "location": {"index": 6, "type": restDataType.DATA_TYPE_STRING},
    "healthStatus": {"index": 7, "type": restDataType.DATA_TYPE_ENUM},
    "runningStatus": {"index": 8, "type": restDataType.DATA_TYPE_ENUM},
    "queryCondition": {"index": 15, "type": restDataType.DATA_TYPE_STRING},
}

DISK = {
    "disk_type": {"index": 64, "type": restDataType.DATA_TYPE_ENUM}  # 硬盘类型
}

ENCLOSURE_MODEL = {
    0: "CTRL_BMC",  # BMC控制框/
    1: "CTRL_SAS2U_12",  # 2U SAS 12盘主控框/
    2: "CTRL_SAS2U_24",  # 2U SAS 24盘主控框/
    16: "EXPSAS2U_12",  # 2U SAS 12盘级联框/
    17: "EXPSAS2U_24",  # 2U SAS 24盘级联框/
    18: "EXPSAS4U",  # 4U 6Gbit/s SAS 24盘位 3.5英寸 硬盘框/
    19: "EXPFC",  # 4U FC 24盘级联框/
    20: "DSW_PCIe1U",  # 1U PCIe数据交换机/
    21: "EXPSAS4U_75",  # 4U SAS 75盘级联框/
    22: "SVP",  # SVP/SVP Controller Enclosure
    97: "CTRL_6U",  # 6U 4控独立机头/
    96: "CTRL_3U",  # 3U 2控独立机头/
    24: "EXPSAS2U_25",  # 2U 6Gbit/s SAS 25盘位 2.5英寸 硬盘框/
    25: "EXPSAS4U_24_NEW",  # 4U SAS 24盘3.5寸磁盘框（新）/
    26: "CTRL_12GSAS_2U25_EAR",  # 2U 12GSAS 25盘主控框/
    23: "CTRL_12GSAS_2U12_EAR",  # 2U 12GSAS 12盘主控框/
    39: "EXP_12G_SAS_4U_75",  # EXP_12G_SAS_4U_75
    65: "SSD_12G_2U_25_DISKS_ENCLOSURE",  # 2U 12G SSD 25盘2.5寸级联框/
    66: "SSD_12G_4U_24_DISKS_ENCLOSURE",  # 4U 12G SSD 24盘2.5寸级联框/
    67: "EXP_SAS2U_25",  # 2U SAS 25盘位 2.5英寸 硬盘框/
    69: "EXP_SAS4U_24",  # 4U SAS 24盘位 3.5英寸 硬盘框/
    99: "CTRL_NVMe2U_24",  # 2U NVMe 2.5寸主控框/
    101: "EXP2U_JBOF",  # 2U JBOF硬盘框/
    112: "CTRL_4U_4C",  # 4U 四控 控制框/
    113: "CTRL_SAS2U_2C_25_MID",  # 中端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    114: "CTRL_SAS2U_2C_12_MID",  # 中端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    115: "CTRL_NVMe2U_2C_36",  # 2U 双控 NVMe 36盘位 控制框/
    116: "CTRL_SAS2U_2C_25_LOW",  # 低端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    117: "CTRL_SAS2U_2C_12_LOW",  # 低端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    118: "EXP_IPSAS_2U_25",  # 2U IP SAS 25盘位 2.5英寸 硬盘框/
    119: "EXP_IPSAS_2U_12",  # 2U IP SAS 12盘位 3.5英寸 硬盘框/
    120: "EXP_IPNVMe_2U_36",  # 2U IP NVMe 36盘位 硬盘框/
}

ENCLOSURE_HEIGHT = {
    0: 2,  # BMC控制框/
    1: 2,  # 2U SAS 12盘主控框/
    2: 2,  # 2U SAS 24盘主控框/
    16: 2,  # 2U SAS 12盘级联框/
    17: 2,  # 2U SAS 24盘级联框/
    18: 4,  # 4U 6Gbit/s SAS 24盘位 3.5英寸 硬盘框/
    19: 4,  # 4U FC 24盘级联框/
    20: 1,  # 1U PCIe数据交换机/
    21: 4,  # 4U SAS 75盘级联框/
    22: 2,  # SVP/SVP Controller Enclosure
    97: 6,  # 6U 4控独立机头/
    96: 3,  # 3U 2控独立机头/
    24: 2,  # 2U 6Gbit/s SAS 25盘位 2.5英寸 硬盘框/
    25: 4,  # 4U SAS 24盘3.5寸磁盘框（新）/
    26: 2,  # 2U 12GSAS 25盘主控框/
    23: 2,  # 2U 12GSAS 12盘主控框/
    39: 4,  # EXP_12G_SAS_4U_75
    65: 2,  # 2U 12G SSD 25盘2.5寸级联框/
    66: 4,  # 4U 12G SSD 24盘2.5寸级联框/
    67: 2,  # 2U SAS 25盘位 2.5英寸 硬盘框/
    69: 4,  # 4U SAS 24盘位 3.5英寸 硬盘框/
    99: 2,  # 2U NVMe 2.5寸主控框/
    101: 2,  # 2U JBOF硬盘框/
    112: 4,  # 4U 四控 控制框/
    113: 2,  # 中端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    114: 2,  # 中端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    115: 2,  # 2U 双控 NVMe 36盘位 控制框/
    116: 2,  # 低端 2U 双控 SAS 25盘位 2.5英寸 控制框/
    117: 2,  # 低端 2U 双控 SAS 12盘位 2.5英寸 控制框/
    118: 2,  # 2U IP SAS 25盘位 2.5英寸 硬盘框/
    119: 2,  # 2U IP SAS 12盘位 3.5英寸 硬盘框/
    120: 2 # 2U IP NVMe 36盘位 硬盘框/
}

ENCLOSURE_TYPE_E = {
    'EXP': 0,  # 级联框（硬盘框）
    'CTRL': 1,  # 控制框
    'DSW': 2,  # 数据交换机
    'MSW': 3,  # 管理交换机
    'SVP': 4  # 管理服务器
}

ENCLOSURE_TYPE = {
    0: "EXP",  # 级联框（硬盘框）/
    1: "CTRL",  # 控制框/
    2: "DSW",  # 数据交换机/
    3: "MSW",  # 管理交换机/
    4: "SVP"  # 管理服务器/
}

INTF_MODEL = {
    1: "FC_4X4G",  # 4x4G FC接口模块/4x4G FC Interface Module
    2: "FC_2X4G",  # 2x4G FC接口模块/2x4G FC Interface Module
    3: "GE_RJ45_2X",  # 2xGE 电接口模块/2xGE Electrical Interface Module
    4: "SASI_4X",  # 4xSAS I 接口模块/4xSAS I Interface Module
    5: "FC_4X4G_EXPAND",  # Swapped FC接口模块/Swapped FC Interface Module
    6: "ETH10G_2",  # 2x10GE 光接口模块/2x10GE Optical Interface Module
    7: "FC_1X8G",  # 1x8G FC光接口模块/1x8G FC Optical Interface Module
    8: "FC_2X8G""FC_2X8G",  # 2x8G FC光接口模块/2x8G FC Optical Interface Module
    9: "SASII_2X",  # 2xSAS II电接口模块/2xSAS II Electrical Interface Module
    10: "SASII_4X",  # 4xSAS II电接口模块/4xSAS II Electrical Interface Module
    11: "Combo_2FCx2GE",  # 2xFC+2xGE 接口模块/2xFC+2xGE Interface Module
    12: "iSCSI_4X",  # 4xGE 电接口模块/4xGE Electrical Interface Module
    13: "FC_4X8G",  # 4x8G FC光接口模块/4x8G FC Optical Interface Module
    16: "MINISAS_4X",  # 4xmini-SAS接口模块/4x mini-SAS Interface Module
    21: "FCoE_4X",  # 4x10G FCoE光接口模块/4x10G Optical Interface Module
    22: "SASA_2X6G",  # 2x6G SASA接口模块/2x6G SASA Interface Module
    23: "SASB_2X6G",  # 2x6G SASB接口模块/2x6G SASB Interface Module
    24: "ManagerBoard",  # 管理板/Management Board
    25: "TOE",  # 4x10GE接口模块/4x10GE Interface Module
    26: "PCIe_2X5G",  # 2x5Gbps PCIe接口模块/2x5Gbps PCIe Interface Module
    27: "FCoE_2X",  # 2x10G FCoE光接口模块/2x10G Optical Interface Module
    28: "iSCSI_4XGE",  # 4xGE Optical Interface Module/4xGE光接口模块
    29: "FC_2X16G",  # 2x16G FC Optical Interface Module    2x16G FC光接口模块
    30: "SAS_4X12G",  # 4x12SAS QSFP Interface Module    4x12G SAS光电接口模块
    31: "iSCSI_4X10",  # 4x10GE Electrical Interface Module    4x10GE 电接口模块
    32: "IB_2x40G",  # 2x40GE Infiniband Interface Module    2x40GE IB接口模块
    33: "IB_2x56G",  # 2x56GE Infiniband Interface Module    2x56GE IB接口模块
    34: "GE_RJ45_4X",  # 4xGE Electrical Interface Module    4xGE 电接口模块
    35: "AccerationEngineCard",  # Express Module（ACC，Acceration engine）    重删压缩加速卡
    36: "IOC_4X10G_RJ45",  # 4x10GE Electrical Interface Module    4x10GE 电接口模块
    37: "IOC_4XSMART",  # 4xSMART Optical Interface Module    4xSMART 光接口模块
    38: "IOC_8X8G_FC",  # 8x8G FC Optical Interface Module    8x8G FC光接口模块
    39: "IOC_4X8G_FC",  # 4x8G FC Optical Interface Module    4x8G FC光接口卡
    40: "IOC_4X16G_FC",  # 4x16G FC Optical Interface Module    4x16G FC光接口卡
    44: "PCIe_2X5G",
    41: "SAS_12PORT_BACKEND_MODULE",  # 12 port 4*12Gb SAS Back-End Interconnect I/O Module     12端口4*12Gb SAS后端全互联IO模块
    55: "PCIe_2PORT_BACK",  # 2 port PCIe Interface Module/2接口PCIe接口模块'
    58: "IOC_8X16G_FC",  # 8x16G FC Optical Interface Module    8x16G FC光接口卡
    65: "IOC_4X32G_X16_FC",  # 4 端口 SmartIO2.0 I/O模块（光口SFP+）X16
    66: "IOC_4X32G_X8_FC",  # 4 端口 SmartIO2.0 I/O模块（光口SFP+）X8
    67: "IOC_2X100G_X16_ETH",  # 2 端口 100Gb ETH I/O模块（QSFP28）X16
    68: "IOC_2X100G_X8_ETH",  # 2 端口 100Gb ETH I/O模块（QSFP28）X8
    71: "ETH_2X10G",  # 4端口 10Gb ETH I/O模块
    516: "ETH_4X1G",  # 4端口 FE 1Gb ETH I/O模块
    518: "SAS_4X12G",  # 4端口 BE 12G SAS I/O模块
    529: "AI_CARD",  # V6 AI单归属卡
    535: "AI_CARD",  # C+ AI单归属卡
    537: "ETH_4X1G",  # 4端口 FE 1Gb ETH I/O模块
    538: "SAS_4X12G",  # 4端口 BE 12Gb SAS I/O模块
    580: "ETH_4X1G",  # 4端口 FE 1Gb ETH I/O模块
    583: "SAS_V2_4X12G",  # 4端口 BE 12G SAS V2 I/O模块
    601: "ETH_4X1G",  # 4端口 FE 1Gb ETH I/O模块
    2304: "FC_4X8G",  # 4端口 FE 8Gb FC I/O模块
    2305: "FC_4X16G",  # 4端口 FE 16Gb FC I/O模块
    2306: "FC_4X32G",  # 4端口 FE 32Gb FC I/O模块
    2307: "ETH_4X10G",  # 4端口 FE 10Gb ETH I/O模块
    2308: "ETH_4X25G",  # 4端口 FE 25Gb ETH I/O模块
    2309: "RDMA_4X25G",  # 4端口 SO 25Gb RDMA I/O模块
    2310: "FC_4X8G",  # 4端口 FE 8Gb FC I/O模块
    2311: "FC_4X16G",  # 4端口 FE 16Gb FC I/O模块
    2312: "FC_4X32G",  # 4端口 FE 32Gb FC I/O模块
    2313: "ETH_4X10G",  # 4端口 FE 10Gb ETH I/O模块
    2314: "ETH_4X25G",  # 4端口 FE 25Gb ETH I/O模块
    2315: "ETH_2X40G",  # 2端口 FE 40Gb ETH I/O模块
    2316: "ETH_2X100G",  # 2端口 FE 100Gb ETH I/O模块
    2317: "RDMA_BE_2X100G",  # 2端口 BE 100Gb RDMA I/O模块
    2318: "RDMA_SO_2X100G",  # 2端口 SO 100Gb RDMA I/O模块
    2319: "ETH_2X40G",  # 2端口 FE 40Gb ETH I/O模块
    2320: "ETH_2X100G",  # 2端口 FE 100Gb ETH I/O模块
    2321: "RDMA_BE_2X100G",  # 2端口 BE 100Gb RDMA I/O模块
    2322: "RDMA_SO_2X100G",  # 2端口 SO 100Gb RDMA I/O模块
    # 为了减少xml的配置，下方ROCE只分为两类，即4端口和2端口情况
    2323: "ROCE_FE_4PORT",  # 4端口 FE 10Gb ROCE I/O模块
    2324: "ROCE_FE_4PORT",  # 4端口 FE 25Gb ROCE I/O模块
    2325: "ROCE_FE_4PORT",  # 4端口 FE 10Gb ROCE I/O模块
    2326: "ROCE_FE_4PORT",  # 4端口 FE 25Gb ROCE I/O模块
    2327: "ROCE_FE_2PORT",  # 2端口 FE 40Gb ROCE I/O模块
    2328: "ROCE_FE_2PORT",  # 2端口 FE 100Gb ROCE I/O模块
    2329: "ROCE_FE_2PORT",  # 2端口 FE 40Gb ROCE I/O模块
    2330: "ROCE_FE_2PORT",  # 2端口 FE 100Gb ROCE I/O模块
    2331: "ETH_4X10G",  # 4端口 FE 10Gb ETH I/O模块
    2332: "ETH_4X10G",  # 4端口 FE 10Gb ETH I/O模块
    2333: "FC_4X8G",  # 4端口 FE 8Gb FC I/O模块
    2334: "FC_4X16G",  # 4端口 FE 16Gb FC I/O模块
    2335: "FC_4X32G",  # 4端口 FE 32Gb FC I/O模块
    2336: "ETH_4X10G",  # 4端口 FE 10Gb ETH I/O模块
    2337: "ETH_4X25G",  # 4端口 FE 25Gb ETH I/O模块
    2338: "RDMA_4X25G",  # 4端口 SO 25Gb RDMA I/O模块
    2339: "ROCE_FE_4PORT",  # 4端口 FE 10Gb ROCE I/O模块
    2340: "ROCE_FE_4PORT",  # 4端口 FE 25Gb ROCE I/O模块
    2341: "FC_4X8G",  # 4端口 FE 8Gb FC I/O模块
    2342: "FC_4X16G",  # 4端口 FE 16Gb FC I/O模块
    2343: "FC_4X32G",  # 4端口 FE 32Gb FC I/O模块
    2344: "ETH_4X10G",  # 4端口 FE 10Gb ETH I/O模块
    2345: "ETH_4X25G",  # 4端口 FE 25Gb ETH I/O模块
    2346: "ROCE_FE_4PORT",  # 4端口 FE 10Gb ROCE I/O模块
    2347: "ROCE_FE_4PORT",  # 4端口 FE 25Gb ROCE I/O模块
    2348: "ETH_2X40G",  # 2端口 FE 40Gb ETH I/O模块
    2349: "ETH_2X100G",  # 2端口 FE 100Gb ETH I/O模块
    2350: "RDMA_BE_2X100G",  # 2端口 BE 100Gb RDMA I/O模块
    2351: "RDMA_SO_2X100G",  # 2端口 SO 100Gb RDMA I/O模块
    2352: "ROCE_FE_2PORT",  # 2端口 FE 40Gb ROCE I/O模块
    2353: "ROCE_FE_2PORT",  # 2端口 FE 100Gb ROCE I/O模块
    2354: "ETH_2X40G",  # 2端口 FE 40Gb ETH I/O模块
    2355: "ETH_2X100G",  # 2端口 FE 100Gb ETH I/O模块
    2356: "RDMA_BE_2X100G",  # 2端口 BE 100Gb RDMA I/O模块
    2357: "RDMA_SO_2X100G",  # 2端口 SO 100Gb RDMA I/O模块
    2358: "ROCE_FE_2PORT",  # 2端口 FE 40Gb ROCE I/O模块
    2359: "ROCE_FE_2PORT",  # 2端口 FE 100Gb ROCE I/O模块
    2360: "ETH_4X10G",  # 4端口 FE 10Gb ETH I/O模块
    2361: "RDMA_4X25G",  # C+ 4端口 SmartIO2.0
    2362: "RDMA_SO_2X100G",  # C+ 2端口 100G/40G RDMA卡
    2363: "RDMA_SO_2X100G",  # C+ 2端口 100G/40G RDMA卡 高端共享
    2364: "ETH_FE_4X10G",  # C+ 4端口 FE 10Gb ETH 前端SmartIO容器卡 C+
    2365: "ETH_FE_4X25G",  # C+ 4端口 FE 25Gb ETH 前端SmartIO容器卡 C+
    2366: "ETH_FE_4X10G",  # C+ 4端口 FE 10Gb ETH SmartIO电口容器卡 C+
    2367: "ROCE_FE_4X25G",  # C+ 4端口 FE 25Gb ROCE模式 SmartIO容器后端卡 C+
    2368: "FC_4X8G",  # C+ 4端口 FE 8Gb FC 前端SmartIO容器卡 C+
    2369: "FC_4X16G",  # C+ 4端口 FE 16Gb FC 前端SmartIO容器卡 C+
    2370: "FC_4X32G",  # C+ 4端口 FE 32Gb FC 前端SmartIO容器卡 C+
    4133: "ManagerBoard",  # 管理模块
    4134: "ManagerBoard",  # 管理模块
    2371: "CONTAINER_CARD",  # 4端口 FE 10Gb ETH 前端容器卡
    2372: "CONTAINER_CARD",  # 4端口 FE 25Gb ETH 前端容器卡
    2373: "CONTAINER_CARD",  # 4端口 FE 25Gb ROCE模式 后端容器卡
    2375: "FC_4X8G",  # 4port FE 8Gb FC I/O模块
    2376: "FC_FE_4X16G",  # 4port FE 16Gb FC I/O模块
    2377: "FC_FE_4X32G",  # 4port FE 32Gb FC I/O模块
    2378: "ETH_FE_4X10G",  # 4port FE 10Gb ETH I/O模块
    2379: "ETH_FE_4X25G",  # 4port FE 25Gb ETH I/O模块
    2380: "ROCE_FE_4X10G",  # 4port FE 10Gb ROCE I/O模块
    2381: "ROCE_FA_4X25G",  # 4port FA 25Gb ROCE I/O模块
    2382: "ETH_FE_2X40G",  # 2port FE 40Gb ETH I/O模块
    2383: "ETH_FE_2X100G",  # 2port FE 100Gb ETH I/O模块
    2384: "RDMA_BE_2X100G",  # 2port BE 100Gb RDMA I/O模块
    2385: "RDMA_SO_2X100G",  # 2port SO 100Gb RDMA I/O模块
    2386: "ROCE_FE_2X40G",  # 2port FE 40Gb ROCE I/O模块
    2387: "ROCE_FE_2X100G",  # 2port FE 100Gb ROCE I/O模块
    2388: "ROCE_FA_2X100G",  # 2port FA 100Gb ROCE I/O模块
    2389: "SAS_BE_4X12G",  # 4port BE 12Gb SAS I/O模块
    2390: "ETH_FE_4X1G",  # 4port FE 1Gb ETH I/O模块
    2391: "ETH_FE_2X1G",  # 2port FE 1Gb ETH I/O模块
    2392: "RDMA_SO_4X25G",  # 4port SO 25Gb RDMA I/O模块
    2393: "ROCE_FE_4X25G",  # 4port FE 25Gb ROCE I/O模块
    2394: "FC_4X8G",  # 4port FE 8Gb FC I/O模块
    2395: "FC_4X16G",  # 4port FE 16Gb FC I/O模块
    2396: "FC_4X32G",  # 4port FE 32Gb FC I/O模块
    2397: "ETH_FE_4X10G",  # 4port FE 10Gb ETH I/O模块
    2398: "ETH_FE_4X25G",  # 4port FE 25Gb ETH I/O模块
    2399: "RDMA_SO_4X25G",  # 4port SO 25Gb RDMA I/O模块
    2400: "ROCE_FE_4X10G",  # 4port FE 10Gb ROCE I/O模块
    2401: "ROCE_FE_4X25G",  # 4port FE 25Gb ROCE I/O模块
    2402: "ETH_FE_2X40G",  # 2port FE 40Gb ETH I/O模块
    2403: "ETH_FE_2X100G",  # 2port FE 100Gb ETH I/O模块
    2404: "RDMA_BE_2X100G",  # 2port BE 100Gb RDMA I/O模块
    2405: "RDMA_SO_2X100G",  # 2port SO 100Gb RDMA I/O模块
    2406: "ROCE_FE_2X40G",  # 2port FE 40Gb ROCE I/O模块
    2407: "ROCE_FE_2X100G",  # 2port FE 100Gb ROCE I/O模块
    2408: "CONTAINER_CARD",  # 4port FE 10Gb ETH I/O模块
    2409: "CONTAINER_CARD",  # 4port FE 25Gb ETH I/O模块
    2410: "CONTAINER_CARD",  # 4port FE 25Gb ROCE I/O模块
    2411: "CONTAINER_CARD",  # 4port FE 10Gb ETH I/O模块
    2412: "CONTAINER_CARD",  # 4port FE 10Gb ETH I/O模块
    2413: "CONTAINER_CARD",  # 4port FE 25Gb ETH I/O模块
    2414: "CONTAINER_CARD",  # 4port FE 25Gb ROCE I/O模块
    2415: "ETH_FE_4x10G",  # 4port FE 10Gb ETH I/O模块
    2416: "ETH_FE_4x10G",  # 4port FE 10Gb ETH I/O模块
    2417: "ETH_FE_4X1G",  # 4port FE 1Gb ETH I/O模块
    2419: "ETH_FE_4X10G",  # 4port FE 10Gb ETH I/O模块
    2421: "ETH_FE_4X10G",  # 4port FE 10Gb ETH I/O模块
    2420: "ETH_FE_4X25G",  # 4port FE 25Gb ETH I/O模块
    2422: "ETH_FE_4X25G",  # 4port FE 25Gb ETH I/O模块
    2423: "HYPERDETECT_CARD",  # OceanCyber 100 data security card||OceanCyber 100 数据安全卡,
    2424: "HYPERDETECT_CARD",  # OceanCyber 100 data security card||OceanCyber 100 数据安全卡,
    2425: "HYPERDETECT_CARD",  # HyperDetect ransomware detection module||HyperDetect 勒索软件检测模块
    2426: "HYPERDETECT_CARD",  # HyperDetect ransomware detection module||HyperDetect 勒索软件检测模块
    2427: "ETH_FE_4X10G",  # 4port FE 10Gb ETH I/O模块
    2428: "ETH_FE_4X25G",  # 4port FE 25Gb ETH I/O模块
    2429: "ETH_FE_2X40G",  # 2port FE 40Gb ETH I/O模块
    2430: "ETH_FE_2X100G",  # 2port FE 100Gb ETH I/O模块
    2431: "ETH_FE_2X200G",  # 2port FE 200Gb ETH I/O模块
    2432: "ETH_FE_4X10G",  # 4port FE 10Gb ETH I/O模块
    2433: "ETH_FE_4X25G",  # 4port FE 25Gb ETH I/O模块
    2434: "ETH_FE_2X40G",  # 2port FE 40Gb ETH I/O模块
    2435: "ETH_FE_2X100G",  # 2port FE 100Gb ETH I/O模块
    2436: "ETH_FE_2X200G",  # 2port FE 200Gb ETH I/O模块
    2437: "FC_4X64G",  # 4port FE 64Gb FC I/O模块
    2438: "FC_4X64G",  # 4port FE 64Gb FC I/O模块
    2439: "ETH_FE_2X200G",  # 2port FE 200Gb ETH I/O模块
    2440: "ETH_FE_2X200G",  # 2port FE 200Gb ETH I/O模块
    2441: "ROCE_FE_2X200G",  # 2port FE 200Gb ROCE I/O模块
    2442: "ROCE_FE_2X200G",  # 2port FE 200Gb ROCE I/O模块
    2443: "NOF_FE_2X200G",  # 2port FE 200Gb NoF I/O模块
    2444: "RDMA_SO_2X200G",  # 2port SO 200Gb RDMA I/O模块
    2445: "RDMA_SO_2X200G",  # 2port SO 200Gb RDMA I/O模块
    2446: "ETH_FE_2X40G",  # 2port FE 40Gb ETH I/O模块
    2447: "ETH_FE_2X40G",  # 2port FE 40Gb ETH I/O模块
    2448: "ROCE_FE_2X40G",  # 2port FE 40Gb ROCE I/O模块
    2449: "ROCE_FE_2X40G",  # 2port FE 40Gb ROCE I/O模块
    2450: "ETH_FE_2X100G",  # 2port FE 100Gb ETH I/O模块
    2451: "ETH_FE_2X100G",  # 2port FE 100Gb ETH I/O模块
    2452: "ROCE_FE_2X100G",  # 2port FE 100Gb ROCE I/O模块
    2453: "ROCE_FE_2X100G",  # 2port FE 100Gb ROCE I/O模块
    2454: "NOF_FE_2X100G",  # 2port FE 100Gb NoF I/O模块
    2455: "RDMA_BE_2X100G",  # 2port BE 100Gb RDMA I/O模块
    2456: "RDMA_BE_2X100G",  # 2port BE 100Gb RDMA I/O模块
    2457: "RDMA_SO_2X100G",  # 2port SO 100Gb RDMA I/O模块
    2458: "RDMA_SO_2X100G",  # 2port SO 100Gb RDMA I/O模块
    2459: "ROCE_FE_2X100G",  # 2port FE 100Gb ROCE I/O模块
    2460: "ROCE_FE_2X100G",  # 2port FE 100Gb ROCE I/O模块
    2461: "ROCE_FE_2X200G",  # 2port FE 200Gb ROCE I/O模块
    2462: "ROCE_FE_2X200G",  # 2port FE 200Gb ROCE I/O模块
}

ENCLOSURE = {
    "name": {"index": 2, "type": restDataType.DATA_TYPE_STRING},
    "model": {"index": 64, "type": restDataType.DATA_TYPE_ENUM},
    "logicType": {"index": 65, "type": restDataType.DATA_TYPE_ENUM},
    "serialNum": {"index": 68, "type": restDataType.DATA_TYPE_STRING},
    "height": {"index": 70, "type": restDataType.DATA_TYPE_SIGN_INT},
    "expanderDepth": {"index": 71, "type": restDataType.DATA_TYPE_SIGN_INT},
    "expanderPort": {"index": 72, "type": restDataType.DATA_TYPE_STRING},
    "switch": {"index": 73, "type": restDataType.DATA_TYPE_ENUM},
}

SAS_PORT = {
    "logicType": {"index": 64, "type": restDataType.DATA_TYPE_ENUM},
    "runSpeed": {"index": 65, "type": restDataType.DATA_TYPE_UNSIGN_INT},
    "current_peer_port_id": {"index": 75, "type": restDataType.DATA_TYPE_STRING},
    "suggest_peer_port_id": {"index": 76, "type": restDataType.DATA_TYPE_STRING},
    "lightStatus": {"index": 77, "type": restDataType.DATA_TYPE_ENUM},
}

PCIE_PORT = {
    "pcieSpeed": {"index": 64, "type": restDataType.DATA_TYPE_UNSIGN_INT},
    "current_peer_port_id": {"index": 65, "type": restDataType.DATA_TYPE_STRING},
    "suggest_peer_port_id": {"index": 66, "type": restDataType.DATA_TYPE_STRING},
    "lightStatus": {"index": 69, "type": restDataType.DATA_TYPE_ENUM},
}

EXPBOARD_TYPE = {
    0: "SAS",
    1: "FC",
    5: "PCIe",
    6: "Smart_SAS",
    7: "Smart_NVMe",
}

INTF_MODULE = {
    'model': {'index': 64, 'type': restDataType.DATA_TYPE_ENUM},
    'lightStatus': {'index': 69, 'type': restDataType.DATA_TYPE_ENUM},
    'runMode': {'index': 71, 'type': restDataType.DATA_TYPE_ENUM},
}


EXPBOARD = {
    "model": {"index": 64, "type": restDataType.DATA_TYPE_ENUM},  # 型号, enum
    "logicVer": {"index": 65, "type": restDataType.DATA_TYPE_STRING},  # 逻辑版本, string
    "pcbVer": {"index": 66, "type": restDataType.DATA_TYPE_STRING},  # PCB版本, string
    "sesVer": {"index": 67, "type": restDataType.DATA_TYPE_STRING},  # SES版本, string
    "elabel": {"index": 68, "type": restDataType.DATA_TYPE_STRING},  # 电子标签, string
    "lightStatus": {"index": 70, "type": restDataType.DATA_TYPE_ENUM},  # 定位灯, enum
}

# 硬盘枚举值字典
DISK_TYPE_E_DICT = {
    "0": u"FC",
    "1": u"SAS",
    "2": u"SATA",
    "3": u"SSD",
    "4": u"NL_SAS",
    "5": u"SLC SSD",
    "6": u"MLC SSD",
    "7": u"FC_SED",
    "8": u"SAS_SED",
    "9": u"SATA_SED",
    "10": u"SSD_SED",
    "11": u"NL_SAS_SED",
    "12": u"SLC_SSD_SED",
    "13": u"MLC_SSD_SED",
    "14": u"NVMe_SSD",
    "15": u"SMR_SATA",
    "16": u"NVMe-SSD加密盘",
    "17": u"SCM",
    "18": u"SCM_SED",
    "19": u"Capacity-Optimized SSD",
    "20": u"Capacity-Optimized SSD_SED",
    "21": u"Capacity-Optimized SSD",
    "22": u"Capacity-Optimized SSD_SED",
}


class DiskType():
    FC = "FC"
    FC_SED = "FC SED"
    SAS = "SAS"
    SSD = "SSD"
    SATA = "SATA"
    SSD_SED = "SSD SED"
    NVMe_SSD = "NVMe SSD"
    NVMe_SSD_SED = "NVMe SSD SED"
    NearLine_SAS = "NearLine SAS"
    SAS_SED = "SAS SED"
    NearLine_SAS_SED = "NearLine SAS SED"
    SATA_SED = "SATA SED"
    SCM = "SCM"
    SCM_SED = "SCM SED"
    Capacity_optimized_SSD = "Capacity-Optimized SSD"
    Capacity_optimized_SSD_SED = "Capacity-Optimized SSD SED"


# 硬盘枚举值映射
DISK_TYPE_MAP = {
    "0": DiskType.FC,
    "1": DiskType.SAS,
    "2": DiskType.SATA,
    "3": DiskType.SSD,
    "4": DiskType.NearLine_SAS,
    "5": DiskType.SSD,     # SLC SSD
    "6": DiskType.SSD,     # MLC SSD
    "7": DiskType.FC_SED,
    "8": DiskType.SAS_SED,
    "9": DiskType.SATA_SED,
    "10": DiskType.SSD_SED,
    "11": DiskType.NearLine_SAS_SED,
    "12": DiskType.SSD_SED,      # SLC_SSD_SED
    "13": DiskType.SSD_SED,      # MLC_SSD_SED
    "14": DiskType.NVMe_SSD,
    "15": DiskType.SATA,       # SMR_SATA
    "16": DiskType.NVMe_SSD_SED,      # "NVMe-SSD加密盘"
    "17": DiskType.SCM,  # key=SCM
    "18": DiskType.SCM_SED,
    "19": DiskType.Capacity_optimized_SSD,
    "20": DiskType.Capacity_optimized_SSD_SED,
    "21": DiskType.Capacity_optimized_SSD,
    "22": DiskType.Capacity_optimized_SSD_SED
}


class OperateLogObj:
    POWER = 0
    ENCLOSURE = 1
    BBU = 2
    CONTROLLER = 3
    EXPBOARD = 4
    INTF_MODEL = 5
    FAN_CTRL_MODEL = 6
