# coding:utf-8
import decimal
import os
import re

import logger
import resource
from cbb.frame.cli import cliUtil

FILE_SUFFIX = "."

# basePath到tools/xx/这层目录
basePath = os.path.abspath(".")

# 工具配置xml路径文件。
tool_rule_config_path_dict = {
    "inspect": basePath + "\\packages\\inspector\\products\\pyframe\\check_item_rule.xml",
}


def getMsg(lang, msg, args=""):
    """消息国际化

    :param lang: 语言lang
    :param msg: 消息
    :param args: 消息参数
    :return: 经过国际化处理后的消息
    """
    return cliUtil.getMsg(lang, msg, args, resource.MESSAGES_DICT)


def getSoftwarePatchVersion(cli, LANG):
    """获取当前设备补丁版本

    :param cli: cli对象
    :param LANG: 语言
    :return:
    """
    productVersion = ''
    hotPatchVersion = ''
    ((echoStatus, cliRet, errMsg), softwareVersionList, hotPatchVersionList) = parse_upgradePackage(cli, LANG)
    if not echoStatus:
        return False, "", errMsg

    for upgradeInfoMap in hotPatchVersionList:
        currentVersion = upgradeInfoMap.get("Current Version", "")
        if currentVersion:
            hotPatchVersion = currentVersion

    for upgradeInfoMap in softwareVersionList:
        currentVersion = upgradeInfoMap.get("Current Version", "")
        if currentVersion:
            productVersion = currentVersion

    if productVersion and hotPatchVersion:
        return True, productVersion, hotPatchVersion, ''

    return False, "", getMsg(LANG, "cannot.get.upgrade.package.info")


def parse_upgradePackage(cli, lang):
    """执行show upgrade packge命令，将Software Version与HotPatch Version的回显存放到同一个字典列表中，并增加Version Type键来区
    分Version类型,并返回CLI回显

    :param cli: cli对象
    :param lang: 语言
    :return:
    """
    cmd = "show upgrade package"
    softwareVersionList = []
    hotPatchVersionList = []

    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, cliRet, errMsg), softwareVersionList, hotPatchVersionList

    softwareVersionIndex = cliRet.find("Software Version")
    hotPatchVersionIndex = cliRet.find("HotPatch Version")
    softwareVersionList = cliUtil.getHorizontalCliRet(cliRet[softwareVersionIndex:hotPatchVersionIndex])
    hotPatchVersionList = cliUtil.getHorizontalCliRet(cliRet[hotPatchVersionIndex:])

    return (flag, cliRet, errMsg), softwareVersionList, hotPatchVersionList


def check_ver_hot_his_version(cli, lang):
    """
    获取软件版本，补丁版本及历史版本
    :param cli:
    :param lang:
    :return:
    """
    software_ver = ""
    hot_patch = ""
    history_version = ""
    # 获取设备当前产品版本
    check_ret, software_ver_list, hot_version_list = parse_upgradePackage(
        cli, lang)
    if check_ret[0] is not True:
        return check_ret, software_ver, hot_patch, history_version

    # 获取当前系统版本
    ret_flag, software_ver, err_msg = get_version(
        software_ver_list, lang, "Current Version")
    if ret_flag is not True:
        return (ret_flag, check_ret[1],
                check_ret[2]), software_ver, hot_patch, history_version
    # 获取历史版本
    ret_flag, history_version, err_msg = get_history_version(
        software_ver_list, "History Version")
    if ret_flag is not True:
        return (ret_flag, check_ret[1],
                check_ret[2]), software_ver, hot_patch, history_version

    # 获取补丁版本
    ret_flag, hot_patch, err_msg = get_version(
        hot_version_list, lang, "Current Version")
    if ret_flag is not True:
        return (ret_flag, check_ret[1],
                check_ret[2]), software_ver, hot_patch, history_version
    return check_ret, software_ver, hot_patch, history_version


def get_ver_hot_his_version(cli, lang):
    """
    获取软件版本及历史版本，补丁版本及补丁历史版本
    :param cli:
    :param lang:
    :return:
    """
    software_ver = ""
    hot_patch = ""
    history_version = ""
    hot_patch_his = ""
    # 获取设备当前产品版本
    check_ret, software_ver_list, hot_version_list = parse_upgradePackage(
        cli, lang
    )
    if check_ret[0] is not True:
        return (
            check_ret,
            software_ver,
            hot_patch,
            history_version,
            hot_patch_his,
        )

    # 获取当前系统版本
    ret_flag, software_ver, err_msg = get_version(
        software_ver_list, lang, "Current Version"
    )
    if ret_flag is not True:
        return (
            (ret_flag, check_ret[1], check_ret[2]),
            software_ver,
            hot_patch,
            history_version,
            hot_patch_his,
        )
    # 获取历史版本
    ret_flag, history_version, err_msg = get_history_version(
        software_ver_list, "History Version"
    )
    if ret_flag is not True:
        return (
            (ret_flag, check_ret[1], check_ret[2]),
            software_ver,
            hot_patch,
            history_version,
            hot_patch_his,
        )

    # 获取补丁版本
    ret_flag, hot_patch, err_msg = get_version(
        hot_version_list, lang, "Current Version"
    )
    if ret_flag is not True:
        return (
            (ret_flag, check_ret[1], check_ret[2]),
            software_ver,
            hot_patch,
            history_version,
            hot_patch_his,
        )

    # 获取补丁历史版本
    ret_flag, hot_patch_his, err_msg = get_history_version(
        hot_version_list, "History Version"
    )
    if ret_flag is not True:
        return (
            (ret_flag, check_ret[1], check_ret[2]),
            software_ver,
            hot_patch,
            history_version,
            hot_patch_his,
        )

    return check_ret, software_ver, hot_patch, history_version, hot_patch_his


def get_version(version_list, lang, version_str):
    """
    从版本list中获取对应版本
    :param version_list: 版本list
    :param lang: 中英文
    :param version_str: 需要获取的key
    :return:
    """
    for controller in version_list:
        version = controller.get(version_str, "")
        return True, version, ""
    return False, "",  getMsg(lang, "cannot.get.product.version.info")


def get_history_version(version_list, version_str):
    """
    从版本list中获取对应版本
    :param version_list: 版本list
    :param lang: 中英文
    :param version_str: 需要获取的key
    :return:
    """
    for controller in version_list:
        version = controller.get(version_str, "")
        if version != "--":
            return True, version, ""
    return True, False, ""


def joinLines(originLines, postLines):
    """将postLines追加originLines后。

    :param originLines: 当前行
    :param postLines: 新增行
    :return:
    """
    if not (originLines or postLines):
        return ""

    if not originLines:
        return postLines

    if not postLines:
        return originLines

    return "\n".join([originLines, postLines])


def paseResult(noRecordsExitCheckResult):
    """对True和False做转换。

    :param noRecordsExitCheckResult: 检查结果
    :return:
    """
    if noRecordsExitCheckResult:
        if noRecordsExitCheckResult == 'True':
            noRecordsExitCheckResult = True
        elif noRecordsExitCheckResult == 'False':
            noRecordsExitCheckResult = False

    return noRecordsExitCheckResult


def getBaseName(file_path):
    """返回文件路径的文件名，不包含后缀

    :param file_path: 文件路径
    :return: 返回不包含后缀的文件名字符串
    """
    file_name = os.path.basename(file_path)
    if FILE_SUFFIX in file_name:
        dot_index = file_name.rindex(FILE_SUFFIX)
        return file_name[0:dot_index]
    else:
        return file_name


def getLogger(loggerInstance, pyFilePath):
    """获取日志类

    :param loggerInstance: logger实例
    :param pyFilePath: py文件路径
    :return:
    """
    pyFileName = getBaseName(pyFilePath)
    return logger.Logger(loggerInstance, pyFileName)


def getRuleXmlABSPath(toolName):
    return tool_rule_config_path_dict.get(toolName)


def changUnit2GBDecimal(strValue):
    """根据传入的值转换单位为GB

    :param strValue: 值字符串
    :return:
    """
    floatValue = decimal.Decimal("0.0")
    unitValue = decimal.Decimal("1024")
    # noinspection PyBroadException
    try:
        if not strValue:
            return False, floatValue

        if re.search("PB", strValue):
            floatValue = decimal.Decimal(strValue.split('P')[0].strip()) * unitValue * unitValue
        elif re.search("TB", strValue):
            floatValue = decimal.Decimal(strValue.split('T')[0].strip()) * unitValue
        elif re.search("GB", strValue):
            floatValue = decimal.Decimal(strValue.split('G')[0].strip())
        elif re.search("MB", strValue):
            floatValue = decimal.Decimal(strValue.split('M')[0].strip()) / unitValue
        elif re.search("KB", strValue):
            floatValue = decimal.Decimal(strValue.split('K')[0].strip()) / unitValue / unitValue
        elif re.search("B", strValue):
            floatValue = decimal.Decimal(strValue.split('B')[0].strip()) / unitValue / unitValue / unitValue
        elif decimal.Decimal(strValue.strip()) == decimal.Decimal("0.0"):
            return True, floatValue
        else:
            return False, floatValue

        return True, floatValue

    except Exception:
        return False, floatValue
