# -*- coding: UTF-8 -*-

'''
Description: 通用类：Tlv参数定义类：从字符串到数字
Create Date: 2014-02-25
Relation Map: 对象与表单的对应关系如下：
    pubAttr: 对象公共属性
    cmd: 命令字定义
    Enum: 枚举定义
    SysMgmt: (公共)系统管理
    Upgrade: (公共)升级
    Hardware: (公共)硬件
    PoolLunMap: (阵列)Pool&LUN&映射
    ValueAdd: (阵列)增值
'''


class TlvEnum():
    ________TEST_ZONE________ = None

    ________FUNC_ZONE________ = None

    '''
    Description: 对象公共属性
    '''
    pubAttr = {"type": 0,  # 对象类型
               "id": 1,  # 对象ID
               "name": 2,  # 对象名称
               "parentType": 3,  # 父对象类型
               "parentID": 4,  # 父对象ID
               "parentName": 5,  # 父对象名称
               "location": 6,  # 位置信息
               "healthStatus": 7,  # 健康状态
               "runningStatus": 8,  # 运行状态
               "description": 9,  # 描述信息
               "count": 10,  # 对象统计数量，对单个对象无效，仅用于查询对象的数量时返回
               "associateObjType": 11,  # 关联对象类型，对单个对象无效，仅用于查询此与关联对象有关系的对象
               "associateObjID": 12,  # 对单个对象无效，仅用于查询此与关联对象有关系的对象
               "associateMetadata": 13,
               # 对单个对象无效，仅用于表示两个对象之间存在关联关系后附加的数据，如LUN与Host建立关联后，附加了一个HostLunID，此时可以在这个字段里表示。此字段必须是一个JSON对象，对象的定义根据应用的场景不同而不同
               "application": 14,  # 为基于应用的管理提供的标识，由管理软件设置，设备存下来，后续管理软件可以据此确定存储资源与应用的绑定关系
               "queryCondition": 15,  # 用于批量查询对象时增加搜索及排序条件，命令下发时使用，格式为一个json对象
               "associateObjIDList": 16,  # 对单个对象无效，仅用于批量创建关联关系，如将多个硬盘一次性关联到Pool
               "tenancyId": 17,  # 租户ID
               "tenancyName": 18,  # 租户名称
               "importantPsw": 4093,  # 重要事务的鉴权密码
               }

    '''
    Description: 命令字定义
    '''
    cmd = {'CREATE': 55834591232,  # 创建对象
           'MODIFY': 55834583040,  # 修改对象
           'GET': 55834574848,  # 查询单个对象
           'GET_BATCH_NEXT': 55834624000,  # 批量查询对象
           'DELETE': 55834599424,  # 删除对象
           'COUNT': 55834632192,  # 查询对象的数量
           'ASSOCIATE': 55834615808,  # 关联查询对象
           'CREATE_ASSOCIATE': 55834595328,  # 建立关联
           'REMOVE_ASSOCIATE': 55834603520,  # 移除关联
           'START': 55834583049,  # 开始任务
           'STOP': 55834583050,  # 停止任务
           'PAUSE': 55834583051,  # 暂停任务
           'CONTINUE': 55834583052,  # 继续任务
           'GET_NEXT_AVAILABLE_ID': 55834583053,  # 查询下一个可用的ID号
           'CLI_CMD_START': 57176752129,  # CLI专用命令字起始位置
           'CLI_CMD_END': 57176752129,  # CLI专用命令字结束位置
           'SYNCHRONIZE_CONSISTENCY_GROUP': 55849058305,  # 同步一致性组
           'SWITCH_GROUP_ROLE': 55849058306,  # 一致性组主从切换
           'DO_SWITCHROLE_GROUP': 55849058307,  # 一致性组强制主从切换
           'ADD_MIRROR': 55849058308,  # 向一致性组添加远程复制
           'DEL_MIRROR': 55849058309,  # 删除一致性组中的远程复制
           'DO_DEL_MIRROR': 55849058310,  # 强制删除一致性组中的远程复制
           'SPLIT_CONSISTENCY_GROUP': 55849058311,  # 分裂一致性组
           'START_VERIFY': 55849058312,  # 接口中有该操作，但是目前代码中并不会用到，请东哥确认是否需要该命令字
           'INTF_MODULE_POWER_ON': 55848271873,  # 上电
           'INTF_MODULE_POWER_OFF': 55848271874,  # 下电
           'MODIYF_IOCLASS_SWITCH': 55849648129,  # 修改IO分类开关
           'CONNECT_ISCSI_TARGET': 55850500097,  # 连接iSCSI链路
           'DISCONNECT_ISCSI_TARGET': 55850500098,  # 断开iSCSI链路
           'CREATE_AND_CONNECT': 55850500099,  # 创建并连接iSCSI TGT
           'DISCONNECT_AND_DELETE': 55850500100,  # 断开并删除iSCSI TGT
           'GET_BATCH_NEXT_ISCSI_TGT': 55850500101,  # 查询所有iSCSI链路目标器详细信息
           'GET_ISCSI_TGT': 55850500102,  # 查询iSCSI链路目标器详细信息
           'MODIFY_ISCSI_TGT': 55850500103,  # 修改iSCSI链路目标器信息
           'ADD_FCLINK_TO_REMOTE_DEVICE': 55849320449,  # 将FC链路添加给远端设备
           'REMOVE_FCLINK_FROM_REMOTE_DEVICE': 55849320450,  # 从远端设备移除FC链路
           'STOP_HYPERCOPY': 55848927233,  # 停止LUN拷贝
           'PAUSE_HYPERCOPY': 55848927234,  # 暂停LUN拷贝
           'CONTINUE_HYPERCOPY': 55848927235,  # 继续LUN拷贝
           'MARK_HYPERCOPY': 55848927236,  # 给增量LUN拷贝打标签
           'ADD_TGT_LUN': 55848927237,  # 增加目标LUN
           'START_HYPERCOPY': 55848927238,  # 启动LUN拷贝
           'GET_LUNCOPY_MEMBERLUN': 55849451521,  # 查询LUN Copy 成员LUN信息
           'GET_BATCH_NEXT_LUNCOPY_MEMBERLUN': 55849451522,  # 批量查询LUN拷贝成员LUN信息(GETBATCH)
           'REMOVE_LUNCOPY_MEMBERLUN': 55849451523,  # 删除LUN Copy 成员LUN
           'GET_HYPERCOPY_MEMLUN_INFO': 55849451524,  # 查询成员LUN信息
           'GET_BATCH_NEXT_HYPERCOPY_MEMLUN_INFO': 55849451525,  # 批量查询LUN拷贝成员LUN信息(GETBATCH)
           'GET_BATCH_NEXT_AVAILABLE_LUNS': 55849451526,  # 批量查询LUNCopy候选成员LUN
           'GET_BATCH_NEXT_AVAILABLE_LUNS_BY_SOURCELUN': 55849451527,  # 批量查询LUNCopy候选成员LUN
           'GET_NEXT_FITTING_MIRROR': 55836409857,  # 查询符合条件加入一致性组的远程复制(NEXT)
           'SPLIT_HYPERMIRROR': 55849385985,  # 分裂
           'SYNCRONIZE_HYPERMIRROR': 55849385986,  # 同步
           'SWITCHROLE_HYPERMIRROR': 55849385987,  # 主从切换
           'DO_SWITCHROLE_HYPERMIRROR': 55849385988,  # 强制主从切换
           'MODIFY_REMOTE_REPLICATION_MEMBER_LUN': 55849385989,  # 修改远程复制成员LUN属性
           'GET_REMOTE_REPLICATION_MEMBER_LUN': 55849385990,  # 查询远程复制成员LUN的详细信息
           'GET_BATCH_NEXT_REMOTE_REPLICATION_MEMBER_LUN': 55849385991,  # 批量查询远程复制成员LUN的详细信息
           'GET_BATCH_NEXT_MIRROR_LUN_CANUSE': 55849385992,  # 查询可以用来创建远程复制LUN(NEXT)/查询可以用来加入一致性组的Pair
           'GET_BATCH_NEXT_MIRROR_LUN_DETAIL': 55849385993,  # 查询远程复制成员LUN的详细信息信息
           'ADD_SECONDARY_LUN': 55849385994,  # 增加远程复制从LUN
           'REMOVE_SENCONDARY_LUN': 55849385995,  # 删除远程复制从LUN
           'DO_REMOVE_SENCONDARY_LUN': 55849385996,  # 强制删除远程复制从LUN
           'START_VERIFY_SENCONDARY_LUN_CONF': 55849385997,  # 接口中有该操作，但是目前代码中并不会用到，请东哥确认是否需要该命令字
           'CREATE_HYPERIMAGE_COPY': 55836344321,  # 创建虚拟快照副本
           'ENABLE_HYPERIMAGE': 55836344322,  # 重建虚拟快照
           'DISABLE_HYPERIMAGE': 55836344323,  # 停用虚拟快照
           'ACTIVE_HYPERIMAGE': 55836344324,  # 激活虚拟快照
           'ROLLBACK_HYPERIMAGE': 55836344325,  # 回滚虚拟快照
           'CANCEL_ROLLBACK_HYPERIMAGE': 55836344326,  # 取消回滚虚拟快照
           'GET_GLOBLE_MIGRATE_LEVEL': 55848730625,  # 查询全局迁移速率
           'SET_GLOBLE_MIGRATE_LEVEL': 55848730626,  # 设置全局迁移速率
           'ADD_ALL_REMAIN_DISK_TO_POOL': 55848730627,  # 添加所有剩余磁盘到pool中
           'EXPAND_POOL': 55848730628,  # POOL扩展磁盘
           'MODIFY_MIGRATIONMODE': 55848730629,  # 修改迁移模式
           'MODIFY_MIGRATIONTIME': 55848730630,  # 修改迁移时刻表
           'OPEN_OR_CLOSE_MIGRATION': 55848730631,  # 开启或关闭立即迁移
           'PAUSE_OR_RESUME_MIGRATION': 55848730632,  # 暂停/恢复迁移
           'SHOW_POOL_ANALYSIS_DEFAULT_PROPERTY': 55848730633,  # 显示Pool的预测分析默认属性
           'GET_INACTIVE_LICENSE_HEAD': 55850565633,  # 查询未激活License文件头信息
           'GET_LICENSE_HEAD': 55850565634,  # 查询已激活License文件头信息
           'GET_INACTIVE_LICENSE': 55850565635,  # 查询未激活License信息
           'GET_LICENSE': 55850565636,  # 查询已激活License信息
           'GET_LICENSE_FUNC': 55850565637,  # 批量查询License功能配置项
           'GET_INACTIVE_LICENSE_FUNC': 55850565638,  # 批量查询未激活License功能配置项
           'GET_LICENSE_RESOURCE': 55850565639,  # 批量查询License资源配置项
           'GET_INACTIVE_LICENSE_RESOURCE': 55850565640,  # 批量查询未激活License资源配置项
           'GET_LICENSE_INFO': 55850565641,  # 单个查询License使用情况
           'GETBATCH_LICENSE_INFO': 55850565642,  # 批量查询License使用情况
           'USER_IMPORT_LICENSE': 55850565643,  # 激活License
           'OM_MSG_OP_GET_LICENSE_PATH': 55850565644,  # 查询License导入路径
           'GET_LICENSE_EXPORT_PATH': 55850565645,  # 查询License导出路径
           'GET_BATCH_ROUTE': 55847747585,  # 查询端口的路由信息
           'ADD_ROUTE': 55847747586,  # 增加路由
           'REMOVE_ROUTE': 55847747587,  # 移除路由
           'SET_ISCSI_DEVICE_NAME': 55847747588,  # 设置iSCSI设备名称
           'GET_ISCSI_DEVICE_NAME': 55847747589,  # 查询iSCSI设备名称
           'GET_ISNS_SERVER': 55847747590,  # 查询iSNS服务
           'SET_ISNS_SERVER': 55847747591,  # 设置iSNS服务地址
           'CONFIG_POOL_ANALYSIS': 55847747592,  # 配置Pool的预测分析功能
           'SHOW_POOL_ANALYSIS_RESULT': 55847747593,  # 显示Pool的预测分析结果
           'SHOW_POOL_ANALYSIS_PROPERTY': 55847747594,  # 显示Pool的预测分析属性
           'GET_POOL_TASK': 55847747595,  # 查询指定POOL的后台任务
           'GET_POOL_TASK_BATCH_NEXT': 55847747596,  # 批量查询POOL后台任务
           'CLEAR_ERROR_CODE': 55847747597,  # 清除误码
           'GET_FC_ERROR_CODE': 55847747598,  # 查询FC误码
           'GET_ISCSI_ERROR_CODE': 55847747599,  # 查询ISCSI误码
           'GET_SAS_ERROR_CODE': 55847747600,  # 查询SAS误码
           'IMPORT_DB_CONFIG_DIR': 55847747601,  # 获取导入配置文件路径
           'IMPORT_DB_CONFIG': 55847747602,  # 导入配置文件
           'EXPORT_DB_CONFIG': 55847747603,  # 导出配置文件
           'CLEAR_EXPORT_DATA': 55847747604,  # 清除导出数据
           'GET_SYSTEM_CONFIG': 55847747605,  # 导出运行数据
           'PACKAGE_ALARM_OR_LOG': 55847747606,  # 打包设备数据
           'OM_MSG_OP_EXPORT_ALARM_OR_LOG': 55847747607,  # 获取收集信息导出路径
           'GET_SYS_UTC_TIME': 55847747608,  # 查询系统本地时间
           'SET_SYS_UTC_TIME': 55847747609,  # 设置系统本地时间
           'GET_SYS_DST': 55847747610,  # 查询系统中指定时区的夏令时配置
           'SET_SYS_DST': 55847747611,  # 设置系统中指定时区的夏令时配置
           'GET_SYS_NTP_CLNT_CONF': 55847747612,  # 查询系统NTP客户端配置
           'SET_SYS_NTP_CLNT_CONF': 55847747613,  # 设置系统NTP客户端配置
           'GET_SFTP_USER': 55847747614,  # SFTP用户信息
           'SET_ALARM_RESTORE_ENABLE': 55847747615,  # SET_ALARM_RESTORE_ENABLE
           'SET_ALARM_RESTORE_ADDRESS': 55847747616,  # SET_ALARM_RESTORE_ADDRESS
           'GET_ALARM_RESTORE_ADDRESS': 55847747617,  # GET_ALARM_RESTORE_ADDRESS
           'SET_STATISTIC_STRATEGY': 55847747618,  # SET_STATISTIC_STRATEGY
           'GET_STATISTIC_STRATEGY': 55847747619,  # GET_STATISTIC_STRATEGY
           'SET_STATISTIC_RESTORE_INFO': 55847747620,  # 设置性能统计数据自动转储信息
           'OM_MSG_OP_SET_THRESHOLD': 55847747621,  # 设置性能告警阈值
           'OM_MSG_OP_GET_THRESHOLD': 55847747622,  # 查询性能告警阈值
           'OM_MSG_OP_GETBATCH_THRESHOLD': 55847747623,  # 查询所有性能告警阈值
           'RECOVER_ALARM_THRESHOLD': 55847747624,  # 恢复性能统计默认告警阈值
           'EXPORT_STATISTIC_DATA': 55847747625,  # EXPORT_STATISTIC_DATA
           'GET_STATISTIC_OBJECT_DATA_MAP': 55847747626,  # GET_STATISTIC_OBJECT_DATA_MAP
           'GET_STATISTIC_TIME_SPAN': 55847747627,  # GET_STATISTIC_TIME_SPAN
           'SET_PERFORMANCE_SWITCH': 55847747628,  # SET_PERFORMANCE_SWITCH
           'GET_CUR_STATISTIC_DATA': 55847747629,  # GET_CUR_STATISTIC_DATA
           'GET_HIS_STATISTIC_DATA': 55847747630,  # GET_HIS_STATISTIC_DATA
           'DEL_STATISTIC_DATA_FILE': 55847747631,  # DEL_STATISTIC_DATA_FILE
           'GET_STATISTIC_DATA_FILE': 55847747632,  # GET_STATISTIC_DATA_FILE
           'GET_PERFORMANCE_SWITCH': 55847747633,  # GET_PERFORMANCE_SWITCH
           'START_NOTIFY': 55847747634,  # 通知上报
           'STOP_NOTIFY': 55847747635,  # 停止上报
           'NOTIFY_CREATE': 55847747636,  # 组件添加
           'NOTIFY_CHANGE': 55847747637,  # 组件属性变化
           'NOTIFY_DELETE': 55847747638,  # 组件删除
           'SET_EMAIL_INFO': 55847747639,  # 配置告警Email
           'GET_EMAIL_INFO': 55847747640,  # 查询告警Email配置
           'SET_SMS_INFO': 55847747641,  # 配置告警短信
           'GET_SMS_INFO': 55847747642,  # 查询告警短信配置
           'SET_ALARM_CONFIG': 55847747643,  # 设置远程告警发送
           'GET_ALARM_CONFIG': 55847747644,  # 查询远程告警发送
           'GET_CLIENT_INFO': 55847747645,  # GET_CLIENT_INFO
           'SET_CLIENT_INFO': 55847747646,  # SET_CLIENT_INFO
           'REPORT_ALARM': 55847747647,  # 上报告警
           'GET_CURRENT_ALARM': 55847747648,  # 查询当前告警
           'GET_HISTORY_ALARM': 55847747649,  # 查询所有事件（GETBATCH）
           'CLEAR_ALARM': 55847747650,  # 清除告警
           'GET_SYS_TIMEZONE': 55847747651,  # 查询系统时区配置
           'SET_SYS_TIME_ZONE': 55847747652,  # 设置系统时区配置
           'SEND_TEST_EMAIL': 55847747653,  # 发送测试Email
           'SEND_TEST_SMS': 55847747654,  # 发送测试短信
           'SEND_TEST_TRAPMSG': 55847747655,  # 发送测试TRAP消息
           'OM_MSG_OP_SET_ALARM_SYSLOG_CFG': 55847747656,  # 设置syslog配置
           'OM_MSG_OP_GET_ALARM_SYSLOG_CFG': 55847747657,  # 查询syslog配置
           'REBOOT': 55847747658,  # 设备重启
           'POWEROFF': 55847747659,  # 设备下电
           'GET_STATISTIC_RESTORE_INFO': 55847747660,  # 查询性能统计数据自动转储信息
           'GET_SNMP_CONFIG': 55847747661,  # 查询SNMP配置信息
           'MODIFY_SNMP_ENGINEBOOTS': 55847747662,  # 修改SNMP引擎重启次数
           'GET_OEM_MANUFACTORY': 55847747663,  # 查询OEM厂商信息
           'SET_OEM_MANUFACTORY': 55847747664,  # 设置OEM厂商信息
           'MODIFY_CONFIG_ITEM': 55847747665,  # 修改系统配置项
           'SET_DHA_POLICY': 55847747666,  # 设置DHA策略
           'GET_DHA_POLICY': 55847747667,  # 查询DHA策略
           'SET_DHA_SERVICE_STATES': 55847747668,  # 设置DHA服务状态
           'GET_DHA_SERVICE_STATES': 55847747669,  # 查询DHA服务状态
           'SET_DHA_EXPORT': 55847747670,  # 导出DHA信息
           'GET_DISKSCANCONF': 55847747671,  # 查询DiskScanConf
           'MODIFY_DISKSCANCONF': 55847747672,  # 修改DiskScanConf
           'GET_SERVICE_STATUS': 55847747673,  # 查指定节点agent状态
           'GET_SERVICE_STATUS_BATCH_NEXT': 55847747674,  # 查所有节点agent状态
           'START_SERVICE': 55847747675,  # 启动agent
           'STOP_SERVICE': 55847747676,  # 停止agent
           'DELETE_ISNS_SERVER': 55847747677,  # 删除ISNS SERVER配置
           'CLEAR_DB': 55847747678,  # 清除DB
           'GET_BACK_DB_INFO': 55847747679,  # 查询DB备份信息
           'BACKUP_DB': 55847747680,  # 备份DB
           'RESTORE_DB': 55847747681,  # 恢复DB
           'GET_DB_VERSION': 55847747682,  # 查询DB版本
           'SET_DHA_SINGLE_TASK_SWITCH': 55847747683,  # 设置DHA singletask开关
           'GET_DHA_LAST_RESULT': 55847747684,  # 查询DHA last result
           'GET_POWER_CONSUMPTION': 55847747685,  # 查询系统能耗
           'GET_REPAIRVERIFYCONF': 55847747686,  # 查询RepairVerifyConf
           'MODIFY_REPAIRVERIFYCONF': 55847747687,  # 修改RepairVerifyConf
           'GET_BSTCONF': 55847747688,  # 查询BSTConf
           'MODIFY_BSTCONF': 55847747689,  # 修改BSTConf
           'GET_CHUNKISOLATECONF': 55847747690,  # 查询ChunkIsolateConf
           'MODIFY_CHUNKISOLATECONF': 55847747691,  # 修改ChunkIsolateConf
           'FORCE_REBOOT': 55847747692,  # 强制重启
           'GET_POWERON_INFO': 55847747693,  # 获取指定节点或本节点上电结果
           'GET_NEXT_BATCH_POWERON_RESULT': 55847747694,  # 获取所有节点上电结果
           'VERIFY_VEIW_PASSWD': 55847747695,  # 验证视图密码
           'CHANGE_VIEW_PASSWD': 55847747696,  # 修改视图密码
           'RETSET_VIEW_PASSWD': 55847747697,  # 重置视图密码
           'GETBATCH_ENUM_INFO': 55847747698,  # 查询某个枚举定义详情
           'INTEGRATIVE_QUERY': 8596488204,  # 查询NAS引擎的用户名和密码
           'INTEGRATIVE_SET_IP': 55847747700,  # 设置NAS引擎的机头IP
           'INTEGRATIVE_SET_USERINFO': 55847747701,  # 设置NAS引擎的用户名和密码
           'INTEGRATIVE_DEL': 55847747702,  # 重置NAS用户名和密码、IP
           'INTEGRATIVE_SHOW': 55847747703,  # 显示DB中存的NAS引擎的所有用户名和密码
           'GET_FILE_DATA': 55847747704,  # 获取文件数据
           'GET_CURRENT_NODE_STATUS': 55847747705,  # 查当前节点状态
           'GET_SYSTEM_STATUS': 55847747706,  # 查系统状态
           'SPA_OPCODE_QUERY_ROOT_CKGID': 55847747707,  # 查询指定Pool的rootckg0 ID
           'SPA_OPCODE_EXPORT_ROOT_CKG': 55847747708,  # 导出指定CKG上的元数据
           'SPA_OPCODE_EXPORT_BTREE': 55847747709,  # 导出指定节点上的元数据
           'SPA_OPCODE_IMPORT_ROOT_CKG': 55847747710,  # 导入指定CKG上的元数据
           'SPA_OPCODE_IMPORT_BTREE': 55847747711,  # 导入指定节点上的元数据
           'GET_FILE_META': 55847747712,  # 获取文件描述信息
           'UPLOAD_FILE_DATA': 55847747713,  # 上传文件数据
           'SPA_OPCODE_BTREE_SMO_CHECK_BEGIN': 55847747714,  # 启动元数据校验
           'SPA_OPCODE_BTREE_SMO_CHECK_QUERY': 55847747715,  # 查询元数据校验结果
           'NOTIFY_NEW_FILE_CREATE': 55847747716,  # 通知新的文件产生
           'GET_ALARM_COUNT': 55847747717,  # 查询告警数量
           'show_dps_statistic': 55847747718,  # 查询备份软件统计信息
           'show_processor_statistic': 55847747719,  # 查询备份服务器统计信息
           'query_progress': 55847747720,  # 进度查询
           'query_bacth_service': 55847747721,  # 查询批量系统服务
           'start_service': 55847747722,  # 启动系统服务
           'stop_service': 55847747723,  # 停止系统服务
           'restart_service': 55847747724,  # 重启系统服务
           'start_backup': 55847747725,  # 手动执行备份任务
           'activate_policy': 55847747726,  # 激活策略
           'import_backupset': 55847747727,  # 导入备份集
           'expired_backupset': 55847747728,  # 立即过期备份集
           'query_storage_unit_capacity': 55847747729,  # 查询存储单元容量
           'del_license': 55847747730,  # 删除license
           'EXPORT_ALARM': 55847747731,  # 导出告警
           'NOTIFY_CMD_EXECUTE': 55847747732,  # 命令执行上报
           'CLEAR_LICENSE_FILE': 55847747733,  # 清除License文件
           'GET_HISTORY_ALARM_COUNT': 55847747734,  # 查询历史告警数量
           'CONFIRM_ALARM': 55847747735,  # 告警确认
           'GET_DISKPOOL_TASK': 55847747736,  # 查询指定DISKPOOL的后台任务
           'SCAN_AND_CREATE_HOST': 55847747737,  # 自动扫描并创建主机
           'TEST_NTP_COMM': 55847747738,  # 测试NTP服务通信
           'SWITCH_WORKING_CONTROLLER': 55835295745,  # 切换LUN的归属控制器
           'LUN_TRANSFERM': 55835295746,  # Thin LUN与Fat LUN之间的相互转换
           'EXPAND_LUN_CAPACITY': 55835295747,  # LUN的扩容
           'GET_BATCH_NEXT_SNAPSHOT_LUN_CANUSE': 55835295748,  # 查询可创建快照的LUN
           'SET_WORM_STATE': 55835295749,  # 设置WORM状态
           'SET_SYS_WORM_SW': 55835295750,  # 设置全局WORM开关
           'GET_SYS_WORM_SW': 55835295751,  # 查询全局WORM开关
           'ADD_LUN_BY_WWN': 55835295752,  # 根据WWN添加LUN到映射视图
           'REMOVE_LUN_BY_WWN': 55835295753,  # 根据WWN移除LUN从映射视图
           'GET_BATCH_NEXT_LUN_FOR_MIGRATION': 55835295754,  # 查询LUN迁移的源LUN或目标LUN
           'COUNT_LUN_FOR_MIGRATION': 55835295755,  # 查询LUN迁移的源LUN或目标LUN的总数
           'REMOVE_iSCSI_FROM_HOST': 55849123841,  # 将iSCSI启动器从HOST移除
           'REMOVE_FC_FROM_HOST': 55849189377,  # 将FC启动器从HOST移除
           'USER_LOGIN': 55847813121,  # 用户登陆
           'USER_LOGOUT': 55847813122,  # 用户注销
           'OFFLINE_USER': 55847813123,  # 踢除用户
           'INITIALIZE_USER_PWD': 55847813124,  # 初始化密码
           'HANDSHAKE': 55847813125,  # 用户握手
           'LOCK_USER': 55837327366,  # 锁定用户
           'UNLOCK_USER': 55837327367,  # 解锁用户
           'REQUEST_TOKEN': 55837327368,  # 获取一次性登陆令牌
           'UNLOCK_IP': 55837327369,  # 解锁IP
           'GET_DEFAULT_LDAP_CONFIG': 55850172417,  # 查询LDAP的默认属性
           'GET_IPRULE_SWITCH': 55850041345,  # 查询ip规则开关状态
           'MODIFY_IPRULE_SWITCH': 55850041346,  # 设置IP规则
           'ADD_HYPERCLONE_SLAVE': 55849517057,  # 添加从Lun
           'DELETE_HYPERCLONE_SLAVE_LUN': 55849517058,  # 删除从Lun
           'SPLIT_HYPERCLONE_SLAVE': 55849517059,  # 分裂从Lun
           'SYNCHRONIZE_HYPERCLONE_SLAVE': 55849517060,  # 同步从Lun
           'REVERSE_SYCH_HYPERCLONE_SLAVE': 55849517061,  # 反向同步从Lun
           'GET_BATCH_NEXT_HYPERCLONE_LUN_CANUSE': 55849517062,  # 查询创建分裂镜像时需要的LUN
           'GET_HYPERCLONE_LUN_DETAILS': 55849517063,  # 查询分裂镜像的LUN
           'GET_BATCH_NEXT_HYPERCLONE_LUN_INFO': 55849517064,  # 批量查询分裂镜像的LUN（NEXT）
           'SPLIT_MULTI_HYPERCLONE_SLAVE': 55849517065,  # 分类多个从Lun
           'DISK_POWER_ON': 55835230209,  # 硬盘上电
           'DISK_POWER_OFF': 55835230210,  # 硬盘下电
           'DISK_RESET': 55835230211,  # DISK_RESET
           'GET_DISK_NCQ_SWITCH': 55835230212,  # GET_DISK_NCQ_SWITCH
           'SET_DISK_NCQ_SWITCH': 55835230213,  # SET_DISK_NCQ_SWITCH
           'GET_DISK_UNPLUG': 55835230214,  # GET_DISK_UNPLUG
           'SET_DISK_UNPLUG': 55835230215,  # SET_DISK_UNPLUG
           'GET_DISK_WRITECACHESW': 55835230216,  # GET_DISK_WRITECACHESW
           'SET_DISK_WRITECACHESW': 55835230217,  # SET_DISK_WRITECACHESW
           'GET_DISK_PRECOPYSW': 55835230218,  # GET_DISK_PRECOPYSW
           'SET_DISK_PRECOPYSW': 55835230219,  # SET_DISK_PRECOPYSW
           'GET_DISK_BST': 55835230220,  # GET_DISK_BST
           'CLEAR_DISK_BST': 55835230221,  # CLEAR_DISK_BST
           'SET_DISK_LITHTSW': 55835230222,  # 硬盘定位灯开启/关闭
           'FORCE_READ_DISK': 55835230223,  # 强制接入硬盘并使用它对其它硬盘进行重构
           'START_DISK_PRECOPY': 55835230224,  # 启动预拷贝
           'GET_DISK_ROUTINE_TEST': 55835230225,  # 获取硬盘例测周期
           'SWAP_CONTROLLER': 55848140801,  # 主从切换控制器
           'REBOOT_CONTROLLER': 55848140802,  # 重启控制器
           'GET_INITIATOR_NAME': 55848140803,  # 查询控制器作为启动器的名称
           'SET_INITIATOR_NAME': 55848140804,  # 设置控制器作为启动器的名称
           'GET_FRONT_END_CONCURRENT': 55848140805,  # 获取前端并发
           'GET_BACK_END_CONCURRENT': 55848140806,  # 获取后端并发
           'OFFLINE_CONTROLLER': 55848140807,  # 离线控制器
           'OFFLINE_CONTROLLER_SERVICE': 55848140808,  # 切换控制器业务
           'ONLINE_CONTROLLER_SERVICE': 55848140809,  # 切回控制器业务
           'OM_OPCODE_SAFE_POWER_OFF_SYSTEM': 55848140812,  # 2800V3单控新增安全下电（其内部包含1.前置条件检查2.备份控制器信息3.离线控制器）
           'GET_FREQUENCYSWITCH': 55835623425,  # 查询调频开关
           'SET_FREQUENCYSWITCH': 55835623426,  # 设置调频开关
           'POWERON_ENCLOSURE': 55848075265,  # 框上电
           'CREATE_REMOTE_DEVICE': 55849254913,  # 创建远端设备
           'SCAN_REMOTE_LUN': 55850958849,  # 手动扫描Remote LUN
           'GET_EXPANSION_BAY_ID': 55848009729,  # 获取待扩容柜id
           'CAPACITY_EXPAND': 55848009730,  # 扩容系统柜
           'CANCEL_CAPACITY_EXPAND': 55848009731,  # 取消系统柜扩容
           'SET_FILELEVEL_PRIORITIES': 56911134721,  # 设置SNAS分级存储策略优先级
           'GET_FILELEVEL_PRIORITIES': 56911134722,  # 查询SNAS分级存储策略优先级
           'TEST_SWITCH_COMM': 56911134742,  # 测试交换机SNMP通信
           'OM_MSG_OP_GET_PACKAGE_UPLOADPATH': 8599109754,  # 查询升级包上传路径
           'OM_MSG_OP_NOTIFY_PACKAGE_PATH': 8599117947,  # 通知软件包上传完成
           'OM_MSG_OP_UPD_LST_PACKAGE_INFO': 8599109756,  # 查询升级包信息
           'OM_MSG_OP_UPD_LST_ACTIVEMODE': 8599150994,  # 查询激活方式
           'OM_MSG_OP_UPD_LST_DETAILINFO': 8599150995,  # 查询升级详细信息
           'OM_MSG_OP_EXC_HOTPATCH_DELETE': 8599118950,  # 删除热补丁
           'OM_MSG_OP_UPD_DISK_FIRMWARE': 8599117938,  # 升级硬盘
           'OM_MSG_OP_UPD_GET_DISK_RESULT': 8599117939,  # 获取硬盘升级状态
           'OM_MSG_OP_UPD_GET_MGTBOARD_RESULT': 8599117975,  # 获取管理板升级状态
           'OM_MSG_OP_LST_VER': 8599109735,  # 查询版本信息
           'OM_MSG_OP_UPD_EXECUTE': 8599117931,  # 通知执行一个升级流程
           'OM_MSG_OP_UPD_LST_SYS_PROGRESS': 8599109744,  # 查询整体升级状态
           'OM_MSG_OP_LST_SYS_UPSTAT': 56908316673,  # 查询集群总体以及各节点升级状态
           'OM_MSG_OP_UPD_NODE_REPORT': 56908316674,  # 查询集群各节点升级报告
           'OM_MSG_OP_UPD_SYS_REPORT': 56908316675,  # 查询集群整体升级报告
           'OM_MSG_OP_UPD_PRE_TEST': 56908316676,  # 集群升级预检测
           'OM_MSG_OP_LST_DLD_VERPKG': 56908316677,  # 通知节点下载软件升级包
           'SET_FILELEVEL_PRIORITIES': 56911134721,  # 设置SNAS分级存储策略优先级
           'GET_FILELEVEL_PRIORITIES': 56911134722,  # 查询SNAS分级存储策略优先级
           'TEST_SWITCH_COMM': 56911134742,  # 测试交换机SNMP通信
           'query_backupset_import_info': 59592671232,  # 查询导入备份集信息
           'query_backuoset_import_log': 59592671233,  # 查询导入备份集日志
           'sync_vm': 59592671234,  # 同生产端同步虚拟机
           'backup_task_cancel': 59592671235,  # 备份任务取消
           'sync_backup_server_ip': 59592671236,  # 同步服务器的IP信息
           'get_config_file': 59592671237,  # 查询告警配置文件、错误码配置文件
           'get_storage_usage_top': 59592671238,  # 查询存储单元TOP5
           'get_backup_server_status': 59592671239,  # 强制刷新备份服务器状态
           'repair_storage_unit': 59592671240,  # 修复存储单元
           'PRO_SYS_TIME_MANUAL_SYNC': 59592671241,  # 在processor上手动同步系统时间
           'get_local_role': 59592671242,  # 获取本地服务器角色
           'DELETE_SHNAPSHOT': 59592671243,  # 删除快照
           'get_single_CBT': 59592671244,  # 查询单个备份服务器CBT状态
           'set_local_CBT': 59592671245,  # 设置本地CBT状态
           'set_vm_CBT': 59592671246,  # 设置虚拟机CBT状态
           'DELETE_BITMAP': 59592671247,  # 删除位图卷
           'QUERY_BITMAP': 59592671248,  # 查询位图卷
           'DELET_SNAPSHOT_PROCESS': 59592671249,  # 查询删除快照进度
           'QUERY_SNAPSHOT_INFO': 59592671250,  # 查询快照信息
           'get_single_transMode': 59592671251,  # 查询单个备份服务器传输模式
           'set_local_transMode': 59592671252,  # 设置本地传输模式
           'CHECK_IBC_PASSWORD': 55847747746,  # 检查ibc_os_hs用户是否为默认密码,检查ibc_os_hs公私钥对是否被修改
           'GET_INTF_MODULE_STATUS': 57176883201,  # 获取接口卡状态信息，专用于更换IP scale-out接口卡
           'GET_ALL_PORTS_BY_INTF_SLOT': 57176883202,  # 获取接口卡下的所有端口信息，专用于更换IP scale-out接口卡
           'CHECK_SAS_CARD_LINK_STATUS': 55847747759,  # 获取接口卡下所连接的所有硬盘中是否不存在链路不完整的硬盘
           'GET_VIRTUAL_MACHINE': 55847747925,
           'RECORD_OPERATION_LOG': 55847747739,  # 记录转储或导出操作日志
           }

    # 枚举定义
    class Enum():
        '''
        '''
        OM_OBJ_E = {'ARRAY': 2,  # 阵列/阵列
                    'FRONT_CONTROLLER': 3,  # 前端控制器/前端控制器
                    'UNIFY_CONTROLLER': 4,  # 前后端合一控制器/前后端合一控制器
                    'BACK_CONTROLLER': 5,  # 后端控制器/后端控制器
                    'FRONT_PORT': 6,  # 前端端口/前端端口
                    'BACK_PORT': 7,  # 后端端口/后端端口
                    'VOLUME': 8,  # 卷/卷
                    'SCOPE': 9,  # 范围/范围
                    'REMOTE_MIRRORGROUP': 12,  # 远程镜像组/远程镜像组
                    'REMOTE_LINK': 13,  # 远程连接链路/远程连接链路
                    'RAID': 15,  # RAID/RAID
                    'REPLICATION_BANDWIDTH': 17,  # 复制带宽/复制带宽
                    'SNAPSHOT_CONSISTENTGROUP': 18,  # 快照一致性组/快照一致性组
                    'VOLUME_CONSISTENTGROUP': 19,  # 一致性卷组/一致性卷组
                    'DISKGROUP': 20,  # 磁盘组/磁盘组
                    'CPU_CORE': 24,  # CPU核心/CPU核心
                    'NODE': 25,  # 节点/节点
                    'FAN_ENCLOSURE': 26,  # 风扇框/风扇框
                    'REMOTE_LUNCOPY': 29,  # 远程LUN拷贝/远程LUN拷贝
                    'THINPOOL': 30,  # Thin pool(精简池)/Thin pool(精简池)
                    'COM_HYPER_CLONE_CG': 32,  # 分裂镜像一致性组/分裂镜像一致性组
                    'NFS_Share': 33,  # NFS共享/NFS Share
                    'NFS_Server': 34,  # NFS服务器/NFS Server
                    'CIFS_Share': 35,  # CIFS共享/CIFS Share
                    'CIFS_Server': 36,  # CIFS服务器/CIFS Server
                    'FTP': 37,  # FTP/FTP
                    'HTTP': 38,  # HTTP/HTTP
                    'Replication': 39,  # 远程复制/Replication
                    'FileSystem': 40,  # 文件系统/FileSystem
                    'Pool': 41,  # 文件存储池/Pool
                    'User': 42,  # 用户/User
                    'Wi-Fi': 43,  # Wi-Fi/Wi-Fi
                    'Cloud Backup': 44,  # 云备份/Cloud Backup
                    'FileSystemTier': 45,  # 文件系统分层/File System Tier
                    'NFSClient': 46,  # NFS客户端/NFS Client
                    'USER_SECURITY_POLICY': 47,  # 用户安全策略/USER_SECURITY_POLICY
                    'DISK': 10,  # 硬盘/Disk
                    'LUN': 11,  # LUN/LUN
                    'HOSTGROUP': 14,  # 主机组/Host Group
                    'CPU': 16,  # CPU/CPU
                    'HOST': 21,  # 主机/Host
                    'POWER': 23,  # 电源模块/Power
                    'SNAPSHOT': 27,  # 快照/Snapshot
                    'REMOTEREPLICATION': 28,  # 远程复制/Remote Replication
                    'FSSNAPSHOT': 29,  # 文件系统快照/FSSNAPSHOT
                    'SystemLicense': 199,  # SystemLicense/SystemLicense
                    'CommonData': 200,  # 通用数据存储/CommonData
                    'SYSTEM': 201,  # 系统/System
                    'USER': 202,  # 用户/User
                    'DOMAIN': 203,  # 域/Domain
                    'DOMAINMEMBER': 204,  # 域成员/Domain Member
                    'BAY': 205,  # 柜/Bay
                    'ENCLOSURE': 206,  # 框/Enclosure
                    'CONTROLLER': 207,  # 控制器/Controller
                    'EXPBOARD': 208,  # 级联板/Expand Board
                    'INTF_MODULE': 209,  # 接口模块/Interface Module
                    'BACKUP_POWER': 210,  # 备电模块/Backup Power
                    'FAN': 211,  # 风扇模块/Fan
                    'FC_PORT': 212,  # FC端口/FC Port
                    'ETH_PORT': 213,  # 以太网口/Ethernet Port
                    'SAS_PORT': 214,  # SAS端口/SAS Port
                    'IB_PORT': 16500,  # IB端口/IB Port
                    'SERIAL_PORT': 215,  # 串口/Serial Port
                    'STORAGEPOOL': 216,  # 存储池/Storage Pool
                    'STORAGETIER': 217,  # 存储层/Storage Tier
                    'SMARTCACHE': 218,  # SmartCache/SmartCache
                    'LUNCOPY': 219,  # LUN拷贝/LUN Copy
                    'SPLITMIRROR': 220,  # 分裂镜像/Split Mirror
                    'CONSISTENTGROUP': 221,  # 一致性组/Consistent Group
                    'ISCSI_INITIATOR': 222,  # iSCSI启动器/iSCSI Initiator
                    'FC_INITIATOR': 223,  # FC启动器/FC Initiator
                    'REMOTE_DEVICE': 224,  # 远端设备/Remote Device
                    'FC_LINK': 225,  # FC远端链路/FC Link
                    'REMOTEREPLICATIONMEMBERLUN': 226,  # 远程复制成员LUN/Remote Replication Member LUN
                    'LUNCOPYMEMBERLUN': 227,  # LUN拷贝成员LUN/LUN Copy Member LUN
                    'SPLITMIRRORTARGETLUN': 228,  # 分裂镜像从LUN/Split Mirror Target LUN
                    'ISCSI_SESSION': 229,  # iSCSI会话/iSCSI Session
                    'IOCLASS': 230,  # IO分类/IO Class
                    'UPS': 231,  # UPS/UPS
                    'PCIE_DATA_SWITCH': 232,  # PCIE数据交换机/PCIE Data Switch
                    'PCIE_PORT': 233,  # PCIE端口/PCIE Data Switch Port
                    'SFP_OPTICAL_TRANSCEIVER': 234,  # 光模块/SFP optical transceiver
                    'BOND_PORT': 235,  # 绑定端口/bond port
                    'IPRule': 236,  # 安全规则/IPRule
                    'MEMORY': 237,  # 内存/MEMROY
                    'LDAPConfig': 238,  # ldap配置/LDAP configuraion
                    'LDAP_USER_MAP': 239,  # ldap用户映射/LDAP_USER_MAP
                    'SNMP_TRAP_ADDR': 240,  # SNMP Trap地址/SNMP_TRAP_ADDR
                    'SNMP_COMMUNITY': 241,  # SNMP 团体字/SNMP_COMMUNITY
                    'SNMP_USM': 242,  # 基于用户的安全模型/SNMP_USM
                    'iSCSI_LINK': 243,  # iSCSI远端链路/iSCSI_LINK
                    'License': 244,  # License/License
                    'MAPPINGVIEW': 245,  # 映射视图/Mapping View
                    'SCHEDULE': 246,  # 时刻表/Schedule
                    'iSCSI_SESSION_SETTING': 247,  # iSCSI会话初始参数信息（即连接会话时的协商参数）/iSCSI Session Settings
                    'iSCSI_TGT_NODE': 248,  # iSCSI目标器节点/iSCSI Target Node
                    'iSCSI_TGT_PORT': 249,  # iSCSI目标器端口/iSCSI Target Port
                    'REMOTE_LUN': 250,  # 远端lun/Remote LUN
                    'MONITOR_BOARD': 251,  # 监控板/Monitor Board
                    'FCoE_PORT': 252,  # FCoE端口/FCoE_PORT
                    'LUN_Migration_Task': 253,  # LUN迁移任务/LUN Migration Task
                    'CloneGroup': 254,  # 克隆组/Clone Group
                    'HOST_LINK': 255,  # 主机链路/Host Link
                    'LUNGroup': 256,  # LUN组/LUN Group
                    'PortGroup': 257,  # Port组/Port Group
                    'Subnet': 258,  # 子网段/Subnet
                    'NetGroup': 259,  # 网络组/NetGroup
                    'DNS_Server': 260,  # DNS服务器/DNS_Server
                    'IP_LINK': 261,  # IP链路/IP LINK
                    'UserGroup': 262,  # 用户组/User Group
                    'REPLICATIONPAIR': 263,  # 远程复制pair/REPLICATION PAIR
                    'Slow_disk_policy': 264,  # 慢盘检测/Slow disk policy
                    'LUNBackgroudTask': 265,  # LUN后台任务/LUNBackgroudTask
                    'DiskPool': 266,  # 硬盘域/DiskPool
                    'StorageEngine': 267,  # 存储引擎/StorageEngine
                    'CachePartition': 268,  # Cache分区/CachePartition
                    'IOCLASSTemplate': 269,  # IO分类模板/IOCLASSTemplate
                    'LUNDestroyData': 270,  # LUN数据消毁/LUNDestroyData
                    'DiskDestroyData': 271,  # Disk数据消毁/DiskDestroyData
                    'LUNPriorityStatistic': 272,  # LUN优先级统计/LUNPriorityStatistic
                    'SmartCachePartition': 273,  # SmartCache分区/SmartCachePartition
                    'DISK_SCAN_TASK': 274,  # Disk扫描任务/DISK_SCAN_TASK
                    'FAN_CTRL_MODULE': 306,  # 风扇控制器模块/FAN_CTRL_MODULE
                    'CLI_COMMON': 20480,  # 专用于CLI公共部分，CLI新增的特殊命令字可以挂接在此对象下，仅供CLI使用/CLI_COMMON
                    'SAS_Card': 32768,  # SAS卡/SAS_Card
                    'Raid_Card': 32769,  # Raid卡/Raid_Card
                    'Memory': 32770,  # 内存信息/Memory
                    'Server_FileSystem': 32771,  # 服务器文件系统/Server_FileSystem
                    'RaidCard_Raid': 32772,  # /RaidCard_Raid
                    'RaidCard_LUN': 32773,  # /RaidCard_LUN
                    'RaidCard_LogicDisk': 32774,  # /RaidCard_LogicDisk
                    'SmartData_Raid': 32775,  # /SmartData_Raid
                    'SmartData_LUN': 32776,  # /SmartData_LUN
                    'SmartData_LogicDisk': 32777,  # /SmartData_LogicDisk
                    'SNAS_SYSTEM': 16384,  # Scale out NAS系统/SNAS_SYSTEM
                    'SNAS_NODE': 16385,  # SNAS集群系统节点/Scale out NAS NODE
                    'PROTOCOL_CLUSTER': 16386,  # SNAS协议集群/Protocol cluster
                    'PROTOCOL_CLUSTER_NODE': 16387,  # SNAS协议集群节点/Protocol cluster node
                    'PROTOCOL_CLUSTER_ZONE': 16388,  # SNAS协议集群分区/Protocol cluster zone
                    'SNAS_IP_POOL': 16389,  # 动态IP池/Public ip pool
                    'SNAS_CLIENT': 16390,  # SNAS系统客户端/NAS client
                    'SNAS_DNS_CONFIG': 16391,  # SNAS DNS 配置/DNS configuration
                    'SNAS_LOCAL_USER': 16392,  # 本地用户/local user
                    'SNAS_LOCAL_GROUP': 16393,  # 本地用户组/local group
                    'SNAS_USERANDGROUP': 16394,  # 用户组和用户关系/user&group relationship
                    'SNAS_IDMAP_CONFIG': 16395,  # SNAS ID MAPPING/ID MAPPING
                    'SNAS_ROOT_USER': 16396,  # SNAS节点root用户/Root user password setting
                    'SNAS_NODE_FS_SERV': 16397,  # SNAS节点文件系统服务/FS service running on node
                    'SNAS_NODE_SHARE_SERV': 16398,  # SNAS节点协议共享服务/NAS service running on node
                    'SNAS_CIFS_SERVICE': 16399,  # SNAS CIFS 服务/CIFS service configuration
                    'SNAS_FILE': 16400,  # SNAS 文件/SNAS file object
                    'SNAS_NFS_SHARE': 16401,  # SNAS NFS共享/NFS share of file
                    'SNAS_CIFS_SHARE': 16402,  # SNAS CIFS 共享/CIFS share of file
                    'SNAS_USER_QUOTA': 16403,  # SNAS用户配额/SNAS user quota
                    'SNAS_CIFS_SHARE_AUTH_CLIENT': 16404,  # SNAS CIFS用户共享/CIFS client permission of file
                    'DATA_RECOVER_SCHEDULE': 16405,  # 数据恢复计划/Data recovery schedule
                    'SNAS_TASK': 16406,  # SNAS任务/back task
                    'SNAS_KEY_VALUE_STORE': 16407,  # SNAS KV存储接口/key-value store
                    'SNAS_FILE_QUOTA': 16408,  # SNAS文件配额/SNAS file quota
                    'SNAS_NFS_SHARE_AUTH_CLIENT': 16409,  # SNAS NFS 客户端共享/NFS client permission of file
                    'SNAS_ACL_STRATEGY': 16410,  # 协议 ACL策略/ACL
                    'SNAS_LOCAL_AUTH': 16411,  # 本地认证源/Local authority configuration
                    'SNAS_NIS_CONFIG': 16412,  # NIS认证源/NIS configuration
                    'SNAS_LDAP_CONFIG': 16413,  # LDAP认证源/LDAP configuration
                    'SNAS_AD_CONFIG': 16414,  # AD域认证源/AD domain
                    'SNAS_SYS_WATERLEVEL': 16415,  # SNAS性能节点数据迁移水位/SNAS node water level
                    'SNAS_SYS_ENERGY_SAVING': 16416,  # SNAS系统节能开关/energy saving
                    'SNAS_ALARM_VOICE': 16417,  # SNAS告警声音设置/alarm void setting
                    'SNAS_SECURITY_POLICY': 16418,  # SNAS 系统安全策略/admin user security policies
                    'SNAS_HEARTBEAT': 16419,  # 心跳/connection heart beat
                    'SNAS_HANDSHAKE': 16420,  # 握手接口/connection hand shake
                    'SNAS_MGR_NODE': 16421,  # 管理节点/check snas main mrg node
                    'SNAS_NODE_PERFORMANCE': 16422,  # 集群节点性能接口/snas node performance
                    'SNAS_SECURITY_SMTP': 16423,  # SNAS SMTP配置/snas super user pwd reset
                    'SNAS_ALARM_THRESHOLD': 16424,  # SNAS告警阈值/snas alarm threshold
                    'SNAS_AD_SOURCE': 16425,  # SNAS AD域/snas AD domain
                    'SNAS_SYS_TIER': 16426,  # SNAS 分级存储/snas storage Tier
                    'SNAS_FILE_LEVEL_POLICY': 16427,  # /snas file level policy
                    'SNAS_FILE_LEVEL_POLICY_ITEM': 16428,  # /snas file level policy item
                    'SNAS_SYS_IO_TEMP': 16429,  # /snas file io statistic
                    'SNAS_NIS_SOURCE': 16430,  # /snas nis auth source
                    'SNAS_LDAP_SOURCE': 16431,  # /snas ldap auth source
                    'SNAS_FILE_ATIME': 16432,  # /snas file access time
                    'SNAS_ENCRYPT_KEY': 16433,  # AES对称加密密钥128位/snas encrypte key
                    'SNAS_DEVICE_SMSMODEM': 16434,  # /snas sms modem
                    'SNAS_ALARM_DEFINITION': 16435,  # 告警定义配置/snas_alarm_level
                    'SNAS_CMD_OPINFO': 16436,  # 命令操作提示信息接口/snas_cmd_opinfo
                    'SNAS_EXTERNAL_DNS': 16437,  # /snas dns service
                    'SNAS_IP_SWITCH': 16438,  # /snas ip switch
                    'SNAS_IP_SWITCH_PORT': 16439,  # /snas ip switch port
                    'SNAS_DISCOVERY_SNMP': 16440,  # /snas snmp discovery config
                    'IPZone': 16441,  # /IPZone
                    'vStore': 16442,  # 虚拟存储（多租户）/vStore
                    'WormUser': 16443,  # WORM管理员/WormUser
                    'CommConfigure': 16444,  # 通用配置（目前VMware使用）/CommConfigure
                    'QUOTATREE': 16445,  # /QUOTATREE
                    'LOCAL_RESUSER': 16446,  # 本地资源用户（统一存储使用）/LOCAL_RESUSER
                    'LOCAL_RESGROUP': 16447,  # 本地资源用户组（统一存储使用）/LOCAL_RESGROUP
                    'HTTPOnlineLink': 16448,  # HTTP的在线连接/HTTPOnlineLink
                    'FTPOnlineLink': 16449,  # FTP的在线连接/FTPOnlineLink
                    'HTTPSERVICE': 16450,  # HTTP服务/HTTPSERVICE
                    'FTPSERVICE': 16451,  # FTP服务/FTPSERVICE
                    'NFSSERVICE': 16452,  # NFS服务/NFSSERVICE
                    'CIFSSERVICE': 16453,  # CIFS服务/CIFSSERVICE
                    'SNAS_FTP_SHARE_AUTH_CLIENT': 16454,  # FTP共享权限/SNAS_FTP_SHARE_AUTH_CLIENT
                    'SNAS_HTTP_SHARE_AUTH_CLIENT': 16455,  # HTTP共享权限/SNAS_HTTP_SHARE_AUTH_CLIENT
                    'SNAS_HTTP_SHARE': 16456,  # HTTP共享/SNAS_HTTP_SHARE
                    'Homedir': 16457,  # 用户主目录/Homedir
                    'Quota': 16458,  # 配额/Quota
                    'SNAS_CAPACITY_STATISTIC': 16459,  # 集群对象容量数据采集/snas capacity collection
                    'IB_INITIATOR': 16499,  # IB_INITIATOR/IB启动器（主机端口）
                    'ISM': 49152,
                    'NOFS': 53248,  # NOFS/NOFS
                    'TASK': 57344,  # 任务/task
                    'BACKUP_SERVER': 57345,  # 备份服务器/backup server
                    'VRM': 57346,  # 虚拟资源管理节点（VRM）/VRM
                    'CLUSTER': 57347,  # 集群/cluster
                    'CAN': 57348,  # 计算节点代理（CNA）/CAN
                    'DATASTORE': 57349,  # 数据存储/datastore
                    'VIRTUAL_MACHINE': 57350,  # 虚拟机/virtual machine
                    'VDI_DISK': 57351,  # VDI虚拟磁盘/virtualdisk
                    'BACKUP_POLICY': 57352,  # 备份策略/backup policy
                    'STORAGE_UNIT': 57353,  # 存储单元/Storage Unit
                    'RESTORE_POLICY': 57354,  # 恢复策略/Restore Policy
                    'BACKUP_SET': 57355,  # 备份集/Backup Set
                    'VIRTUAL_MACHINE': 402,  # 虚拟机
                    'VMPort': 410,  # 虚拟机端口
                    }

        '''
        '''
        STATISTIC_DATA_ID = {
            'TotalIOCount': 1,  # 总I/O数量/Total I/O Count
            'ReadIORatio': 2,  # 读I/O比率/Read I/O Ratio
            'WriteIORatio': 3,  # 写I/O比率/Write I/O Ratio
            'CurrentBandWidth': 4,  # 当前带宽 （MB/s）/Current Bandwidth (MB/s)
            'MaxBandWidth': 5,  # 最大带宽 （MB/s）/Max. Bandwidth (MB/s)
            'CurrentIOPS': 6,  # 当前IOPS/Current IOPS
            'MaxIOPS': 7,  # 最大IOPS（IO/s）/Max IOPS(IO/s)
            'MaxLatency': 8,  # 最大延迟/Max Latency
            'AverageLatency': 9,  # 平均延迟/Average Latency
            'CacheHit': 10,  # Cache命中率（%）/Cache Hit (%)
            'LocalWriteCacheRatio': 11,  # 本地写Cache利用率/Local Write Cache Ratio
            'MirrorWriteCacheRatio': 12,  # 镜像写Cache利用率/Mirror Write Cache Ratio
            'ReadIOTraffic': 13,  # 读I/O流量/Read I/O Traffic
            'WriteIOTraffic': 14,  # 写I/O流量/Write I/O Traffic
            'MaxPowerConsume': 15,  # 最大功耗/Max Power Consumption
            'AvgPowerConsume': 16,  # 平均功耗/Average Power Consumption
            'MinPowerConsume': 17,  # 最小功耗/Min Power Consumption
            'Usage': 18,  # 利用率 （%）/Usage Ratio (%)
            'QueueSize': 19,  # 队列长度 （个）/Queue Length
            'ResponseTime': 20,  # 响应时间 （ms）/Response Time (ms)
            'BandWidth': 21,  # 带宽 （MB/s）/Bandwidth (MB/s)
            'Throughput': 22,  # 吞吐量（IOPS）（IO/s）/Throughput(IOPS) (IO/s)
            'ReadBandWidth': 23,  # 读带宽 （MB/s）/Read Bandwidth (MB/s)
            'AverageReadIO': 24,  # 读I/O平均大小 （KB）/Average Read I/O Size (KB)
            'ReadThroughput': 25,  # 读吞吐量（IOPS）（IO/s）/Read Throughput(IOPS) (IO/s)
            'WriteBandWidth': 26,  # 写带宽（MB/s）/Write Bandwidth (MB/s)
            'AverageWriteIO': 27,  # 写I/O平均大小 （KB）/Average Write I/O Size (KB)
            'WirteThroughput': 28,  # 写吞吐量（IOPS）（IO/s）/Write Throughput(IOPS) (IO/s)
            'ServiceTime': 29,  # 服务时间(不包括队列排队时间) （ms）/Service Time (Excluding Queue Time) (ms)
            'ReadIOStatistics512B': 30,  # 读IO分布：512B/Read I/O distribution: 512 B
            'ReadIOStatistics1KB': 31,  # 读IO分布：1KB/Read I/O distribution: 1 KB
            'ReadIOStatistics2KB': 32,  # 读IO分布：2KB/Read I/O distribution: 2 KB
            'ReadIOStatistics4K': 33,  # 读IO分布：4KB/Read I/O distribution: 4 KB
            'ReadIOStatistics8KB': 34,  # 读IO分布：8KB/Read I/O distribution: 8 KB
            'ReadIOStatistics16KB': 35,  # 读IO分布：16KB/Read I/O distribution: 16 KB
            'ReadIOStatistics32KB': 36,  # 读IO分布：32KB/Read I/O distribution: 32 KB
            'ReadIOStatistics64KB': 37,  # 读IO分布：64KB/Read I/O distribution: 64 KB
            'ReadIOStatistics128KB': 38,  # 读IO分布：128KB/Read I/O distribution: 128 KB
            'ReadIOStatistics256KB': 39,  # 读IO分布：256KB/Read I/O distribution: 256 KB
            'ReadIOStatistics512KB': 40,  # 读IO分布：512KB/Read I/O distribution: 512 KB
            'WriteIOStatistics512B': 41,  # 写IO分布：512B/Write I/O distribution: 512 B
            'WriteIOStatistics1KB': 42,  # 写IO分布：1KB/Write I/O distribution: 1 KB
            'WriteIOStatistics2KB': 43,  # 写IO分布：2KB/Write I/O distribution: 2 KB
            'WriteIOStatistics4KB': 44,  # 写IO分布：4KB/Write I/O distribution: 4 KB
            'WriteIOStatistics8KB': 45,  # 写IO分布：8KB/Write I/O distribution: 8 KB
            'WriteIOStatistics16KB': 46,  # 写IO分布：16KB/Write I/O distribution: 16 KB
            'WriteIOStatistics32KB': 47,  # 写IO分布：32KB/Write I/O distribution: 32 KB
            'WriteIOStatistics64KB': 48,  # 写IO分布：64KB/Write I/O distribution: 64 KB
            'WriteIOStatistics128KB': 49,  # 写IO分布：128KB/Write I/O distribution: 128 KB
            'WriteIOStatistics256KB': 50,  # 写IO分布：256KB/Write I/O distribution: 256 KB
            'WriteIOStatistics512KB': 51,  # 写IO分布：512KB/Write I/O distribution: 512 KB
            'ReadWriteIOStatistics512B': 52,  # 读写IO分布：512B/Read and write I/O distribution: 512 B
            'ReadWriteIOStatistics1KB': 53,  # 读写IO分布：1KB/Read and write I/O distribution: 1 KB
            'ReadWriteIOStatistics2KB': 54,  # 读写IO分布：2KB/Read and write I/O distribution: 2 KB
            'ReadWriteIOStatistics4KB': 55,  # 读写IO分布：4KB/Read and write I/O distribution: 4 KB
            'ReadWriteIOStatistics8KB': 56,  # 读写IO分布：8KB/Read and write I/O distribution: 8 KB
            'ReadWriteIOStatistics16KB': 57,  # 读写IO分布：16KB/Read and write I/O distribution: 16 KB
            'ReadWriteIOStatistics32KB': 58,  # 读写IO分布：32KB/Read and write I/O distribution: 32 KB
            'ReadWriteIOStatistics64KB': 59,  # 读写IO分布：64KB/Read and write I/O distribution: 64 KB
            'CycleWriteIOCnt': 60,  # 周期内写I/O总数/Total Write I/O Count
            'CycleReadIOCnt': 61,  # 周期内读I/O总数/Total Read I/O Count
            'ReadWriteIOStatistics512KB': 62,  # 读写IO分布：512KB/Read and write I/O distribution: 512 KB
            'WriteIOInPeriod': 63,  # 周期内写I/O总数/Total Write I/O during Periods
            'ReadIOInPeriod': 64,  # 周期内读I/O总数/Total Read I/O during Periods
            'RandomSequenceRatio': 65,  # 随机顺序比例/Random Sequence Ratio
            'Usage2': 66,  # 使用率/Usage Ratio
            'ReadBandWidthUsage': 67,  # 带宽使用率/Read Bandwidth Usage
            'CPUUsage': 68,  # CPU利用率 （%）/CPU Usage (%)
            'MemoryUsage': 69,  # 内存占用率 （%）/Memory Usage (%)
            'SwapUsage': 70,  # 交换分区占用率/Swap Usage
            'NetReadTraffic': 71,  # 网络当前读流量/Network Read Traffic
            'NetWriteTraffic': 72,  # 网络当前写流量/Network Write Traffic
            'NetInPackage': 73,  # 网络当前进包数量/Network Inbound Packages
            'NetOutPackage': 74,  # 网络当前出包数量/Network Outbound Packages
            'WorkTemperture': 75,  # 工作温度/Operating Temperature
            'PowerConsume': 76,  # 功耗/Power Consumption
            'Voltage': 77,  # 电压/Voltage
            'AverageIOResponseTime': 78,  # 平均I/O响应时间 （ms）/Average I/O Latency (ms)
            'MaxIOResponseTime': 79,  # 最大I/O响应时间 （ms）/Max. I/O Latency (ms)
            'DirtyPageRatio': 80,  # 脏页比例 （%）/Dirty Page Percentage (%)
            'RefreshCacheDivideWriteRequest': 81,
            # 刷Cache和写请求的比例 （%）/Percentage of Cache Flushes to Write Requests (%)
            'RefreshCacheBandWidth': 82,  # 刷Cache的带宽 （MB/s）/Cache Flushing Bandwidth (MB/s)
            'RefreshCacheBecauseHightWater': 83,
            # 高水位导致的刷Cache次数 （次）/Cache Flushes Caused by the High Water Level (times)
            'RefreshCacheBecauseScheduleTimer': 84,  # 定时器导致的刷Cache次数/Cache Flushes Caused by the Timer
            'CacheLowWater': 85,  # Cache触及低水位次数（次）/Low Water Level Reaching Times (times)
            'MaxBandWidthWrite': 86,  # 全条带写请求/Full-stripe Write Request
            'FetchFlux': 87,  # 预取流量 （MB/s）/Prefetch Traffic (MB/s)
            'FetchRatio': 88,  # 预取效率 （%）/Prefetch Rate (%)
            'ReadCacheHit': 89,  # 读Cache命中次数（次/秒）/Read Cache Hits (times/s)
            'ReadCacheNotHit': 90,  # 读Cache未命中的次数（次/秒）/Read Cache Not Hit Times (times/s)
            'ReadCacheHitWhenWrite': 91,  # 读在写Cache命中的次数/Read Cache Hits by Writes
            'ReadCacheHitWhenRead': 92,  # 读在读Cache命中的次数/Read Cache Hits by Reads
            'ReadCacheRatio': 93,  # 读Cache命中率 （%）/Read Cache Hit Ratio (%)
            'ReadCacheReHitRatio': 94,  # 读Cache重命中率/Read Cache Rehit Ratio
            'WriteCacheHitRatio': 95,  # 写Cache命中率/Write Cache Hit Ratio
            'WriteCacheReHitRatio': 96,  # 写Cache重命中率/Write Cache Rehit Ratio
            'WriteCacheHit': 97,  # 写Cache命中次数/Write Cache Hits
            'WriteCacheNotHit': 98,  # 写Cache未命中次数/Write Cache Misses
            'AsyncTime': 99,  # 距上次同步的时间间隔 （s）/Time Since Last Synchronization (s)
            'AsyncData': 100,  # 未同步的数据量 （MB）/Unsynchronized Data Amount (MB)
            'ReadeRequestCntFromSnapshot': 101,  # 快照卷上的读请求个数/Read Requests to the Snapshot Volume
            'ReadeRequestCntFromSourceLUN': 102,  # 源LUN上的读请求个数/Read Requests to the Source LUN
            'WriteRequestCntFromSourceLUN': 103,  # 源LUN上的写请求个数/Write Requests to the Source LUN
            'ReadRequestCntSnapshotPool': 104,  # 快照资源池中的读请求个数/Snapshot Pool Read Requests
            'WriteRequestCntSnapshotPool': 105,  # 快照资源池中的写请求个数/Snapshot Pool Write Requests
            'WriteRequestCntMorethanChunk': 106,  # 大于Chunk大小的写请求个数/Writes Requests Exceeding the Chunk Size
            'ChunkCntUsedBySnapshotCopy': 107,  # 快照拷贝中所使用的Chunk的个数/Chunks Used by the Snapshot Copy
            'LocalCacheUsage': 108,  # 本地Cache利用率（%）/Local Cache Usage (%)
            'MirrorCacheUsage': 109,  # 镜像Cache利用率 （%）/Mirror Cache Usage (%)
            'ReadCacheUsage': 110,  # Cache读利用率 （%）/Cache Read Usage (%)
            'Time for Host to Send Data (ms)': 111,  # 主机下发数据的耗时（ms）/Time for Host to Send Data (ms)
            'Time for Saving Write Data (ms)': 112,  # 设备保存写数据的耗时（ms）/Time for Saving Write Data (ms)
            'Time for Releasing Write Request Resources (ms)': 113,
            # 释放写请求资源的耗时（ms）/Time for Releasing Write Request Resources (ms)
            'Time for Executing a Write Request (ms)': 114,
            # 执行读请求的耗时（ms）/Time for Executing a Write Request (ms)
            'Time for Releasing Read Request Resources (ms)': 115,
            # 释放读请求资源的耗时（ms）/Time for Releasing Read Request Resources (ms)
            'Cache Read I/O Latency (ms)': 116,  # Cache读IO响应时间（ms）/Cache Read I/O Latency (ms)
            'Cache Write I/O Latency (ms)': 117,  # Cache写IO响应时间（ms）/Cache Write I/O Latency (ms)
            'Cache Mirror I/O Latency (ms)': 118,  # Cache镜像IO响应时间（ms）/Cache Mirror I/O Latency (ms)
            'Time for Allocating Memory to a Write Request (ms)': 119,
            # 写请求申请内存的耗时（ms）/Time for Allocating Memory to a Write Request (ms)
            'Cache Write Usage (%)': 120,  # Cache写利用率（%）/Cache Write Usage (%)
            'Number of Cache Data Flush I/Os': 121,  # Cache写盘IO数（个）/Number of Cache Data Flush I/Os
            'Number of Cache Data Flush Pages': 122,  # Cache写盘页面数(个)/Number of Cache Data Flush Pages
            'Read Bandwidth (KB/s)': 123,  # 读带宽（KB/s）/Read Bandwidth (KB/s)
            'Write Bandwidth (KB/s)': 124,  # 写带宽 (KB/s)/Write Bandwidth (KB/s)
            'Average Read I/O (Controller A)': 125,
            # 读IO平均大小（A控）（KB）/Average Read I/O Size (Controller A) (KB)
            'Average Write I/O (Controller A)': 126,
            # 写IO平均大小（A控）（KB）/Average Write I/O Size (Controller A) (KB)
            'Max. I/O Latency (Controller A)': 127,  # 最大IO响应时间（A控）（ms）/Max. I/O Latency (Controller A) (ms)
            'Average I/O Latency (Controller A)': 128,
            # 平均IO响应时间（A控）（ms）/Average I/O Latency (Controller A) (ms)
            'Usage Ratio (Controller A)': 129,  # 利用率（A控）（%）/Usage Ratio (Controller A) (%)
            'Queue Length (Controller A)': 130,  # 队列长度（A控）（个）/Queue Length (Controller A)
            'Service Time (Excluding Queue Time) (Controller A)': 131,
            # 服务时间（A控）（ms）/Service Time (Excluding Queue Time) (Controller A) (ms)
            'Number of Combined Read I/Os per Second (Controller A)': 132,
            # 每秒合并读IO的个数（A控）（个/秒）/Number of Combined Read I/Os per Second (Controller A)
            'Number of Combined Write I/Os per Second (Controller A)': 133,
            # 每秒合并写IO的个数（A控）（个/秒）/Number of Combined Write I/Os per Second (Controller A)
            'Read Waiting Time (Controller A) (ms)': 134,
            # 读等待时间（A控）（ms）/Read Waiting Time (Controller A) (ms)
            'Write Waiting Time (Controller A) (ms)': 135,
            # 写等待时间（A控）（ms）/Write Waiting Time (Controller A) (ms)
            'Average I/O Size (Controller A)  (sector)': 136,
            # IO平均大小（A控）(sector)/Average I/O Size (Controller A)  (sector)
            'Average Read I/O (Controller B)': 137,
            # 读IO平均大小（B控）（KB）/Average Read I/O Size (Controller B) (KB)
            'Average Write I/O (Controller B)': 138,
            # 写IO平均大小（B控）（KB）/Average Write I/O Size (Controller B) (KB)
            'Max. I/O Latency (Controller B)': 139,  # 最大IO响应时间（B控）（ms）/Max. I/O Latency (Controller B) (ms)
            'Average I/O Latency (Controller B)': 140,
            # 平均IO响应时间（B控）（ms）/Average I/O Latency (Controller B) (ms)
            'Usage Ratio (Controller B)': 141,  # 利用率（B控）（%）/Usage Ratio (Controller B) (%)
            'Queue Length (Controller B)': 142,  # 队列长度（B控）（个）/Queue Length (Controller B)
            'Service Time (Excluding Queue Time) (Controller B)': 143,
            # 服务时间（B控）（ms）/Service Time (Excluding Queue Time) (Controller B) (ms)
            'Number of Combined Read I/Os per Second (Controller B)': 144,
            # 每秒合并读IO的个数（B控）（个/秒）/Number of Combined Read I/Os per Second (Controller B)
            'Number of Combined Write I/Os per Second (Controller B)': 145,
            # 每秒合并写IO的个数（个/秒）/Number of Combined Write I/Os per Second (Controller B)
            'Read Waiting Time (Controller B) (ms)': 146,
            # 读等待时间（B控）（ms）/Read Waiting Time (Controller B) (ms)
            'Write Waiting Time (Controller B) (ms)': 147,
            # 写等待时间（B控）（ms）/Write Waiting Time (Controller B) (ms)
            'Average I/O Size (Controller B)  (sector)': 148,
            # IO平均大小（B控）(sector)/Average I/O Size (Controller B)  (sector)
            'Read I/O Granularity Distribution: [0K,4K) (%)': 149,
            # 读IO粒度分布：[0K,4K) （%）/Read I/O Granularity Distribution: [0K,4K) (%)
            'Read I/O Granularity Distribution: [4K,8K) (%)': 150,
            # 读IO粒度分布：[4K,8K) （%）/Read I/O Granularity Distribution: [4K,8K) (%)
            'Read I/O Granularity Distribution: [8K,16K) (%)': 151,
            # 读IO粒度分布：[8K,16K) （%）/Read I/O Granularity Distribution: [8K,16K) (%)
            'Read I/O Granularity Distribution: [16K,32K) (%)': 152,
            # 读IO粒度分布：[16K,32K) （%）/Read I/O Granularity Distribution: [16K,32K) (%)
            'Read I/O Granularity Distribution: [32K,64K) (%)': 153,
            # 读IO粒度分布：[32K,64K) （%）/Read I/O Granularity Distribution: [32K,64K) (%)
            'Read I/O Granularity Distribution: [64K,128K) (%)': 154,
            # 读IO粒度分布：[64K,128K) （%）/Read I/O Granularity Distribution: [64K,128K) (%)
            'Read I/O Granularity Distribution: [128K,256K) (%)': 155,
            # 读IO粒度分布：[128K,256K) （%）/Read I/O Granularity Distribution: [128K,256K) (%)
            'Read I/O Granularity Distribution: [256K,512K) (%)': 156,
            # 读IO粒度分布：[256K,512K) （%）/Read I/O Granularity Distribution: [256K,512K) (%)
            'Read I/O Granularity Distribution: [512K,1M) (%)': 157,
            # 读IO粒度分布：[512K,1M)（%）/Read I/O Granularity Distribution: [512K,1M) (%)
            'Read I/O Granularity Distribution: [1M,2M) (%)': 158,
            # 读IO粒度分布：[1M,2M) （%）/Read I/O Granularity Distribution: [1M,2M) (%)
            'Read I/O Granularity Distribution: [2M,+∞) (%)': 159,
            # 读IO粒度分布：[2M,+∞) （%）/Read I/O Granularity Distribution: [2M,+∞) (%)
            'Write I/O Granularity Distribution: [0K,4K) (%)': 160,
            # 写IO粒度分布：[0K,4K) （%）/Write I/O Granularity Distribution: [0K,4K) (%)
            'Write I/O Granularity Distribution: [4K,8K) (%)': 161,
            # 写IO粒度分布：[4K,8K) （%）/Write I/O Granularity Distribution: [4K,8K) (%)
            'Write I/O Granularity Distribution: [8K,16K) (%)': 162,
            # 写IO粒度分布：[8K,16K) （%）/Write I/O Granularity Distribution: [8K,16K) (%)
            'Write I/O Granularity Distribution: [16K,32K) (%)': 163,
            # 写IO粒度分布：[16K,32K) （%）/Write I/O Granularity Distribution: [16K,32K) (%)
            'Write I/O Granularity Distribution: [32K,64K) (%)': 164,
            # 写IO粒度分布：[32K,64K) （%）/Write I/O Granularity Distribution: [32K,64K) (%)
            'Write I/O Granularity Distribution: [64K,128K) (%)': 165,
            # 写IO粒度分布：[64K,128K) （%）/Write I/O Granularity Distribution: [64K,128K) (%)
            'Write I/O Granularity Distribution: [128K,256K) (%)': 166,
            # 写IO粒度分布：[128K,256K) （%）/Write I/O Granularity Distribution: [128K,256K) (%)
            'Write I/O Granularity Distribution: [256K,512K) (%)': 167,
            # 写IO粒度分布：[256K,512K) （%）/Write I/O Granularity Distribution: [256K,512K) (%)
            'Write I/O Granularity Distribution: [512K,1M) (%)': 168,
            # 写IO粒度分布：[512K,1M) （%）/Write I/O Granularity Distribution: [512K,1M) (%)
            'Write I/O Granularity Distribution: [1M,2M) (%)': 169,
            # 写IO粒度分布：[1M,2M) （%）/Write I/O Granularity Distribution: [1M,2M) (%)
            'Write I/O Granularity Distribution: [2M,+∞) (%)': 170,
            # 写IO粒度分布：[2M,+∞) （%）/Write I/O Granularity Distribution: [2M,+∞) (%)
            'Read and Write I/O Granularity Distribution: [0K,4K) (%)': 171,
            # 读写IO粒度分布：[0K,4K) （%）/Read and Write I/O Granularity Distribution: [0K,4K) (%)
            'Read and Write I/O Granularity Distribution: [4K,8K) (%)': 172,
            # 读写IO粒度分布：[4K,8K) （%）/Read and Write I/O Granularity Distribution: [4K,8K) (%)
            'Read and Write I/O Granularity Distribution: [8K,16K) (%)': 173,
            # 读写IO粒度分布：[8K,16K) （%）/Read and Write I/O Granularity Distribution: [8K,16K) (%)
            'Read and Write I/O Granularity Distribution: [16K,32K) (%)': 174,
            # 读写IO粒度分布：[16K,32K) （%）/Read and Write I/O Granularity Distribution: [16K,32K) (%)
            'Read and Write I/O Granularity Distribution: [32K,64K) (%)': 175,
            # 读写IO粒度分布：[32K,64K) （%）/Read and Write I/O Granularity Distribution: [32K,64K) (%)
            'Read and Write I/O Granularity Distribution: [64K,128K) (%)': 176,
            # 读写IO粒度分布：[64K,128K) （%）/Read and Write I/O Granularity Distribution: [64K,128K) (%)
            'Read and Write I/O Granularity Distribution: [128K,256K) (%)': 177,
            # 读写IO粒度分布：[128K,256K) （%）/Read and Write I/O Granularity Distribution: [128K,256K) (%)
            'Read and Write I/O Granularity Distribution: [256K,512K) (%)': 178,
            # 读写IO粒度分布：[256K,512K) （%）/Read and Write I/O Granularity Distribution: [256K,512K) (%)
            'Read and Write I/O Granularity Distribution: ≤ [512K,1M) (%)': 179,
            # 读写IO粒度分布：[512K,1M) （%）/Read and Write I/O Granularity Distribution: ≤ [512K,1M) (%)
            'Read and Write I/O Granularity Distribution: [1M,2M) (%)': 180,
            # 读写IO粒度分布：[1M,2M) （%）/Read and Write I/O Granularity Distribution: [1M,2M) (%)
            'Read and Write I/O Granularity Distribution: [2M,+∞) (%)': 181,
            # 读写IO粒度分布：[2M,+∞) （%）/Read and Write I/O Granularity Distribution: [2M,+∞) (%)
            'OPS': 182,  # OPS/OPS
            'Number of Online User': 183,  # 在线用户数/Number of Online User
            'File Space Hard Quota': 184,  # 硬配额空间容量/File Space Hard Quota
            'Used Capacity': 185,  # 已用容量/Used Capacity
            'Total Capacity': 186,  # 总容量/Total Capacity
            'Dedupe Rate': 187,  # 重删率/Dedupe Rate
            'Packets Transmitted Rate': 188,  # 包传输速率(Packets/s)/Packets Transmitted Rate(Packets/s)
            'Packets Dropped Ratio': 189,  # 丢包率(%)/Packets Dropped Ratio(%)
            'Packets Errors Ratio': 190,  # 错误包率(%)/Packets Errors Ratio(%)
            'Packets Overruns Ratio': 191,  # 包溢出率(%)/Packets Overruns Ratio(%)
            'Disk Busy Ratio': 192,  # 磁盘繁忙度(%)/Disk Busy Ratio(%)
            'Packages Rate': 193,  # 包吞吐率(%)/Packages Rate(%)
            'ATTR_REMOTE_REP_BAND': 194,  # 远程复制带宽（KB/s）/Remote Replicated Bandwidth（KB/S）
            'Max Read I/O Latency': 195,  # 最大读IO响应时间（ms）/Max Read I/O Latency
            'Max Write I/O Latency': 196,  # 最大写IO响应时间（ms）/Max Write I/O Latency
            'Average Read I/O Latency': 197,  # 平均读IO响应时间（ms）/Average Read I/O Latency
            'Average Write I/O Latency': 198,  # 平均写IO响应时间（ms）/Average Write I/O Latency
            'Read I/O Latency Distribution: [0ms,10ms) (%)': 199,
            # 读IO响应时间分布：[0ms,10ms) (%)/Read I/O Latency Distribution: [0ms,10ms) (%)
            'Read I/O Latency Distribution: [10ms,20ms) (%)': 200,
            # 读IO响应时间分布：[10ms,20ms) (%)/Read I/O Latency Distribution: [10ms,20ms) (%)
            'Read I/O Latency Distribution: [20ms,50ms) (%)': 201,
            # 读IO响应时间分布：[20ms,50ms) (%)/Read I/O Latency Distribution: [20ms,50ms) (%)
            'Read I/O Latency Distribution: [50ms,100ms) (%)': 202,
            # 读IO响应时间分布：[50ms,100ms) (%)/Read I/O Latency Distribution: [50ms,100ms) (%)
            'Read I/O Latency Distribution: [100ms,200ms) (%)': 203,
            # 读IO响应时间分布：[100ms,200ms) (%)/Read I/O Latency Distribution: [100ms,200ms) (%)
            'Read I/O Latency Distribution: [200ms,+∞) (%)': 204,
            # 读IO响应时间分布：[200ms,+∞) (%)/Read I/O Latency Distribution: [200ms,+∞) (%)
            'Write I/O Latency Distribution: [0ms,10ms) (%)': 205,
            # 写IO响应时间分布：[0ms,10ms) (%)/Write I/O Latency Distribution: [0ms,10ms) (%)
            'Write I/O Latency Distribution: [10ms,20ms) (%)': 206,
            # 写IO响应时间分布：[10ms,20ms) (%)/Write I/O Latency Distribution: [10ms,20ms) (%)
            'Write I/O Latency Distribution: [20ms,50ms) (%)': 207,
            # 写IO响应时间分布：[20ms,50ms) (%)/Write I/O Latency Distribution: [20ms,50ms) (%)
            'Write I/O Latency Distribution: [50ms,100ms) (%)': 208,
            # 写IO响应时间分布：[50ms,100ms) (%)/Write I/O Latency Distribution: [50ms,100ms) (%)
            'Write I/O Latency Distribution: [100ms,200ms) (%)': 209,
            # 写IO响应时间分布：[100ms,200ms) (%)/Write I/O Latency Distribution: [100ms,200ms) (%)
            'Write I/O Latency Distribution: [200ms,+∞) (%)': 210,
            # 写IO响应时间分布：[200ms,+∞) (%)/Write I/O Latency Distribution: [200ms,+∞) (%)
            'Read and Write I/O Latency Distribution: [0ms,10ms) (%)': 211,
            # 读写IO响应时间分布：[0ms,10ms) (%)/Read and Write I/O Latency Distribution: [0ms,10ms) (%)
            'Read and Write I/O Latency Distribution: [10ms,20ms) (%)': 212,
            # 读写IO响应时间分布：[10ms,20ms) (%)/Read and Write I/O Latency Distribution: [10ms,20ms) (%)
            'Read and Write I/O Latency Distribution: [20ms,50ms) (%)': 213,
            # 读写IO响应时间分布：[20ms,50ms) (%)/Read and Write I/O Latency Distribution: [20ms,50ms) (%)
            'Read and Write I/O Latency Distribution: [50ms,100ms) (%)': 214,
            # 读写IO响应时间分布：[50ms,100ms) (%)/Read and Write I/O Latency Distribution: [50ms,100ms) (%)
            'Read and Write I/O Latency Distribution: [100ms,200ms) (%)': 215,
            # 读写IO响应时间分布：[100ms,200ms) (%)/Read and Write I/O Latency Distribution: [100ms,200ms) (%)
            'Read and Write I/O Latency Distribution: [200ms,+∞) (%)': 216,
            # 读写IO响应时间分布：[200ms,+∞) (%)/Read and Write I/O Latency Distribution: [200ms,+∞) (%)
            'Max CPU Usage': 217,  # 最大CPU利用率（%）/Max CPU Usage
            'Max Memory Usage': 218,  # 最大内存利用率（%）/Max Memory Usage
            'NFS Bandwidth': 219,  # NFS带宽（MB/s）/NFS Bandwidth
            'NFS In Bandwidth': 220,  # in NFS带宽（MB/s）/NFS In Bandwidth
            'NFS Out Bandwidth': 221,  # out NFS带宽（MB/s）/NFS Out Bandwidth
            'CIFS Bandwidth': 222,  # CIFS带宽（MB/s）/CIFS Bandwidth
            'CIFS In Bandwidth': 223,  # in CIFS带宽（MB/s）/CIFS In Bandwidth
            'CIFS Out Bandwidth': 224,  # out CIFS带宽（MB/s）/CIFS Out Bandwidth
            'Connected Client Count': 225,  # 已连接客户端个数（个）/Connected Client Count
            'Connected NFS Client Count': 226,  # NFS已连接客户端个数（个）/Connected NFS Client Count
            'Connected CIFS Client Count': 227,  # CIFS已连接客户端个数（个）/Connected CIFS Client Count
            'Average IO Size': 228,  # 平均IO大小（KB）/Average IO Size
            'Network Packet Rate': 229,  # 网络包流速（个/s）/Network Packet Rate
            'Network Inbound Packet Rate': 230,  # in网络包流速（个/s）/Network Inbound Packet Rate
            'Network Outbound Packet Rate': 231,  # out网络包流速（个/s）/Network Outbound Packet Rate
            'Read OPS': 232,  # 每秒平均得到处理的读请求个数（个/s）/Read OPS
            'Write OPS': 233,  # 每秒平均得到处理的写请求个数（个/s）/Write OPS
            'Average IO Size': 234,  # 读平均IO大小（KB）/Read Average IO Size
            'Average IO Size': 235,  # 写平均IO大小（KB）/Write Average IO Size
            'Band Width': 236,  # 带宽（KB/s)/Band Width（KB/s)
            'Read L2Cache Hit': 237,  # 读L2Cache命中次数（次/秒）/Read L2Cache Hit
            'Read L2Cache NotHit': 238,  # 读L2Cache未命中次数（次/秒）/Read L2Cache NotHit
            'Read L2Cache HitRatio': 239,  # 读L2Cache命中率（%）/Read L2Cache HitRatio
            'Average QueueSize': 240,  # 平均队列深度/Average QueueSize
            'Complete SCSI commands per second': 241,  # 每秒磁盘完成的总SCSI命令/Complete SCSI commands per second
            'Verify commands per second': 242,  # 每秒Verify命令次数/Verify commands per second
            'Disk Total capacity': 243,  # 磁盘的总容量（GB）/Disk Total capacity
            'Disk alloced capacity': 244,  # 磁盘的已用容量（GB）/Disk alloced capacity
            'Disk alloced Usage': 245,  # 已用容量百分比/Disk alloced Usage
            'Disk Free Usage': 246,  # 空闲容量百分比/Disk Free Usage
            'WP Count': 247,  # 脏数据页面数/WP Count
            'WP Limit': 248,  # 脏数据页面限制/WP Limit
            '% WP Utilization': 249,  # 脏数据页面占页面的百分比/% WP Utilization
            '% Cache Used': 250,  # 已经使用的cache百分比/% Cache Used
            'Host Hits/sec': 251,  # 每秒主机发送的读写IO能够立即在cache中找到的数目/Host Hits/sec
            'Host Read Hits/sec': 252,  # 每秒主机发送的读IO能够立即在cache中找到的数目/Host Read Hits/sec
            'Host Write Hits/sec': 253,  # 每秒主机发送的写IO能够立即在cache中找到的数目/Host Write Hits/sec
            'Host Misses/sec': 254,  # 每秒主机发送的读写IO在cache中不能立即找到的数目/Host Misses/sec
            'Host Read Misses/sec': 255,  # 每秒主机发送的读IO在cache中不能立即找到的数目/Host Read Misses/sec
            'Host Write Misses/sec': 256,  # 每秒主机发送的写IO在cache中不能立即找到的数目/Host Write Misses/sec
            'BE Reqs/sec': 257,  # 后端从磁盘到cache完成的读写请求数/BE Reqs/sec
            'BE Read Reqs/sec': 258,  # 后端从磁盘到cache完成的读请求数/BE Read Reqs/sec
            'BE Write Reqs/sec': 259,  # 后端从磁盘到cache完成的写请求数/BE Write Reqs/sec
            'BE MBs transferred/sec': 260,  # 每秒的后端流量/BE MBs transferred/sec
            'BE MBs Read/sec': 261,  # 每秒的后端读流量/BE MBs Read/sec
            'BE MBs Written/sec': 262,  # 每秒的后端写流量/BE MBs Written/sec
            'Read Miss Response Time (ms)': 263,  # 读丢失响应时间/Read Miss Response Time (ms)
            'Write Miss Response Time (ms)': 264,  # 写丢失响应时间/Write Miss Response Time (ms)
            '% Read': 265,  # 读IO占总IO的百分比/% Read
            '% Write': 266,  # 写IO占总IO的百分比/% Write
            '% Read Hit': 267,  # 读IO占总读IO的百分比/% Read Hit
            '% Write Hit': 268,  # 写IO占总写IO的百分比/% Write Hit
            '% Read Miss': 269,  # 读丢失百分比/% Read Miss
            '% Write Miss': 270,  # 写丢失百分比/% Write Miss
            'BE Read Request Time (ms)': 271,  # 后端读请求时间（从磁盘端口到cache）/BE Read Request Time (ms)
            'BE Disk Read Response Time (ms)': 272,  # 后端读响应时间（从磁盘端口到cache）/BE Disk Read Response Time (ms)
            'BE Read Task Time (ms)': 273,  # 后端读请求排队时间/BE Read Task Time (ms)
            'BE Read Response Time (ms)': 274,  # 后端读响应时间（ms）/BE Read Response Time (ms)
            'BE Write Response Time (ms)': 275,  # 后端写响应时间（ms）/BE Write Response Time (ms)
            'BE Avg Response Time (ms)': 276,  # 后端平均响应时间（ms）/BE Avg Response Time (ms)
            'BE % Reads': 277,  # 后端读请求百分比/BE % Reads
            'BE % Writes': 278,  # 后端写请求百分比/BE % Writes
            'Reqs/sec': 279,  # 前端端口到cache之间的数据传输请求数/Reqs/sec
            'Read Reqs/sec': 280,  # 前端端口到cache之间的数据传输读请求数/Read Reqs/sec
            'Write Reqs/sec': 281,  # 前端端口到cache之间的数据传输写请求数/Write Reqs/sec
            'Read Hit Reqs/sec': 282,  # 每秒种所有前端端口发送的读请求直接命中数/Read Hit Reqs/sec
            'Write Hit Reqs/sec': 283,  # 每秒种所有前端端口发送的写请求直接命中数/Write Hit Reqs/sec
            'Miss Req/sec': 284,  # 每秒的请求丢失数/Miss Req/sec
            'Read Miss Reqs/sec': 285,  # 每秒所有的前端端口丢失的总读请求数/Read Miss Reqs/sec
            'Write Miss Reqs/sec': 286,  # 每秒所有的前端端口丢失的总写请求数/Write Miss Reqs/sec
            '% Read Reqs': 287,  # 读请求数占总请求数的百分比/% Read Reqs
            '% Write Reqs': 288,  # 写请求数占总请求数的百分比/% Write Reqs
            '% Hit Reqs': 289,  # 读写请求的命中率百分比/% Hit Reqs
            '% Read Req Hit': 290,  # 读请求的命中率百分比/% Read Req Hit
            'IOs/sec': 291,  # 后端到磁盘的每秒IO数/IOs/sec
            'Reqs/sec': 292,  # 后端端口到cache之间的数据传输请求数/Reqs/sec
            'Read Reqs/sec': 293,  # 后端端口到cache之间的数据传输读请求数/Read Reqs/sec
            'Write Reqs/sec': 294,  # 后端端口到cache之间的数据传输写请求数/Write Reqs/sec
            'MBs/sec': 295,  # 读写流量/MBs/sec
            'Port MBs/sec': 296,  # 端口的读写流量/Port MBs/sec
            'Port IOs/sec': 297,  # 端口的读写IOPS/Port IOs/sec
            'MBs Read/sec': 298,  # 每秒的读流量/MBs Read/sec
            'MBs Written/sec': 299,  # 每秒的写流量/MBs Written/sec
            'Port Avg Req Size': 300,  # 通过端口的平均IO请求数/Port Avg Req Size
            'Max WP Threshold': 301,  # 脏数据页面最大数/Max WP Threshold
            'Random Hits/sec': 302,  # 每秒随机命中数/Random Hits/sec
            '% Hit': 303,  # 命中百分比/% Hit
            '% Miss': 304,  # 未命中率/% Miss
            '% Random Reads': 305,  # 随机读百分比/% Random Reads
            '% Random Writes': 306,  # 随机写百分比/% Random Writes
            'Max IOPS(IO/s)': 307,  # 最大IOPS(个/秒)/Max IOPS(IO/s)
            'Failed IOs': 308,  # 执行失败的总IO数（个）/Failed IOs
            'Failed IOs/sec': 309,  # 每秒的失败IO数（个/秒）/Failed IOs/sec
            'Failed IO Ratio (%)': 310,  # 故障的IO率（%）/Failed IO Ratio (%)
            'Throughput': 311,  # 吞吐量（MB/s）/Throughput(MB/s)
            'ReadThroughput': 312,  # 读吞吐量（MB/s）/Read Throughput(MB/s)
            'WirteThroughput': 313,  # 写吞吐量（MB/s）/Write Throughput(MB/s)
            'util%': 314,  # 磁盘活动时间百分比（百分比）/util%
            'Extent fragmentation-smaller than 8blk': 315,
            # 小于8blk的extent百分比/Extent fragmentation-smaller than 8blk
            'Extent fragmentation-smaller than 64blk': 316,
            # 小于64blk的extent百分比/Extent fragmentation-smaller than 64blk
            'Extent fragmentation-larger than 64blk': 317,
            # 大于64blk的extent百分比/Extent fragmentation-larger than 64blk
            'usr%': 318,  # 用户使用率（百分比）/usr%
            'sys%': 319,  # 系统使用率（百分比）/sys%
            'wait%': 320,  # io-wait使用率（百分比）/wait%
            'idle%': 321,  # 空闲率（百分比）/idle%
            'hiq%': 322,  # 硬中断使用率 （百分比）/hiq%
            'siq%': 323,  # 软中断使用率（百分比）/siq%
            'Swap Use': 324,  # 交换分区使用量（MB）/Swap Use
            'Swap Free': 325,  # 交换分区未使用量（MB）/Swap Free
            'Memory Use': 326,  # 内存使用量（MB）/Memory Use
            'Memory Buffer': 327,  # 内存写缓存（MB）/Memory Buffer
            'Memory Cache': 328,  # 内存读缓存（MB）/Memory Cache
            'Memory Free': 329,  # 内存剩余量（MB）/Memory Free
            'Memory Dirty Page': 330,  # 脏内存量（MB）/Memory Dirty Page
            'Network Error Inbound Packets': 331,  # 错误进包数（Packets/s）/Network Error Inbound Packets
            'Network Error Outbound Packets': 332,  # 错误出包数（Packets/s）/Network Error Outbound Packets
            'CacheWater': 333,  # Cache水位（百分比）/Cache Water(%)
            'Total MBs Read': 334,  # 指定时间段的读流量/Total read MBs in special period
            'Total MBs Write': 335  # 指定时间段的写流量/Total write MBs in special period
        }

        '''
        '''
        PRODUCT_MODE_E = {
            'V1500': 0,  # V1500/V1500
            'V1800': 1,  # V1800/V1800
            'S2100': 2,  # S2100/S2100
            'S2300': 3,  # S2300/S2300
            'S5100': 4,  # S5100/S5100
            'S5300': 5,  # S5300/S5300
            'S5500': 6,  # S5500/S5500
            'S5600': 7,  # S5600/S5600
            'VIS': 8,  # VIS/VIS
            'S2600': 9,  # S2600/S2600
            'S6800E': 10,  # S6800E/S6800E
            'V1500N': 11,  # V1500N/V1500N
            'S2300E': 12,  # S2300E/S2300E
            'COMMON': 13,  # COMMON(插框混用)/COMMON
            'N8000': 15,  # N8000/N8000
            'S6900': 16,  # S6900/S6900
            'S3900': 17,  # S3900/S3900
            'S5500T': 18,  # S5500T/S5500T
            'S5600T': 19,  # S5600T/S5600T
            'S6800T': 20,  # S6800T/S6800T
            'S6900_M100': 21,  # S6900-M100/S6900-M100
            'S3900_M200': 22,  # S3900-M200/S3900-M200
            'S3900_M300': 23,  # S3900-M300/S3900-M300
            'S5900_M100': 24,  # S5900-M100/S5900-M100
            'S8100': 25,  # S8100/S8100
            'S5800T': 26,  # S5800T/S5800T
            'V1600N': 27,  # V1600N/V1600N
            'S5900_M200': 28,  # S5900-M200/S5900-M200
            'N8001': 29,  # N8001/N8001
            'S2600T': 30,  # S2600T/S2600T
            'S8000_I': 31,  # S8000-I/S8000-I
            'Dorado5100': 32,  # Dorado5100/Dorado5100
            'T3200': 33,  # T3200/T3200
            'T3500': 34,  # T3500/T3500
            'N8000-R710': 35,  # N8000-R710/N8000-R710
            'N8000-C2': 36,  # N8000-C2/N8000-C2
            'N8000-C2-SYMC': 40,  # N8000-C2-SYMC/N8000-C2-SYMC
            'VTL': 41,  # VTL/VTL
            'S2900': 42,  # S2900/S2900
            'S2200T': 43,  # S2200T/S2200T
            'Dorado2100 G2': 44,  # Dorado2100 G2/Dorado2100 G2
            'VIS 6000': 45,  # VIS 6000/VIS 6000
            'HVS85T': 46,  # HVS85T/HVS85T
            'HVS88T': 47,  # HVS88T/HVS88T
            '9000': 48,  # 9000/9000
            'T3200 G2': 49,  # T3200 G2/T3200 G2
            'T3500 G2': 50,  # T3500 G2/T3500 G2
            'T3200 G3': 51,  # T3200 G3/T3200 G3
            'T3500 G3': 52,  # T3500 G3/T3500 G3
            'S5700': 53,  # S5700/S5700
            'CE6800': 54,  # CE6800/CE6800
            'CE12800': 55,  # CE12800/CE12800
            'HVS_18800F': 56,  # HVS的纯SSD盘版本/18800F
            'HVS_18500': 57,  # HVS的18500型号/18500
            'HVS_18800': 58,  # HVS的18800型号/18800
            'SSS': 60,  # SSS/SSS
            '6800V3': 61,  # 中低端V3/6800V3-6U-2/4C
            '6900V3': 62,  # 中低端V3/6900V3-6U-4C
            '5600V3': 63,  # 中低端V3/5600V3-3U2C
            '5800V3': 64,  # 中低端V3/5800V3-3U2C
            'T3200 MINI': 65,  # T3200/T3200/9000 C01版本(建行项目新增)
            'WUSHAN_SQL': 66,  # WUSHAN_SQL/WUSHAN_SQL/9000 C10版本
            'WUSHAN_HD': 67,  # WUSHAN_HD/WUSHAN_HD/9000 C10版本
            '5500V3': 68,  # 5500 V3/5500 V3/2U盘控一体 5500 V3
            '2600V3': 69,  # 2600 V3/2600 V3/2U盘控一体 2600 V3
            '5300V3': 70,  # 5300 V3/5300 V3/2U盘控一体 5300 V3
            '2800V3': 71,  # 2800 V3/2800 V3/2U盘控一体 2800 V3
            '18500V3': 72,  # 18500 V3/18500 V3/6U独立机头
            '18800V3': 73,  # 18800 V3/18800 V3/6U独立机头
            'N5000': 401,  # N5000/N5000
            'VIS8200': 800,  # VIS8200/VIS8200
            'VIS8400': 801,  # VIS8400/VIS8400
            'VIS8600': 802,  # VIS8600/VIS8600
            'VIS8800': 803  # VIS8800/VIS8800
        }

        '''
        '''
        CONFIG_MODEL_E = {
            'SINGLE_CTRL': 0,
            'MULTI_CTRL': 1,
        }

        '''
        '''
        LICENSE_FEATURE_E = {
            'LUNMapping': 0,  # 支持LUN映射数/LUN Mapping
            'MemberDisks': 1,  # 支持的磁盘数/Member Disks
            'HyperSnap': 2,  # 快照/HyperSnap
            'HyperClone': 3,  # 克隆/HyperClone
            'HyperCopy': 4,  # LUN拷贝/HyperCopy
            'LUNMigration': 5,  # LUN迁移/LUN Migration
            'SynchronousRemoteMirror': 6,  # 同步远程复制/Synchronous Remote Mirror
            'AsynchronousRemoteMirror': 7,  # 异步远程复制/Asynchronous Remote Mirror
            'ExpandedCopy': 8,  # 扩展拷贝/Expanded Copy
            'SmartCache': 9,  # 智能数据缓存/SmartCache
            'ThinProvisioning': 10,  # 精简配置/ThinProvisioning
            'SmartTier': 20,  # 智能数据分级/SmartTier
            'SmartMotion': 21,  # 智能数据迅移/SmartMotion
            'SmartQoS': 22,  # 智能服务质量控制/SmartQoS
            'SmartDedup': 23,  # 智能重复数据删除/SmartDedup
            'HyperReplication': 24,  # 远程复制/HyperReplication
            'SmartThin': 25,  # 智能精简配置/SmartThin
            'XVESystem': 27,  # XVE系统软件/XVE System
            'ManagementConsole': 28,  # 管理软件/Management Console
            'SmartVirtualization': 29,  # 智能异构虚拟化/SmartVirtulication
            'HyperSoftwareSuite': 30,  # 增值套件/Hyper software suite
            'SmartCache-SmartTier': 31,  # 智能分级与缓存/SmartCache&SmartTier
            'SmartQuota': 32,  # 配额管理/SmartQuota
            'LoadBalance': 33,  # 负载均衡/LoadBalance
            'WFS': 34,  # 巫山文件系统/Wushan FileSystem
            'HVS_BASIC_NLSAS': 35,  # HVS基础软件包，NL-SAS，默认容量许可：1TB/HVS Basic,NL-SAS,1TB
            'HVS_BASIC_SSD_SAS': 36,  # HVS基础软件包，SSD&SAS，默认容量许可：1TB/HVS Basic,SSD&SAS,1TB
            'HVS_ADVANCED_NLSAS': 37,  # HVS高级软件包，NL-SAS，默认容量许可：1TB/HVS Advanced,NL-SAS,1TB
            'HVS_ADVANCED_SSD_SAS': 38,  # HVS高级软件包，SSD&SAS，默认容量许可：1TB/HVS Advanced,SSD&SAS,1TB
            'SmartCompression': 39,  # 智能数据压缩/SmartCompression
            'SmartPartition': 40,  # 智能缓存分区/SmartPartition
            'HyperShredder': 41,  # 数据销毁/HyperShredder
            'SystemReporter': 42  # System Reporter/System Reporter
        }

        '''
        '''
        HEALTH_STATUS_E = {
            'UNKNOWN': 0,  # 未知/--
            'NORMAL': 1,  # 正常/Normal
            'FAULT': 2,  # 故障/Fault
            'PRE_FAIL': 3,  # 即将故障/Pre-Fail
            'PART_BROKEN': 4,  # 部分损坏/partially broken
            'DEGRADE': 5,  # 降级/Degraded
            'HAS_BAD_BLOCK': 6,  # 有坏块/Bad sectors found
            'HAS_ERR_CODE': 7,  # 有误码/Bit errors found
            'CONSISTENT': 8,  # 一致/Consistent
            'INCONSISTENT': 9,  # 不一致/Inconsistent
            'BUSY': 10,  # 繁忙/Busy
            'POWER_NO_INPUT': 11,  # 无输入/No input
            'POWER_NOT_ENOUGH': 12,  # 电量不足/Low battery
            'SINGLE_LINK_FAULT': 13,  # 单链路故障/Single link fault
            'INVALID': 14,  # 失效/invalid
            'WRITE_PROTECT': 15  # /write protect
        }

        '''
        '''
        RUNNING_STATUS_E = {
            'UNKNOWN': 0,  # 未知/--
            'NORMAL': 1,  # 正常/Normal
            'RUNNING': 2,  # 运行/Running
            'NOT_RUNNING': 3,  # 未运行/Not running
            'NOT_EXIST': 4,  # 不存在/Not existed
            'HIGH_TEMPERATURE_SLEEP': 5,  # 高温休眠/Sleep in high temperature
            'STARTING': 6,  # 正在启动/Starting
            'POWER_FAILURE_PROTECTING': 7,  # 掉电保护/Power failure protection
            'SLEEPING': 8,  # 休眠/Spin down
            'SPINGUP': 9,  # 已启动/Started
            'LINK_UP': 10,  # 已连接/Link Up
            'LINK_DOWN': 11,  # 未连接/Link Down
            'POWER_ON': 12,  # 正在上电/Powering on
            'POWER_OFF': 13,  # 已下电/Powered off
            'PRE_COPY': 14,  # 预拷贝/Precopy
            'COPYBACK': 15,  # 回拷/Copyback
            'RECONSTRUCTION': 16,  # 重构/Reconstruction
            'EXPANSION': 17,  # 扩容/Expansion
            'NOT_FORMAT': 18,  # 未格式化/Unformatted
            'FORMATTING': 19,  # 正在格式化/Formatting
            'UNMAPPING': 20,  # 未映射/Unmapped
            'INITIAL_SYNCHRONIZING': 21,  # 正在初始同步/Initial synchronizing
            'CONSISTENT': 22,  # 数据一致/Consistent
            'SYNCHRONIZING': 23,  # 正在同步/Synchronizing
            'SYNCHRONIZED': 24,  # 已同步/Synchronized
            'NOT_SYNCHRONIZED': 25,  # 未同步/Unsynchronized
            'SPLIT': 26,  # 已分裂/Splited
            'ONLINE': 27,  # 在线/Online
            'OFFLINE': 28,  # 离线/Offline
            'LOCKED': 29,  # 已锁定/Locked
            'ENABLE': 30,  # 已启用/Enabled
            'DISABLED': 31,  # 已禁用/Disabled
            'LEVELING': 32,  # 正在均衡/balancing
            'TO_BE_RECOVERD': 33,  # 待恢复/To be recovered
            'INTERRUPTED': 34,  # 异常断开/Interrupted
            'INVALID': 35,  # 失效/Invalid
            'NOSTART': 36,  # 新创建/Not start
            'QUEUING': 37,  # 正在排队/Queuing
            'STOP': 38,  # 已停止/Stopped
            'COPYING': 39,  # 正在拷贝/Copying
            'COMPLETED': 40,  # 拷贝完成/Completed
            'PAUSE': 41,  # 暂停/Paused
            'REVSYNCHRONIZING': 42,  # 正在反向同步/Reverse synchronizing
            'ACTIVATED': 43,  # 已激活/Activated
            'ROLLBACK': 44,  # 正在回滚/Restore
            'INACTIVATED': 45,  # 未激活/Inactive
            'IDLE': 46,  # 等待/Idle
            'POWERING_OFF': 47,  # 正在下电/Powering off
            'CHARGING': 48,  # 正在充电/Charging
            'CHARGED': 49,  # 充电完成/Charging completed
            'DISCHARGING': 50,  # 正在放电/Discharging
            'UPGRADING': 51,  # 正在升级/Upgrading
            'POWER_LOST': 52,  # 掉电中/Power Lost
            'INITIALIZING': 53,  # 初始化中/Initializing
            'APPLY_CONFIG_CHANGE': 54,  # 正在应用变更/Apply Change
            'ONLINE_DISABLE': 55,  # 在线禁用/online disable
            'OFFLINE_DISABLE': 56,  # 离线禁用/Offline disable
            'ONLINE_FROZEN': 57,  # 在线冻结/online frozen
            'OFFLINE_FROZEN': 58,  # 离线冻结/offline frozen
            'CLOSED': 59,  # 已关闭/closed
            'REMOVING': 60,  # (节点)删除中/removing
            'INSERVICE': 61,  # 服务中/in service
            'OUTOFSERVICE': 62,  # 退出服务/out of service
            'ERASEMENT_RUNNING_NORMAL': 63,  # 正在销毁/Running normal
            'ERASEMENT_RUNNING_FAIL': 64,  # 销毁失败/Running fail
            'ERASEMENT_RUNNING_SUCCESS': 65,  # 销毁成功/Running success
            'SUCCESS': 66,  # 任务执行成功/Running success
            'FAILED': 67,  # 任务执行失败/Running failed
            'WAITING': 68,  # 任务正在等待/Waiting
            'CANCELLING': 69,  # 任务正在取消/Cancelling
            'CANCELLED': 70,  # 任务已取消/Cancelled
            'RUNNING_PREPARE_SYNC': 71,  # 在线|即将灾备同步/About to synchronize
            'RUNNING_SYNCHRONINING': 72,  # 在线|正在灾备同步/Synchronizing data
            'RUNNING_SYNC_FAILED': 73,  # 在线|灾备同步失败/Failed to synchronize
            'MIGRATION_FAULT': 74,  # 迁移故障/MIGRATION_FAULT
            'MiGRATING': 75,  # 迁移中/MiGRATING
            'MIGRATION_COMPLETED': 76,  # 迁移完成/MIGRATION_COMPLETED
            'POWER_ON_FAILED': 103  # 上电失败
        }

        '''
        '''
        EVENT_LEVEL_E = {
            'Info': 2,  # 提示/Info
            'Warning': 3,  # 警告/Warning
            'Major': 5,  # 重要/Major
            'Critical': 6  # 紧急/Critical
        }

        '''
        '''
        LUN_ALLOC_TYPE_E = {
            'FAT': 0,  # Thick LUN/Thick LUN
            'THIN': 1  # Thin LUN/Thin LUN
        }

        '''
        '''
        IO_TYPE_E = {
            'READ': 0,  # 读I/O/Read I/O
            'WRITE': 1,  # 写I/O/Write I/O
            'READ_WRITE': 2  # 读I/O和写I/O/Read I/O and Write I/O
        }

        '''
        '''
        IOCLASS_SCHEDULE_POLICY_E = {
            'ONCE': 0,  # 调度一次/
            'DAILY': 1,  # 每日调度/
            'WEEKLY': 2  # 按周调度/
        }

        '''
        '''
        IOCLASS_PRIORITY_E = {
            'NORMAL': 0,  # 正常/Normal
            'HIGH': 1  # 高/High
        }

        '''
        '''
        SNAP_BELONG_E = {
            'PUBLIC': 1,  # 公有快照/Public
            'PRIVATE': 2  # 私有快照/Private
        }

        '''
        '''
        SNAP_SPEED_E = {
            'SPEED_LEVEL_LOW': 1,  # 低/Low
            'SPEED_LEVEL_MIDDLE': 2,  # 中/Middle
            'SPEED_LEVEL_HIGH': 3,  # 高/High
            'SPEED_LEVEL_ASAP': 4  # 最高/Asap
        }

        '''
        '''
        ENCLOSURE_MODEL_E = {
            'CTRL_BMC': 0,  # BMC控制框/
            'CTRL_SAS2U_12': 1,  # 2U SAS 12盘主控框/
            'CTRL_SAS2U_24': 2,  # 2U SAS 24盘主控框/
            'EXPSAS2U_12': 16,  # 2U SAS 12盘级联框/
            'EXPSAS2U_24': 17,  # 2U SAS 24盘级联框/
            'EXPSAS4U': 18,  # 4U 6Gbit/s SAS 24盘位 3.5英寸 硬盘框/
            'EXPFC': 19,  # 4U FC 24盘级联框/
            'DSW_PCIe1U': 20,  # 1U PCIe数据交换机/
            'EXPSAS4U_75': 21,  # 4U SAS 75盘级联框/
            'SVP': 22,  # SVP/SVP Controller Enclosure
            'CTRL_6U': 97,  # 6U 4控独立机头/
            'CTRL_3U': 96,  # 3U 2控独立机头/
            'EXPSAS2U_25': 24,  # 2U 6Gbit/s SAS 25盘位 2.5英寸 硬盘框/
            'EXPSAS4U_24_NEW': 25,  # 4U SAS 24盘3.5寸磁盘框（新）/
            'CTRL_12GSAS_2U25_EAR': 26,  # 2U 12GSAS 25盘主控框/
            'CTRL_12GSAS_2U12_EAR': 23,  # 2U 12GSAS 12盘主控框/
            'ARM_2U_12': 37,  # 2U 12GSAS 12盘ARM主控框/
            'ARM_2U_25': 38,  # 2U 12GSAS 25盘ARM主控框/
            'ENCLOSURE_MODEL_EXPSAS2U_25_12GLINK': 65,  # 2U SSD 25盘2.5寸级联框/
            'CTRL_12GSAS_4U24_EAR_12GLINK': 66,  # 4U SSD 24盘3.5寸级联框/
            'EXP_SAS2U_25': 67,  # 2U SAS 25盘位 2.5英寸 硬盘框/
            'EXP_SAS4U_24': 69,  # 4U SAS 24盘位 3.5英寸 硬盘框/
            'EXP_12G_SAS_4U_75': 39,  # 12G 4U SAS 75盘 3.5寸级联框/
            'CTRL_12GSAS_2U25_EAR_12GLINK': 40,  # 2U 12G SAS 25盘主控框/
            'CTRL_NVMe2U_24': 99,  # 2U NVMe 2.5寸主控框/
            'EXP2U_JBOF': 101,  # 2U JBOF硬盘框/
            'CTRL_4U_4C': 112,  # 4U 四控 控制框/
            'CTRL_SAS2U_2C_25_MID': 113,  # 中端 2U 双控 SAS 25盘位 2.5英寸 控制框/
            'CTRL_SAS2U_2C_12_MID': 114,  # 中端 2U 双控 SAS 12盘位 2.5英寸 控制框/
            'CTRL_NVMe2U_2C_36': 115,  # 2U 双控 NVMe 36盘位 控制框/
            'CTRL_SAS2U_2C_25_LOW': 116,  # 低端 2U 双控 SAS 25盘位 2.5英寸 控制框/
            'CTRL_SAS2U_2C_12_LOW': 117,  # 低端 2U 双控 SAS 12盘位 2.5英寸 控制框/
            'EXP_IPSAS_2U_25': 118,  # 2U IP SAS 25盘位 2.5英寸 硬盘框/
            'EXP_IPSAS_2U_12': 119,  # 2U IP SAS 12盘位 3.5英寸 硬盘框/
            'EXP_IPNVMe_2U_36': 120,  # 2U IP NVMe 36盘位 硬盘框/
        }

        '''
        '''
        ENCLOSURE_TYPE_E = {
            'EXP': 0,  # 级联框（硬盘框）/
            'CTRL': 1,  # 控制框/
            'DSW': 2,  # 数据交换机/
            'MSW': 3,  # 管理交换机/
            'SVP': 4  # 管理服务器/
        }

        '''
        '''
        INTF_MODEL_E = {
            'FC_4X4G': 1,  # 4x4G FC接口模块/4x4G FC Interface Module
            'FC_2X4G': 2,  # 2x4G FC接口模块/2x4G FC Interface Module
            'GE_RJ45_2X': 3,  # 2xGE 电接口模块/2xGE Electrical Interface Module
            'SASI_4X': 4,  # 4xSAS I 接口模块/4xSAS I Interface Module
            'FC_4X4G_EXPAND': 5,  # Swapped FC接口模块/Swapped FC Interface Module
            'ETH10G_2': 6,  # 2x10GE 光接口模块/2x10GE Optical Interface Module
            'FC_1X8G': 7,  # 1x8G FC光接口模块/1x8G FC Optical Interface Module
            'FC_2X8G': 8,  # 2x8G FC光接口模块/2x8G FC Optical Interface Module
            'SASII_2X': 9,  # 2xSAS II电接口模块/2xSAS II Electrical Interface Module
            'SASII_4X': 10,  # 4xSAS II电接口模块/4xSAS II Electrical Interface Module
            'Combo_2FCx2GE': 11,  # 2xFC+2xGE 接口模块/2xFC+2xGE Interface Module
            'iSCSI_4X': 12,  # 4xGE 电接口模块/4xGE Electrical Interface Module
            'FC_4X8G': 13,  # 4x8G FC光接口模块/4x8G FC Optical Interface Module
            'MINISAS_4X': 16,  # 4xmini-SAS接口模块/4x mini-SAS Interface Module
            'FCoE_4X': 21,  # 4x10G FCoE光接口模块/4x10G Optical Interface Module
            'SASA_2X6G': 22,  # 2x6G SASA接口模块/2x6G SASA Interface Module
            'SASB_2X6G': 23,  # 2x6G SASB接口模块/2x6G SASB Interface Module
            'ManagerBoard': 24,  # 管理板/Management Board
            'TOE': 25,  # 4x10GE接口模块/4x10GE Interface Module
            'PCIe_2X5G': 26,  # 2x5Gbps PCIe接口模块/2x5Gbps PCIe Interface Module
            'FCoE_2X': 27,  # 2x10G FCoE光接口模块/2x10G Optical Interface Module
            'iSCSI_4XGE': 28,  # 4xGE Optical Interface Module/4xGE光接口模块
            'FC_2X16G': 29,  # 2x16G FC Optical Interface Module/2x16G FC光接口模块
            'SAS_4X12G': 30,  # 4x12SAS QSFP Interface Module/4x12G SAS光电接口模块
            'iSCSI_4X10': 31,  # 4x10GE Electrical Interface Module/4x10GE 电接口模块
            'IB_2x40G': 32,  # 2x40GE Infiniband Interface Module/2x40GE IB接口模块
            'IB_2x56G': 33,  # 2x56GE Infiniband Interface Module/2x56GE IB接口模块
            'GE_RJ45_4X': 34,  # 4xGE Electrical Interface Module/4xGE 电接口模块
            'AccerationEngineCard': 35,  # Express Module(ACC，Acceration engine)/重删压缩加速卡
            'IOC_4X10G_RJ45': 36,  # 4x10GE Electrical Interface Module/4x10GE 电接口模块
            'IOC_4XSMART': 37,  # 4xSMART Optical Interface Module/4xSmart 光接口模块
            'IOC_8X8G_FC': 38,  # 8x8G FC Optical Interface Module/8x8G FC光接口模块
            'IOC_4X8G_FC': 39,  # 4x8G FC Optical Interface Module/4x8G FC光接口卡
            'IOC_4X16G_FC': 40,  # 4x16G FC Optical Interface Module/4x16G FC光接口卡
            'SAS_12PORT_BACKEND_MODULE': 41,
            # 12 port 4*12Gb SAS Back-End Interconnect I/O Module/12端口4*12Gb SAS后端全互联IO模块
        }

        '''
        '''
        INI_OR_TGT_E = {
            'INI': 2,  # 启动器/
            'TGT': 3,  # 目标器/
            'INI_AND_TGT': 4  # 启动器和目标器/
        }

        '''
        '''
        DISK_TYPE_E = {
            'FC': 0,  # FC/FC
            'SAS': 1,  # SAS/SAS
            'SATA': 2,  # SATA/SATA
            'SSD': 3,  # SSD/SSD
            'NL_SAS': 4,  # NL_SAS/NL_SAS
            'SLC_SSD': 5,  # SLC SSD/SLC SSD
            'MLC_SSD': 6,  # MLC SSD/MLC SSD
            'FC_SED': 7,  # FC_SED/FC_SED
            'SAS_SED': 8,  # SAS_SED/SAS_SED
            'SATA_SED': 9,  # SATA_SED/SATA_SED
            'SSD_SED': 10,  # SSD_SED/SSD_SED
            'NL_SAS_SED': 11,  # NL_SAS_SED/NL_SAS_SED
            'SLC_SSD_SED': 12,  # SLC_SSD_SED/SLC_SSD_SED
            'MLC_SSD_SED': 13,  # MLC_SSD_SED/MLC_SSD_SED
            'NVME_SSD': 14,  # NVME_SSD/NVME_SSD
            'NVME_SSD_SED': 16,  # NVME_SSD_SED/NVME_SSD_SED
            'SCM': 17,  # SCM/SCM
            'SCM_SED': 18,  # SCM_SED/SCM_SED
        }

        '''
        '''
        DISK_LIGHT_STATUS_E = {
            'OFF': 0,  # /
            'ON': 1  # /
        }

        '''
        '''
        DISK_LOGIC_TYPE_E = {
            'FREE': 1,  # 空闲盘/
            'MEMBER': 2,  # 成员盘/
            'SPARE': 3,  # 热备盘/
            'CACHE': 4  # 缓存盘/
        }

        '''
        '''
        POWER_TYPE_E = {
            'DC': 0,  # /
            'AC': 1  # /
        }

        '''
        '''
        BACKUP_POWER_TYPE_E = {
            'BBU': 0  # /
        }

        '''
        '''
        PORT_LOGIC_TYPE_E = {
            'HOST': 0,  # 主机端口/业务端口/
            'EXP': 1,  # 级联端口/
            'MNGT': 2,  # 管理端口/
            'INNER': 3,  # 内部端口/
            'MAINTENANCE': 4,  # 维护端口/
            'MNGT_SRV': 5,  # 管理/业务混合口/
            'MAINTENANCE_SRV': 6,  # 维护/业务混合口/
            'BACKUP_MGR': 7,  # 备份管理网口/
            'PRODUCT_STORAGE': 8,  # 生产存储网口/
            'BACKUP_STORAGE': 9,  # 备份存储网口/
            'ETH_NOT_CONFIG': 10,  # 未配置角色网口/
            'IP_SCALE_OUT': 11  # IP Scale Out接口卡网口
        }

        '''
        '''
        PORT_SFP_STATUS_E = {
            'NO_NEED': 0,  # 端口没有光模块/
            'OFFLINE': 1,  # 离线/
            'ONLINE': 2  # 在线/
        }

        '''
        '''
        FC_PORT_MODE_E = {
            'FABRIC': 0,  # Fabric/Fabric
            'LOOP': 1,  # FC-AL/FC-AL
            'POINT2POINT': 2,  # P2P/P2P
            'AUTO': 3  # Auto/Auto
        }

        '''
        '''
        ETH_PORT_DUPLEX_E = {
            'HALF_DUPLEX': 1,  # 半双工/
            'DUPLEX': 2,  # 全双工/
            'AUTO': 3  # 自协商/
        }

        '''
        '''
        FAN_LEVEL_E = {
            'LOW': 0,  # 低/
            'NORMAL': 1,  # 正常/
            'HIGH': 2  # 高/
        }

        '''
        '''
        USER_LEVEL_E = {
            'SUPER_ADMIN': 1,  # 超级管理员/
            'ADMIN': 2,  # 管理员/
            'READONLY': 3,  # 只读用户/
            'RESOURCE_ADMIN': 4,  # 资源管理员/
            'DEVICE_ADMIN': 5,  # 设备管理员/
            'TENENT_ADMIN': 6  # 租户管理员/
        }

        '''
        '''
        USER_STATE_E = {
            'OFF_LINE': 0,  # 离线/
            'ON_LINE': 1,  # 在线/
            'LOCKED': 2,  # 用户被锁定/
            'PWD_EXPIRED': 3,  # 密码过期/
            'PWD_INITIAL': 4,  # 用户密码处于初始化状态，需要修改/
            'PWD_EXPIRING': 5  # 密码即将到期/
        }

        '''
        '''
        USER_SCOPE_E = {
            'LOCAL': 0,  # 本地用户/Local
            'LDAP': 1,  # LDAP用戶/LDAP User
            'LDAP_GROUP': 2,  # LDAP用户组/LDAP User Group
            'SFTP_USER': 3,  # SFTP用户/SFTP User
            'M2M_USER': 4  # 机机交互用户/Machine to Machine User
        }

        '''
        '''
        DOMAIN_AUTH_SERVICE_TYPE_E = {
            'LDAP': 0  # ldap验证/
        }

        '''
        '''
        SPEED_LEVEL_3_E = {
            'LOW': 1,  # 低/low
            'MEDIUM': 2,  # 中/medium
            'HIGH': 3  # 高/high
        }

        '''
        '''
        DST_RUNNING_STATUS_E = {
            'READY': 1,  # 准备/Ready
            'MIGRATING': 2,  # 迁移/Migrating
            'PAUSED': 3  # 暂停/Paused
        }

        '''
        '''
        PREDICTION_SWITCH_E = {
            'ON': 1,  # 开/On
            'OFF': 2  # 关/Off
        }

        '''
        '''
        MIGRATION_MODE_E = {
            'AUTO': 1,  # 定时/Schedule
            'MANUAL': 2  # 手动/Manual
        }

        '''
        '''
        TRIGGER_MODE_E = {
            'AUTO': 1,  # 自动/Auto
            'SCHEDULE': 2,  # 定时/Schedule
            'MANUAL': 3  # 手动/Manual
        }

        '''
        '''
        HIBERNATE_MANNER_E = {
            'STOP_RUNNING': 1,  # 停转/Stop Running
            'POWEROFF': 2  # 下电/Power Off
        }

        '''
        '''
        HOTSPARE_SPACE_STRATEGY_E = {
            'LOW': 1,  # 低/Low
            'HIGH': 2,  # 高/High
            'NONE': 3  # 无/None
        }

        '''
        '''
        DST_STATUS_E = {
            'ACTIVE': 1,  # 激活/active
            'INACTIVE': 2  # 未激活/inactive
        }

        '''
        '''
        SWITCH_E = {
            'ON': 1,  # 开/on
            'OFF': 2  # 关/off
        }

        '''
        '''
        BST_TYPE_E = {
            'LOGIC_BST': 1,  # 逻辑坏扇区/
            'PHYSICAL_BST': 2  # 物理坏扇区/
        }

        '''
        '''
        TASK_TYPE_E = {
            'TASK_PRECOPY': 1,  # 预拷贝/Precopy
            'TASK_RECONSTRUCT': 2,  # 重构/Reconstruct
            'TASK_MIGRATION': 3,  # 迁移/Migration
            'TASK_FORMAT': 4  # 格式化/Format
        }

        '''
        '''
        LUN_STRIPE_UNIT_SIZE_E = {
            'LUN_STRIPE_UNIT_SIZE_8K': 8,  # 分条深度为8KB/
            'LUN_STRIPE_UNIT_SIZE_16K': 16,  # 分条深度为16KB/
            'LUN_STRIPE_UNIT_SIZE_32K': 32,  # 分条深度为32KB/
            'LUN_STRIPE_UNIT_SIZE_64K': 64,  # 分条深度为64KB/
            'LUN_STRIPE_UNIT_SIZE_128K': 128,  # 分条深度为128KB/
            'LUN_STRIPE_UNIT_SIZE_256K': 256,  # 分条深度为256KB/
            'LUN_STRIPE_UNIT_SIZE_512K': 512,  # 分条深度为512KB/
            'LUN_STRIPE_UNIT_SIZE_1024K': 1024  # 分条深度为1024KB/
        }

        '''
        '''
        CACHE_WRITE_BACK_E = {
            'WRITE_BACK': 1,  # 回写/
            'WRITE_THROUGH': 2,  # 透写/
            'WRITE_BACK_MANDATORY': 3,  # 强制回写/
            'MIXED': 4  # 混合/
        }

        '''
        '''
        CACHE_MIRROR_STATUS_E = {
            'CACHE_MIRROR_DISABLE': 0,  # 非镜像/
            'CACHE_MIRROR_ENABLE': 1  # 镜像/
        }

        '''
        '''
        CACHE_READ_AHEAD_STRATEGY_E = {
            'CACHE_READ_AHEAD_STRATEGY_NOTHING': 0,  # 不预取/
            'CACHE_READ_AHEAD_STRATEGY_FASTNESS': 1,  # 固定预取/
            'CACHE_READ_AHEAD_STRATEGY_MULTIPLIER': 2,  # 可变预取/
            'CACHE_READ_AHEAD_STRATEGY_INTELLIGENT': 3  # 只能预取/
        }

        '''
        '''
        RAID_LEVEL_E = {
            'RAID_LEVEL_NONE': 0,  # /NONE
            'RAID_LEVEL_RAID10': 1,  # /RADI10
            'RAID_LEVEL_RAID5': 2,  # /RAID5
            'RAID_LEVEL_RAID0': 3,  # /RAID0
            'RAID_LEVEL_RAID1': 4,  # /RAID1
            'RAID_LEVEL_RAID6': 5,  # /RAID6
            'RAID_LEVEL_RAID50': 6,  # /RAID50
            'RAID_LEVEL_RAID3': 7,  # /RAID3
            'RAID_LEVEL_RAID60': 8  # /RAID60
        }

        '''
        '''
        RM_UPDATE_TYPE_E = {
            'RM_UPDATE_TYPE_MANUAL': 1,  # 手动/
            'RM_UPDATE_TYPE_AUTO_START_TIMING': 2,  # 同步开始后定时等待/
            'RM_UPDATE_TYPE_AUTO_END_TIMING': 3  # 同步完成后定时等待/
        }

        '''
        '''
        RM_LUN_MIRROR_STATE_E = {
            'RM_LUN_MIRROR_STATE_SYNCED': 1,  # 已同步/
            'RM_LUN_MIRROR_STATE_CONSISTENT': 2,  # 完整/
            'RM_LUN_MIRROR_STATE_SYNCING': 3,  # 正在同步/
            'RM_LUN_MIRROR_STATE_INIT_SYNCING': 4,  # 正在初始同步/
            'RM_LUN_MIRROR_STATE_INCONSISTENT': 5  # 不完整/
        }

        '''
        '''
        SPEED_LEVEL_E = {
            'SPEED_LEVEL_LOW': 1,  # 低/Low
            'SPEED_LEVEL_MIDDLE': 2,  # 中/Middle
            'SPEED_LEVEL_HIGH': 3,  # 高/High
            'SPEED_LEVEL_ASAP': 4  # 最快/Asap
        }

        '''
        '''
        LUN_RELATION_E = {
            'LUN_RELATION_MASTER': 1,  # 主LUN或源lUN/
            'LUN_RELATION_SLAVE': 2  # 从LUN或目标LUN/
        }

        '''
        '''
        CPY_TYPE_E = {
            'CPY_TYPE_FULL': 1,  # 全量/
            'CPY_TYPE_INCREMENT': 2  # 增量/
        }

        '''
        '''
        EXC_AND_REC_MODE_E = {
            'EXC_AND_REC_MODE_AUTO': 1,  # 自动/
            'EXC_AND_REC_MODE_MANUAL': 2  # 手动/
        }

        '''
        '''
        HYPERCOPY_LUN_TYPE_E = {
            'HYPERCOPY_LUN_TYPE_LOCAL': 0,  # 本阵列的LUN/
            'HYPERCOPY_LUN_TYPE_EXTS5000': 1,  # 外部私有阵列的LUN/
            'HYPERCOPY_LUN_TYPE_THIRD': 2  # 第三方阵列的LUN/
        }

        '''
        '''
        HYPERCLONE_LUN_STATUS_E = {
            'HYPERCLONE_LUN_STATUS_INCONSISTENT': 1,  # 数据不一致/
            'HYPERCLONE_LUN_STATUS_REVINCONSISTENT': 2,  # 反向数据不一致/
            'HYPERCLONE_LUN_STATUS_SYNCHRONIZING': 3,  # 同步中/
            'HYPERCLONE_LUN_STATUS_REVSYNCHRONIZING': 4,  # 反向同步中/
            'HYPERCLONE_LUN_STATUS_CONSISTENT': 5,  # 数据一致/
            'HYPERCLONE_LUN_STATUS_SYNCHRONIZED': 6,  # 同步完成/
            'HYPERCLONE_LUN_STATUS_FAULT': 7  # 故障/
        }

        '''
        '''
        EPL_ARRAY_TYPE_E = {
            'EPL_ARRAY_PRIVATE': 1,  # 本厂商设备/
            'EPL_ARRAY_3RD': 2,  # 第三方设备/
            'EPL_ARRAY_UNKNOWN': 3  # 未知设备/
        }

        '''
        '''
        SNAPSHOT_STATUS_E = {
            'SNAPSHOT_STATUS_DISABLE': 1,  # 停用/
            'SNAPSHOT_STATUS_ACTIVE': 2,  # 激活/
            'SNAPSHOT_STATUS_ROLLBACK': 3,  # 回滚/
            'SNAPSHOT_STATUS_ERROR': 4  # 错误/
        }

        '''
        '''
        RM_MODEL_E = {
            'RM_MODEL_SYNC': 1,  # 同步/
            'RM_MODEL_ASYNC': 2  # 异步/
        }

        '''
        '''
        WORM_LUN_STATE = {
            'WORM_LUN_READ_ONLY': 1,  # 只读/
            'WORM_LUN_READ_WRITE': 2  # 读写/
        }

        '''
        '''
        TargetSessionIdentifyingHandle_E = {
            'Discovery': 2,  # /
            'Normal': 3  # /
        }

        '''
        '''
        OS_TYPE_E = {
            'Linux': 0,  # Linux/Linux
            'Windows': 1,  # Windows/Windows
            'Solaris': 2,  # Solaris/Solaris
            'HPUX': 3,  # HP-UX/HP-UX
            'AIX': 4,  # AIX/AIX
            'XenServer': 5,  # XenServer/XenServer
            'MacOS': 6,  # Mac OS/Mac OS
            'ESX': 7,  # Vmware ESX/Vmware ESX
            'LINUX_VIS': 8  # Linux/Linux
        }

        '''
        '''
        REMOTE_DEVICE_SCOPE_E = {
            'ALL_CREATED': 1,  # 所有已经创建的远端设备/All Remote Device
            'CREATED_AND_LINKED': 2  # 所有已经创建的且处于已连接状态的远端设备/Linked Remote Device
        }

        '''
        '''
        EXPBOARD_TYPE_E = {
            'SAS': 0,  # SAS/SAS
            'FC': 1  # FC/FC
        }

        '''
        '''
        INIT_TIER_POLICY_E = {
            'INIT_TIER_POLICY_AUTO': 0,  # 自动/automatic
            'INIT_TIER_POLICY_EXTREME_PERFORMANCE': 1,  # 最高性能/Extreme Performance
            'INIT_TIER_POLICY_PERFORMANCE': 2,  # 性能/Performance
            'INIT_TIER_POLICY_CAPACITY': 3  # 容量/Capacity
        }

        '''
        '''
        MIGRATE_LUN_POLICY_E = {
            'MIGRATE_LUN_POLICY_NONE': 0,  # 不迁移/None
            'MIGRATE_LUN_POLICY_AUTO': 1,  # 自动迁移/Auto
            'MIGRATE_LUN_POLICY_HIGHEST': 2,  # 向高性能层迁移/Highest Available
            'MIGRATE_LUN_POLICY_LOWEST': 3  # 向低性能层迁移/Lowest Available
        }

        '''
        '''
        SFP_MODE_E = {
            'SINGLEMODE': 0,  # 单模/None
            'MULTIMODE': 1  # 多模/Auto
        }

        '''
        '''
        DISKSCAN_IOTYPE_E = {
            'READ': 1,  # 读/read
            'VERIFY': 2  # 验证/verify
        }

        '''
        '''
        HOSTGROUP_WORKMODE_E = {
            'APF': 0,  # A/P-F/A/P-F
            'AAA': 1  # A/A-A/A/A-A
        }

        '''
        '''
        IP_SEC_RULE_E = {
            'WHITE_NAME_LIST': 1,  # 白名单/WHITE NAME LIST
            'BLACK_NAME_LIST': 2  # 黑名单/BLACK_NAME_LIST
        }

        '''
        '''
        TRAP_VERSION_E = {
            'TRAP_V1': 1,  # SNMPV1/SNMPV1
            'TRAP_V2C': 2,  # SNMPV2c/SNMPV2c
            'TRAP_V3': 3  # SNMPV3/SNMPV3
        }

        '''
        '''
        tagUPGRADE_PKGTYPE_E = {
            'UPGRADE_PKGTYPE_TYPE_SYS': 1,  # 系统软件包
            'UPGRADE_PKGTYPE_TYPE_COLD_PATCH': 2,  # 冷补丁
            'UPGRADE_PKGTYPE_TYPE_HOT_PATCH': 3  # 热补丁
        }

        '''
        '''
        TRAP_TYPE_E = {
            'TRAP_HUAWEI': 1,  # Huawei Trap/TRAP_HUAWEI
            'TRAP_HUAWEISYMANTEC': 2,  # HuaweiSymantec Trap/TRAP_HUAWEISYMANTEC
            'TRAP_ALL': 3  # All Trap/TRAP_ALL
        }

        '''
        '''
        LDAP_MAP_TYPE_E = {
            'USER_MAP': 0,  # LDAP用户映射/USER_MAP
            'GROUP_MAP': 1  # LDAP组映射/GROUP_MAP
        }

        '''
        '''
        LDAP_DIRECTORY_TYPE_E = {
            'LDAP': 1,  # /LDAP
            'AD': 2  # /AD
        }

        '''
        '''
        LDAP_TRANSFER_E = {
            'LDAP': 1,  # /LDAP
            'LDAPS': 2  # /LDAPS
        }

        '''
        '''
        SCHEDULE_TYPE_E = {
            'MONITOR_SCHEDULE': 1,  # IO监控时刻表/IO Monitoring Schedule
            'MIGRATION_SCHEDULE': 2,  # 迁移时刻表/Migration Schedule
            'SPINDOWN_SCHEDULE': 3  # 休眠时刻表/Spindown Schedule
        }

        '''
        '''
        ENUM_ROUTE_TYPE_E = {
            'ROUTE_TYPE_NET': 0,  # 网段路由/Net
            'ROUTE_TYPE_HOST': 1,  # 主机路由/Host
            'ROUTE_TYPE_DEFAULT': 2  # 默认路由/Default
        }

        '''
        '''
        MULTIPATH_TYPE_E = {
            'DEFAULT': 0,  # 默认/Defalut
            'ALUA': 1  # ALUA/ALUA
        }

        '''
        '''
        iSCSI_Session_Type_E = {
            'Normal': 0,  # /Discovery
            'Discovery': 1  # /Normal
        }

        '''
        '''
        BAD_DISK_TYPY_E = {
            'REGISTER_FAILED': 1,  # 注册失败/
            'WRITE_PROTECT': 2,  # 写保护/
            'SLOW_DISK': 3,  # 慢盘/
            'FAULT_DISK': 4  # 故障盘/
        }

        '''
        '''
        SET_QUOTA_STATUS = {
            'NOT_SUPPORT': 1,  # 不支持/
            'NOT_SET': 2,  # 未设置/
            'SET_DIR_QUOTA': 3,  # 已设置目录配额（未设置用户配额）/
            'SET_USER_QUOTA': 4  # 已设置用户配额（也设置了目录配额）/
        }

        '''
        '''
        POSITION_TYPE = {
            'NOT_POSITION': 1,  # 不再为/Not in position
            'POSITION': 2  # 在位/In position
        }

        '''
        '''
        DEPLOY_STATUS = {
            'CREATE_CONNECTION': 1,  # 建立连接/
            'DOWNLOAD_CONFIG_FILE': 2,  # 下载配置文件/
            'PARSE_CONFIG_FILE': 3,  # 解析配置文件/
            'DOWNLOAD_PACKAGE': 4,  # 下载软件包%s/
            'DEPLOY_NETWORK': 5,  # 配置网络/
            'DEPLOY_IPMI': 6,  # 配置IPMI/
            'INSTALL_SOFTWARE': 7,  # 安装软件%s/
            'DEPLOY_SOFTWARE': 8,  # 配置软件%s/
            'START_STFTWARE': 9,  # 启动软件%s/
            'DEPLOYFINISH': 10  # 部署完成/
        }

        '''
        '''
        DEPLOY_ERROR_CODE = {
        }

        '''
        '''
        POWERON_STATUS_E = {
            'POWERON_SUCCESS': 0,  # /
            'POWERON_FAIL': 1,  # /
            'POWERON_POWERONING': 2,  # /
            'POWEROFF': 3  # /
        }

        '''
        '''
        SYSTEM_ROLE_E = {
            'SYSTEM_ROLE_NORMAL': 0,  # /
            'SYSTEM_ROLE_MASTER': 1,  # /
            'SYSTEM_ROLE_SLAVE': 2  # /
        }

        '''
        '''
        PRIORITY_E = {
            'LOW': 1,  # 低/Low
            'MIDDLE': 2,  # 中/Middle
            'HIGH': 3  # 高/High
        }

        '''
        '''
        REMOTE_DEVICE_SERVICE_TYPE_E = {
            'LUN_COPY': 1,  # LUN拷贝/
            'REMOTE_REPLICATION': 2  # 远程复制/
        }

        '''
        '''
        STORAGE_CAPABILITY = {
            'NoProtected': 0,  # /NoProtected
            'Capacity': 1,  # /Capacity
            'Performance': 2,  # /Performance
            'ExtremePerformance': 3,  # /Extreme Performance
            'Muti-Tiers': 4  # /Muti-Tiers
        }

        '''
        '''
        SPECIALITY_E = {
            'SMARTCACHE': 0,  # /
            'SNAPSHOT': 1,  # /
            'LUNCOPY': 2,  # /
            'HYPERREPLICATION': 3,  # /
            'CONSISTENT_GROUP': 4,  # /
            'HyperClone': 5,  # /
            'THIN_PROVISION': 6,  # /
            'LUN_MUTI_MAPPING': 7,  # /
            'IPV6': 8,  # /
            'LICENSE_COMPARE': 9,  # /
            'NTP': 10,  # /
            'TIME_ZONE': 11,  # /
            'SYNC_CMD': 12,  # /
            'PERFORMANCE_DATA_IN_FILE': 13,  # /
            'EXPORT_ORIG_DATA': 14,  # /
            'CREATE_DATA_DISK': 15,  # /
            'INIT_FILE_SYSTEM': 16,  # /
            'ALUA': 17,  # /
            'ACCESSIP': 18,  # /
            'ExpandDisk': 19,  # /
            'DISKSUBRACK_LIGHT': 20,  # /
            'DISKSUBRACK_LIGHT_CTRL_HARDDISK': 21,  # /
            'INPUT_POWER': 22,  # /
            'PERF_STAT_DUMP': 23,  # /
            'CLIENTINFO': 24,  # /
            'EXPORT_PERFORMANCE_DATA': 25,  # /
            'QUERY_USER_QUATO': 26,  # /
            'QUERY_CIFS_ONLINE_USER': 27,  # /
            'USER_LEVEL_READONLY': 28,  # /
            'ALARM_CONFIG_CLASSIFICATION': 29,  # /
            'NOTIFICATION_SMS_CLASSIFICATION': 30,  # /
            'AUTO_BACKUP': 31,  # /
            'PERFORMANCE_THRESHOLD': 32,  # /
            'MULTI_PATH_MONITORING': 33,  # /
            'SUPPORT_FCOE_CARD': 34,  # /
            'PERFORMANCE_SPLITED_INTERVAL': 35,  # /
            'INTEGERATED_NAS': 36,  # /
            'SUPPORT_DEFAULT_ROUTE': 37,  # /
            'HOT_PATCH': 38,  # /
            'FC_PORT_MODE': 39,  # /
            'FILE_ENGINE_NODE': 40,  # /
            'LOG_OF_DOWNLOAD_PERF_STAT_ARCHIVE': 41,  # /
            'HOSTGROUP_PORTMODE': 42,  # /
            'SPLIT_MIRROR_CONSISTENTGROUP': 43,  # /
            'LDAP_CONFIG': 44,  # /
            'T_SERIES_UNITARY': 45,  # /
            'THIN_LUN_CONTROLLER_MODIFY': 46,  # /
            'HAS_SVP': 47,  # /
            'BAY_RETRIEVEABLE': 48,  # /
            'HAS_MONITOR_BOARD': 49,  # /
            'PORT_MAPPING_VIEW': 50,  # /
            'HOST_LINK': 51  # /
        }

        '''
        '''
        DISK_SSD_IF_TYPE_E = {
            'NA': 0,  # /Not Available
            'FC_SSD': 1,  # /FC SSD
            'SAS_SSD': 2,  # /SAS SSD
            'NL SAS_SSD': 3,  # /NL SAS SSD
            'SATA_SSD': 4,  # /SATA SSD
            'SATA2_SSD': 5,  # /SATA2 SSD
            'SATA3_SSD': 6  # /SATA3 SSD
        }

        '''
        '''
        DISK_FORM_E = {
            'Unknown': 0,  # /
            'DISK_5_25_INCH': 1,  # /5.25 inch
            'DISK_3_5_INCH': 2,  # /3.5 inch
            'DISK_2_5_INCH': 3,  # /2.5 inch
            'DISK_1_8_INCH': 4  # /1.8 inch
        }

        '''
        '''
        SYS_STATUS_E = {
            'Normal': 0,  # 正常/
            'Abnormal': 1,  # 异常/
            'POWERONING': 2,  # 上电中/
            'POWEROFF': 3,  # 下电中/
            'SAFE_MODE': 4,  # 安全保护状态/
            'UPGRADING': 5,  # 升级中/
            'POWER_LOST': 6,  # 掉电/
            'OFFLINE': 7  # 离线/
        }

        '''
        '''
        RESOURCE_ACCESS_E = {
            'NOACCESS': 1,  # 禁止访问/
            'READ_ONLY': 2,  # 只读/
            'READ_WRITE': 3  # 读写/
        }

        '''
        '''
        FS_SHARE_WINDOWS_MODE = {
            'NORMAL': 1,  # /NORMAL
            'HOMEDIRE': 2  # /HOMEDIRE
        }

        '''
        '''
        FS_SHARE_TYPE = {
            'CIFS_NFS': 1,  # /CIFS_NFS
            'CIFS': 2,  # /CIFS
            'NFS': 3  # /NFS
        }

        '''
        '''
        QUOTA_TYPE_E = {
            'QUOTA_FOLDER': 1,  # Normal目录配额/
            'QUOTA_USER': 2,  # 用户的配额/
            'QUOTA_USERGROUP': 3,  # 用户组的配额/
            'DEFAULT_USER_QUOTA': 4,  # 用户默认配额/
            'DEFAULT_GROUP_QUOTA': 5,  # 组默认配额/
            'QUOTA_USER_USERGROUP': 6  # 用户和组配额/
        }

        '''
        '''
        ACCESS_PERMISSION = {
            'CIFS_READ': 1,  # 只读/
            'CIFS_READ_WRITE': 2,  # 读写/
            'CIFS_ALLCONTROL': 3,  # 完全控制/
            'CIFS_NOACCESS': 4,  # 禁止访问/
            'NFS_R': 5,  # 只读/
            'NFS_RW_NOROOT': 6,  # 读写，不允许root权限/
            'NFS_RW_ALLOWROOT': 7,  # 读写，允许root权限/
            'NFS_NOACCESS': 8,  # 禁止访问/
            'NFS_EXECUTE': 9  # 执行/
        }

        '''
        '''
        ACCESS_OBJ = {
            'USER': 1,  # USER/
            'USERGROUP': 2,  # USERGROUP/
            'DOMAIN_USER': 3,  # DOMAIN_USER/
            'DOMAIN_USERGROUP': 4,  # DOMAIN_USERGROUP/
            'HOST': 5,  # HOST/
            'SUBNET': 6,  # SUBNET/
            'NETGROUP': 7,  # NETGROUP/
            'USERANDGROUP': 8,  # USERANDGROUP/
            'IPADDRESS': 9  # IPADDRESS/
        }

        '''
        '''
        DOMAIN_TYPE_E = {
            'NIS': 1,  # NIS/
            'LDAP': 2,  # LDAP/
            'AD': 3  # AD/
        }

        '''
        '''
        FILE_ID_E = {
            'event_en': 0,  # 事件定义文件(英文)/
            'event_zh': 1,  # 事件定义文件(中文)/
            'event_restore_file': 10,  # 告警转储文件/
            'error_en': 20,  # 错误码资源文件(英文)/
            'error_zh': 21,  # 错误码资源文件(中文)/
            'task_en': 30,  # 运行任务资源文件(英文)/
            'task_zh': 31,  # 运行任务资源文件(中文)/
            'license': 40,  # license文件/
            'configData': 50,  # 配置数据文件/
            'systemLog': 60,  # 系统日志文件/
            'runningData': 70,  # 运行数据文件/
            'performanceData': 80  # 性能数据文件/
        }

        '''
        '''
        DOMAIN_SECURITY_E = {
            'DOMAIN': 1,  # 域/Domain
            'NETGROUP': 2  # 网络组/Netgroup
        }

        '''
        '''
        CASESENSITIVITY_E = {
            'NOFS_CASE_SENSITIVE': 0,  # 0 是大小写敏感/
            'NOFS_CASE_INSENSITIVE': 1,  # 1 是大小写不敏感/
            'NOFS_CASE_MIXED': 2  # 2 是混合/
        }

        '''
        '''
        COMPRESSION_E = {
            'NIO_COMPRESS_ON          1': 1,  # /
            'NIO_COMPRESS_OFF         2': 2,  # /
            'NIO_COMPRESS_GZIP_1      5': 5,  # /
            'NIO_COMPRESS_GZIP_2      6': 6,  # /
            'NIO_COMPRESS_GZIP_3      7': 7,  # /
            'NIO_COMPRESS_GZIP_4      8': 8,  # /
            'NIO_COMPRESS_GZIP_5      9': 9,  # /
            'NIO_COMPRESS_GZIP_6      10': 10,  # /
            'NIO_COMPRESS_GZIP_7      11': 11,  # /
            'NIO_COMPRESS_GZIP_8      12': 12,  # /
            'NIO_COMPRESS_GZIP_9      13': 13  # /
        }

        '''
        '''
        CHECKSUM_E = {
            'CHECKSUM_ON': 1,  # /
            'CHECKSUM_OFF': 2,  # /
            'CHECKSUM_FLETCHER_2': 6,  # /
            'CHECKSUM_FLETCHER_4': 7,  # /
            'CHECKSUM_SHA256': 8  # /
        }

        '''
        '''
        QUOTA_SET_STATUS_E = {
            'QUOTA_NONSUPPORT': 1,  # 不支持/
            'QUOTA_YESSET': 2,  # 已设置/
            'QUOTA_NOTSET': 3  # 未设置/
        }

        '''
        '''
        WORM_TYPE_E = {
            'ENTERPRISE': 0,  # Enterprise企业模式/
            'COMPLIANCE': 1,  # Compliance遵从模式/
            'DISABLED': 2  # 关闭/
        }

        '''
        '''
        UNIT_E = {
            'UNIT_BYTE': 1,  # Byte/Byte
            'UNIT_KB': 2,  # KB/KB
            'UNIT_MB': 3,  # MB/MB
            'UNIT_GB': 4,  # GB/GB
            'UNIT_TB': 5,  # TB/TB
            'UNIT_PB': 6,  # PB/PB
            'UNIT_KIB': 11,  # KiB/KiB
            'UNIT_MIB': 12,  # MiB/MiB
            'UNIT_GIB': 13,  # GiB/GiB
            'UNIT_TIB': 14,  # TiB/TiB
            'UNIT_PIB': 15,  # PiB/PiB
            'UNIT_BYTE_PER_SEC': 21,  # Bytes/s/Bytes/s
            'UNIT_BYTE_KB_SEC': 22,  # KB/s/KB/s
            'UNIT_BYTE_MB_SEC': 23,  # MB/s/MB/s
            'UNIT_BYTE_GB_SEC': 24,  # GB/s/GB/s
            'UNIT_BYTE_TB_SEC': 25,  # TB/s/TB/s
            'UNIT_BYTE_PB_SEC': 26,  # PB/s/PB/s
            'UNIT_NS': 40,  # 纳秒/ns
            'UNIT_MICROSECOND': 41,  # 微秒/μs
            'UNIT_MS': 42,  # 毫秒/ms
            'UNIT_SECOND': 43,  # 秒/second(s)
            'UNIT_MINUTE': 44,  # 分/minute(s)
            'UNIT_HOUR': 45,  # 小时/hour(s)
            'UNIT_DAY': 46,  # 天/day(s)
            'UNIT_MONTH': 47,  # 月/month(s)
            'UNIT_YEAR': 48,  # 年/year(s)
            'UNIT_TIMES': 70,  # 次/Times
            'UNIT_TIMES_PER_SEC': 71,  # 次/秒/Times/s
            'UNIT_ENTRIES': 72,  # 个/Entries
            'UNIT_ENTRIES_PER_SEC': 73,  # 个/秒/Entries/s
            'UNIT_PERCENTAGE': 74,  # %/%
            'UNIT_WATT': 90,  # 瓦/W
            'UNIT_KILOWATT': 91,  # 千瓦/KW
            'UNIT_IOPS': 100  # IO/s/IO/s
        }

        '''
        '''
        IOCLASS_CTRL_TYPE = {
            'CTRL_UPPER': 1,  # 控制IO上限/控制IO上限
            'CTRL_LOWER': 2  # 控制IO下限/控制IO下限
        }

        '''
        '''
        CACHE_POLICY_E = {
            'READ_CACHE_POLICY_EVICT_LOW': 1,  # /
            'READ_CACHE_POLICY_EVICT_MIDDLE': 2,  # /
            'READ_CACHE_POLICY_EVICT_HIGH': 3,  # /
            'WRITE_CACHE_POLICY_DESTAGE_LOW': 4,  # /
            'WRITE_CACHE_POLICY_DESTAGE_MIDDLE': 5,  # /
            'WRITE_CACHE_POLICY_DESTAGE_HIGH': 6  # /
        }

        '''
        '''
        ULTRAPATH_SWITH_E = {
            'NORMAL': 1,  # 正常/
            'WAIT': 2,  # 待切换/
            'FINISH': 3  # 切换完成/
        }

        '''
        '''
        DESTROY_TYPE_E = {
            'DOD_ERASEMENT': 1,  # DoD方式/DoD
            'REP_ERASEMENT': 2  # 自定义反复写/Write Replication
        }

        '''
        '''
        SECURITY_STYLE_E = {
            'UNIX': 1,  # UNIX/UNIX
            'NTFS': 2  # NTFS/NTFS
        }

        '''
        '''
        COMM_CONFIGURE_E = {
            'VMWARE': 1  # VMWARE/VMWARE
        }

        '''
        '''
        SECURITY_MODEL_E = {
            'LOCAL_ATTESTATION': 1,  # 本地认证/LOCAL_ATTESTATION
            'ALL_ATTESTATION': 2  # 全局认证（域认证和本地认证）/ALL_ATTESTATION
        }

        '''
        '''
        PASSWORDHASH_E = {
            'clear': 1,  # /clear
            'md5': 2,  # /md5
            'crypt': 3  # /crypt
        }

        '''
        '''
        APP_TYPE_E = {
            'other': 0,  # 其他/other
            'oracel': 1,  # /oracle
            'exchange': 2,  # /exchange
            'sqlserver': 3,  # /sqlserver
            'vmware': 4,  # /vmware
            'hyper-V': 5  # /hyper-V
        }

        '''
        '''
        NTLM_LEVEL_E = {
            'LEVEL_0': 0,  # /LEVEL_0
            'LEVEL_1': 1,  # /LEVEL_1
            'LEVEL_2': 2,  # /LEVEL_2
            'LEVEL_3': 3,  # /LEVEL_3
            'LEVEL_4': 4  # /LEVEL_4
        }

        '''
        '''
        RES_TYPE_E = {
            'DEFAULT': 1,  # 初始默认/
            'CREATE': 2  # 管理员创建/
        }

        '''
        '''
        CONSULT_STATUS_E = {
            'NOPASS': 0,  # 密钥未协商通过/
            'PASS': 1,  # 已通过/
            'NOT_SUPPORT': 2  # 不支持加密传输/
        }

        '''
        '''
        DDP_COMP_LEVEL_E = {
            'DDP_COMP_LEVEL_FAST': 0,  # 速度快/
            'DDP_COMP_LEVEL_MIDDLE': 1,  # 速度相当/
            'DDP_COMP_LEVEL_DEEP': 2  # 速度最慢/
        }

        '''
        '''
        DISK_SCAN_SCOPE_E = {
            'ALL': 1,  # 全局/
            'ENCLOSURE': 2,  # 指定硬盘框/
            'DISK': 3  # 指定硬盘/
        }

        '''
        '''
        BACKUP_OBJECT_E = {
        }

        '''
        '''
        QUERY_SEQUENCE_E = {
        }

        '''
        '''
        VM_BACKUP_STATUS_E = {
        }

        '''
        '''
        VM_EXIST_STATUS_E = {
        }

        '''
        '''
        BACKUP_TYPE_E = {
        }

        '''
        '''
        RESTORE_MODE_E = {
        }

        '''
        '''
        RESTORE_LOCATION_TYPE_E = {
        }

        '''
        '''
        SERVER_ROLE_E = {
            'dispatcher': 1,  # 备份管理服务器/
            'processer': 2,  # 备份处理服务器/
            'none': 3  # 无/
        }

        '''
        '''
        DEVICE_TYPE_E = {
            'Dsware': 1,  # FusionStorage:华为分布式存储/
            'Virtual': 2  # 虚拟化存储/
        }

        '''
        '''
        SCHEDUAL_TYPE_E = {
        }

        '''
        '''
        FREQUENCY_RANGE_E = {
            'year': 0,  # 年/
            'month': 1,  # 月/
            'week': 2,  # 周/
            'day': 3,  # 日/
            'hour': 4,  # 小时/
            'minute': 5  # 分钟/
        }

        '''
        '''
        CLIENT_TYPE_E = {
        }

        '''
        '''
        VM_TYPE_E = {
        }

        '''
        '''
        DISK_STATUS_E = {
        }

        '''
        '''
        POLICY_TYPE_E = {
        }

        '''
        '''
        BACKUP_OBJECT_TYPE_E = {
        }

        '''
        '''
        STORAGE_TYPE_E = {
        }

        '''
        '''
        NAS_PROTOCOL_TYPE_E = {
        }

        '''
        '''
        CIFS_VERIFY_TYPE_E = {
        }

        '''
        '''
        BACKUP_DATA_TYPE_E = {
        }

        '''
        '''
        RESOTRE_OBJECT_TYPE_E = {
        }

        '''
        '''
        OPERATE_TYPE_E = {
        }

        '''
        '''
        EXPIRED_STATUS_E = {
        }

        '''
        '''
        IP_CFG_TYPE_E = {
            'DHCP': 0,  # /
            'STATIC': 1  # /
        }

        '''
        '''
        SERVICE_NAME_E = {
            'ftp': 1,  # /
            'snmp': 2,  # /
            'nfs': 3,  # /
            'dps': 4,  # /
            'dhcp': 5  # /
        }

        '''
        '''
        ENUM_ROUTE_TYPE_E = {
            'ROUTE_TYPE_NET': 0,  # 网段路由/Net
            'ROUTE_TYPE_HOST': 1,  # 主机路由/Host
            'ROUTE_TYPE_DEFAULT': 2  # 默认路由/Default
        }

        '''
        '''
        PROCESS_STATUS_E = {
        }

        '''
        '''
        IS_CAN_RESTART_TYPE_E = {
        }

        '''
        '''
        CONFIG_TYPE_E = {
        }

        '''
        '''
        BAY_MODEL_E = {
            'BAY_2U': 0,  # 2.5寸柜/
            'BAY_4U': 1,  # 3.5寸柜/
            'INTERMAXING': 2  # 混插柜/
        }

        '''
        '''
        SMARTCACHE_STATE_E = {
            'CLOSE': 0,  # 关闭/
            'OPEN': 1,  # 打开/
            'EXTEND_PARENTPOOL': 2  # 继承POOL的状态/
        }

        '''
        '''
        CLIENT_TRNAS_MODE_E = {
            'LAN': 0,  # 基于局域网的Socket传输方式/LAN-based transmission
            'LANSSL': 1  # 基于局域网的Socket加密传输方式/LAN-based transmission wish SSL
        }

    '''
    Description: (公共)系统管理
    '''

    class SysMgmt():
        '''
        Description: 系统信息
        '''
        SYSTEM = {'type': 0,  # ,
                  'id': 1,  # ,
                  'name': 2,  # ,
                  'location': 6,  # ,
                  'healthStatus': 7,  # ,
                  'runningStatus': 8,  # ,
                  'description': 9,  # ,
                  'productMode': 64,  # 产品型号, enum
                  'productVersion': 65,  # 产品版本号, string
                  'domainName': 66,  # 归属域, String
                  'highWaterLevel': 67,  # 高水位, uint32
                  'lowWaterLevel': 68,  # 低水位, uint32
                  'cacheWriteQuota': 69,  # Cache写配额, uint32
                  'memberDisksCapacity': 70,  # , uint64
                  'hotSpareDisksCapacity': 71,  # , uint64
                  'freeDisksCapacity': 72,  # , uint64
                  'unavailableDisksCapacity': 73,  # , uint64
                  'storagePoolRawCapacity': 74,  # , uint64
                  'storagePoolCapacity': 75,  # , uint64
                  'storagePoolUsedCapacity': 76,  # , uint64
                  'storagePoolFreeCapacity': 77,  # , uint64
                  'storagePoolHostSpareCapacity': 78,  # , uint64
                  'thicklunsAllocateCapacity': 79,  # , uint64
                  'thicklunsUsedCapacity': 80,  # , uint64
                  'thinlunsMaxCapacity': 81,  # , uint64
                  'thinlunsAllocateCapacity': 82,  # , uint64
                  'thinlunsUsedCapacity': 83,  # , uint64
                  'sectorSize': 84,  # 扇区大小, uint32
                  'VASA_SUPPORT_BLOCK': 85,  # 支持的块访问接口类型, String
                  'VASA_SUPPORT_FILESYSTEM': 86,  # 支持的文件系统接口类型, String
                  'VASA_ALTERNATE_NAME': 87,  # 阵列别名, String
                  'VASA_SUPPORT_PROFILE': 88,  # 支持的配置文件类型, String
                  'wwn': 89,  # WWN, String
                  'config_model': 101,  # 配置型号, enum
                  }

        '''
        Description: 通知上报
        '''
        NOTIFY_E = {
            'type': 0,  # , enum
            'id': 1  # , string
        }

        '''
        Description: 上报告警
        '''
        CMO_ALARM_INFO_E = {
            'CMO_ALARM_TYPE': 0,  # 告警类型/查询规则, int32
            'CMO_ALARM_ID': 1,  # 告警标识/起始告警流水号, uint64
            'CMO_ALARM_LEVEL': 2,  # 告警级别/查询告警条数，参见EVENT_LEVEL_E, uint32
            'CMO_ALARM_SEQUENCE': 3,  # 告警流水号/告警起始时间, uint32
            'CMO_ALARM_TIME': 4,  # 告警发生时间(日历时间)/告警结束时间, uint32
            'CMO_ALARM_CLEAR_TIME': 5,  # 告警清除时间（日历时间）, uint32
            'CMO_ALARM_RECOVERY_TIME': 6,  # 告警恢复时间（日历时间）, uint32
            'CMO_ALARM_CLEAR_USER_NAME': 7,  # 告警清除用户名, string
            'CMO_ALARM_PARMETER': 8,  # 告警参数, string
            'CMO_ALARM_COUNT': 9,  # 网管一次查询的数量<=1000条, uint32
            'queryCondition': 15,  # 查询条件, json
            'alarmConfirmUser': 64,  # 告警确认人(user id), string
            'alarmConfirmTime': 65,  # 告警确认时间, uint32
            'alarmObjType': 66,  # 告警来源对象类型, enum
            'alarmObjId': 67  # 告警来源对象ID, string
        }

        '''
        Description: 告警Email
        '''
        EMAIL = {
            'CMO_EMAIL_SMTP_SERVER': 0,  # SMTP服务ip地址（IPV4/IPV6共用）, string
            'CMO_EMAIL_SENDER': 1,  # 发件人, string
            'CMO_EMAIL_NEED_SMTP_CHECK': 3,  # 是否需要SMTP验证, uint32
            'CMO_EMAIL_NEED_SEND': 4,  # 是否发送, uint32
            'CMO_EMAIL_SMTP_USER_NAME': 5,  # 身份验证用户名, string
            'CMO_EMAIL_SMTP_USER_PASSWD': 6,  # 身份验证密码, string
            'CMO_EMAIL_RECEIVER': 7,  # 接收Email地址列表, string
            'CMO_EMAIL_SSL': 8,  # 是否使用SSL连接, uint32
            'CMO_EMAIL_SMTP_SERVER_PORT': 9  # SMTP端口号, uint32
        }

        '''
        Description: 告警短信
        '''
        ALARM_SMS = {
            'CMO_SMS_NEED_SEND': 0,  # 是否发送, uint32
            'CMO_SMS_SEND_COUNTRY': 2,  # 发送国家, uint32
            'CMO_SMS_RECEIVER': 3,  # 接收短信号码, string
            'CMO_SMS_SERVICE_CENTRE': 4  # 短信服务中心号码，国家编码+手机号码, string
        }

        '''
        Description: 告警转储
        '''
        ALARM_RESTORE = {
            'CMO_ALARM_RESTORE_ENABLE': 0,  # 自动转储使能, uint32
            'CMO_ALARM_RESTORE_ADDRESS': 1,  # IP地址, string
            'CMO_ALARM_RESTORE_VISUALPATH': 2,  # 转储的FTP路径, string
            'CMO_ALARM_RESTORE_ACCOUNT': 3,  # 用户, string
            'CMO_ALARM_RESTORE_PASSWD': 4  # 密码, string
        }

        '''
        Description: 清除数据
        '''
        CLEAR_EXPORT_DATA = {
            'EXPORT_DATA_TYPE': 0  # 需要清除的数据所在的, uint32
        }

        '''
        Description: 远程告警
        '''
        REMOTE_ALARM = {
            'CMO_HEALTH_WATCH_INFO_ENABLE': 0,  # 远程告警发送开关, uint32
            'CMO_HEALTH_WATCH_INFO_PERIOD': 1  # 远程告警发送周期, uint32
        }

        '''
        Description: SYSLOG
        '''
        SYSLOG_INFO = {
            'OM_MSG_OP_SET_ALARM_SYSLOG_CFG': 0,  # 开关, uint32
            'CMO_ALARM_SYSLOG_SEVERITY': 1,  # 发送级别, uint32
            'CMO_ALARM_SYSLOG_SERVER_IP': 2  # 日志服务器IP, string
        }

        '''
        Description: 统计对象类型与统计数据映射
        '''
        PERFORMANCE_MAPPING = {
            'CMO_STATISTIC_OBJECT_ID': 0,  # 统计对象类型ID, enum
            'CMO_STATISTIC_DATA_ID': 1,  # 统计数据ID, uint64
            'CMO_STATISTIC_TIME_SPAN': 2,  # 统计时段, uint64
            'CMO_STATISTIC_MIN_PERIOD': 3  # 统计最小周期, uint64
        }

        '''
        Description: 性能统计
        '''
        PERFORMANCE_STATISTIC = {
            'CMO_STATISTIC_UUID': 0,  # 统计对象的UUID, string
            'CMO_STATISTIC_DATA_ID': 1,  # 统计数据ID, uint64
            'CMO_STATISTIC_TIME_SPAN': 2,  # 性能统计粒度, uint64
            'CMO_STATISTIC_DATA': 3,  # 性能值, uint64
            'CMO_STATISTIC_TIMESTAMP': 4,  # 时间戳, uint64
            'SKIP_SWITCH': 5,  # , bool
            'START_TIME': 6,  # , uint64
            'END_TIME': 7  # , uint64
        }

        '''
        Description: 性能统计开关
        '''
        PERFORMANCE_STATISTIC_SWITCH = {
            'CMO_PERFORMANCE_SWITCH': 0,  # 性能统计开关, uint64
            'CMO_ PERFORMANCE_BEGIN_TIME': 1,  # 性能统计开始时间, uint64
            'CMO_ PERFORMANCE_END_TIME': 2  # 性能统计开始时间, uint64
        }

        '''
        Description: 性能数据
        '''
        PERFORMANCE_DATA = {
            'CMO_EXPORT_PERF_OBJECT_ID': 0,  # 统计对象类型ID, enum
            'CMO_EXPORT_PERF_TIME_SPAN': 1,  # 统计的采样周期, uint64
            'CMO_EXPORT_PERF_ADDRESS': 2  # 导出的路径, string
        }

        '''
        Description: 性能告警阈值
        '''
        PERFORMANCE_ALARM_THRESHOLD = {
            'obj_type': 0,  # 类型, enum
            'CMO_THRESHOLD_PARAMID': 1,  # 性能统计参数, uint64
            'CMO_THRESHOLD_ATTRID': 2,  # 统计对象属性, uint32
            'CMO_THRESHOLD_VALUE': 3  # 性能告警阈值, uint32
        }

        '''
        Description: 性能统计策略
        '''
        PEFORMANCE_STATISTIC_STRATEGY = {
            'CMO_STATISTIC_INTERVAL': 0,  # 实时性能数据收集时间间隔, uint64
            'CMO_STATISTIC_ARCHIVE_SWITCH': 1,  # 性能统计数据文件存档开关, uint64
            'CMO_STATISTIC_ARCHIVE_TIME': 2,
            # 性能统计数据文件保存间隔，V200R001仅提供接口，不提供设置界面，值只允许与实时性能数据收集时间间隔值一致, uint64
            'CMO_STATISTIC_AUTO_STOP': 3,  # 性能统计自动停止开关，V200R001目前只允许取值为1, uint64
            'CMO_STATISTIC_MAX_TIME': 4  # 性能统计采集天数, uint64
        }

        '''
        Description: 性能统计数据文件
        '''
        PERFORMANCE_STATISTIC_FILE = {
            'CMO_STATISTIC_FILE': 0,  # 设备性能统计数据文件, string
            'CMO_FILE_UPDATE_TIME': 1,  # 文件最后更新时间, uint64
            'CMO_FILE_UPDATE_SIZE': 2  # 设备性能统计数据文件大小, Uint32
        }

        '''
        Description: 性能统计数据自动转储信息
        '''
        PERF_DATA_RESTORE = {
            'CMO_STATISTIC_RESTORE_ENABLE': 0,  # 自动转储使能, uint32
            'CMO_STATISTIC_RESTORE_ADDRESS': 1,  # FTP IP地址, string
            'CMO_STATISTIC_RESTORE_VISUALPATH': 2,  # 转储的FTP路径, string
            'CMO_STATISTIC_RESTORE_ACCOUNT': 3,  # 用户, string
            'CMO_STATISTIC_RESTORE_PASSWD': 4  # 密码, string
        }

        '''
        Description: 系统能耗
        '''
        POWER_CONSUMPTION = {
            'START_TIME': 0,  # 起始时间, uint64
            'TIME_TYPE': 1,  # 统计类型, uint32
            'TIME_STAMP': 2,  # UTC时间戳, uint64
            'POWER_CONSUMPTION_VALUE': 3  # 能耗值, uint32
        }

        '''
        Description: License信息
        '''
        LICENSE_INFO = {
            'CMO_LICENSE_ESN': 0,  # 硬件设备序列号或唯一的软件序列号, string
            'CMO_LICENSE_SERVICE_AUTH_TYPE': 1,  # 授权类型, string
            'CMO_LICENSE_SWM_TIME': 2,  # 软件维护截止日期, string
            'CMO_LICENSE_HWM_TIME': 3,  # 硬件维护截止日期, string
            'CMO_LICENSE_SFUPDATE_TIME': 4,  # 软件免费升级截止日期, string
            'CMO_LICENSE_VERSION': 5,  # 产品的版本信息, string
            'CMO_LICENSE_LIBVER': 6,  # License文件的格式版本, string
            'CMO_LICENSE_COMMENT': 7,  # 包含与产品相关的一些注释信息, string
            'CMO_IS_TEMP_LICENSE': 8  # 是否临时license文件, bool
        }

        '''
        Description: License功能配置项
        '''
        LICENSE_FUNC_CONFIGITEM = {
            'CMO_LICENSE_FEATURE_NAME': 0,  # Feature 的名称, string
            'CMO_LICENSE_TRIAL_TIME': 1,  # 总试用天数, uint32
            'CMO_LICENSE_RUN_TIME': 2,  # 运行截止日期, string
            'CMO_LICENSE_FUNC': 3,  # 功能配置信息的名称, string
            'CMO_LICENSE_FUNC_SWITCH': 4,  # 功能配置开关, uint32
            'CMO_LICENSE_FUNC_FEATURE_ID': 5  # License特性ID, uint32
        }

        '''
        Description: License资源配置项
        '''
        LICENSE_RES_CONFIGITEM = {
            'CMO_LICENSE_FEATURE_NAME': 0,  # Feature 的名称, string
            'CMO_LICENSE_TRIAL_TIME': 1,  # 总试用天数, uint32
            'CMO_LICENSE_RUN_TIME': 2,  # 运行截止日期, string
            'CMO_LICENSE_RESOURCE': 3,  # 资源配置项的名称, string
            'CMO_LICENSE_RESOURCE_NUM': 4,  # 资源配置项允许的个数, uint32
            'CMO_LICENSE_FUNC_FEATURE_ID': 5,  # License特性ID, uint32
            'CMO_LICENSE_RESOURCE_UNIT': 6  # , enum
        }

        '''
        Description: License文件头信息
        '''
        LICENSE_FILE_HEAD = {
            'CMO_LICENSE_HEAD_ COPYRIGHT': 0,  # 版权信息, string
            'CMO_LICENSE_HEAD_SERIALNO': 1,  # 文件生成序列号, string
            'CMO_LICENSE_HEAD_CREATOR': 2,  # 文件创建者, string
            'CMO_LICENSE_HEAD_CREATEDTIME': 3,  # 创建时间, string
            'CMO_LICENSE_HEAD_COUNTRY': 4,  # 所在国家, string
            'CMO_LICENSE_HEAD_CUSTOM': 5,  # 运营商名称, string
            'CMO_LICENSE_HEAD_OFFICE': 6  # 所在地区, string
        }

        '''
        Description: License使用情况
        '''
        LICENSE_FILE_USAGE = {
            'CMO_LICENSE_INFO_FEATURE_ID': 0,  # License特性ID, uint32
            'CMO_LICENSE_INFO_STATUS': 1,  # License的状态, uint32
            'CMO_LICENSE_INFO_OPEN_STATUS': 2,  # Licnese打开状态, uint32
            'CMO_LICENSE_INFO_LEFT_TIME': 3,  # 时间限制, uint32
            'CMO_LICENSE_INFO_RESOURCE_LIMIT': 4,  # 资源数限制, uint32
            'CMO_LINCENS_INFO_TOTAL': 5,  # 全部License数目, uint32
            'CMO_ CMO_LINCENS_INFO_USAGE': 6,  # 已用License数目, uint32
            'CMO_LICENSE_INFO_UNIT': 7  # , enum
        }

        '''
        Description: License导入路径
        '''
        LICENSE_PATH = {
            'CMO_LICENSE_DIR_INFO_DIR': 0  # License导入路径, string
        }

        '''
        Description: 配置
        '''
        EXPORT_CONFIG_DATA = {
            'CMO_EXPORT_DB_TYPE': 0,  # 导出方式, uint32
            'CMO_EXPORT_DRIVE_ID': 1,  # 硬盘编号, uint32
            'CMO_EXPORT_DB_DATA_DIR': 2  # 导出路径, string
        }

        '''
        Description: 运行数据
        '''
        EXPORT_RUNNING_DATA = {
            'CMO_ SYSTEM_CONFIG_DIR': 0  # , string
        }

        '''
        Description: 设备配置导入路径
        '''
        IMPORT_CONFIG_DATA = {
            'CMO_IMPORT_DB_CONFIG_DIR': 0  # 配置导入的路径, string
        }

        '''
        Description: 配置项
        '''
        CONFIG_ITEM = {
            'CMO_INI_SECTION_NAME': 0,  # 段名, string
            'CMO_INI_ITEM_NAME': 1,  # 配置项名, string
            'CMO_INI_ITEM_VALUE': 2  # 配置项值, string
        }

        '''
        Description: 信息打包
        '''
        EXPORT_ALL_LOG = {
            'CMO_EXPORT_TYPE': 0,  # 导出类型, uint32
            'CMO_EXPORT_PATH': 1,  # 导出的路径, String
            'CMO_EXPORT_RESULT': 2  # 导出结果, uint32
        }

        '''
        Description: OEM厂商信息
        '''
        OEM_INFO = {
            'CMO_OEM_MANUFACTORY_INFO': 0,  # 产商信息, string
            'CMO_OEM_BRAND_INFO': 1  # 品牌信息, string
        }

        '''
        Description: 客户信息
        '''
        CLIENT_INFO = {
            'CMO_CLIENT_NAME': 0  # 维护中心地址信息, string
        }

        '''
        Description: 系统时区
        '''
        SYSTEM_TIMEZONE = {
            'CMO_SYS_TIME_ZONE_NAME': 0,  # 时区名称, string
            'CMO_SYS_TIME_ZONE': 1,  # 时区, string
            'CMO_SYS_TIME_ZONE_NAME_STYLE': 2,  # 时区名称的显示风格, uint32
            'CMO_SYS_TIME_ZONE_USE_DST': 3  # 此时区是否使用了夏令时, uint32
        }

        '''
        Description: 系统本地时间
        '''
        SYSTEM_UTC_TIME = {
            'CMO_SYS_UTC_TIME': 0  # UTC时间, int64
        }

        '''
        Description: 夏令时配置
        '''
        SYSTEM_DST_CONFIG = {
            'CMO_SYS_DST_CONF_TIME_ZONE_NAME': 0,  # 时区名称, string
            'CMO_SYS_DST_CONF_DATE_TIME_BEGIN': 1,  # 系统当前时区夏令时起始日期时间, string
            'CMO_SYS_DST_CONF_DATE_TIME_END': 2,  # 系统当前时区夏令时结束日期时间, string
            'CMO_SYS_DST_CONF_ADJUST_TIME': 3,  # 夏令时调整时间, uint32
            'CMO_SYS_DST_CONF_MODE': 4  # 夏令时的配置方式, uint32
        }

        '''
        Description: NTP客户端配置
        '''
        NTP_CLIENT_CONFIG = {
            'CMO_SYS_NTP_CLNT_CONF_SWITCH': 0,  # NTP服务开启状态，默认为关闭, uint32
            'CMO_SYS_NTP_CLNT_CONF_SERVER_IP': 1,  # NTP服务器IP, String
            'CMO_SYS_NTP_SYNC_PERIOD': 2  # 同步时间周期, uint32
        }

        '''
        Description: SFTP用户信息
        '''
        SFTP_USER = {
            'CMO_SFTP_USER_TYPE': 0,  # 用户类型, uint32
            'CMO_SFTP_USER_NAME': 1,  # 用户名, string
            'CMO_SFTP_USER_PASSWORD': 2  # 密码, string
        }

        '''
        Description: SNMP配置信息
        '''
        SNMP_CONFIG = {
            'CMO_SNMP_ADDRESS': 0,  # , string
            'CMO_SNMP_PORT': 1,  # , uint32
            'CMO_SYS_ROOTOID': 2,  # , string
            'CMO_SYS_DESC': 3,  # , string
            'CMO_SYSS_OBJID': 4,  # , string
            'CMO_SNMP_NODE_CODE': 5,  # , string
            'CMO_SNMP_NODE_TYPE': 6,  # , uint32
            'CMO_SNMP_CONTEXTNAME': 7,  # , string
            'CMO_SNMP_ENGINEBOOTS': 8  # , uint32
        }

        '''
        Description: SNMP团体字
        '''
        SNMP_COMMUNITY = {
            'type': 0,  # ,
            'id': 1,  # 团体字ID, string
            'CMO_SNMP_RDCOMMUNITY': 64,  # , string
            'CMO_SNMP_WRCOMMUNITY': 65  # , string
        }

        '''
        Description: 安全名
        '''
        SNMP_USM = {
            'type': 0,  # ,
            'id': 1,  # 同安全用户名, string
            'CMO_USM_USER': 64,  # , string
            'CMO_USM_PASSWD': 65,  # , string
            'CMO_USM_ISDEFAULT': 66  # , bool
        }

        '''
        Description: Trap地址
        '''
        SNMP_TRAP_ADDR = {
            'type': 0,  # ,
            'id': 1,  # Trap 标识, string
            'CMO_TRAP_VERSION': 64,  # , enum
            'CMO_TRAP_SERVER_IP': 65,  # , string
            'CMO_TRAP_SERVER_PORT': 66,  # , uint32
            'CMO_TRAP_SERVER_TYPE': 67  # , enum
        }

        '''
        Description: DHA策略
        '''
        DHA_POLICY = {
            'CMO_START_TIME': 0,  # 采集开始时间, uint32
            'CMO_CPU_USE_RATE': 1,  # CPU使用阈值, uint32
            'CMO_MEMORY_USE_RATE': 2,  # 内存使用阈值, uint32
            'CMO_TIMING_RETRY': 3,  # 定时采集重试次数, uint32
            'CMO_EXCEPT_RETRY': 4,  # 异常采集延时时间, uint32
            'CMO_TIMING_DELAY': 5,  # 定时采集延时时间, uint32
            'CMO_EXCEPT_DELAY': 6,  # 异常采集延时时间, uint32
            'CMO_TASK_CYCLE': 7,  # 单次任务最大采集时间, uint32
            'CMO_COLLECT_CYCLE': 8,  # 采集周期, uint32
            'CMO_FILES_SPACE': 9  # 采集数据占用最大空间, uint32
        }

        '''
        Description: DHA策略
        '''
        DHA_POLICY_SWITCH = {
            'CMO_DHA_SERVICE_STATUS': 0  # HAD服务启停状态, uint32
        }

        '''
        Description: DHA策略
        '''
        DHA_EXPORT = {
            'CMO_DHA_EXPORT_TYPE': 0,  # 导出状态, uint32
            'CMO_DHA_EXPORT_PATH': 1  # 导出路径, string
        }

        '''
        Description: 
        '''
        DHA_LAST_RESULT = {
            'TaskType': 0,  # , uint32
            'TaskStatus': 1,  # , uint32
            'TaskExecutionResult': 2  # , uint32
        }

        '''
        Description: 
        '''
        DHA_SINGLE_TASK_SWITCH = {
            'switch': 0  # , uint32
        }

        '''
        Description: BACK_DB
        '''
        BACK_DB = {
            'product': 0,  # , string
            'version': 1,  # , uint32
            'save_time': 2  # , uint64
        }

        '''
        Description: BACK_DB
        '''
        DB_VERSION = {
            'version': 0,  # , uint32
            'modifyTime': 1  # , Time
        }

        '''
        Description: service
        '''
        SERVICE = {
            'NodeID': 0,  # , string
            'name': 1,  # , string
            'pid': 2,  # , uint32
            'status': 3,  # , uint32
            'memory': 4,  # , uint64
            'cpu': 5  # , uint32
        }

        '''
        Description: 用户
        '''
        USER = {
            'type': 0,  # 类型, enum
            'id': 1,  # 用户ID, string
            'name': 2,  # 用户名, string
            'description': 9,  # 用户描述, string
            'count': 10,  # 用户数, uint32
            'queryCondition': 15,  # 查询条件, json
            'level': 64,  # 级别, enum
            'password': 65,  # 密码, string
            'oldPassword': 66,  # 旧密码, string
            'addressInfo': 67,  # 登录客户端的IP地址或串口特定字符串, string
            'sessionKey': 68,  # 登录时获取的用户SessionKey, uint32
            'isOnLine': 69,  # 用户是否在线, enum
            'createTime': 70,  # 创建时间, uint64
            'scope': 71,  # 本地用户或者域用户, enum
            'userGroupName': 72,  # 用户组名称, string
            'email': 73,  # 邮箱地址, string
            'pwdChangeTime': 74,  # 上一次密码更新时间, time
            'token': 75,  # , string
            'accountState': 76,  # 帐号当前状态, enum
            'loginlog': 77  # , bool
        }

        '''
        Description: 用户组
        '''
        UserGroup = {
            'type': 0,  # 类型, enum
            'id': 1,  # 用户组ID，默认情况下超级管理员组不可见, string
            'name': 2,  # 用户组名, string
            'count': 10,  # 用户数, uint32
            'queryCondition': 15,  # 查询条件, json
            'description': 9,  # 用户描述, string
            'count': 10,  # 数量, uint32
            'createTime': 64,  # 创建时间, uint64
            'level': 65  # , enum
        }

        '''
        Description: 访问控制列表
        '''
        IPRule = {
            'type': 0,  # 类型, enum
            'id': 1,  # 规则ID, uint32
            'secureIP': 64,  # IP白名单, string
            'strategy': 65,  # 规则策略, enum
            'enable': 66  # 安全规则开关, bool
        }

        '''
        Description: LDAP配置
        '''
        LDAPConfig = {
            'type': 0,  # 类型, enum
            'id': 1,  # , string
            'count': 10,  # , uint32
            'serverIp': 64,  # 逗号分隔的LDAP服务器ip，最多4个IP, string
            'port': 65,  # LDAP服务端口, uint32
            'directoryType': 66,  # LDAP目录类型, enum
            'transferType': 67,  # 底层通讯协议类型, enum
            'bindDN': 68,  # 查询LDAP中数据时需要鉴权时的绑定目录, string
            'bindPasswd': 69,  # 查询密码, string
            'userSearchPath': 70,  # 用户信息所在的LDAP目录地址, string
            'groupSearchPath': 71,  # 用户组信息所在的LDAP目录地址, string
            'userIdAttr': 72,  # LDAP中的用户id属性, string
            'userNameAttr': 73,  # LDAP中的用户名属性, string
            'groupNameAttr': 74,  # LDAP中的用户组属性名, string
            'groupMemberAttr': 75,  # LDAP中的组成员属性名, string
            'userObjectClass': 76,  # LDAP中用户节点中使用的ObjectClass, string
            'groupObjectClass': 77,  # LDAP中组节点中使用的ObjectClass, string
            'baseDN': 78,  # 查询LDAP中数据时的起始目录, string
            'passwordHash': 79,  # 指定密码哈希方法, string
            'groupIdAttr': 80  # LDAP中的组id属性, string
        }

        '''
        Description: 
        '''
        SYS_STATUS = {
            'status': 1  # , enum
        }

        '''
        Description: 
        '''
        POWERON_RESULT = {
            'status': 1,  # , enum
            'err_code': 2,  # , uint32
            'param': 3  # , string
        }

        '''
        Description: 
        '''
        MONITOR_BOARD = {
            'type': 0,  # ,
            'id': 1,  # ,
            'tempe': 64,  # , uint32
            'PCB_VER': 65,  # , string
            'elabel': 66  # 电子标签, string
        }

        '''
        Description: cli视图
        '''
        CLI_VIEW = {
            'view': 2,  # , string
            'password': 65,  # , string
            'oldpasswd': 66  # , string
        }

        '''
        Description: 通用数据存储
        '''
        CommonData = {
            'type': 0,  # ,
            'id': 1,  # ,
            'value': 64  # 数据Value, json
        }

        '''
        Description: 枚举详情
        '''
        ENUM_INFO = {
            'enum_name': 0,  # 枚举的名称, string
            'enum_index': 1,  # 枚举的索引值, uint32
            'enum_glossary_cn': 2,  # 枚举的中文术语, String
            'enum_glossary_en': 3,  # 枚举的英文术语, String
            'enum_description_cn': 4,  # 枚举的中文描述, String
            'enum_description_en': 5  # 枚举的英文描述, String
        }

        '''
        Description: 文件引擎
        '''
        FILE_ENGINEER = {
            'CMO_INTEGRATION_IP_A': 0,  # 设备A控制器IP, String
            'CMO_INTEGRATION_IP_B': 1,  # 设备B控制器IP, String
            'CMO_INTEGRATION_USER': 2,  # 设备登陆用户名, String
            'CMO_INTEGRATION_PASSWD': 3,  # 设备登陆密码, String
            'CMO_INTEGRATION_DEV_TYPE': 4,  # 设备类型, String
            'CMO_INTEGRATION_USER_LEVEL': 5  # 用户级别, uint32
        }

        '''
        Description: 特性列表
        '''
        SPECIALITY_LIST = {
            'SPECIALITY': 0  # 特性, string
        }

        '''
        Description: 硬盘例测
        '''
        DISK_ROUTINE_TEST = {
            'enableRoutineTest': 0,  # 例测周期状态, bool
            'routineTestPeriod': 1  # 例测周期, uint32
        }

        '''
        Description: 控制器Io并发
        '''
        CONTROLLER_IO = {
            'id': 0,  # 控制器ID, string
            'frontEndIO': 1,  # 前端并发, uint32
            'frontEndLimit': 2,  # 前端并发的上限值, uint32
            'portType': 3,  # 后端端口类型, enum
            'portID': 4,  # 后端端口ID, string
            'backEndIO': 5,  # 后端并发, uint32
            'backEndLimit': 6  # 后端并发的上限值, uint32
        }

        '''
        Description: 文件传输
        '''
        FILE_TRANSFER = {
            'fileId': 0,  # 特性, enum
            'version': 1,  # 文件版本, string
            'content-type': 2,  # , string
            'start': 3,  # , uint32
            'end': 4,  # , string
            'data': 5,  # , memory
            'fileName': 6  # 文件名, string
        }

        '''
        Description: 子网段
        '''
        Subnet = {
            'type': 0,  # 类型, enum
            'id': 1,  # ID, string
            'name': 2,  # 对象名, string
            'description': 9,  # 描述, string
            'count': 10,  # , uint32
            'queryCondition': 15,  # , string
            'ip': 64,  # ipv地址，支持IPV4\IPV6, string
            'maskAndPrefix': 65  # 掩码或前缀, string
        }

        '''
        Description: 网络组
        '''
        NetGroup = {
            'type': 0,  # 类型, enum
            'id': 1,  # ID, string
            'name': 2,  # 名称, string
            'description': 9,  # 描述, string
            'count': 10,  # , uint32
            'queryCondition': 15,  # , string
            'netGroupName': 64  # 网络名称, string
        }

        '''
        Description: DNS服务器
        '''
        DNS_Server = {
            'type': 0,  # 类型, enum
            'tenancyId': 17,  # , uint32
            'address': 64  # 地址, array
        }

        '''
        Description: 快慢盘策略
        '''
        Slow_disk_policy = {
            'type': 0,  # 类型, enum
            'check_interval': 64,  # , uint32
            'slow_service_time': 65,  # , uint32
            'check_times': 66,  # , uint32
            'slow_cycle_threshold': 67,  # , uint32
            'combinated_cycle': 68  # , uint32
        }

        '''
        Description: SystemLicense
        '''
        SystemLicense = {
            'type': 0,  # 类型, enum
            'id': 1  # ID, string
        }

        '''
        Description: 命令执行上报
        '''
        CMD_NOTIFY_E = {
            'cmd': 0  # , uint64
        }

        '''
        Description: 管理用户安全策略
        '''
        USER_SECURITY_POLICY = {
            'type': 0,  # , enum
            'id': 1,  # , string
            'passwordMinLength': 64,  # 口令最小长度，默认值8, uint32
            'passwordMaxLength': 65,  # 口令最大长度，默认值16, uint32
            'pwdComplex': 66,  # 密码复杂性（是否支持特殊字符）, uint32
            'reduplicateCharCount': 67,  # 同一字符连续出现的最大次数, uint32
            'enablePwdLock': 68,  # 是否开启密码锁机制, bool
            'pwdLockTime': 69,  # 密码锁定时间, uint32
            'pwdIncorrectTimes': 70,  # 不正确密码次数, uint32
            'sessionExpiredTime': 71,  # 会话过期时间, uint32
            'minValidPeriod': 72,  # 人机登陆用户最短过期时间, uint32
            'maxValidPeriod': 73,  # 人机登陆用户密码过期时间, uint32
            'promptAhead': 74,  # 人机登陆用户提前提示的天数, uint32
            'historyCount': 75,  # 人机登陆用户口令历史记录, uint32
            'm2mUserPwdMinValidPeriod': 76,  # 接口对接用户最短过期时间, uint32
            'm2mUserPwdMaxValidPeriod': 77,  # 接口对接用户最大过期时间, uint32
            'm2mUserPwdPromptAhead': 78,  # 接口对接用户提前提示的天数, uint32
            'm2mUserPwdHistoryCount': 79,  # 接口对接用户口令历史记录, uint32
            'IPpwdIncorrectTimes': 80,  # 不正确密码次数锁定IP, uint32
            'pwdIncorrectInterval': 81  # 不正确密码输入间隔, uint32
        }

        '''
        Description: DPSVM虚拟机统计信息
        '''
        DPS_STATIS = {
            'numAllVM': 0,  # , uint32
            'numVMFail': 1,  # , uint33
            'numVMSuccess': 2,  # , uint34
            'numVM': 3  # , uint35
        }

        '''
        Description: 配置文件
        '''
        CONFIG_FILE_INFO = {
            'fileID': 0,  # 文件唯一标识, String
            'fileType': 1,  # 配置文件类型, enum
            'languageType': 2,  # 语言类型, enum
            'filePath': 3  # 文件路径, string
        }

        '''
        Description: 同步系统时间
        '''
        SYNC_TIME = {
            'SERVER_ID': 10  # 服务器ID标识, string
        }

        CHECK_IBC_PASSWORD = {
            "passwordChanged": 0,  # 返回IBC密码是否为默认密码
            "keypairIsChanged": 1  # 返回ibc_os_hs公私钥对是否已被修改
        }
        '''
       Description：虚拟机
        '''
        VirtualMachine = {
            'name': 2,  #
            'ownerControllerID': 4,  #
            'healthStatus': 7,  #
            'runningStatus': 8,  #
            'runningControllerID': 64,  #
        }

        # 记录转储或导出操作日志参数位置
        RECORD_OPERATION_LOG = {
            'operType': 0,
            'fileType': 1,
            'retValue': 3,
        }

        # 虚拟机端口信息
        VMPorts = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # enum
            'parentID': 4,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'mac': 64,  # Mac地址
            'mappingMode': 65,  # uint32, 映射模式(0：直通1：网桥)
            'useType': 66,  # 用途:0普通端口，1镜像端口,
            'bondName': 67,  # 所属的绑定口的名称
            'portType': 68,  # uint32与其依赖的物理口 1:eth  2:bond
            'portId': 69,  # 与其依赖的实际口ID，物理口返回物理口ID，绑定口返回绑定口ID
            'portLocation': 70,  # , 与其依赖的物理口Location，Location之间逗号间隔
            'mirrorVMPortId': 71,  # 当userType是镜像端口时，此字段表示对控的互为镜像的VMportID
        }

    '''
    Description: (公共)系统管理
    '''

    class Upgrade():
        '''
        Description: 查询升级版本
        '''
        CMO_CR_VER_INFO_S = {
            'CMO_VER_PACKAGE_TYPE': 0,  # 要查询的升级包类型, uint32
            'CMO_VER_RESULT': 0,  # 查询结果, uint32
            'CMO_VER_NODE_ID': 1,  # 节点ID, uint32
            'CMO_VER_NODE_NAME': 2,  # 节点名称, string
            'CMO_VER_NODE_IP': 3,  # 节点IP, string
            'CMO_VER_CUR_VERSION': 4,  # 当前运行的包版本号, string
            'CMO_VER_SAVED_VERSION': 5,  # 设备当前保存的可回退版本号, string
            'CMO_VER_NODE_TYPE': 6,  # 节点类型, string
            'CMO_VER_CUR_VERSION_FOR_USER': 7  # 设备当前的Spc版本信息, string
        }

        '''
        Description: 查询升级包上传路径
        '''
        CMO_PACKAGE_DIR_E = {
            'CMO_PACKAGE_TYPE': 0,  # 升级包类型, uint32
            'CMO_PACKAGE_DIR_FILE': 1  # 升级包导入目录, string
        }

        '''
        Description: 网管通知升级包上传路径
        '''
        CMO_NOTIFY_PACKAGE_PATH_E = {
            'CMO_NOTIFY_PACKAGE_PATH': 0,  # , string
            'CMO_NOTIFY_NODE_LIST': 1  # , string
        }

        '''
        Description: 查询升级包信息
        '''
        CMO_PACKAGE_INFO_E = {
            'CMO_PACKAGE_TYPE': 0,  # 升级包类型, uint32
            'CMO_PACKAGE_NODE_ID': 1,  # 节点ID, uint32
            'CMO_PACKAGE_INNER_VERSION': 2,  # 系统软件内部版本号, string
            'CMO_PACKAGE_TIME': 3,  # 版本发布时间（可选）, uint32
            'CMO_PACKAGE_SIZE': 4,  # 升级包大小以字节为单位（可选）, uint32
            'CMO_PACKAGE_STATUS': 5,  # 升级包状态, uint32
            'CMO_PACKAGE_SPC_VERSION': 6  # 系统软件外部版本号, string
        }

        '''
        Description: 查询升级包激活类型
        '''
        CMO_QUERY_ACTIVE_TYPE_E = {
            'CMO_ACTIVE_TYPE': 0  # 升级方式, uint32
        }

        '''
        Description: 通知执行升级执行一个流程
        '''
        CMO_NOTIFY_EXC_UPGRADE_E = {
            'CMO_EXE_UPD_MSGTYPE': 0,  # 执行步骤, uint32
            'CMO_EXE_UPD_NIDLIST': 1,  # 执行节点的IP列表, String
            'CMO_EXE_UPD_ACTIVETYPE': 2,  # 激活类型, uint32
            'CMO_EXE_UPD_BAKPATH': 3,  # 备份路径, String
            'CMO_EXE_UPD_EXENODETYPE': 4,  # 要执行的节点类型, String
            'CMO_EXE_UPD_EXEFLOW': 5,  # 待执行的流程名字, String
            'CMO_EXE_UPD_EXEFLOWSEGMENT': 6,  # 待执行的流程段名字, String
            'CMO_EXE_UPD_EXEATOM': 7,  # 待执行的原子名字, String
            'CMO_EXE_UPD_SYNCPAR': 8,  # 同步参数, String
            'CMO_EXE_UPD_PKG_TYPE': 9,  # 包类型, uint32
            'CMO_EXC_RESULT': 10,  # 处理结果, uint32
            'CMO_EXC_ERROR_INFO': 11  # 错误码, uint32
        }

        '''
        Description: 查询节点升级进度
        '''
        CMO_LST_NODE_UPSTATUS = {
            'CMO_NODE_UPSTATUS_NODE_LIST': 0,  # 节点列表, string
            'CMO_NODE_UPSTATUS_NODE_SERIAL': 1,  # 节点序列号, string
            'CMO_NODE_UPSTATUS_NODE_NAME': 2,  # 节点名称, string
            'CMO_NODE_UPSTATUS_NODE_IP': 3,  # 节点IP, string
            'CMO_NODE_UPSTATUS_STEP': 4,  # 节点当前所处的升级大步骤名称, string
            'CMO_NODE_UPSTATUS_NODE_STATUS': 5,  # 节点状态, string
            'CMO_NODE_UPSTATUS_STEP_REMAINTIME': 6,  # 节点当前subFLOW的剩余时间, uint32
            'CMO_NODE_UPSTATUS_NODE_PERCENT': 7,  # 节点当前SubFLOW的执行百分比, uint32
            'CMO_NODE_UPSTATUS_STEP_STARTTIME': 8,  # 节点当前SubFlowd开始时间, uint64
            'CMO_NODE_UPSTATUS_STEP_ENDTIME': 9  # 节点当前SubFLOW结束时间，UTC时间, uint64
        }

        '''
        Description: 查询升级过程详细信息
        '''
        CMO_PROCESS_DETAIL_INFO_S = {
            'CMO_DETAIL_ATOM_NAME': 0,  # 原子的名称, string
            'CMO_DETAIL_ATOM_STATE': 1,  # 原子状态值, uint32
            'CMO_DETAIL_ATOM_RECORD': 2,  # 错误码, string
            'CMO_DETAIL_NODE_ID': 3,  # 节点ID, uint32
            'CMO_DETAIL_NODE_IP': 4,  # 节点IP, string
            'CMO_DETAIL_ATOM_GROUP': 5,  # 原子所属的AG的名称, string
            'CMO_DETAIL_START_TIME': 6,  # 原子开始执行的时间, int64
            'CMO_DETAIL_END_TIME': 7  # 原子结束时间, int64
        }

        '''
        Description: 删除热补丁
        '''
        CMO_HOTPATCH_DELETE_S = {
        }

        '''
        Description: 升级硬盘
        '''
        CMO_DISK_FIRMWARE_S = {
            'CMO_DISK_FIRMWARE_UPD_TYPE': 0,  # 硬盘升级类型, uint32
            'CMO_DISK_FIRMWARE_FRAME_ID': 1,  # 用户框号, uint32
            'CMO_DISK_FIRMWARE_SLOT_ID': 2  # 硬盘槽号, uint32
        }

        '''
        Description: 获取硬盘升级状态
        '''
        CMO_GET_DISK_RESULT_S = {
            'CMO_DISK_FIRMWARE_UPD_TYPE': 0,  # 硬盘升级类型, uint32
            'CMO_DISK_FIRMWARE_FRAME_ID': 1,  # 用户框号, uint32
            'CMO_DISK_FIRMWARE_SLOT_ID': 2,  # 硬盘槽号, uint32
            'CMO_DISK_FIRMWARE_RESULT': 3  # 升级结果, uint32
        }

        '''
        Description: 管理板升级
        '''
        CMO_MGTBOARD_S = {
            'CMO_DISK_FIRMWARE_UPD_TYPE': 0,  # 硬盘升级类型, uint32
            'CMO_DISK_FIRMWARE_FRAME_ID': 1,  # 用户框号, uint32
            'CMO_DISK_FIRMWARE_SLOT_ID': 2  # 硬盘槽号, uint32
        }

        '''
        Description: 查询整体升级状态
        '''
        CMO_UPD_SYS_STATUS = {
            'CMO_UPD_SYS_MODE': 0,  # 升级方式, uint32
            'CMO_UPD_SYS_STEP_ID': 1,  # 执行步骤, uint32
            'CMO_UPD_SYS_STEP_REMAINTIME': 2,  # 执行步骤, uint32
            'CMO_UPD_SYS_STEP_TASK_STATUS': 3,  # 描述整个大步骤的状态, uint32
            'CMO_UPD_SYS_STEP_STEP_PERCENT': 4  # 升级各大步骤的进度百分比, uint32
        }

    '''
    Description: (公共)系统管理
    '''

    class Hardware():
        '''
        Description: 机框
        '''
        ENCLOSURE = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'model': 64,  # 型号, enum
            'logicType': 65,  # 类型, enum
            'temperature': 67,  # 温度, uint32
            'serialNum': 68,  # 序列号, string
            'macAddress': 69,  # MAC地址, string
            'height': 70,  # 高度, uint32
            'expanderDepth': 71,  # 级联深度, uint32
            'expanderPort': 72,  # SAS域或FC环路, string
            'switch': 73,  # 定位灯状态, enum
            'softVer': 76,  # Firmware版本, string
            'cpuUsage': 77,  # CPU占用率, uint32
            'memoryUsage': 78  # 内存使用率, uint32
        }

        '''
        Description: 控制器
        '''
        CONTROLLER = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'softVer': 64,  # Firmware版本, string
            'temperature': 65,  # 温度, int32
            'isMaster': 66,  # 主备状态, bool
            'elabel': 67,  # 电子标签, string
            'pcbVer': 68,  # PCB版本, string
            'sesVer': 69,  # SES版本, string
            'bmcVer': 70,  # BMC版本, string
            'logicVer': 71,  # 逻辑版本, string
            'biosVer': 72,  # BIOS版本, string
            'allTemperature': 73,  # 所有温度, array
            'memorySize': 74,  # Cache大小, uint32
            'cpuInfo': 75,  # CPU信息, string
            'role': 76,  # , enum
            'cpuUsage': 77,  # CPU占用率, uint32
            'memoryUsage': 78,  # 内存使用率, uint32
            'voltage': 79,  # 电压值, uint32
            'lightStatus': 80,  # 定位灯状态, enum
            'dirtyDataRate': 81  # 脏页面的占用率, uint32
        }

        '''
        Description: 级联板
        '''
        EXPBOARD = {
            'type': 0,  # 级联版,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # 框,
            'parentID': 4,  # 框ID,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'model': 64,  # 型号, enum
            'logicVer': 65,  # 逻辑版本, string
            'pcbVer': 66,  # PCB版本, string
            'sesVer': 67,  # SES版本, string
            'elabel': 68,  # 电子标签, string
            'voltage': 69,  # 电压值, uint32
            'lightStatus': 70  # 定位灯, enum
        }

        '''
        Description: 接口模块
        '''
        INTF_MODULE = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'model': 64,  # 型号, enum
            'elabel': 65,  # 电子标签, string
            'logicVer': 66,  # 逻辑版本, string
            'pcbVer': 67,  # PCB版本, string
            'temperature': 68,  # 温度值, uint32
            'lightStatus': 69,  # 定位灯, enum
            'runModel': 71  # 工作模式
        }

        '''
        Description: 硬盘
        '''
        DISK = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'queryCondition': 15,  # 查询条件, json
            'diskType': 64,  # 硬盘类型, enum
            'sectors': 65,  # 扇区数量, uint64
            'bandwidth': 66,  # 接口带宽, uint32
            'sectorSize': 67,  # 扇区大小, uint32
            'speedRPM': 68,  # 转速, uint32
            'temperature': 69,  # 温度, uint32
            'model': 70,  # 型号, string
            'firmwareVer': 71,  # 固件版本号, string
            'manufacturer': 72,  # 生产厂商, string
            'serialNumber': 73,  # 序列号, string
            'lightStatus': 74,  # , enum
            'logicType': 75,  # 逻辑类型, enum
            'poolID': 76,  # 所属POOL, string
            'poolName': 77,  # 所属POOL名称, string
            'poolTierID': 78,  # 所属Pool的Tier层, string
            'isCofferDisk': 79,  # 是否保险箱盘, bool
            'runTime': 80,  # 运行天数, uint32
            'progress': 81,  # 重构、回拷、预拷贝、销毁等的进度, uint32
            'ncqSwitch': 82,  # 磁盘类型相关的全局配置，磁盘Native Command Queuing 开关, bool
            'unplug': 83,  # 全局配置，磁盘调优参数, uint32
            'writeCacheSwitch': 84,  # 全局配置, bool
            'preCopySwitch': 85,  # 全局配置, bool
            'startLBA': 86,  # , uint32
            'Len': 87,  # , uint32
            'bstType': 88,  # logic/physic, enum
            'badtime': 89,  # 故障时间, int64
            'badtype': 90,  # 类型, uint32
            'sensekey': 91,  # sensekey, uint8
            'sensecode': 92,  # sensecode, uint16
            'fru': 93,  # fru, uint8
            'barcode': 94,  # 编码, string
            'badrate': 95,  # 坏盘率, uint32
            'capacityUsage': 96,  # 容量利用率, uint32
            'multiPath': 97,  # , array
            'healthMark': 98,  # 硬盘的健康评分, uint32
            'invalidTime': 99,  # 发生故障时间, Time
            'diskIFType': 100,  # 硬盘接口类型, enum
            'diskForm': 101,  # 硬盘外形尺寸, enum
            'diskPortAddr': 102,  # 对于不同接口的硬盘该值不同：FC:为FC PortWWN；SAS：为SAS Addrees，16位十六进制数；SATA：该字段为空, string
            'smartCachePoolId': 103,  # 所属SmartCache的ID, string
            'bstNum': 104  # BST数量, uint32
        }

        '''
        Description: 电源模块
        '''
        POWER = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'temperature': 64,  # 温度, uint32
            'powerType': 65,  # 电源类型, enum
            'inputVoltage': 66,  # 输入电压, uint32
            'outputVoltage': 67,  # 输出电压, uint32
            'manufacturer': 68,  # 生产厂商, string
            'model': 69,  # 型号, string
            'version': 70,  # 版本号, string
            'produceDate': 71,  # 生产日期, string
            'serialNumber': 72,  # 序列号, string
            'lightStatus': 73,  # 定位灯, enum
            'ratedPower': 74,  # 额定功率, uint32
            'totalOutputPower': 75,  # 电源总功耗, uint32
            'bundleID': 76  # 一体化硬件的槽位号的ID, string
        }

        '''
        Description: 备电模块
        '''
        BACKUP_POWER = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'backupPowerType': 64,  # , enum
            'Voltage': 65,  # 当前电压, uint32
            'RemainLifeDays': 66,  # 剩余寿命, uint32
            'chargeTimes': 67,  # 放电次数, uint32
            'firmwareVer': 68,  # Firmware版本, string
            'elabel': 69,  # 电子标签, string
            'manufacturedDate': 70,  # 出厂日期, string
            'controllerID': 71,  # 控制器ID, string
            'lightStatus': 72,  # 定位灯, enum
            'bundleID': 73  # 一体化硬件的槽位号的ID, string
        }

        '''
        Description: 风扇
        '''
        FAN = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'runLevel': 64,  # 运行档位, enum
            'elabel': 65,  # 电子标签, String
            'lightStatus': 66,  # 定位灯, enum
            'manufacturer': 67,  # 厂家信息, String
            'model': 68,  # 型号, String
            'serialNumber': 69,  # 序列号, String
            'version': 70,  # 版本号, String
            'elementName': 71,  # 类型+id（槽位置）, String
            'identifyingNumber': 72,  # 可选，可用序列号, String
            'vendor': 73,  # 生产厂商（集成厂商）, String
            'bundleID': 74  # 一体化硬件的槽位号的ID, String
        }

        '''
        Description: 风扇控制模块
        '''
        FAN_CTRL_MODULE = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'elabel': 65,  # 电子标签,
            'pcbVer': 66,  # pcb版本
        }

        '''
        Description: 路由信息
        '''
        ETH_PORT_ROUTE = {
            'portID': 0,  # , String
            'destination': 1,  # 目的地址, string
            'mask': 2,  # 掩码, string
            'gateway': 3,  # 网关, string
            'type': 4  # 类型, enum
        }

        '''
        Description: FC 端口
        '''
        FC_PORT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'logicType': 64,  # 逻辑类型, enum
            'runSpeed': 65,  # 运行速率, uint32
            'confSpeed': 66,  # 配置速率, uint32
            'wwn': 67,  # WWN, string
            'iniOrTgt': 68,  # 启动器/目标器, enum
            'sfpStatus': 69,  # 光模块状态, enum
            'fcConfMode': 70,  # 配置模式, enum
            'fcRunMode': 71,  # 运行模式, enum
            'lostSignals': 73,  # Loss of Signal,类型错误数目, uint32
            'badCharNumber': 74,  # Bad RX Char类型错误数目, uint32
            'lostSync': 75,  # Loss of Sync类型错误数目, uint32
            'linkFail': 76,  # Link Fail,类型错误数目, uint32
            'startTime': 77,  # 起始时间, uint32
            'floginDelayTimes': 78,  # , uint32
            'maxSupportSpeed': 79,  # 最大支持速率, uint32
            'lightStatus': 80,  # 定位灯, enum
            'ultrapathSwitch': 81  # 多路径切换标志, enum
        }

        '''
        Description: 绑定端口
        '''
        BOND_PORT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'portIDList': 64  # , array
        }

        '''
        Description: ETH端口
        '''
        ETH_PORT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'logicType': 64,  # 逻辑类型, enum
            'macAddress': 65,  # MAC地址, string
            'iniOrTgt': 66,  # 启动器/目标器, enum
            'ethDuplex': 67,  # 双工模式, enum
            'ethNegotiate': 68,  # 自协商模式, enum
            'MTU': 69,  # MTU, uint32
            'bondName': 70,  # 绑定名称, string
            'ipv4Addr': 71,  # IPv4地址, String
            'ipv4Mask': 72,  # IPv4掩码, String
            'ipv4Gateway': 73,  # IPv4网关, String
            'ipv6Addr': 74,  # IPv6地址, String
            'ipv6Mask': 75,  # IPv6掩码, String
            'ipv6Gateway': 76,  # IPv6网管, String
            'iscsiTcpPort': 77,  # iSCSI端口号, String
            'iscsiName': 78,  # iSCSI名称, String
            'errorPackets': 80,  # 错误包数, uint32
            'lostPackets': 81,  # 丢失包数, uint32
            'OverflowedPackets': 82,  # 溢出包数, uint32
            'startTime': 83,  # 统计起始时间, uint32
            'speed': 84,  # , uint32
            'lightStatus': 85,  # 定位灯, enum
            'ultrapathSwitch': 86,  # 多路径切换标志, enum
            'vlan': 87,  # VLAN的ID, uint32
            'selectType': 88,  # 查询类型, enum
            'zoneId': 91,  # IP Scale-Out中该端口连接的交换平面号，String
            'dswId': 92,  # IP Scale Out组网连接的交换机ID， String
            'dswLinkRight': 93,  # IP Scale Out组网时端口是否连接正确，String
        }

        '''
        Description: FCoE 端口
        '''
        FCoE_PORT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'logicType': 64,  # 逻辑类型, enum
            'runSpeed': 65,  # 运行速率, uint32
            'wwn': 66,  # WWN, string
            'iniOrTgt': 67,  # 启动器/目标器, enum
            'sfpStatus': 68,  # 光模块状态, enum
            'errorPackets': 69,  # 错误包数, uint32
            'lostPackets': 70,  # 丢失包数, uint32
            'OverflowedPackets': 71,  # 溢出包数, uint32
            'startTime': 72,  # 统计起始时间, uint32
            'ultrapathSwitch': 73,  # 多路径切换标志, enum
            'vlanID': 74  # vlanID, int32
        }

        '''
        Description: SAS端口
        '''
        SAS_PORT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'logicType': 64,  # 逻辑类型, enum
            'runSpeed': 65,  # 运行速率, uint32
            'wwn': 66,  # WWN, string
            'iniOrTgt': 67,  # 启动器/目标器, enum
            'portSwitch': 69,  # , bool
            'invalidDword': 70,  # 无效DWORD数, uint32
            'disparityError': 71,  # 一致性错误数, uint32
            'lossDword': 72,  # 丢失DWORD同步数, uint32
            'PHYResetErrors': 73,  # PHY reset 失败数, uint32
            'startTime': 74,  # 开始统计时间, uint32
            'current_peer_port_id': 75,  # 当前连接的对端端口ID, string
            'suggest_peer_port_id': 76,  # 应该连接的对端端口ID, string
            'lightStatus': 77,  # 定位灯, enum
            'isMiniSAS': 78,  # , bool
            'enclosureWWNList': 80,  # 端口所连接环路中的所有硬盘框的WWN
        }

        '''
        Description: IB端口
        '''
        IB_PORT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'logicType': 64,  # 逻辑类型, enum
            'runSpeed': 65,  # 运行速率, uint32
            'wwn': 67,  # WWN, string
            'iniOrTgt': 68,  # 启动器/目标器, enum
            'portSwitch': 69,  # 端口开关, bool
            'symbolErrorCounter': 73,  # 符号错误统计, uint32
            'linkErrorRecoveryCounter': 74,  # 连接错误恢复数据统计, uint32
            'portRcvErrors': 75,  # 端口接收错误, uint32
            'portRcvRemotePhysicalErrors': 76,  # 端口远程接收错误   , uint32
            'portRcvSwitchRelayErrors': 77,  # 端口接收转发错误, uint32
            'portXmitConstraintErrors': 78,  # 未被switch端口发送的包计数, uint32
            'portRcvConstraintErrors': 79,  # 端口接收强制错误, uint32
            'localLinkIntegrityErrors': 80,  # 本地连接错误, uint32
            'excessiveBufferOverrunErrors': 81,  # buffer溢出错误, uint32
            'startTime': 82  # 起始时间, uint32
        }

        '''
        Description: 串口
        '''
        SERIAL_PORT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'logicType': 64  # 逻辑类型, enum
        }

        '''
        Description: PCIE端口
        '''
        PCIE_PORT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # 数据交换机或者控制器,
            'parentID': 4,  # 数据交换机或者控制器ID,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # PCIE链路状态linkup/linkdown,
            'pcieSpeed': 64,  # PCIE链路数据速率, uint32
            'current_peer_port_id': 65,  # 当前连接的对端端口ID, string
            'suggest_peer_port_id': 66,  # 应该链接的对端端口ID, string
            'lostSignals': 67,  # PCIE端口误码数量, uint32
            'portSwitch': 68,  # 端口开或关, enum
            'lightStatus': 69,  # 定位灯, enum
            'ECRCError': 70,  # ECRC错误数, uint32
            'BadTLP': 71,  # 坏TLP个数, uint32
            'BadDLLP': 72,  # 坏DLLP个数, uint32
            'RecvError': 73,  # 接收器错误个数, uint32
            'ChipECCError': 74,  # 芯片ECC错误个数, uint32
            'startTime': 74  # 开始统计时间, uint32
        }

        '''
        Description: 仅具有命令字的操作
        '''
        CMD_ONLY = {
            'enable': 0  # , bool
        }

        '''
        Description: 内存条信息
        '''
        MEMORY = {
            'type': 0,  # 对象类型, enum
            'ID': 1,  # 内存编号, string
            'parentType': 3,  # 控制器,
            'parentID': 4,  # 控制器ID,
            'SN': 64,  # 内存序列号, string
            'capacity': 65,  # 容量, int64
            'vendor': 66  # 厂商, string
        }

        '''
        Description: CPU
        '''
        CPU = {
            'type': 0,  # 对象类型, enum
            'id': 1,  # 对象ID,
            'parentType': 3,  # 控制器,
            'parentID': 4,  # 控制器ID,
            'healthStatus': 7,  # 健康状态, enum
            'coreTemp': 64,  # 核心温度, uint32
            'volts': 65,  # 核心电压, uint32
            'eCCError': 66,  # ECC错误, string
            'workFrequency': 67,  # , uint32
            'currentFrequency': 68,  # , uint32
            'frequencySwitch': 69  # , bool
        }

        '''
        Description: 光模块
        '''
        SFP_OPTICAL_TRANSCEIVER = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'location': 6,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'sfpModeType': 64,  # 单模/多模, enum
            'waveLength': 65,  # 波长, uint32
            'rxPower': 66,  # 接收功率, uint32
            'txPower': 67,  # 发送功率, uint32
            'speed': 68,  # 速率, uint32
            'temperature': 69,  # 温度, uint32
            'voltage': 70,  # 电压, uint32
            'vendor': 71,  # , string
            'model': 72,  # , string
            'sn': 73  # , string
        }

        '''
        Description: 机架
        '''
        BAY = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'location': 6,  # ,
            'model': 64,  # MODEL, enum
            'newID': 65  # , String
        }

        '''
        Description: 硬盘扫描
        '''
        DISK_SCAN_TASK = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentID': 4,  # ,
            'location': 6,  # ,
            'runningStatus': 8,  # 运行状态, enum
            'progress': 65,  # 进度, uint32
            'remainTime': 66,  # 剩余时间, string
            'scanScope': 67,  # 扫描范围, enum
            'scanObjList': 69  # , array
        }

        '''
        Description: IB启动器（主机端口）
        '''
        IB_INITIATOR = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'queryCondition': 15,  # ,
            'isFree': 64,  # 是否空闲, bool
            'multiPathType': 65,  # 多路径类型, enum
        }

    '''
    Description: (公共)系统管理
    '''

    class PoolLunMap():
        '''
        Description: LUN
        '''
        LUN = {'type': 0,  # ,
               'id': 1,  # ,
               'name': 2,  # ,
               'parentType': 3,  # ,
               'parentID': 4,  # ,
               'parentName': 5,  # ,
               'healthStatus': 7,  # ,
               'runningStatus': 8,  # ,
               'description': 9,  # ,
               'count': 10,  # ,
               'associateObjType': 11,  # ,
               'associateObjID': 12,  # ,
               'associateMetadata': 13,  # ,
               'queryCondition': 15,  # ,
               'allocType': 64,  # 类型, enum
               'capacity': 65,  # 配置容量, uint64
               'initialAllocCapacity': 66,  # 初始分配容量, uint64
               'allocCapacity': 67,  # 实际占用容量, uint64
               'sectorSize': 68,  # 块大小, uint32
               'exposedToInitiator': 69,  # 是否映射, bool
               'wwn': 70,  # WWN, string
               'dataDistributing': 71,  # 数据分布, array
               'WritePolicy': 72,  # 写策略, enum
               'RunningWritePolicy': 73,  # 运行写策略, enum
               'mirrorPolicy': 74,  # 镜像策略, enum
               'prefetchPolicy': 75,  # 预取策略, enum
               'PrefetchValue': 76,  # 预取策略值, uint32
               'owningController': 77,  # 归属控制器, string
               'workingController': 78,  # 工作控制器, string
               'SnapshotIDs': 79,  # 快照ID列表, array
               'LUNCopyIDs': 80,  # LUN拷贝ID列表, array
               'RemoteReplicationIDs': 81,  # 远程复制ID列表, array
               'SplitMirrorIDs': 82,  # 分裂镜像ID列表, array
               'dataTransferPolicy': 83,  # 数据迁移策略, enum
               'initialDistributePolicy': 84,  # 初始分配策略, enum
               'IOClassID': 85,  # IO分类, string
               'wormRetentionAble': 86,  # 是否可设置WORM, bool
               'retentionState': 87,  # WORM LUN状态, enum
               'retentionTerm': 88,  # WORM 保护周期, uint32
               'retentionTime': 89,  # WORM 已保护时间, uint32
               'retentionSetTime': 90,  # 设置为WORM LUN为只读LUN的时间, uint64
               'moveToTier0Data': 91,  # 待迁往tier0的数据量, uint32
               'moveToTier1Data': 92,  # 待迁往tier1的数据量, uint32
               'moveToTier2Data': 93,  # 待迁往tier2的数据量, uint32
               'metaCapacity': 94,  # 元数据容量扇区数, uint64
               'IOPriority': 95,  # IO优先级, enum
               'DRS_Enable': 96,  # , bool
               'CAPABILITY': 97,  # , enum
               'existsIO': 98,  # , bool
               'smartCacheState': 99,  # SmartCache的状态, enum
               'SC_CachedSize': 100,  # SmartCache缓存量, uint64
               'SC_CachedRage': 101,  # SmartCache缓存比, uint32
               'SC_HitRage': 102,  # SmartCache命中率, uint32
               'capacityAlarmLevel': 103,  # , enum
               'thinCapacityUsage': 104,  # , uint32
               'DGList': 105,  # , array
               'isCheckZeroPage': 106,  # , bool
               'replicationCapacity': 107,  # 数据保护容量, uint64
               'readCachePolicy': 108,  # 读Cache策略, enum
               'writeCachePolicy': 109,  # 写Cache策略, enum
               'grainSize': 110,  # , uint32
               'faultSwitch': 111,  # , bool
               'CachePartitionID': 112,  # Cache Partition ID, string
               'isAdd2LunGroup': 113,  # 是否已添加给LUN组, bool
               'SmartCachePartitionID': 114,  # SmartCache Partition ID, string
               'progress': 115,  # 进度, uint32
               'extendDifSwitch': 116  # 是否支持外部DIF特性, bool
               }

        '''
        Description: LUN Backgroud Task
        '''
        LUNBackgroudTask = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'runningStatus': 8,  # ,
            'process': 64,  # 进度, uint32
            'remainTime': 65,  # 预计剩余时间, uint32
            'startTime': 66,  # 启动时间, Time
            'duration': 67,  # 持续时间, uint32
            'taskType': 68  # 任务类型, enum
        }

        '''
        Description: 存储池
        '''
        STORAGEPOOL = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'queryCondition': 15,  # ,
            'workNodeID': 64,  # 工作节点, string
            'userTotalCapacity': 65,  # 总容量, uint64
            'userFreeCapacity': 66,  # 空闲容量, uint64
            'userConsumedCapacity': 67,  # 已用容量, uint64
            'userConsumedCapacityPercentage': 68,  # 已用容量百分比, uint32
            'userConsumedCapacityThreshold': 69,  # 已用容量阈值, uint32
            'hotspareSpaceTotalCapacity': 70,  # 热备空间总容量, uint64
            'hotspareSpaceConsumedCapacity': 71,  # 热备空间已用容量, uint64
            'hotspareSpaceConsumedCapacityPercentage': 72,  # 用户热备空间已用容量百分比, uint32
            'levelingSpeed': 73,  # 均衡速度, uint32
            'DSTStatus': 74,  # DST特性状态, enum
            'DSTRunningStatus': 75,  # 迁移运行状态, enum
            'ExtentSize': 76,  # 迁移粒度, uint32
            'migrationMode': 77,  # 迁移触发模式, enum
            'migrationDays': 78,  # 迁移日子, array
            'migrationStartTime': 79,  # 迁移起始时间, Time
            'migrationDurationTime': 80,  # 迁移持续时间, uint32
            'MonitorDays': 81,  # , array
            'MonitorStartTime': 82,  # IO监控起始时间, string
            'MonitorDurationTime': 83,  # IO监控持续时间, uint32
            'allMigrationSpeedLevel': 84,  # 全局迁移速度, enum
            'immediateMigration': 85,  # 立即迁移开关, bool
            'immediateMigrationDurationTime': 86,  # 立即迁移持续时间, uint32
            'pauseMigrationSwitch': 87,  # 暂停迁移开关, bool
            'moveUpData': 88,  # 待上迁数据量, uint64
            'moveDownData': 89,  # 待下迁数据量, uint64
            'migrationEstimatedTime': 90,  # 迁移时间, uint32
            'tier0RaidLv': 91,  # RAID级别, enum
            'tier0RaidDiskNum': 92,  # RAID逻辑成员盘数量, uint32
            'tier0DiskNum': 93,  # 硬盘数量, uint32
            'tier0DiskType': 94,  # 硬盘类型, enum
            'tier0DiskList': 95,  # Tier0磁盘列表, array
            'tier0HotspareSpaceStrategy': 96,  # 热备策略, enum
            'tier1RaidLv': 97,  # RAID级别, enum
            'tier1RaidDiskNum': 98,  # RAID逻辑成员盘数量, uint32
            'tier1DiskNum': 99,  # 硬盘数量, uint32
            'tier1DiskType': 100,  # 硬盘类型, enum
            'tier1DiskList': 101,  # Tier1磁盘列表, array
            'tier1HotspareSpaceStrategy': 102,  # 热备策略, enum
            'tier2RaidLv': 103,  # RAID级别, enum
            'tier2RaidDiskNum': 104,  # RAID逻辑成员盘数量, uint32
            'tier2DiskNum': 105,  # 硬盘数量, uint32
            'tier2DiskType': 106,  # 硬盘类型, enum
            'tier2DiskList': 107,  # Tier2磁盘列表, array
            'tier2HotspareSpaceStrategy': 108,  # 热备策略, enum
            'tier0StripeDepth': 109,  # 分条深度, uint32
            'tier1StripeDepth': 110,  # 分条深度, uint32
            'tier2StripeDepth': 111,  # 分条深度, uint32
            'movedUpData': 112,  # 已上迁数据量, uint32
            'movedDownData': 113,  # 已下迁数据量, uint32
            'migrationScheduleID': 114,  # 迁移时刻表ID, array
            'monitorScheduleID': 115,  # 监控时刻表ID, array
            'rawCapacity': 116,  # 原始容量, uint64
            'invalidTime': 117,  # , Time
            'enableSpindown': 118,  # 是否启动休眠, bool
            'SpindownScheduleID': 119,  # 休眠时刻表ID, array
            'nasProperties': 120,
            # 格式如：{"dedup":0,"dedupditto":100,"dedupRetrenchCapacity":66,"supportL2acc":1,"useL2accCapacity":2000,tie1saveSwitch:0,tie1L1Threshold:30,tie1L1DelayTime:10,tie1L2Threshold:60,tie1L2DelayTime:10,tie1allocGrpNum:0,tie2saveSwitch:0,tie2L1Threshold:30,tie2L1DelayTime:10,tie2L2Threshold:60,tie2L2DelayTime:10,tie2allocGrpNum=0,"tie0Capacity":4096000000, "tie0Used":1024, "tie1Capacity":4096000000, "tie1Used":1024, "tie2Capacity":4096000000, "tie2Used":1024}, string
            'nasTier': 121,
            # {"tier0":[{"num":8,"size":500GB,"type":"SSD"},{"num":7,"size":"1TB","type":"SSD"}],"tier1":[{"num":8,"size":500GB,"type":SAS},{"num":7,"size":"1TB","type":"SAS"}],"tier2":[{"num":8,"size":"500GB","type":"NL_SAS"},{"num":7,"size":"1TB","type":"NL_SAS"},{"num":8,"size":"500GB","type":"SATA"},{"num":7,"size":"1TB","type":"SATA"}]}, string
            'reservedCapacity': 122,  # 预留容量, uint64
            'sectorSize': 123,  # 块大小, uint32
            'tier0Capacity': 124,  # Tier 0 裸容量, uint64
            'tier1Capacity': 125,  # Tier 1 裸容量, uint64
            'tier2Capacity': 126,  # Tier 2 裸容量, uint64
            'replicationCapacity': 127,  # 数据保护容量, uint64
            'spindownTrigger': 128,  # 休眠触发模式, enum
            'spindownManner': 129,  # 休眠方式, enum
            'spindownDetectTime': 130,  # 休眠检测时间, uint32
            'enableSmartCache': 131  # 是否启动SmartCache, bool
        }

        '''
        Description: 时刻表
        '''
        SCHEDULE = {
            'type': 0,  # , enum
            'id': 1,  # , string
            'name': 2,  # , string
            'relatedObjID': 64,  # , array
            'app_type': 65,  # , enum
            'Days': 66,  # 迁移日子, array
            'StartTime': 68,  # 起始时间, string
            'DurationTime': 69,  # 持续时间, uint32
            'DayHours': 70,  # , array
            'DayMinute': 71,  # , uint32
            'MonthDays': 72,  # , array
            'MonthStartTime': 73  # 起始时间, string
        }

        '''
        Description: 存储池预测分析
        '''
        STORAGEPOOL_ANALYSIS = {
            'poolid': 0,  # , string
            'predictionSwitchStatus': 1,  # , bool
            'tier0_disktype': 2,  # , enum
            'tier1_disktype': 3,  # , enum
            'tier2_disktype': 4,  # , enum
            'tier0_raidlevel': 5,  # , enum
            'tier0_raiddisknum': 6,  # , uint32
            'tier1_raidlevel': 7,  # , enum
            'tier1_raiddisknum': 8,  # , uint32
            'tier2_raidlevel': 9,  # , enum
            'tier2_raiddisknum': 10,  # , uint32
            'lastPredictTime': 11,  # , uint64
            'tier0_capRatio': 12,  # , uint32
            'tier1_capRatio': 13,  # , uint32
            'tier2_capRatio': 14,  # , uint32
            'tier0_iops': 15,  # , uint64
            'tier1_iops': 16,  # , uint64
            'tier2_iops': 17,  # , uint64
            'tier0_bandwidth': 18,  # , uint64
            'tier1_bandwidth': 19,  # , uint64
            'tier2_bandwidth': 20,  # , uint64
            'enabled_time': 21  # , uint64
        }

        '''
        Description: Pool后台任务
        '''
        POOLTASK = {
            'taskType': 0,  # 任务类型, enum
            'diskEnclosureId': 1,  # 硬盘框号, uint32
            'diskSlotId': 2,  # 硬盘槽号, uint32
            'dataSize': 3,  # 总数据量, uint64
            'dataFinishedSize': 4,  # 已完成的数据量, uint64
            'remainTime': 5,  # 预计剩余时间, string
            'poolID': 6,  # 所属 Pool ID, string
            'process': 7  # 进度, uint32
        }

        '''
        Description: 存储层
        '''
        STORAGETIER = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'raidLv': 64,  # RAID级别, enum
            'raidDiskNum': 65,  # RAID逻辑成员盘数量, uint32
            'diskNum': 66,  # 硬盘数量, uint32
            'diskType': 67,  # 硬盘类型, enum
            'diskList': 68,  # ~~, array
            'tierHotspareSpaceStrategy': 69,  # 热备策略, enum
            'tierUserCapacity': 70,  # 用户容量, uint64
            'tierConsumedCapacity': 71,  # 已用容量, uint64
            'tierAvailableCapacity': 72,  # 可用容量, uint64
            'tierMoveUpData': 73,  # 待上迁数据量, uint64
            'tierMoveDownData': 74,  # 待下迁数据量, uint64
            'stripeDepth': 75,  # 分条深度, uint32
            'tierHotspareTotalCapacity': 76,  # 热备空间总容量, uint64
            'tierHotspareConsumedCapacity': 77  # 热备空间已用容量, uint64
        }

        '''
        Description: 磁盘扫描配置
        '''
        DiskScanConf = {
            'executeStatus': 0,  # , bool
            'ioType': 1,  # , enum
            'period': 2,  # , uint32
            'singleDiskMaxLoad': 3,  # , uint32
            'maxDiskUtil': 4  # , uint32
        }

        '''
        Description: 坏道修复失败校验配置
        '''
        RepairVerifyConf = {
            'switchStatus': 0,  # , bool
            'verifyPeriod': 1,  # , uint32
            'verifyTimes': 2  # , uint32
        }

        '''
        Description: 坏块标记开关配置
        '''
        BstSwitchConf = {
            'switchStatus': 0  # , bool
        }

        '''
        Description: CHUNK隔离配置
        '''
        ChunkIsolateConf = {
            'isolateChunkThreshold': 0  # , uint32
        }

        '''
        Description: 映射视图
        '''
        MAPPINGVIEW = {
            'type': 0,  # 映射视图,
            'id': 1,  # ID,
            'name': 2,  # 名称,
            'healthStatus': 7,  # 健康状态,
            'runningStatus': 8,  # 运行状态,
            'description': 9,  # 描述,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'associateMetadata': 13,  # ,
            'queryCondition': 15,  # ,
            'LunMapping': 64,  # LUN映射表, array
            'snapshotMapping': 65,  # 快照映射表, array
            'hostLunID': 66,  # 主机LUN ID, uint32
            'enableInbandCommand': 67,  # 是否启用命令设备, bool
            'inbandLunWWN': 68,  # 命令设备WWN, string
            'workMode': 69,  # , enum
            'lunWWN': 70,  # , string
            'forFileSystem': 71  # , bool
        }

        '''
        Description: 主机
        '''
        HOST = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'location': 6,  # 位置,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'associateMetadata': 13,  # ,
            'queryCondition': 15,  # ,
            'operationSystem': 64,  # 操作系统, enum
            'networkName': 65,  # 域名, string
            'ip': 66,  # IP, string
            'model': 68,  # 型号, string
            'isAdd2HostGroup': 69  # 是否已添加给HostGroup, bool
        }

        '''
        Description: iSCSI启动器（主机端口）
        '''
        ISCSI_INITIATOR = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'queryCondition': 15,  # ,
            'isFree': 64,  # 是否空闲, bool
            'useChap': 65,  # 是否启用CHAP, bool
            'chapName': 66,  # CHAP名, string
            'chapPassword': 67,  # CHAP密码, string
            'multiPathType': 68,  # 多路径类型, enum
            'operationSystem': 69  # 操作系统, enum
        }

        '''
        Description: FC启动器（主机端口）
        '''
        FC_INITIATOR = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'queryCondition': 15,  # ,
            'isFree': 64,  # 是否空闲, bool
            'multiPathType': 65,  # 多路径类型, enum
            'operationSystem': 69  # 操作系统, enum
        }

        '''
        Description: iSCSIDeviceName
        '''
        iSCSIDeviceName = {
            'CMO_ISCSI_DEVICE_NAME': 0  # iSCSI设备名称, string
        }

        '''
        Description: ISNS_SERVER
        '''
        ISNS_SERVER = {
            'CMO_ISNS_SERVER_IP': 0  # iSNS服务IP地址, string
        }

        '''
        Description: iSCSI会话
        '''
        ISCSI_SESSION = {
            'type': 0,  # ,
            'id': 1,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'targetPortID': 64,  # , string
            'targetPortTPGT': 65,  # , uint32
            'sessionType': 66,  # , enum
            'targetSessionIdentifyingHandle': 67,  # , uint32
            'endPointName': 68,  # , string
            'currentConnections': 69,  # , uint32
            'initialR2T': 70,  # , bool
            'immediateData': 71,  # , bool
            'maxOutstandingR2T': 72,  # , uint32
            'maxUnsolicitedFirstDataBurstLength': 73,  # , uint32
            'maxDataBurstLength': 74,  # , uint32
            'dataSequenceInOrder': 75,  # , uint32
            'dataPDUInOrder': 76,  # , uint32
            'errorRecoveryLevel': 77,  # , uint32
            'maxConnectionsPerSession': 78,  # , uint32
            'defaultTimeToWait': 79,  # , uint32
            'defaultTimeToRetain': 80  # , uint32
        }

        '''
        Description: iSCSI会话初始参数信息
        '''
        iSCSI_SESSION_SETTING = {
            'type': 0,  # ,
            'id': 1,  # ,
            'iSCSINodeName': 64,  # , string
            'maxConnectionsPerSession': 65,  # , uint32
            'initialR2TPreference': 66,  # , bool
            'immediateDataPreference': 67,  # , bool
            'maxOutstandingR2T': 68,  # , uint32
            'maxUnsolicitedFirstDataBurstLength': 69,  # , uint32
            'maxDataBurstLength': 70,  # , uint32
            'dataSequenceInOrderPreference': 71,  # , bool
            'dataPDUInOrderPreference': 72,  # , bool
            'defaultTimeToWaitPreference': 73,  # , uint32
            'defaultTimeToRetainPreference': 74,  # , uint32
            'errorRecoveryLevelPreference': 75  # , uint32
        }

        '''
        Description: iSCSI目标器节点信息
        '''
        iSCSI_TGT_Node = {
            'type': 0,  # ,
            'id': 1,  # ,
            'iSCSINodeAliase': 64  # , string
        }

        '''
        Description: iSCSI目标器端口信息
        '''
        iSCSI_TGT_Port = {
            'type': 0,  # ,
            'id': 1,  # ,
            'associateObjType': 11,  # EthPort类型,
            'associateObjID': 12,  # EthPort ID,
            'TPGT': 65,  # , uint32
            'EthPortID': 67  # , string
        }

        '''
        Description: 主机链路
        '''
        HOST_LINK = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'initiator_type': 64,  # , enum
            'initiator_id': 65,  # , string
            'initiator_port_wwn': 66,  # , string
            'initiator_node_wwn': 67,  # , string
            'target_type': 68,  # , enum
            'target_id': 69,  # , string
            'target_port_wwn': 70,  # , string
            'target_node_wwn': 71,  # , string
            'target_alternatename': 72,  # , string
            'ctrl_id': 73  # , string
        }

        '''
        Description: LUN组/FS组
        '''
        LUNGroup = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'queryCondition': 15,  # ,
            'tenancyId': 17,  # , uint32
            'isAdd2MapingView': 64,  # 是否已添加给映射视图, bool
            'appType': 65,  # , enum
            'groupType': 66,  # , uint32
            'capacity': 67,  # 配置容量, uint64
            'configData': 68  # , string
        }

        '''
        Description: 主机组
        '''
        HostGroup = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'description': 9,  # 描述,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'queryCondition': 15,  # ,
            'isAdd2MapingView': 64  # 是否已添加给映射视图, bool
        }

        '''
        Description: 端口组
        '''
        PortGroup = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'description': 9,  # 描述,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'queryCondition': 15  # ,
        }

        '''
        Description: SmartMotion View Group
        '''
        SmartMotion_ViewGroup = {
            'type': 0,  # ,
            'id': 1,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12  # ,
        }

        '''
        Description: SmartMotion Task
        '''
        SmartMotion_Task = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'process': 64,  # 进度, uint32
            'remainTime': 65  # 预计剩余时间, uint32
        }

        '''
        Description: 硬盘组
        '''
        DiskGroup = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'associateMetadata': 13,  # ,
            'diskType': 64,  # DiskGroup的硬盘类型, enum
            'sectorSize': 65,  # 块大小, uint32
            'totalCapacity': 66,  # DG的总可用裸容量, uint64
            'freeCapacity': 67  # DG的剩余裸容量, uint64
        }

        '''
        Description: 硬盘域
        '''
        DiskPool = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'description': 9,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'associateObjIDList': 16,  # , array
            'totalCapacity': 64,  # 总可用裸容量, uint64
            'spareCapacity': 65,  # 总热备裸容量, uint64
            'usedSpareCapacity': 66,  # 已用热备裸容量, uint64
            'freeCapacity': 67,  # 空闲容量, uint64
            'SSDtotalCapacity': 68,  # SSD总可用裸容量, uint64
            'SSDspareCapacity': 69,  # SSD总热备裸容量, uint64
            'SSDusedSpareCapacity': 70,  # SSD已用热备裸容量, uint64
            'SSDfreeCapacity': 71,  # SSD空闲裸容量, uint64
            'SAStotalCapacity': 72,  # SAS总可用裸容量, uint64
            'SASspareCapacity': 73,  # SAS总热备裸容量, uint64
            'SASusedSpareCapacity': 74,  # SAS已用热备裸容量, uint64
            'SASfreeCapacity': 75,  # SAS空闲裸容量, uint64
            'NLSAStotalCapacity': 76,  # NLSAS总可用裸容量, uint64
            'NLSASspareCapacity': 77,  # NLSAS总热备裸容量, uint64
            'NLSASusedSpareCapacity': 78,  # NLSAS已用热备裸容量, uint64
            'NLSASfreeCapacity': 79,  # NLSAS空闲裸容量, uint64
            'SSDhotspareStrategy': 80,  # SSD热备策略, enum
            'SAShotspareStrategy': 81,  # SAS热备策略, enum
            'NLSAShotspareStrategy': 82,  # NLSAS热备策略, enum
            'SSDdiskNum': 83,  # SSD成员盘个数, int32
            'SASdiskNum': 84,  # SAS成员盘个数, int32
            'NLSASdiskNum': 85,  # NLSAS成员盘个数, int32
            'usedCapacity': 86,  # 已分配裸容量, uint64
            'SSDusedCapacity': 87,  # SSD已分配裸容量, uint64
            'SASusedCapacity': 88,  # SAS已分配裸容量, uint64
            'NLSASusedCapacity': 89  # NLSAS已分配裸容量, uint64
        }

        '''
        Description: 存储引擎
        '''
        StorageEngine = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'freeReadCacheSize': 64,  # 剩余读Cache容量, uint64
            'freeWriteCacheSize': 65,  # 剩余写Cache容量, uint64
            'freeAssignedSize': 66,  # 剩余可分配SmartCache的容量, uint64
            'nodeList': 67  # , array
        }

        '''
        Description: Cache分区
        '''
        CachePartition = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'description': 9,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'isDefault': 64,  # 是否缺省分区, bool
            'minReadSize': 65,  # 最小读Cache容量, uint64
            'expectReadSize': 66,  # 期望的读Cache容量, uint64
            'maxReadSize': 67,  # 最大读Cache容量, uint64
            'minWriteSize': 68,  # 最小写Cache容量, uint64
            'expectWriteSize': 69,  # 期望的写Cache容量, uint64
            'maxWriteSize': 70  # 最大写Cache容量, uint64
        }

        '''
        Description: SPA
        '''
        SPA1 = {
            'poolId': 0,  # 指定CKG所属pool ID, uint32
            'ckgId': 1  # 查询到的指定POOL ID对应的root CKG0 ID, uint32
        }

        '''
        Description: SPA
        '''
        SPA2 = {
            'poolId': 0,  # 指定CKG所属pool ID, uint32
            'volumeId': 1,  # 指定CKG所属volume ID, uint64
            'ckgId': 2,  # 所要导出的元数据所在的CKG ID, uint32
            'offset': 3,  # 所要导出的元数据在指定的CKG上的偏移, uint64
            'length': 4,  # 所要导出的元数据的长度, uint64
            'ckgLayer': 5,  # 指定导出方式：0（经过cache导出）、1（绕过cache直接从盘上导出）, uint32
            'fileName': 6  # 文件名, char[]
        }

        '''
        Description: SPA
        '''
        SPA3 = {
            'poolId': 0,  # 指定所属pool ID, uint32
            'volumeId': 1,  # 指定所属volume ID, uint64
            'nodeId': 2,  # 所要导出的元数据所在的NODE ID, uint64
            'nodeSize': 3,  # 所要导出的元数据在节点大小, uint32
            'ckgLayer': 5,  # 指定导出方式：0（经过cache导出）、1（绕过cache直接从盘上导出）, uint32
            'fileName': 6  # 文件名, char[]
        }

        '''
        Description: LUN数据消毁
        '''
        LUNDestroyData = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'runningStatus': 8,  # ,
            'destroyType': 64,  # , enum
            'writeCount': 65,  # , uint32
            'process': 66  # 进度, uint32
        }

        '''
        Description: Disk数据消毁
        '''
        DiskDestroyData = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'runningStatus': 8,  # ,
            'destroyType': 64,  # , enum
            'writeCount': 65,  # , uint32
            'process': 66  # 进度, uint32
        }

        '''
        Description: LUN优先级统计
        '''
        LUNPriorityStatistic = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2  # ,
        }

    '''
    Description: (公共)系统管理
    '''

    class ValueAdd():
        '''
        Description: 快照
        '''
        SNAPSHOT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'associateMetadata': 13,  # ,
            'queryCondition': 15,  # ,
            'snapshotUser': 64,  # 快照的使用者, enum
            'timeStamp': 65,  # 快照时间点, uint64
            'rollbackStarttime': 66,  # 回滚开始时间, uint64
            'rollbackEndtime': 67,  # 回滚结束时间, uint64
            'rollbackSpeed': 68,  # 回滚速率, enum
            'rollbackRate': 69,  # 回滚进度, uint32
            'exposedToInitiator': 70,  # 映射状态, bool
            'wwn': 71,  # WWN, string
            'userCapacity': 72,  # 快照的用户容量, uint64
            'consumedCapacity': 73  # 快照实际消耗的容量, uint64
        }

        '''
        Description: 批量操作快照
        '''
        SnapshotBatchOperation = {
            'snapshotList': 0  # , array
        }

        '''
        Description: 远程复制
        '''
        REMOTEREPLICATION = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # , string
            'healthStatus': 7,  # , enum
            'runningStatus': 8,  # , enum
            'description': 9,  # , string
            'count': 10,  # ,
            'priLunID': 64,  # 主LUN ID, string
            'priLunName': 65,  # 主Lun名称, string
            'priLunCapacity': 66,  # 主Lun容量, uint64
            'replicationModel': 67,  # 复制模式, enum
            'isInCg': 68,  # 是否属于一致性组, bool
            'cgID': 69,  # 所属一致性组ID, string
            'silentTime': 70,  # 静默时间, uint32
            'priArraySN': 71,  # 主Lun阵列序列号, string
            'priArrayName': 72,  # 主Lun阵列名称, string
            'isPrimary': 73  # 是否是主端, bool
        }

        '''
        Description: 远程复制成员LUN
        '''
        REMOTEREPLICATIONMEMBERLUN = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'replicationID': 64,  # , string
            'relationType': 65,  # , enum
            'secondaryArraySN': 66,  # , string
            'secondaryArrayName': 67,  # , string
            'isRollback': 68,  # , uint32
            'isFirstSync': 69,  # , uint32
            'synchronizeType': 70,  # , enum
            'capacity': 71,  # , uint64
            'recoveryPolicy': 72,  # , enum
            'replicationProgress': 73,  # , uint32
            'startTime': 74,  # , uint64
            'endTime': 75,  # , uint64
            'speed': 76,  # , enum
            'timingVal': 77,  # , uint64
            'secLunDataStatus': 78,  # , enum
            'poolName': 80,  # , string
            'primaryLUNID': 81  # , string
        }

        '''
        Description: 远程复制一致性组
        '''
        CONSISTENTGROUP = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # , string
            'healthStatus': 7,  # , enum
            'runningStatus': 8,  # , enum
            'description': 9,  # , string
            'count': 10,  # ,
            'queryCondition': 15,  # ,
            'recoveryPolicy': 64,  # 恢复策略, enum
            'replicationModel': 65,  # 复制模式, enum
            'speed': 66,  # 速率, enum
            'synchronizeType': 67,  # 同步类型, enum
            'rmList': 68,  # 远程复制ID列表, array
            'isPrimary': 71,  # 是否主端, bool
            'timingVal': 72,  # 定时时长, uint32
            'secResAccess': 73,  # , enum
            'isLocalDelete': 74,  # , bool
            'timingValInSec': 75,  # 定时时长, uint32
            'isEmpty': 76  # , bool
        }

        '''
        Description: LUN拷贝
        '''
        LUNCOPY = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # , string
            'healthStatus': 7,  # , enum
            'runningStatus': 8,  # , enum
            'description': 9,  # , string
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'queryCondition': 15,  # ,
            'copySpeed': 64,  # , enum
            'lunCopyType': 65,  # LUN拷贝类型, enum
            'copySyncFirst': 66,  # , bool
            'copyProgress': 67,  # , uint32
            'copyMarkBOOL': 68,  # , bool
            'copyMarkTime': 69,  # , uint64
            'copyStartTime': 70,  # , uint64
            'copyStopTime': 71,  # , uint64
            'sourceLun': 72,  # , string
            'targetLun': 73  # , string
        }

        '''
        Description: LUN拷贝成员LUN
        '''
        LUNCOPYMEMBERLUN = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # , string
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'lunCopyID': 64,  # LUN拷贝ID, string
            'lunCopyType': 65,  # LUN拷贝类型, enum
            'lunClassType': 67,  # LUN类型, enum
            'capacity': 68,  # LUN容量, uint64
            'pool': 69,  # 所属存储池的名称, string
            'lunScopeType': 73,  # LUN所属设备类型, enum
            'lunDeviceID': 74,  # 所属阵列ID, string
            'lunDeviceName': 75,  # 所属设备名称, string
            'lunwww': 76,  # LUN www, string
            'remotewwpn': 77,  # 远端端口的wwpn, string
            'hostLunId': 78  # 主机LUN id, string
        }

        '''
        Description: 分裂镜像
        '''
        SPLITMIRROR = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'queryCondition': 15,  # ,
            'priLunID': 64,  # , string
            'priLunName': 65,  # , string
            'priLUNCapacity': 66,  # , uint64
            'silentTime': 67  # , uint32
        }

        '''
        Description: 分裂镜像从LUN
        '''
        SPLITMIRRORTARGETLUN = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'dataStatus': 64,  # , enum
            'speed': 66,  # , enum
            'process': 67,  # , uint32
            'startTime': 68,  # , uint64
            'endTime': 69,  # , uint64
            'splitTime': 70,  # , uint64
            'resumePolicy': 71,  # , enum
            'firstSync': 72,  # , uint32
            'protectModel': 73,  # , uint32
            'lunType': 74,  # , enum
            'lunCapacity': 75,  # , uint64
            'poolName': 76,  # , string
            'pairID': 77,  # , string
            'primaryLUNID': 78  # , string
        }

        '''
        Description: 远端设备
        '''
        REMOTE_DEVICE = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'scope': 64,  # , enum
            'wwn': 65,  # 设备唯一标识, string
            'sn': 66,  # 设备序列号, string
            'arrayType': 67,  # , enum
            'serviceType': 68,  # , enum
            'remoteUsername': 69,  # 远端阵列登录用户名, string
            'remotePassword': 70,  # 远端阵列登录密码, string
            'remoteLogintype': 71,  # 远端阵列登录方式, enum
            'linkNum': 72,  # 远端设备链路数量, uint32
            'deviceModel': 73,  # 远端设备型号, string
            'enableEncrypt': 74,  # 传输数据是否启动加密, bool
            'encryptPassword': 75,  # 传输数据加密的密码, string
            'consultStatus': 76,  # 传输数据的协商状态：0=密钥未协商通过；1=已通过；2=不支持加密传输, enum
            'compressStatus': 77  # 数据压缩传输的状态：false=不支持；true=支持, bool
        }

        '''
        Description: 远端设备创建
        '''
        REMOTE_DEVICE_BUILDER = {
            'arrayType': 0,  # , enum
            'id': 1,  # 远端设备ID, string
            'name': 2,  # 远端设备名称, string
            'description': 3,  # 远端设备描述, string
            'fcLinkID': 4,  # 链路ID, string
            'iSCSILink_localControlID': 5,  # 本端控制器ID, string
            'iSCSILink_localPortID': 6,  # 本端端口ID, string
            'iSCSILink_remoteIP': 7,  # 对端IP, string
            'iSCSILink_remoteTCPPort': 8,  # 对端端口号, uint32
            'iSCSILink_enableCHAP': 9,  # 是否启动CHAP, bool
            'iSCSILink_chapUser': 10,  # CHAP名, string
            'iSCSILink_chapPasswd': 11,  # CHAP密码, string
            'iSCSILink_recovery_policy': 12,  # 修复策略, enum
            'remoteUsername': 13,  # 远端阵列登录用户名, string
            'remotePassword': 14,  # 远端阵列登录密码, string
            'remoteLoginType': 15  # 远端阵列登录方式, enum
        }

        '''
        Description: FC链路
        '''
        FC_LINK = {
            'type': 0,  # ,
            'id': 1,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'queryCondition': 15,  # ,
            'deviceID': 64,  # 设备ID, string
            'localControlID': 65,  # 本端控制器ID, string
            'remoteControlID': 66,  # 远端控制器ID, string
            'localPortID': 67,  # 本端端口ID, string
            'remotePortID': 68,  # 远端端口ID, string
            'fcLinkLocalPortWWPN': 69,  # FC链路本地端口WWPN, string
            'fcLinkRemotePortWWPN': 70,  # FC链路远端端口WWPN, string
            'linkUsage': 71,  # 链路用途, bool
            'bandwidthLimitSwitch': 72,  # 带宽限制开关, uint32
            'bandwidthLimitSize': 73,  # 限制带宽大小, uint64
            'bandwidthLimitUnit': 74,  # 限制带宽单位, uint32
            'bandwidthLimitUtilization': 75,  # 带宽利用率, uint32
            'arrayType': 76,  # , enum
            'deviceName': 77,  # 远端设备名称, string
            'deviceWWN': 78,  # 远端设备WWN, string
            'remoteUsername': 79,  # 远端阵列登录用户名, string
            'remotePassword': 80,  # 远端阵列登录密码, string
            'remoteLogintype': 81,  # 远端阵列登录方式, enum
            'remoteSN': 82  # 远端设备SN, string
        }

        '''
        Description: iSCSI链路
        '''
        iSCSI_LINK = {
            'type': 0,  # ,
            'id': 1,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'queryCondition': 15,  # ,
            'deviceID': 64,  # 设备ID, string
            'localControlID': 65,  # 本端控制器ID, string
            'remoteControlID': 66,  # 远端控制器ID, string
            'localPortID': 67,  # 本端端口ID, string
            'remotePortID': 68,  # 远端端口ID, string
            'linkUsage': 69,  # 链路用途, bool
            'targetName': 70,  # iSCSI目标器名称, string
            'initiatorName': 71,  # iSCSI启动器名称, string
            'bandwidthLimitSwitch': 72,  # 带宽限制开关, uint32
            'bandwidthLimitSize': 73,  # 限制带宽大小, uint64
            'bandwidthLimitUnit': 74,  # 限制带宽单位, uint32
            'bandwidthLimitUtilization': 75,  # 带宽利用率, uint32
            'arrayType': 76,  # 本厂商、第三方, enum
            'recovery_policy': 77,  # 修复策略, enum
            'enableCHAP': 78,  # 是否启动CHAP, bool
            'chapUser': 79,  # CHAP名, string
            'chapPasswd': 80,  # CHAP密码, string
            'ip': 81,  # 对端IP, string
            'port': 82,  # 对端端口号, uint32
            'remoteUsername': 83,  # 远端阵列登录用户名, string
            'remotePassword': 84,  # 远端阵列登录密码, string
            'remoteLogintype': 85  # 远端阵列登录方式, enum
        }

        '''
        Description: IP链路
        '''
        IP_LINK = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'deviceID': 64,  # 设备ID, string
            'localControlID': 65,  # 本端控制器ID, string
            'remoteControlID': 66,  # 远端控制器ID, string
            'localPortID': 67,  # 本端端口ID, string
            'localIP': 68,  # 本端IP, string
            'remotePortID': 69,  # 远端端口ID, string
            'remoteIP': 70,  # 远端IP, string
            'remoteUsername': 71,  # 远端访问用户名, string
            'remotePassword': 72  # 远端访问密码, string
        }

        '''
        Description: iSCSI链路目标器
        '''
        iSCSI_TARGET = {
            'id': 0,  # , string
            'name': 1,  # iSCSI目标器名称, string
            'status': 2,  # , enum
            'localControlID': 3,  # 本端控制器ID, string
            'localPortID': 4,  # 本端端口ID, string
            'remoteIp': 5,  # 对端IP, string
            'port': 6,  # 对端端口号, uint32
            'recovery_policy': 7,  # 修复策略, enum
            'enableCHAP': 8,  # 是否启动CHAP, bool
            'chapUser': 9,  # CHAP名, string
            'chapPasswd': 10  # CHAP密码, string
        }

        '''
        Description: 设备的iSCSI启动器
        '''
        iSCSI_INITIATOR_NAME = {
            'CMO_SET_INITIATOR_NAME_CONTROLLER': 0,  # , string
            'CMO_SET_INITIATOR_NAME_VALUE': 1  # , string
        }

        '''
        Description: IO分类
        '''
        IOCLASS = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'description': 9,  # ,
            'count': 10,  # ,
            'IOType': 64,  # IO分类中的IO属性, enum
            'enableStatus': 65,  # , bool
            'lunList': 66,  # 归属于该IO分类的LUN的ID列表, array
            'maxBandWidth': 67,  # IO分类最大带宽设置, uint32
            'minBandWidth': 68,  # IO分类最小带宽设置, uint32
            'maxIOPS': 69,  # IO分类最大IOPS设置, uint32
            'minIOPS': 70,  # IO分类最小IOPS设置, uint32
            'latency': 71,  # IO分类时延要求, uint32
            'priority': 72,  # IO分类优先级设置, enum
            'schedulePolicy': 73,  # , enum
            'scheduleStartTime': 74,  # IO分类设置的生效开始日期, uint64
            'startTime': 75,  # IO分类设置生效开始时间, string
            'duration': 76,  # IO分类设置生效持续时间, uint64
            'cycleSet': 77,  # IO分类设置生效循环周期, array
            'classType': 78  # IOClass控制类型, enum
        }

        '''
        Description: IO分类模板
        '''
        IOCLASSTemplate = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'description': 9,  # ,
            'IOType': 64,  # IO分类中的IO属性, enum
            'maxBandWidth': 67,  # IO分类最大带宽设置, uint32
            'minBandWidth': 68,  # IO分类最小带宽设置, uint32
            'maxIOPS': 69,  # IO分类最大IOPS设置, uint32
            'minIOPS': 70,  # IO分类最小IOPS设置, uint32
            'latency': 71,  # IO分类时延要求, uint32
            'priority': 72,  # IO分类优先级设置, enum
            'classType': 73  # IOClass控制类型, enum
        }

        '''
        Description: 远端设备LUN
        '''
        Remote_LUN = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'healthStatus': 7,  # ,
            'count': 10,  # ,
            'queryCondition': 15,  # ,
            'lunid': 64,  # , string
            'deviceID': 65,  # , string
            'deviceSN': 66,  # , string
            'used': 67,  # , bool
            'capacity': 68,  # , uint64
            'LUNCopyIDs': 69,  # LUN拷贝ID列表, array
            'RemoteReplicationIDs': 70,  # 远程复制ID列表, array
            'lunwwn': 71,  # , string
            'arrayType': 72,  # , enum
            'vendor': 73,  # 厂商名称, string
            'model': 74  # LUN所属设备型号, string
        }

        '''
        Description: 快照组
        '''
        SnapshotGroup = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # , enum
            'parentID': 4,  # , string
            'parentName': 5,  # , string
            'description': 9,  # 描述,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'queryCondition': 15,  # 查询条件, json
            'consistent': 64,  # 保持一致性, bool
            'appType': 65  # , enum
        }

        '''
        Description: 克隆组
        '''
        CloneGroup = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'description': 9,  # 描述,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'consistent': 64,  # 保持一致性, bool
            'recoveryPolicy': 65,  # 恢复策略, enum
            'speed': 66,  # 速率, enum
            'enableSlaveLunProtected': 67  # 是否启用从LUN保护模式, bool
        }

        '''
        Description: Link Test Task
        '''
        LinkTest_Task = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'process': 64,  # 进度, uint32
            'remainTime': 65,  # 预计剩余时间, uint32
            'startTime': 66,  # 启动时间, Time
            'duration': 67  # 持续时间, uint32
        }

        '''
        Description: LUN Migration Task
        '''
        LUN_Migration_Task = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'runningStatus': 8,  # , enum
            'count': 10,  # , uint32
            'queryCondition': 15,  # , json
            'process': 64,  # 进度, uint32
            'startTime': 65,  # 启动时间, uint64
            'endTime': 66,  # 结束时间, uint64
            'targetLunID': 67,  # , string
            'targetLunName': 68,  # , string
            'speed': 69  # , enum
        }

        '''
        Description: Smart Cache Pool
        '''
        SmartCachePool = {
            'type': 0,  # ,
            'id': 1,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'controllerID': 64,  # , string
            'totalCapacity': 65,  # 总容量, uint64
            'freeCapacity': 66,  # 空闲容量, uint64
            'totalPhysicsCap': 67,  # 总物理容量, uint64
            'faultCapacity': 68,  # 失效容量, uint64
            'specCapacity': 69,  # 规格容量, uint64
            'engineId': 70,  # , string
            'engineName': 71  # , string
        }

        '''
        Description: 远程复制pair
        '''
        REPLICATIONPAIR = {
            'type': 0,  # ,
            'id': 1,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'runningStatus': 8,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'associateMetadata': 13,  # ,
            'queryCondition': 15,  # ,
            'isPrimary': 64,  # 是否是主端, bool
            'localResID': 65,  # , string
            'localResName': 66,  # , string
            'localResType': 67,  # , enum
            'remoteDeviceID': 68,  # , string
            'remoteDeviceSN': 69,  # , string
            'remoteDeviceName': 70,  # , string
            'remoteResID': 71,  # , string
            'remoteResName': 72,  # , string
            'isFirstSync': 73,  # , bool
            'synchronizeType': 74,  # , enum
            'capacity': 75,  # , uint64
            'recoveryPolicy': 76,  # , enum
            'replicationProgress': 77,  # , uint32
            'startTime': 78,  # , time
            'endTime': 79,  # , time
            'speed': 80,  # , enum
            'timingVal': 81,  # , uint32
            'isRollback': 82,  # , bool
            'secResDataStatus': 83,  # , enum
            'poolName': 84,  # , string
            'replicationModel': 85,  # 复制模式, enum
            'priResDataStatus': 86,  # , enum
            'secResAccess': 87,  # , enum
            'isSecResBeWrite': 88,  # , bool
            'isInCg': 89,  # 是否属于一致性组, bool
            'cgID': 90,  # 所属一致性组ID, string
            'cgName': 91,  # 所属一致性组名称, string
            'isDataSync': 92,  # , bool
            'isLocalDelete': 93,  # , bool
            'toSyncSRWhenDelete': 94,  # , bool
            'enableEncrypt': 95,  # , bool
            'enableCompress': 96,  # , bool
            'compressLevel': 97  # , enum
        }

        '''
        Description: 文件系统快照
        '''
        FSSNAPSHOT = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'healthStatus': 7,  # ,
            'count': 10,  # ,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'associateMetadata': 13,  # ,
            'queryCondition': 15,  # ,
            'timeStamp': 64,  # 快照时间点, uint64
            'userCapacity': 65,  # 源FS的容量, uint64
            'consumedCapacity': 66  # 快照完全独占空间, uint64
        }

        '''
        Description: SmartCache分区
        '''
        SmartCachePartition = {
            'type': 0,  # ,
            'id': 1,  # ,
            'name': 2,  # ,
            'parentType': 3,  # ,
            'parentID': 4,  # ,
            'parentName': 5,  # ,
            'description': 9,  # 描述,
            'associateObjType': 11,  # ,
            'associateObjID': 12,  # ,
            'isDefault': 64,  # 是否缺省分区, bool
            'totalCapacity': 65,  # 分区总容量, uint64
            'cachedCapacity': 66,  # 已缓存容量, uint64
            'freeCapacity': 67,  # 空闲容量, uint64
            'SSDHitRate': 68  # SSD命中率, uint32
        }
