/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.python.bouncycastle.asn1.ASN1Encodable;
import org.python.bouncycastle.asn1.ASN1EncodableVector;
import org.python.bouncycastle.asn1.ASN1Object;
import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.ASN1Set;
import org.python.bouncycastle.asn1.BEROctetString;
import org.python.bouncycastle.asn1.BERSet;
import org.python.bouncycastle.asn1.DEROctetString;
import org.python.bouncycastle.asn1.DERSet;
import org.python.bouncycastle.asn1.cms.AuthenticatedData;
import org.python.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.python.bouncycastle.asn1.cms.ContentInfo;
import org.python.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python.bouncycastle.cms.CMSAuthenticatedData;
import org.python.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.python.bouncycastle.cms.CMSException;
import org.python.bouncycastle.cms.CMSTypedData;
import org.python.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.python.bouncycastle.operator.DigestCalculator;
import org.python.bouncycastle.operator.DigestCalculatorProvider;
import org.python.bouncycastle.operator.MacCalculator;
import org.python.bouncycastle.operator.OperatorCreationException;
import org.python.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(cMSTypedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        AuthenticatedData authenticatedData;
        ContentInfo contentInfo2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (ContentInfo contentInfo2 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add((ASN1Encodable)contentInfo2.generate(macCalculator.getKey()));
        }
        if (digestCalculator != null) {
            DEROctetString dEROctetString;
            Object object;
            BEROctetString bEROctetString;
            Object object2;
            try {
                contentInfo2 = new ByteArrayOutputStream();
                object2 = new TeeOutputStream(digestCalculator.getOutputStream(), (OutputStream)contentInfo2);
                cMSTypedData.write((OutputStream)object2);
                ((OutputStream)object2).close();
                bEROctetString = new BEROctetString(contentInfo2.toByteArray());
            }
            catch (IOException iOException) {
                throw new CMSException("unable to perform digest calculation: " + iOException.getMessage(), iOException);
            }
            contentInfo2 = Collections.unmodifiableMap(this.getBaseParameters(cMSTypedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), macCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest()));
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            object2 = new DERSet(this.authGen.getAttributes((Map)contentInfo2).toASN1EncodableVector());
            try {
                object = macCalculator.getOutputStream();
                ((OutputStream)object).write(((ASN1Object)object2).getEncoded("DER"));
                ((OutputStream)object).close();
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("unable to perform MAC calculation: " + iOException.getMessage(), iOException);
            }
            object = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes((Map)contentInfo2).toASN1EncodableVector()) : null;
            ContentInfo contentInfo3 = new ContentInfo(cMSTypedData.getContentType(), (ASN1Encodable)bEROctetString);
            authenticatedData = new AuthenticatedData(this.originatorInfo, (ASN1Set)new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), contentInfo3, (ASN1Set)object2, (ASN1OctetString)dEROctetString, (ASN1Set)object);
        } else {
            DEROctetString dEROctetString;
            BEROctetString bEROctetString;
            TeeOutputStream teeOutputStream;
            try {
                contentInfo2 = new ByteArrayOutputStream();
                teeOutputStream = new TeeOutputStream((OutputStream)contentInfo2, macCalculator.getOutputStream());
                cMSTypedData.write(teeOutputStream);
                ((OutputStream)teeOutputStream).close();
                bEROctetString = new BEROctetString(contentInfo2.toByteArray());
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("unable to perform MAC calculation: " + iOException.getMessage(), iOException);
            }
            contentInfo2 = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.EMPTY_MAP).toASN1EncodableVector()) : null;
            teeOutputStream = new ContentInfo(cMSTypedData.getContentType(), (ASN1Encodable)bEROctetString);
            authenticatedData = new AuthenticatedData(this.originatorInfo, (ASN1Set)new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), null, (ContentInfo)teeOutputStream, null, (ASN1OctetString)dEROctetString, contentInfo2);
        }
        contentInfo2 = new ContentInfo(CMSObjectIdentifiers.authenticatedData, (ASN1Encodable)authenticatedData);
        return new CMSAuthenticatedData(contentInfo2, new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }
}

