/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.number;

import org.python.icu.impl.number.DecimalQuantity;
import org.python.icu.impl.number.MicroProps;
import org.python.icu.impl.number.MicroPropsGenerator;
import org.python.icu.impl.number.Modifier;
import org.python.icu.impl.number.MultiplierProducer;
import org.python.icu.impl.number.NumberStringBuilder;
import org.python.icu.number.Notation;
import org.python.icu.number.NumberFormatter;
import org.python.icu.number.Precision;
import org.python.icu.text.DecimalFormatSymbols;
import org.python.icu.text.NumberFormat;

public class ScientificNotation
extends Notation
implements Cloneable {
    int engineeringInterval;
    boolean requireMinInt;
    int minExponentDigits;
    NumberFormatter.SignDisplay exponentSignDisplay;

    ScientificNotation(int engineeringInterval, boolean requireMinInt, int minExponentDigits, NumberFormatter.SignDisplay exponentSignDisplay) {
        this.engineeringInterval = engineeringInterval;
        this.requireMinInt = requireMinInt;
        this.minExponentDigits = minExponentDigits;
        this.exponentSignDisplay = exponentSignDisplay;
    }

    public ScientificNotation withMinExponentDigits(int minExponentDigits) {
        if (minExponentDigits >= 1 && minExponentDigits <= 999) {
            ScientificNotation other = (ScientificNotation)this.clone();
            other.minExponentDigits = minExponentDigits;
            return other;
        }
        throw new IllegalArgumentException("Integer digits must be between 1 and 999 (inclusive)");
    }

    public ScientificNotation withExponentSignDisplay(NumberFormatter.SignDisplay exponentSignDisplay) {
        ScientificNotation other = (ScientificNotation)this.clone();
        other.exponentSignDisplay = exponentSignDisplay;
        return other;
    }

    @Deprecated
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    MicroPropsGenerator withLocaleData(DecimalFormatSymbols symbols2, boolean build2, MicroPropsGenerator parent) {
        return new ScientificHandler(this, symbols2, build2, parent);
    }

    private static class ScientificModifier
    implements Modifier {
        final int exponent;
        final ScientificHandler handler;

        ScientificModifier(int exponent, ScientificHandler handler2) {
            this.exponent = exponent;
            this.handler = handler2;
        }

        @Override
        public int apply(NumberStringBuilder output, int leftIndex, int rightIndex) {
            return this.handler.doApply(this.exponent, output, rightIndex);
        }

        @Override
        public int getPrefixLength() {
            return 0;
        }

        @Override
        public int getCodePointCount() {
            throw new AssertionError();
        }

        @Override
        public boolean isStrong() {
            return true;
        }
    }

    private static class ScientificHandler
    implements MicroPropsGenerator,
    MultiplierProducer,
    Modifier {
        final ScientificNotation notation;
        final DecimalFormatSymbols symbols;
        final ScientificModifier[] precomputedMods;
        final MicroPropsGenerator parent;
        int exponent;

        private ScientificHandler(ScientificNotation notation, DecimalFormatSymbols symbols2, boolean safe, MicroPropsGenerator parent) {
            this.notation = notation;
            this.symbols = symbols2;
            this.parent = parent;
            if (safe) {
                this.precomputedMods = new ScientificModifier[25];
                for (int i = -12; i <= 12; ++i) {
                    this.precomputedMods[i + 12] = new ScientificModifier(i, this);
                }
            } else {
                this.precomputedMods = null;
            }
        }

        @Override
        public MicroProps processQuantity(DecimalQuantity quantity) {
            int exponent;
            MicroProps micros = this.parent.processQuantity(quantity);
            assert (micros.rounder != null);
            if (quantity.isZero()) {
                if (this.notation.requireMinInt && micros.rounder instanceof Precision.SignificantRounderImpl) {
                    ((Precision.SignificantRounderImpl)micros.rounder).apply(quantity, this.notation.engineeringInterval);
                    exponent = 0;
                } else {
                    micros.rounder.apply(quantity);
                    exponent = 0;
                }
            } else {
                exponent = -micros.rounder.chooseMultiplierAndApply(quantity, this);
            }
            if (this.precomputedMods != null && exponent >= -12 && exponent <= 12) {
                micros.modInner = this.precomputedMods[exponent + 12];
            } else if (this.precomputedMods != null) {
                micros.modInner = new ScientificModifier(exponent, this);
            } else {
                this.exponent = exponent;
                micros.modInner = this;
            }
            micros.rounder = Precision.constructPassThrough();
            return micros;
        }

        @Override
        public int getMultiplier(int magnitude) {
            int interval = this.notation.engineeringInterval;
            int digitsShown = this.notation.requireMinInt ? interval : (interval <= 1 ? 1 : (magnitude % interval + interval) % interval + 1);
            return digitsShown - magnitude - 1;
        }

        @Override
        public int getPrefixLength() {
            return 0;
        }

        @Override
        public int getCodePointCount() {
            throw new AssertionError();
        }

        @Override
        public boolean isStrong() {
            return true;
        }

        @Override
        public int apply(NumberStringBuilder output, int leftIndex, int rightIndex) {
            return this.doApply(this.exponent, output, rightIndex);
        }

        private int doApply(int exponent, NumberStringBuilder output, int rightIndex) {
            int i = rightIndex;
            i += output.insert(i, this.symbols.getExponentSeparator(), NumberFormat.Field.EXPONENT_SYMBOL);
            if (exponent < 0 && this.notation.exponentSignDisplay != NumberFormatter.SignDisplay.NEVER) {
                i += output.insert(i, this.symbols.getMinusSignString(), NumberFormat.Field.EXPONENT_SIGN);
            } else if (exponent >= 0 && this.notation.exponentSignDisplay == NumberFormatter.SignDisplay.ALWAYS) {
                i += output.insert(i, this.symbols.getPlusSignString(), NumberFormat.Field.EXPONENT_SIGN);
            }
            int disp = Math.abs(exponent);
            for (int j = 0; j < this.notation.minExponentDigits || disp > 0; ++j, disp /= 10) {
                int d = disp % 10;
                String digitString = this.symbols.getDigitStringsLocal()[d];
                i += output.insert(i - j, digitString, NumberFormat.Field.EXPONENT);
            }
            return i - rightIndex;
        }
    }
}

