/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.parse;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.Item;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.pyengine.jython.JythonCheckItemService;
import com.huawei.ism.tool.pyengine.psdk.bean.CheckConfigItem;
import com.huawei.ism.tool.pyengine.psdk.bean.ExecuteEnv;
import com.huawei.ism.tool.pyengine.psdk.bean.ExpansionExecuteEnv;
import com.huawei.ism.tool.pyengine.psdk.bean.FruExecuteEnv;
import com.huawei.ism.tool.pyengine.psdk.bean.PyTaskResult;
import com.huawei.ism.tool.pyengine.psdk.common.CheckItemStatus;
import com.huawei.ism.tool.pyengine.psdk.common.ExecuteEnvConstants;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckItemPlatformAdapterInBizPackage {
    private static final Logger log = LoggerFactory.getLogger(CheckItemPlatformAdapterInBizPackage.class);
    private static final CheckItemPlatformAdapterInBizPackage INSTANCE = new CheckItemPlatformAdapterInBizPackage();

    public static CheckItemPlatformAdapterInBizPackage getInstance() {
        return INSTANCE;
    }

    public void addCheckConfigItem(List<Item> allItems, String sceneId, String stepId, String insertPoint) {
        DevNode devNode = BizPackageContext.getInstance().getJythonContext().getDevNode();
        this.getExecuteEnv(sceneId, stepId).ifPresent(env -> {
            log.info("need to add new config item. scene id={},step id={}", (Object)sceneId, (Object)stepId);
            JythonCheckItemService service = new JythonCheckItemService(env);
            List configItems = service.getCheckItemList(devNode);
            configItems.forEach(item -> item.setExecuteEnv(env));
            List<Item> addItems = configItems.stream().map(this::transConfigItem).collect(Collectors.toList());
            this.insertCheckItem(allItems, addItems, insertPoint);
        });
    }

    private void insertCheckItem(List<Item> allItems, List<Item> addItems, String insertPoint) {
        if (StringUtils.isNULLStr(insertPoint)) {
            log.info("insert point is empty.");
            allItems.addAll(addItems);
            return;
        }
        try {
            int index = Math.min(Integer.parseInt(insertPoint.trim()), allItems.size());
            if (index < 0) {
                index = Math.max(0, allItems.size() + index);
            }
            log.info("insert check item index = {}", (Object)index);
            allItems.addAll(index, addItems);
        }
        catch (NumberFormatException e) {
            allItems.addAll(addItems);
        }
    }

    private Optional<ExecuteEnv> getExecuteEnv(String sceneId, String stepId) {
        String toolName = BizPackageContext.getInstance().getCurToolName();
        if (toolName.equals(ExecuteEnvConstants.ExecuteScene.EXPANSION.toString())) {
            return ExpansionExecuteEnv.buildExecuteEnv((String)sceneId, (String)stepId);
        }
        if (toolName.equals(ExecuteEnvConstants.ExecuteScene.FRU.toString()) || toolName.equals(ExecuteEnvConstants.ExecuteScene.CRU.toString())) {
            return FruExecuteEnv.buildExecuteEnv((String)sceneId, (String)stepId);
        }
        return Optional.empty();
    }

    private Item transConfigItem(CheckConfigItem configItem) {
        Item item = new Item();
        item.setId(configItem.getItemId());
        item.setDesc(configItem.getName());
        item.setConfigItem(configItem);
        item.setTitle(configItem.getName());
        item.setSuggest(configItem.getSuggestion());
        return item;
    }

    public void runConfigItem(DevNode devNode, Item checkItem, Map<String, Object> result) {
        log.info("run config item: {}", (Object)checkItem.getConfigItem().getItemId());
        checkItem.getConfigItem().getExecuteEnv().setOriEnv(result);
        JythonCheckItemService service = new JythonCheckItemService(checkItem.getConfigItem().getExecuteEnv());
        PyTaskResult taskResult = service.runCheckConfigItem(devNode, checkItem.getConfigItem().getScript());
        result.put("succ", taskResult.getStatus().equals(CheckItemStatus.PASS.toString()));
        result.put("errMsg", taskResult.getDetail());
        result.put("suggestion", taskResult.getSuggestion());
    }

    private CheckItemPlatformAdapterInBizPackage() {
    }
}

