/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.parse;

import com.huawei.ism.tool.base.osplatform.OsEnumn;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.bizpack.parse.XmlConfigParser;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProductsParser
extends XmlConfigParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductsParser.class);
    private static final String PRODUCT_NODE = "product";
    private static final String PRODUCT_NAME_NODE = "productname";
    private static final String PRODUCT_TYPE_NODE = "supporttypes";
    private static final String PRECHECK_NODE = "precheck";

    public ProductsParser(File xmlFile) {
        super(xmlFile);
    }

    @Override
    public boolean parseContent(BizPackage bizPackage) {
        if (this.getDocument() == null) {
            return false;
        }
        Element root = this.getDocument().getDocumentElement();
        NodeList productList = root.getElementsByTagName(PRODUCT_NODE);
        if (productList == null) {
            LOGGER.error("the product.xml format is error.");
            return false;
        }
        int length = productList.getLength();
        ArrayList<PackProduct> products = new ArrayList<PackProduct>();
        for (int index = 0; index < length; ++index) {
            Node node = productList.item(index);
            if (!XmlUtils.parseSupportOs((Element)node).contains((Object)OsEnumn.getNowRunningOs())) continue;
            PackProduct packProduct = this.parseProduct((Element)node);
            products.add(packProduct);
        }
        bizPackage.setPackProducts(products);
        return true;
    }

    private PackProduct parseProduct(Element productElement) {
        PackProduct packProduct = new PackProduct();
        packProduct.setProductName(this.getElementContent(productElement, PRODUCT_NAME_NODE));
        String versionStrings = this.getElementContent(productElement, PRODUCT_TYPE_NODE);
        ArrayList<String> versions = new ArrayList<String>();
        versions.addAll(Arrays.asList(versionStrings.split(",")));
        packProduct.setVersions(versions);
        Element precheckNode = XmlUtils.getChild(productElement, PRECHECK_NODE);
        if (null != precheckNode) {
            String script = this.getAttribute(precheckNode, "script", "");
            String param = this.getAttribute(precheckNode, "param", "");
            packProduct.setScript(script);
            packProduct.setParam(param);
        }
        return packProduct;
    }

    private String getAttribute(Element element, String attriName, String defaultValue) {
        String attribute = element.getAttribute(attriName);
        if (StringUtils.isNULLStr((String)attribute)) {
            attribute = defaultValue;
        }
        return attribute.trim();
    }
}

