/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.parse;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.parse.ConfigParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class XmlConfigParser
implements ConfigParser {
    public static final String XML_SUFFIX = ".xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlConfigParser.class);
    private Document document = null;
    private File xmlFile = null;

    public XmlConfigParser(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public final void initXMLDocument() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.xmlFile);
            this.document = XmlUtils.parseDocument(fileInputStream);
        }
        catch (FileNotFoundException e) {
            try {
                LOGGER.error("the xml config file is not exist or the file is not a file. ");
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, fileInputStream);
                throw throwable;
            }
            StreamUtils.closeResource(null, fileInputStream);
        }
        StreamUtils.closeResource(null, fileInputStream);
    }

    @Override
    public final boolean parse(BizPackage bizPackage) {
        this.initXMLDocument();
        return this.parseContent(bizPackage);
    }

    public abstract boolean parseContent(BizPackage var1);

    protected final String getElementContent(Element parent, String elementName) {
        NodeList nodeList = parent.getElementsByTagName(elementName);
        if (nodeList == null || nodeList.getLength() == 0) {
            return "";
        }
        return ((Element)nodeList.item(0)).getTextContent();
    }

    public Document getDocument() {
        return this.document;
    }
}

