/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.support;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.bizpack.NodeItem;
import com.huawei.ism.tool.bizpack.NodeResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessExecutor.class);
    private static final int NUM_1 = 1;
    private static final int NUM_2 = 2;
    private JythonExecuter executor = null;

    public ProcessExecutor(List<File> scriptDirs) {
        this.executor = new JythonExecuter(scriptDirs);
    }

    public void clearUp() {
        this.executor.cleanup();
    }

    public NodeResult execute(NodeItem nodeItem, Map<String, Object> envParams) {
        File file = new File(nodeItem.getScriptFilePath());
        NodeResult nodeResult = new NodeResult(nodeItem.getDescription());
        nodeResult.setNodeID(nodeItem.getId());
        try {
            this.checkcompileScript(nodeItem, envParams, file, nodeResult);
        }
        catch (TLVException tlve) {
            LOGGER.error("execute python script failed(TLVException)...scriptFile:" + nodeItem.getScriptFilePath(), (Throwable)tlve);
            String errMsg = "";
            errMsg = "--".equals(tlve.getErrorMessage()) ? tlve.toString() : tlve.getErrorMessage();
            nodeResult.setSuccess(false);
            nodeResult.setDetail(ResourceUtil.getStringWithParams((String)"bizpackage.msg.error.tlv", (Object[])new Object[]{errMsg}));
        }
        catch (IsmException isme) {
            LOGGER.error("execute python script failed(IsmException)...scriptFile:" + nodeItem.getScriptFilePath(), (Throwable)isme);
            String errMsg = "";
            errMsg = "--".equals(isme.getErrorMessage()) ? isme.toString() : isme.getErrorMessage();
            nodeResult.setSuccess(false);
            nodeResult.setDetail(ResourceUtil.getStringWithParams((String)"bizpackage.msg.error.tlv", (Object[])new Object[]{errMsg}));
        }
        catch (FileNotFoundException fx) {
            LOGGER.error("the script file is not founded.");
            nodeResult.setSuccess(false);
            nodeResult.setDetail(ResourceUtil.getString((String)"bizpackage.msg.error.nofound"));
        }
        catch (SignException e) {
            LOGGER.error("execute python script failed. SignException .scriptFile:" + nodeItem.getScriptFilePath(), (Throwable)e);
            nodeResult.setSuccess(false);
            nodeResult.setDetail(e.getErrorMsg());
        }
        catch (Exception e) {
            this.checkNodeResult(nodeItem, nodeResult, e);
        }
        return nodeResult;
    }

    void checkNodeResult(NodeItem nodeItem, NodeResult nodeResult, Exception e) {
        LOGGER.error("execute python script failed..scriptFile:" + nodeItem.getScriptFilePath(), (Throwable)e);
        nodeResult.setSuccess(false);
        String businessErrKey = "businessErrMsg:";
        if (null != e.getMessage() && e.getMessage().contains("businessErrMsg:")) {
            String businessErrMsg = e.getMessage().substring(e.getMessage().indexOf("businessErrMsg:") + "businessErrMsg:".length() - 1);
            nodeResult.setDetail(ResourceUtil.getString((String)"bizpackage.msg.error.failed") + businessErrMsg);
        } else {
            nodeResult.setDetail(ResourceUtil.getString((String)"bizpackage.msg.error.failed"));
        }
    }

    void checkcompileScript(NodeItem nodeItem, Map<String, Object> envParams, File file, NodeResult nodeResult) throws FileNotFoundException, ToolException {
        this.executor.compileScript(file);
        List pyResult = this.executor.invokeFunction(nodeItem.getMainMethod(), envParams);
        this.setExecuteResult(pyResult.get(0).toString(), nodeResult);
        if (pyResult.size() > 1) {
            String detail = (String)pyResult.get(1);
            nodeResult.setDetail(detail);
        }
        if (pyResult.size() > 2) {
            nodeResult.setResult(pyResult.get(2));
        }
    }

    public void addJythonClassPath(List<String> scriptPaths) {
        if (scriptPaths == null || scriptPaths.isEmpty()) {
            return;
        }
        ArrayList<File> scriptDirs = new ArrayList<File>();
        for (String scriptPath : scriptPaths) {
            File scriptPathFile;
            if (scriptPath == null || !(scriptPathFile = new File(scriptPath)).exists() || !scriptPathFile.isDirectory()) continue;
            scriptDirs.add(scriptPathFile);
        }
        this.executor.addClassPaths(scriptDirs);
    }

    private void setExecuteResult(String pyResultStr, NodeResult nodeResult) {
        try {
            int retEnum = Integer.valueOf(pyResultStr);
            nodeResult.setResultEnum(retEnum);
            nodeResult.setSuccess(true);
            if (retEnum == 0) {
                nodeResult.setSuccess(false);
            }
        }
        catch (Exception e) {
            Boolean retState = Boolean.valueOf(pyResultStr);
            nodeResult.setSuccess(retState);
        }
    }
}

