/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.factory;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshConnector.class);
    private static final Map<String, SshConnection> CONN_MAP = new ConcurrentHashMap<String, SshConnection>();
    private static final String ERR_AUTHENTICATEFAIL = "1";
    private static final String ERR_CONNECTION = "2";
    private static final String ERR_OTHER = "9";
    private SshConnection sshCon = null;
    private String sshHostname = "";
    private String username = "";
    private String pswd = "";
    private int port = 22;
    private ISshJudge sshEndJudgeIntf;

    public SshConnector(String sshHostname, int port, String username, String password) {
        this.setLoginInfo(sshHostname, port, username, password);
    }

    public static Map<String, SshConnection> getCONNMAP() {
        return CONN_MAP;
    }

    public SshConnector(String sshHostname, int port, String username, String password, ISshJudge sshEndJudgeIntf) {
        this.setLoginInfo(sshHostname, port, username, password);
        this.sshEndJudgeIntf = sshEndJudgeIntf;
    }

    private void setLoginInfo(String logSshHostname, int logPort, String logUsername, String logPassword) {
        this.sshHostname = logSshHostname;
        this.username = logUsername;
        this.pswd = AESEncrypt.encrypt(logPassword);
        this.port = logPort;
    }

    public SshConnection getConnection() throws com.huawei.ism.tool.framework.platform.exception.ToolException {
        if (null == this.sshCon) {
            this.sshCon = this.createSshConnect(this.sshHostname, this.port, this.username, AESEncrypt.decrypt(this.pswd), false);
        } else if (!this.sshCon.isConnected()) {
            this.reConnectThrowExpection();
        }
        return this.sshCon;
    }

    public SshConnection getConnectionForPwdWillExpireBreak() throws com.huawei.ism.tool.framework.platform.exception.ToolException {
        if (null == this.sshCon) {
            this.sshCon = this.createSshConnect(this.sshHostname, this.port, this.username, AESEncrypt.decrypt(this.pswd), true);
        } else if (!this.sshCon.isConnected()) {
            this.reConnectThrowExpection();
        }
        return this.sshCon;
    }

    private void reConnectThrowExpection() throws com.huawei.ism.tool.framework.platform.exception.ToolException {
        try {
            this.sshCon.reConnect();
        }
        catch (ToolException e) {
            LOGGER.error("reConnect err", (Throwable)e);
            throw new com.huawei.ism.tool.framework.platform.exception.ToolException(ERR_CONNECTION, e.getMessage(), (Throwable)e);
        }
        catch (PwdException e) {
            LOGGER.error("reConnect pwd err", (Throwable)e);
            throw new com.huawei.ism.tool.framework.platform.exception.ToolException(ERR_AUTHENTICATEFAIL, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("reConnect err", (Throwable)e);
            throw new com.huawei.ism.tool.framework.platform.exception.ToolException(ERR_OTHER, e.getMessage(), (Throwable)e);
        }
    }

    public SshConnection getConnectionNoException() {
        if (null == this.sshCon) {
            try {
                this.sshCon = this.createSshConnect(this.sshHostname, this.port, this.username, AESEncrypt.decrypt(this.pswd), false);
            }
            catch (Exception e) {
                LOGGER.error("create ssh connect error.", (Throwable)e);
                return null;
            }
        } else if (!this.reConnectNoException()) {
            return null;
        }
        return this.sshCon;
    }

    private boolean reConnectNoException() {
        if (!this.sshCon.isConnected()) {
            try {
                this.sshCon.reConnect();
            }
            catch (PwdException e) {
                LOGGER.error("reConnect pwd err", (Throwable)e);
                return false;
            }
            catch (ToolException e) {
                LOGGER.error("reConnect tool err", (Throwable)e);
                return false;
            }
            catch (Exception e) {
                LOGGER.error("reConnect otherException err", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public String getLoginInfo() {
        HashMap<String, String> loginMap = new HashMap<String, String>();
        loginMap.put("ip", this.sshHostname);
        loginMap.put("sshPort", String.valueOf(this.port));
        loginMap.put("user", this.username);
        loginMap.put("pawd", AESEncrypt.decrypt(this.pswd));
        JSONObject json = new JSONObject(loginMap);
        return json.toString();
    }

    private SshConnection createSshConnect(String prSshHostname, int prPort, String prUsername, String prPassword, boolean isPwdWillExpireBreak) throws com.huawei.ism.tool.framework.platform.exception.ToolException {
        SshConnection sshConnection = null;
        try {
            if (null == this.sshEndJudgeIntf) {
                sshConnection = new SshConnection(prSshHostname, prUsername, prPassword, prPort);
            } else {
                LOGGER.info("connection use sshEndJudgeInf.");
                sshConnection = new SshConnection(prSshHostname, prUsername, prPassword, prPort, this.sshEndJudgeIntf);
            }
            sshConnection.connect(isPwdWillExpireBreak, false);
        }
        catch (PwdException e) {
            LOGGER.error("Create SSH connection Pwd failed", (Throwable)e);
            throw e;
        }
        catch (ToolException e) {
            LOGGER.error("Create SSH connection failed", (Throwable)e);
            throw new com.huawei.ism.tool.framework.platform.exception.ToolException(ERR_CONNECTION, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Create SSH connection otherException failed", (Throwable)e);
            throw new com.huawei.ism.tool.framework.platform.exception.ToolException(ERR_OTHER, e.getMessage(), (Throwable)e);
        }
        CONN_MAP.put(prSshHostname, sshConnection);
        return sshConnection;
    }

    public String toString() {
        return "SshConnector{sshHostname='" + this.sshHostname + '\'' + ", port=" + this.port + '}';
    }
}

