/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.parser;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.bizpack.parse.PackageConfigParser;
import com.huawei.ism.tool.bizpack.parse.ProductsParser;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AllProductsParser {
    private static final AllProductsParser INSTANCE = new AllProductsParser();
    private static final Logger LOGGER = LoggerFactory.getLogger(AllProductsParser.class);
    private static final String PACKAGE_PATH = "packages";
    private static final String PRODUCTS = "products";
    private static final String PACKAGE_INI = "package.ini";
    private static final String PRODUCTS_XML = "products.xml";

    private AllProductsParser() {
    }

    public static AllProductsParser getInstance() {
        return INSTANCE;
    }

    public void parseAllproducts() {
        String rootPath = this.getCurrentPkgRootPath();
        BizPackageContext.getInstance().setBizPackages(new ArrayList<BizPackage>());
        if (rootPath == null) {
            LOGGER.error("Get current package root path error");
            return;
        }
        File rootpathFile = new File(rootPath);
        String packPath = ApplicationContext.getInstance().getAppConfig("tool.selfdefine.package");
        if (!StringUtils.isNULLStr(packPath) && BizPackageContext.getInstance().isSelfDefine()) {
            BizPackage bizPackage = this.initOnepack(rootpathFile);
            if (null != bizPackage) {
                BizPackageContext.getInstance().addBizPackage(bizPackage);
                BizPackageContext.getInstance().setCurBizPackage(bizPackage);
            }
            this.initSupportProduct();
            return;
        }
        File[] pathList = rootpathFile.listFiles();
        if (null == pathList) {
            return;
        }
        for (File subPathFile : pathList) {
            BizPackage bizPackage;
            if (!subPathFile.isDirectory() || null == (bizPackage = this.initOnepack(subPathFile))) continue;
            BizPackageContext.getInstance().addBizPackage(bizPackage);
        }
        this.initSupportProduct();
    }

    public String getCurrentPkgRootPath() {
        StringBuilder rootPath = new StringBuilder();
        File workFile = new File(ApplicationContext.getInstance().getWorkPath());
        String workFilePath = null;
        try {
            workFilePath = workFile.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        String packPath = ApplicationContext.getInstance().getAppConfig("tool.selfdefine.package");
        if (!StringUtils.isNULLStr(packPath) && BizPackageContext.getInstance().isSelfDefine()) {
            rootPath.append(workFilePath);
            rootPath.append(File.separator);
            rootPath.append(packPath);
        } else {
            String toolName = BizPackageContext.getInstance().getCurToolName();
            rootPath.append(workFile);
            rootPath.append(File.separator);
            rootPath.append(PACKAGE_PATH);
            rootPath.append(File.separator);
            rootPath.append(toolName);
            rootPath.append(File.separator);
            rootPath.append(PRODUCTS);
        }
        return rootPath.toString();
    }

    private void initSupportProduct() {
        List<BizPackage> packages = BizPackageContext.getInstance().getBizPackages();
        for (BizPackage bizPackage : packages) {
            List<PackProduct> products = bizPackage.getPackProducts();
            for (PackProduct packProduct : products) {
                BizPackageContext.getInstance().addProducts(packProduct);
            }
        }
    }

    public BizPackage initOnepack(File subPath) {
        File[] fileList = subPath.listFiles();
        if (fileList == null || !this.containsFile(PACKAGE_INI, fileList) || !this.containsFile(PRODUCTS_XML, fileList)) {
            return null;
        }
        String subPathStr = "";
        try {
            subPathStr = subPath.getCanonicalPath();
        }
        catch (IOException e1) {
            LOGGER.error("Get subPath canonical path failed.");
        }
        String pathPackagesIni = subPathStr + File.separator + PACKAGE_INI;
        String pathProductsXml = subPathStr + File.separator + PRODUCTS_XML;
        BizPackage bizPackage = new BizPackage();
        try {
            bizPackage.setAbsolutPath(subPathStr);
            this.loadPackagesIni(pathPackagesIni, bizPackage);
            this.loadProductsXml(pathProductsXml, bizPackage);
        }
        catch (Exception e) {
            LOGGER.error("initOnepack ERR+", (Throwable)e);
            return null;
        }
        return bizPackage;
    }

    private boolean containsFile(String fileName, File[] fileList) {
        for (File file : fileList) {
            if (!file.getName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private void loadPackagesIni(String filePath, BizPackage bizPackage) {
        PackageConfigParser parser = new PackageConfigParser(new File(FilePathUtils.filterPath(filePath)));
        parser.parse(bizPackage);
    }

    private void loadProductsXml(String filePath, BizPackage bizPackage) {
        ProductsParser parser = new ProductsParser(new File(FilePathUtils.filterPath(filePath)));
        parser.parse(bizPackage);
    }
}

