/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.task;

import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecPyScriptTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecPyScriptTask.class);
    private String preScriptPath = "";
    private String pyName = "";
    private JythonContext ssEnv;
    private JythonExecuter jythonExecuter;

    public ExecPyScriptTask(String preScriptPath, String pyName) throws FileNotFoundException, SignException {
        this.preScriptPath = preScriptPath;
        this.pyName = pyName;
        this.ssEnv = BizPackageContext.getInstance().getJythonContext();
        this.initExecuter();
    }

    private void initExecuter() throws FileNotFoundException, SignException {
        ArrayList<File> clsPath = new ArrayList<File>();
        boolean isFromJar = false;
        clsPath.add(new File(this.preScriptPath));
        try {
            this.jythonExecuter = new JythonExecuter(clsPath);
        }
        catch (Exception e) {
            LOGGER.error("init jythonExecuter err.", (Throwable)e);
        }
        String pyDir = this.getScriptPath();
        String pyPath = pyDir + File.separator + this.pyName;
        File pyFile = new File(pyPath);
        if (!pyFile.exists() || pyFile.isDirectory()) {
            LOGGER.info("jython File not found, will search in pyframe");
            pyFile = ExecPyUtils.getPyframeFile(this.pyName);
            isFromJar = ExecPyUtils.isJarFile(this.pyName);
            if (pyFile == null) {
                LOGGER.error("jython File not found in pyframe :" + this.pyName);
                throw new FileNotFoundException();
            }
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("execute script : " + pyFile.getCanonicalPath());
            }
            this.ssEnv.getDict().put("logger", LOGGER);
            if (isFromJar) {
                this.jythonExecuter.compileScriptWithoutSign(pyFile);
            } else {
                this.jythonExecuter.compileScript(pyFile);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("jython File {} not found", (Object)this.pyName);
            throw new FileNotFoundException("jython File is not found:" + this.pyName);
        }
        catch (SignException e) {
            LOGGER.error("python file has no sign", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOGGER.error("get python scrip path exception", (Throwable)e);
        }
    }

    public boolean execFunc(String funcName) {
        try {
            this.ssEnv.clearMsgData();
            Object[] paramList = new Object[]{this.ssEnv.getDict()};
            this.jythonExecuter.invokeFunction(funcName, paramList);
        }
        catch (ToolException e) {
            LOGGER.error("jython exec err", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("jython exec err", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean execFunc(String funcName, String param) {
        if ("".equals(param.trim())) {
            return this.execFunc(funcName);
        }
        try {
            this.ssEnv.clearMsgData();
            this.jythonExecuter.invokeFunction(funcName, new Object[]{this.ssEnv.getDict(), param});
        }
        catch (ToolException e) {
            LOGGER.error("jython exec err", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("jython exec err", (Throwable)e);
            return false;
        }
        return true;
    }

    private String getScriptPath() {
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        StringBuilder scriptPath = new StringBuilder();
        if (null == BizPackageContext.getInstance().getCurBizWizardCfg()) {
            LOGGER.info("exec py path from process.");
            return packPath + File.separator + "process";
        }
        String processPath = BizPackageContext.getInstance().getCurBizWizardCfg().getId();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append("process");
        scriptPath.append(File.separator);
        scriptPath.append(processPath);
        scriptPath.append(File.separator);
        scriptPath.append("script");
        return scriptPath.toString();
    }
}

