/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.task;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecPyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecPyUtils.class);
    private static final String PROCESS = "Process";

    private ExecPyUtils() {
    }

    public static boolean execInitScript(String pyName, String param, String method) {
        JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        ssEnv.clearMsgData();
        String processPath = ExecPyUtils.getScriptPath();
        try {
            ExecPyScriptTask pyTask = new ExecPyScriptTask(processPath, pyName);
            return pyTask.execFunc(method, param);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("jython File not found");
            return false;
        }
        catch (SignException e) {
            LOGGER.error("python file has no sign", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("jython exec err", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File inputStreamToFile(InputStream ins, String fileName) {
        FileOutputStream outputStream = null;
        try {
            String userDir = SystemEnvUtil.getDefaultUserDir();
            String newPath = userDir + "\\temp\\scriptTmp\\" + fileName;
            File file = new File(newPath);
            if (file.isDirectory()) {
                File file2 = null;
                return file2;
            }
            if (file.exists()) {
                file.delete();
            }
            outputStream = new FileOutputStream(file);
            int byteCount = 0;
            byte[] bytes = new byte[1024];
            while ((byteCount = ins.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, byteCount);
            }
            File file3 = file;
            StreamUtils.closeStream(outputStream, ins);
            return file3;
        }
        catch (IOException e) {
            LOGGER.error("read file exception", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(outputStream, ins);
        }
        return null;
    }

    public static File getPyframeFile(String pyName) {
        InputStream resource = ExecPyScriptTask.class.getResourceAsStream(pyName);
        if (resource == null) {
            LOGGER.error("jython File not found", (Object)pyName);
            return null;
        }
        File file = ExecPyUtils.inputStreamToFile(resource, new File(pyName.trim()).getName());
        if (file == null) {
            LOGGER.error("jython File not found", (Object)pyName);
            return null;
        }
        return file;
    }

    public static boolean isJarFile(String filePath) {
        URL res = ExecPyUtils.class.getResource(filePath);
        if (res == null) {
            return false;
        }
        String protocal = res.getProtocol();
        return null != protocal && protocal.equals("jar");
    }

    private static String getScriptPath() {
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        StringBuilder scriptPath = new StringBuilder();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append(PROCESS);
        return scriptPath.toString();
    }
}

