/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private static ExecutorService executeTask = Executors.newSingleThreadExecutor();
    private static final List<String> EXIT_TASK_TITLE = new ArrayList<String>();

    private TaskManager() {
    }

    public static synchronized void submitTask(Runnable task) {
        if (task == null) {
            return;
        }
        Future<?> future = executeTask.submit(task);
        log.info("return value is {}", future);
    }

    public static synchronized boolean submitTask(Runnable task, String title) {
        if (task == null) {
            return false;
        }
        if (EXIT_TASK_TITLE.contains(title)) {
            log.info("task title {} has exit", (Object)title);
            return false;
        }
        executeTask.submit(task);
        EXIT_TASK_TITLE.add(title);
        log.info("task {} has submit success", (Object)title);
        return true;
    }

    public static synchronized void removeFinishedTask(String title) {
        log.info("remove exit task: {}, result:{}", (Object)title, (Object)EXIT_TASK_TITLE.remove(title));
    }

    public static void shutdownTask() {
        executeTask.shutdown();
        executeTask = Executors.newSingleThreadExecutor();
    }
}

