/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.FlowFactory;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.action.ToolAction;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.component.jlist.StepListItem;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizWizardConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.BizpackageFlowWizardDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.BizpackageGuideFlowWizardDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectZoneDeviceDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.BuildOneProcessWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.util.DevNodeUtil;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardAction
extends ToolAction
implements ToolHyperLinkLabel.ClickListener {
    private static final Logger log = LoggerFactory.getLogger(WizardAction.class);
    private static final long serialVersionUID = -3550849266490464439L;
    private static final List<String> notNeedSelectZoneIds = Collections.singletonList("ipScaleOutSwitch");
    private BizWizardConfig curBizWizardCfg;

    public WizardAction(BizWizardConfig cBizWizardCfg) {
        this.curBizWizardCfg = cBizWizardCfg;
    }

    public void actionPerformed(ActionEvent e) {
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String title = resutil.getString(this.curBizWizardCfg.getTitle());
        log.info("you click {} btn", (Object)title);
        BizPackageContext.getInstance().setCurBizWizardCfg(this.curBizWizardCfg);
        BizPackageContext.getInstance().getBizpackageUserOpData().setTaskStartTime(DateUtil.toBeiJingTimeMillis(new Date()));
        BizPackageContext.getInstance().getBizpackageUserOpData().setDevNode(BizPackageContext.getInstance().getCurDevice());
        BizPackageContext.getInstance().getBizpackageUserOpData().setTaskResult(UserOpTaskResult.FAILED);
        BizPackageContext.getInstance().getJythonContext().putExtUtil();
        BizPackageContext.getInstance().getJythonContext().clearMsgData();
        Window parent = BizPackageContext.getInstance().getSelectProcessDialog();
        this.buildWizard(parent);
    }

    private void handleResultException(Window parent, WaitDialogResult result) {
        Exception e = result.getException();
        if (null == e && !"".equals(result.getErrMsg())) {
            DialogUtils.showErrorDialog((Window)parent, (String)result.getErrMsg());
            return;
        }
        if (e instanceof FileNotFoundException) {
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound"));
            return;
        }
        if (e instanceof SignException) {
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned"));
            return;
        }
        if (!this.curBizWizardCfg.getIsCancelled().equals("true")) {
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString("bizpackage.error.buildwizardfailed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void buildWizard(Window parent) {
        try {
            List fs = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{new BuildOneProcessWaitDialog()});
            WaitDialogResult result = (WaitDialogResult)fs.get(0);
            if (!result.isFlag()) {
                this.handleResultException(parent, result);
                return;
            }
        }
        catch (Exception ee) {
            log.error("buildWizard faild" + ee);
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString("bizpackage.error.buildwizardfailed"));
            return;
        }
        Locale loc = LanguageManager.getInstance().getCurrentLanguage();
        String flowXmlPath = BizPackageContext.getInstance().getCurBizWizardCfg().getFlowXmlPath();
        String stepDefineXmlPath = BizPackageContext.getInstance().getCurBizWizardCfg().getStepDefineXmlPath();
        FileInputStream defXmlStream = null;
        FileInputStream flowXmlStream = null;
        try {
            defXmlStream = new FileInputStream(new File(stepDefineXmlPath));
            flowXmlStream = new FileInputStream(new File(flowXmlPath));
            String path = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath() + File.separator + "res" + File.separator + "help";
            this.checkFlowFactory(loc, defXmlStream, flowXmlStream, path);
        }
        catch (FileNotFoundException e) {
            log.error("open xml inputStream failed,file stepDefineXmlPath or flowXmlPath  not found.");
            StreamUtils.closeStream(null, defXmlStream);
            StreamUtils.closeStream(null, flowXmlStream);
        }
        catch (Exception e2) {
            log.error("buildWizard failed", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, defXmlStream);
                    StreamUtils.closeStream(null, flowXmlStream);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, defXmlStream);
            StreamUtils.closeStream(null, flowXmlStream);
        }
        StreamUtils.closeStream(null, defXmlStream);
        StreamUtils.closeStream(null, flowXmlStream);
    }

    private void checkFlowFactory(Locale loc, InputStream defXmlStream, InputStream flowXmlStream, String path) {
        String iconPath = BizPackageContext.getInstance().getCurBizWizardCfg().getIconPath();
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        ImageIcon imageIcon = util.getImage(iconPath);
        Dimension wizardSize = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize();
        FlowFactory flowFactory = new FlowFactory(defXmlStream, flowXmlStream, WizardAction.class.getClassLoader(), loc);
        String guideType = BizPackageContext.getInstance().getCurBizWizardCfg().getGuideType();
        log.info("the guide type: {}", (Object)guideType);
        Object wizard = "PROGRESS_GUIDE".equals(guideType) ? new BizpackageGuideFlowWizardDialog(BizPackageContext.getInstance().getSelectProcessDialog(), loc, flowFactory, imageIcon, path, false) : new BizpackageFlowWizardDialog(BizPackageContext.getInstance().getSelectProcessDialog(), loc, flowFactory, imageIcon, path, false);
        ((Window)wizard).setMinimumSize(wizardSize);
        ((Component)wizard).setPreferredSize(wizardSize);
        ((Window)wizard).setSize(wizardSize);
        ((Window)wizard).setIconImage(imageIcon.getImage());
        StepListItem.setLoadingImageObserver((ImageObserver)wizard);
        UiMethod.putScreenCenter((Window)wizard);
        BizPackageContext.getInstance().setWizard((JDialog)wizard);
        ((Dialog)wizard).setModal(true);
        ((Dialog)wizard).setVisible(true);
    }

    public void clickLink(MouseEvent e) {
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String title = resutil.getString(this.curBizWizardCfg.getTitle());
        log.info("you click {} btn", (Object)title);
        BizPackageContext.getInstance().setCurBizWizardCfg(this.curBizWizardCfg);
        BizPackageContext.getInstance().getBizpackageUserOpData().setTaskStartTime(DateUtil.toBeiJingTimeMillis(new Date()));
        if (this.needSelectZone() && !this.selectZoneNode()) {
            log.info("Deselect the zone node and return to this page.");
            return;
        }
        BizPackageContext.getInstance().getBizpackageUserOpData().setDevNode(BizPackageContext.getInstance().getCurDevice());
        BizPackageContext.getInstance().getBizpackageUserOpData().setTaskResult(UserOpTaskResult.FAILED);
        BizPackageContext.getInstance().getJythonContext().clearMsgData();
        BizPackageContext.getInstance().getJythonContext().putExtUtil();
        Window parent = BizPackageContext.getInstance().getSelectProcessDialog();
        this.buildWizard(parent);
    }

    private boolean needSelectZone() {
        return SceneUtils.getCurrentSubScene().contains("IntelligentCompute_A800") && !notNeedSelectZoneIds.contains(this.curBizWizardCfg.getId());
    }

    private boolean selectZoneNode() {
        SelectZoneDeviceDialog selectZoneDeviceDialog = new SelectZoneDeviceDialog(BizPackageContext.getInstance().getSelectProcessDialog(), BizPackageContext.getInstance().getA800ZoneNodeList(), true);
        selectZoneDeviceDialog.setVisible(true);
        List<DmeNode> storageDevNodeList = selectZoneDeviceDialog.getStorageDevNodeList();
        if (CollectionUtil.isEmpty(storageDevNodeList)) {
            return false;
        }
        String defaultIp = BizPackageContext.getInstance().getCurDevice().getIp();
        DevNode devNode = EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)((com.huawei.ism.tool.obase.entity.DevNode)storageDevNodeList.get(0)));
        BizPackageContext.getInstance().getJythonContext().getDict().put("devNode0", devNode);
        BizPackageContext.getInstance().getJythonContext().getDict().put("dev", DevNodeUtil.getDevMapDict(devNode));
        BizPackageContext.getInstance().getJythonContext().setDevNode(devNode);
        BizPackageContext.getInstance().setCurDevice(devNode);
        if (!defaultIp.equals(devNode.getIp())) {
            this.clearCacheConnections();
        }
        return true;
    }

    private void clearCacheConnections() {
        Object scriptDefContext = BizPackageContext.getInstance().getJythonContext().getDict().get("SCRIPT_DEF_CONTEXT");
        if (scriptDefContext instanceof Map) {
            Map defContextMap = (Map)scriptDefContext;
            defContextMap.remove("CLI_CONNECTION");
            defContextMap.remove("SSH_CONNECTOR");
            defContextMap.remove("REST_CONNECTION");
            defContextMap.remove("TLV_CONNECTION");
        }
    }
}

