/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.IInputComponent;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GridFileChooser
extends JPanel
implements IInputComponent {
    private static final long serialVersionUID = -5492682795598562121L;
    private static final String SELECTFILE_DEFAULT_ID = "getuserinput_saveresult_path_id001";
    private String title = "";
    private String desc = "";
    private int chooseType = 0;
    private int col = 4;
    private boolean open = true;
    private String[] exts = new String[0];
    private JTextField addressField = new JTextField();
    private JButton choose;
    private JButton clear;

    public GridFileChooser(JSONObject jsonObject) {
        this.initData(jsonObject);
        this.initUi();
    }

    private void initData(JSONObject jsonObject) {
        String titleStr = jsonObject.getString("title");
        String descStr = jsonObject.getString("desc");
        JSONArray extArray = jsonObject.getJSONArray("exts");
        String isOpenStr = jsonObject.getString("isOpen");
        String chooseTypeStr = jsonObject.getString("chooseType");
        this.setTitle(titleStr);
        this.setDesc(descStr);
        this.setChooseType(chooseTypeStr);
        this.setOpen(isOpenStr);
        this.setExts(this.getExts(extArray));
        if (jsonObject.has("col")) {
            String colStr = jsonObject.getString("col");
            this.setCol(colStr);
        }
    }

    public void clearArress() {
        this.addressField.setText("");
    }

    private String[] getExts(JSONArray array) {
        String[] extsStrs = new String[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            extsStrs[i] = (String)array.get(i);
        }
        return extsStrs;
    }

    private void initUi() {
        String buttonTxt = ResourceUtil.getString("bizpack.wizard.selectstep.button.desc");
        this.choose = UiMethod.createButton((String)buttonTxt);
        String clearBtnTxt = ResourceUtil.getString("bizpack.wizard.selectstep.clear.button.desc");
        this.clear = UiMethod.createButton((String)clearBtnTxt);
        this.addressField.setEditable(false);
        this.addressField.setColumns(this.col);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.addressField);
        this.add(Box.createHorizontalStrut(12));
        this.add(this.choose);
        this.add(Box.createHorizontalStrut(12));
        this.add(this.clear);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.addressField, "addressField");
        AutomateUtils.setNameAttribute(this.choose, "choose");
        AutomateUtils.setNameAttribute(this.clear, "clear");
    }

    public void initListener(final Window praent) {
        this.choose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File selectFile = ToolFileChooser.selectFile((Window)praent, (String)GridFileChooser.this.title, (String[])GridFileChooser.this.exts, (String)GridFileChooser.SELECTFILE_DEFAULT_ID, (String)GridFileChooser.this.desc, (int)GridFileChooser.this.chooseType, (boolean)GridFileChooser.this.open, (boolean)true, (Locale)Locale.getDefault());
                if (null != selectFile && selectFile.exists()) {
                    GridFileChooser.this.addressField.setText(FilePathUtils.getCanonicalPath(selectFile));
                }
            }
        });
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridFileChooser.this.clearArress();
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String titleStr) {
        this.title = titleStr;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String descStr) {
        this.desc = descStr;
    }

    public int getChooseType() {
        return this.chooseType;
    }

    public void setChooseType(String chooseType) {
        try {
            this.chooseType = Integer.parseInt(chooseType);
        }
        catch (Exception e) {
            this.chooseType = 0;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(String isOpen) {
        this.open = isOpen.equalsIgnoreCase("true");
    }

    public String[] getExts() {
        return (String[])this.exts.clone();
    }

    public void setExts(String[] extsStrs) {
        this.exts = (String[])extsStrs.clone();
    }

    public JTextField getAddressField() {
        return this.addressField;
    }

    public void setAddressField(JTextField addressField) {
        this.addressField = addressField;
    }

    public JButton getChoose() {
        return this.choose;
    }

    public void setChoose(JButton choose) {
        this.choose = choose;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getValue() {
        return this.addressField.getText();
    }

    @Override
    public void setValue(String value) {
        this.addressField.setText(value);
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(String col) {
        try {
            this.col = Integer.parseInt(col);
        }
        catch (Exception e) {
            this.col = 4;
        }
    }
}

