/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.Item;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.ItemResult;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ItemsListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 2733015638572353011L;
    private static final Dimension RESULT_LABLE_SIZE = new Dimension(100, 20);
    private static final Dimension DATE_LABLE_SIZE = new Dimension(120, 20);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        Color bg = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        boolean isComponentSelected = isSelected;
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isComponentSelected = true;
        }
        JPanel viewPan = new JPanel();
        Item result = (Item)value;
        String date = result.getDate();
        JLabel descLabel = new JLabel(result.getTitleRes(resource));
        JLabel dataLabel = new JLabel(date);
        dataLabel.setPreferredSize(DATE_LABLE_SIZE);
        JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), dataLabel});
        String resultStr = result.getResult().toString();
        JLabel resultLabel = null;
        if (result.getResult() == ItemResult.WAITING || result.getResult() == ItemResult.WAITCHECK || result.getResult() == ItemResult.WAITEXEC) {
            resultLabel = new JLabel(resultStr, 2);
        } else {
            ImageIcon icon = result.getImageIcon();
            resultLabel = new JLabel(resultStr, icon, 2);
            icon.setImageObserver(list);
        }
        resultLabel.setPreferredSize(RESULT_LABLE_SIZE);
        JComponent view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, Box.createHorizontalStrut(12), descLabel, Box.createHorizontalGlue(), resultLabel});
        viewPan.setLayout(new BorderLayout());
        viewPan.add((Component)view, "North");
        if (!"".equals(result.getDesc().trim())) {
            viewPan.setToolTipText(result.getDescRes(resource));
        }
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        if (isComponentSelected) {
            viewPan.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty((String)"setForeground", (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPan});
        } else {
            viewPan.setBackground(list.getBackground());
            viewPan.setForeground(list.getForeground());
        }
        return viewPan;
    }
}

